/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

/*BEGINPROLOGUE**************************************************************/
/*                                                                          */
/*   Module Name:              IPLIST.H                                     */
/*                                                                          */
/*   Descriptive Name:         This module has symbol definitions used by   */
/*                             the list manager sub-component.              */
/*                                                                          */
/*   Status:                   Release 1, Level 0                           */
/*                                                                          */
/*   Dependencies:             IBM OS/2 Extended Edition 1.30.1             */
/*                                                                          */
/*ENDPROLOGUE****************************************************************/


typedef struct _iplstnode
{
   struct _iplstnode *pPrev;
   struct _iplstnode *pNext;
   unsigned short flags;               // LT_LOCKED
   char *pData;                        // Pointer to actual data

} IPLSTNODE, *PIPLSTNODE;


typedef struct _iplist
{
   unsigned short usItemCount;         // Number of items in the list
   unsigned short usItemWidth;         // Width of the item in bytes
   short sItemType;                    // LT_FIXEDLEN | LT_VARLEN
   PIPLSTNODE pHead;                   // Pointer to head node
   PIPLSTNODE pTail;                   // Pointer to tail node
   PIPLSTNODE pCurr;                   // Pointer to current node

} IPLIST, *PIPLIST;


#define LT_ERROR        0
#define LT_FIXEDLEN     1
#define LT_VARLEN       2

#define LF_LOCKED       0x0001

#define LSEEK_TOP       1
#define LSEEK_END       2



#define LERR_INSUFMEM   -1
#define LERR_INVPARAM   -2
#define LERR_OPENING    -3

struct  _iplist *CreateList(short  sItemType,unsigned short  usItemWidth);
void  SeekList(struct  _iplist *pList,short  sWhere);
void  DestroyList(struct  _iplist *pList);
int  SaveListToDisk(struct  _iplist *pList,char  *szFName);
int  AppendListItem(struct  _iplist *pList,char  *pData);
int  InsertTopListItem(struct  _iplist *pList,char  *pData);
void  DeleteTopListItem(struct  _iplist *pList);
void  DeleteBottomListItem(struct  _iplist *pList);
char  *CurrListItem(struct  _iplist *pList);
char  *TopListItem(struct  _iplist *pList);
char  *NextListItem(struct  _iplist *pList);
char  *PrevListItem(struct  _iplist *pList);
char  *BottomListItem(struct  _iplist *pList);
unsigned int  QueryListCount(struct  _iplist *pList);
char  *ListItemByIndex(struct  _iplist *pList,int  index);
int  QueryListType(struct  _iplist *pList);
int  QueryListItemWidth(struct  _iplist *pList);
int  AppendListToList(struct  _iplist *pDstList,struct _iplist *pSrcList);
void  DeleteCurrListItem(struct  _iplist *pList);
