/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

/*BEGINPROLOGUE**************************************************************/
/*                                                                          */
/*   Module Name:              IPLIST.C                                     */
/*                                                                          */
/*   Descriptive Name:         This module has functions to implement the   */
/*                             linked lists used throughout the app.        */
/*                                                                          */
/*   Status:                   Release 1, Level 0                           */
/*                                                                          */
/*   Dependencies:             IBM OS/2 Extended Edition 1.30.1             */
/*                                                                          */
/*ENDPROLOGUE****************************************************************/

#define INCL_DOSMEMMGR
#define INCL_GPIBITMAPS
#define INCL_WIN
#define INCL_PM
#include <os2.h>

#include <stdio.h>                     // Standard C standard input/output
#include <stdlib.h>                    // Standard C library header
#include <string.h>                    // Standard C string header
#include <ctype.h>                     // Contains standard macros and symbols
#include "iplist.h"                    // Contains standard macros and symbols


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

PIPLIST CreateList(short sItemType,unsigned short usItemWidth)
{
   PIPLIST pList;

   if (usItemWidth == 0 && sItemType == LT_FIXEDLEN)
      {
      pList = NULL;
      }
   else
      {
      pList = (PIPLIST) malloc(sizeof(IPLIST));
      if (pList != NULL)
         {
         memset(pList,0,sizeof(IPLIST));
         pList->sItemType = sItemType;
         pList->usItemWidth = usItemWidth;
         pList->usItemCount = 0;
         }
      }
   return(pList);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void SeekList(PIPLIST pList,short sWhere)
{
   if (pList)
      {
      if (sWhere == LSEEK_TOP)
         {
         pList->pCurr = pList->pHead;
         }
      else if (sWhere == LSEEK_END)
         {
         pList->pCurr = pList->pTail;
         }
      }
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void DestroyList(PIPLIST pList)
{
   PIPLSTNODE pNode;

   if (pList)
      {
      while (pList->pHead != NULL)
         {
         pNode = pList->pHead->pNext;
         if (pList->pHead->pData != NULL)
            {
            free(pList->pHead->pData);
            }
         free(pList->pHead);
         pList->pHead = pNode;
         }
      }
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int SaveListToDisk(PIPLIST pList,char *szFName)
{
   register int rc = 0;
   FILE *fp = NULL;
   char szOpenType[4], *p;
   int sType;
   unsigned int usItemWidth;

   if (QueryListCount(pList) > 0)
      {
      sType = QueryListType(pList);
      usItemWidth = QueryListItemWidth(pList);
      strcpy(szOpenType,sType == LT_VARLEN ? "w+t" : "w+b");

      fp = (FILE *) fopen(szFName,szOpenType);
      if (fp == NULL)
         {
         rc = LERR_OPENING;
         }
      else
         {
         p = TopListItem(pList);
         while (p != NULL)
            {
            if (sType == LT_VARLEN)
               {
               fputs(p,fp);
               }
            else if (sType == LT_FIXEDLEN)
               {
               fwrite(p,usItemWidth,1,fp);
               }
            p = NextListItem(pList);
            }
         fclose(fp);
         }
      }
   return(rc);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int AppendListItem(PIPLIST pList,char *pData)
{
   PIPLSTNODE pNode;
   register int rc = 0;

   if (pList)
      {
      if (pData == NULL)
         {
         rc = LERR_INSUFMEM;
         }
      else
         {
         pNode = (PIPLSTNODE) malloc(sizeof(IPLSTNODE));
         if (pNode != NULL)
            {
            if (pList->sItemType == LT_FIXEDLEN)
               {
               pNode->pData = (char *) malloc(pList->usItemWidth);
               memcpy(pNode->pData,pData,pList->usItemWidth);
               }
            else
               {
               pNode->pData = (char *) malloc(strlen(pData)+1);
               strcpy(pNode->pData,pData);
               }

            if (pNode->pData == NULL)
               {
               free(pNode);
               rc = LERR_INSUFMEM;
               }
            else
               {
               pNode->pNext = NULL;
               pNode->pPrev = pList->pTail;
               if (pList->pTail != NULL)
                  {
                  pList->pTail->pNext = pNode;
                  }
               pList->pTail = pNode;
               pList->pCurr = pNode;
               pList->usItemCount++;

               if (pList->pHead == NULL)
                  {
                  pList->pHead = pList->pTail;
                  }
               }
            }
         }
      }
   return(rc);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int InsertTopListItem(PIPLIST pList,char *pData)
{
   PIPLSTNODE pNode;
   register int rc = 0;

   if (pList)
      {
      if (pData == NULL)
         {
         rc = LERR_INVPARAM;
         }
      else
         {
         pNode = (PIPLSTNODE) malloc(sizeof(IPLSTNODE));
         if (pNode != NULL)
            {
            if (pList->sItemType == LT_FIXEDLEN)
               {
               pNode->pData = (char *) malloc(pList->usItemWidth);
               memcpy(pNode->pData,pData,pList->usItemWidth);
               }
            else
               {
               pNode->pData = (char *) malloc(strlen(pData)+1);
               strcpy(pNode->pData,pData);
               }

            if (pNode->pData == NULL)
               {
               free(pNode);
               rc = LERR_INSUFMEM;
               }
            else
               {
               if (pList->pHead != NULL)
                  {
                  pList->pHead->pPrev = pNode;
                  }
               pNode->pNext = pList->pHead;
               pNode->pPrev = NULL;
               pList->pHead = pNode;
               pList->pCurr = pNode;
               pList->usItemCount++;

               if (pList->pTail == NULL)
                  {
                  pList->pTail = pList->pHead;
                  }
               }
            }
         }
      }
   return(rc);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void DeleteTopListItem(PIPLIST pList)
{
   PIPLSTNODE pNode;

   if (pList)
      {
      if (pList->pHead != NULL)
         {
         pNode = pList->pHead->pNext;
         if (pList->pHead->pData != NULL)
            {
            free(pList->pHead->pData);
            }
         free(pList->pHead);
         pList->pHead = pNode;
         if (pNode != NULL)
            {
            pNode->pPrev = NULL;
            }
         pList->usItemCount--;

         if (pNode == NULL)
            {
            pList->pTail = NULL;
            }
         }
      }
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void DeleteCurrListItem(PIPLIST pList)
{
   PIPLSTNODE pNode;

   if (pList)
      {
      if (pList->pCurr != NULL)
         {
         if (pList->pCurr->pPrev == NULL)
            {
            DeleteTopListItem(pList);
            }
         else
            {
            if (pList->pCurr->pNext == NULL)
               {
               DeleteBottomListItem(pList);
               }
            else
               {
               pNode = pList->pCurr;
               pNode->pPrev->pNext = pNode->pNext;
               pNode->pNext->pPrev = pNode->pPrev;
               pList->pCurr = pNode->pPrev;
               free(pNode);
               pList->usItemCount--;
               }
            }
         }
      }
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void DeleteBottomListItem(PIPLIST pList)
{
   PIPLSTNODE pNode;

   if (pList)
      {
      if (pList->pTail != NULL)
         {
         pNode = pList->pTail->pPrev;
         if (pList->pTail->pData != NULL)
            {
            free(pList->pTail->pData);
            }

         if (pList->pCurr == pList->pTail)
            {
            pList->pCurr = pNode;
            }
         free(pList->pTail);
         pList->pTail = pNode;
         pList->usItemCount--;

         if (pNode != NULL)
            {
            pNode->pNext = NULL;
            }
         else
            {
            pList->pHead = NULL;
            }
         }
      }
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

char *CurrListItem(PIPLIST pList)
{
   char *p = NULL;

   if (pList)
      {
      if (pList->pCurr != NULL)
         {
         p = pList->pCurr->pData;
         }
      }
   return(p);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

char *TopListItem(PIPLIST pList)
{
   char *p = NULL;

   if (pList)
      {
      if (pList->pHead != NULL)
         {
         p = pList->pHead->pData;
         pList->pCurr = pList->pHead;
         }
      }
   return(p);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

char *NextListItem(PIPLIST pList)
{
   char *p = NULL;

   if (pList)
      {
      if (pList->pCurr != NULL)
         {
         pList->pCurr = pList->pCurr->pNext;
         if (pList->pCurr != NULL)
            {
            p = pList->pCurr->pData;
            }
         }
      }
   return(p);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

char *PrevListItem(PIPLIST pList)
{
   char *p = NULL;

   if (pList)
      {
      if (pList->pCurr != NULL)
         {
         pList->pCurr = pList->pCurr->pPrev;
         if (pList->pCurr != NULL)
            {
            p = pList->pCurr->pData;
            }
         }
      }
   return(p);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

char *BottomListItem(PIPLIST pList)
{
   char *p = NULL;

   if (pList)
      {
      if (pList->pTail != NULL)
         {
         p = pList->pTail->pData;
         pList->pCurr = pList->pTail;
         }
      }
   return(p);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

unsigned int QueryListCount(PIPLIST pList)
{
   register unsigned int count = 0;

   if (pList != NULL)
      {
      count = pList->usItemCount;
      }
   return(count);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int QueryListType(PIPLIST pList)
{
   register int type = 0;
   if (pList != NULL)
      {
      type = pList->sItemType;
      }
   return(type);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int QueryListItemWidth(PIPLIST pList)
{
   register unsigned int width = 0;
   if (pList != NULL)
      {
      width = pList->usItemWidth;
      }
   return(width);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

char *ListItemByIndex(PIPLIST pList,int index)
{
   PIPLSTNODE pNode = NULL;
   register int count = 0;

   if (pList)
      {
      pNode = pList->pHead;
      while (pNode != NULL)
         {
         if (index == count)
            {
            if (pNode->pData != NULL)
               {
               return(pNode->pData);
               }
            else
               {
               return(NULL);
               }
            }
         pNode = pNode->pNext;
         count++;
         }
      }
   return(NULL);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int AppendListToList(PIPLIST pDstList,PIPLIST pSrcList)
{
   register int rc = 0;
   char *p;

   if (QueryListCount(pSrcList) > 0)
      {
      p = TopListItem(pSrcList);
      do
         {
         rc = AppendListItem(pDstList,p);
         if (rc == 0)
            {
            p = NextListItem(pDstList);
            }
         }
      while (p != NULL && rc == 0);
      }
   return(rc);
}
