title IP/2 Export DLL initialization routine
page ,132

;BEGINPROLOGUE**************************************************************;
;                                                                           ;
;   *** IBM CONFIDENTIAL (IBM CONFIDENTIAL - RESTRICTED when combined       ;
;           with the aggregated OCO source modules for this program) ***    ;
;                                                                           ;
;       OCO Source Materials                                                ;
;       5695 - 125 (5042)                                                   ;
;                                                                           ;
;                                                                           ;
;   Module Name:              IPINITC.ASM                                   ;
;                                                                           ;
;   Descriptive Name:         Export DLL initialization routine             ;
;                                                                           ;
;   Module Owner:             Carlos Portela                                ;
;                             Simple Software Solutions, Inc.               ;
;                                                                           ;
;   Status:                   Release 1, Level 0                            ;
;                                                                           ;
;   Function:                 This is the initialization routine for the    ;
;                             IPEXPORT.DLL library module.  It is called    ;
;                             by OS/2's loader every time the DLL is loaded ;
;                                                                           ;
;   Dependencies:             IBM OS/2 Extended Edition 1.30.1              ;
;                                                                           ;
;                                                                           ;
;ENDPROLOGUE****************************************************************;

page
		.286C		       ; This directive suppresses the use of
				       ; instructions which are unique to the
				       ; 80286 processor

		extrn	IPDLLInit:far  ; Declare the C routine IPDLLInit 
				       ; located in the file IPEXPORT.C as an
				       ; external far function.

                extrn   C_INIT:far     ; Reference C runtime initialization


;***************************************************************************;
;                                                                           ;
; This is the CODE segment                                                  ;
;                                                                           ;
;***************************************************************************;

initc_text	segment public 'CODE'
		assume	cs:initc_text

init_ipdll	proc	far
		push	bp	       ; Save BP for caller
		mov	bp,sp
		push	ds	       ; Push the following seven registers
		push	es	       ; on the stack to prepare for the call
		push	dx
		push	cx
		push	bx
		push	si
		push	di

                call    C_INIT         ; Call the C library initialization

		push	ax	       ; Push ax, si, and di on the stack
		push	si	       ; frame as parameters to IPDLLInit
		push	di

		call	IPDLLInit      ; Perform the call to the C routine

		pop	di	       ; Retrieve the seven registers that
		pop	si	       ; were pushed earlier
		pop	bx
		pop	cx
		pop	dx
		pop	es
		pop	ds

;***************************************************************************;
;                                                                           ;
; Contrary to standard convention, initialization routines must set AX to a ;
; non - zero value to indicate a successful completion.  IPDLLInit returns  ;
; the proper value in the AX register.                                      ;
;                                                                           ;
;***************************************************************************;

		pop	bp	       ; Restore callers BP
		ret		       ; Far return

init_ipdll	endp
initc_text	ends

;***************************************************************************;
;                                                                           ;
; By placing a label on the "end" statement, we tell the linker to indicate ;
; that the routine is to be executed when the module is first loaded. It can;
; be used to initialize the dynamic link library.  The label must be the    ;
; entry point of the initializer routine (init_ipdll).                      ;
;                                                                           ;
;***************************************************************************;

		end	init_ipdll
