/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

/*BEGINPROLOGUE**************************************************************/
/*                                                                          */
/*   Module Name:              IPINIT.C                                     */
/*                                                                          */
/*   Descriptive Name:         Module that contains functions to initialize */
/*                             memory tables required by the rest of the    */
/*                             application.                                 */
/*                                                                          */
/*   Status:                   Release 1, Level 0                           */
/*                                                                          */
/*   Function:                 Same as Descriptive name                     */
/*                                                                          */
/*                                                                          */
/*   Dependencies:             IBM OS/2 Extended Edition 1.30.1             */
/*                                                                          */
/*ENDPROLOGUE****************************************************************/
#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#define INCL_DOSMISC
#define INCL_DOSMEMMGR
#define INCL_GPIBITMAPS
#define INCL_WIN
#define INCL_PM
#include <os2.h>

#include <stdio.h>                     // Standard C standard input/output
#include <stdlib.h>                    // Standard C library header
#include <string.h>                    // Standard C string header
#include <ctype.h>                     // Contains standard macros and symbols
#include <fcntl.h>                     // IO defines and symbols
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>                        // Contains io macros and symbols

#define IPS_SDS_INCL                   // To include Spool Device Services
#define IPS_IMG_INCL                   // To include Image Services
#define IPS_PAG_INCL                   // To include Page Services
#define IPS_DSP_INCL                   // To include Display Services
#define IPS_OMS_INCL                   // To include Object Management System
#define IPS_OAS_INCL                   // To include Object Access Services
#include <ips.h>

#include "ip2impex.rch"                // Contains menu symbol definitions
#include "ip2impex.h"                  // Includes prototypes and Masthead
#include "dialog.h"                    // Contains defines used in dialog boxes
#include "globals.h"                   // Contains our global variables
#include "error.h"                     // Contains error definitions


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:          InitSystemTables                                         */
/*                                                                          */
/*  Description:   This function initailizes all system tables.  If this    */
/*                 function fails the entire application fails and we       */
/*                 exit back to OS/2's command line prompt.                 */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int InitSystemTables(int action)
{
   register int sRC;
   unsigned char chDrive;
   ULONG ulTempSerial;

   sRC = InitClassTable();
   if (sRC == SUCCESS)
      {
      sRC = InitAttrTable();
      if (sRC == SUCCESS)
         {
         sRC = InitWBTable();
         if (sRC == SUCCESS)
            {
            sRC = InitCCTable();
            if (sRC == SUCCESS)
               {
               sRC = InitSGTable();
               if (sRC == SUCCESS)
                  {
                  sRC = InitDrives();
                  if (sRC == SUCCESS)
                     {
                     sRC = InitClassGroupMap();
                     if (sRC == SUCCESS)
                        {
                        sRC = GetDASDVolumeOnDEFAULT(szDASDVolName,
                                 &ulDASDVolSer);
                        if (sRC == SUCCESS)
                           {
                           ulTempSerial = ulDASDVolSer;
                           sRC = FindDriveLetter(szDASDVolName,
                                    &ulTempSerial,&chDrive);
                           if (sRC != SUCCESS)
                              {
                              sRC = LogError(ERR_DRVNOTSHR,NULL);
                              }
                           else
                              {
                              szImportTempName[0] = chDrive;
                              szImportTempName[1] = ':';
                              szImportTempName[2] = '\\';
                              szImportTempName[3] = '\0';
                              strcat(szImportTempName,"IP2IMPEX.TMP");
                              }
                           }
                        }
                     }
                  }
               }
            }
         }
      }
   return(sRC);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:          InitClassTable                                           */
/*                                                                          */
/*  Description:   This function queries the system and builds a memory     */
/*                 table of all index classes in the system.  This table    */
/*                 is used to map an index class name to its Id.            */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int InitClassTable()
{
   register int sRC, i;
   RCSTRUCT RC;
   PUSHORT pClasses = NULL;
   PCLASSINFOSTRUCT pClsInfo;

   /* Init table of all index classes and their respective attributes       */

   memset(&RC,0,sizeof(RC));

   sRC = OimEnumerateClasses(
            LOC_OWNER_NAME,            // Identifier for owner of system classes
            IPS_OPT_SYNC,              // Process options - synchronous call
            NULL,                      // Window ID for synchronous call
            0,                         // Window message ID for
            &RC);                      // Pointer to a return structure

   if (sRC != SUCCESS)
      {
      sRC = ERR_ENUMCLS;
      }
   else
      {
      ClsTable.sClasses = (int) RC.usParam;
      ClsTable.pClasses = (PCLASSMAPSTRUCT) malloc(RC.usParam * sizeof(CLASSMAPSTRUCT));
      pClasses = (PUSHORT) RC.ulParam;
      if (ClsTable.pClasses == NULL)
         {
         sRC = ERR_INSUFMEM;
         }
      else
         {
         for (i = 0; i < ClsTable.sClasses; i++)
            {
            sRC = OimGetClassInfo(
                     pClasses[i],
                     IPS_OPT_SYNC,     // Perform function synchronously
                     NULL,             // No semaphore to synchronize
                     0,                // No message to synchronize
                     &RC);             // Pointer to return structure

            if (sRC != SUCCESS)
               {
               sRC = ERR_GETCLSINFO;
               break;
               }
            else
               {
               ClsTable.pClasses[i].usId = pClasses[i];
               pClsInfo = (PCLASSINFOSTRUCT) RC.ulParam;
               memcpy(&ClsTable.pClasses[i].Info,pClsInfo,
                  sizeof(CLASSINFOSTRUCT));
               //DosFreeSeg(SELECTOROF(pClsInfo));
               }
            }

         if (sRC != SUCCESS)
            {
            DosFreeSeg(SELECTOROF(ClsTable.pClasses));
            ClsTable.sClasses = 0;
            ClsTable.pClasses = NULL;
            }
         }
      DosFreeSeg(SELECTOROF(pClasses));
      }
   return(sRC);
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:          InitAttrTable                                            */
/*                                                                          */
/*  Description:   This function queries the system and builds a memory     */
/*                 table of all user-defined attributes in the system. This */
/*                 table is used to map an attribute name to its Id and     */
/*                 the other way around too.                                */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int InitAttrTable()
{
   register int sRC, i;
   RCSTRUCT RC;
   PUSHORT pAttrs = NULL;

   /* Init table of all user-defined attributes */

   memset(&RC,0,sizeof(RC));
   sRC = OimEnumerateAttrs(
            LOC_OWNER_NAME,            // Identifier for owner of attributes
            IPS_OPT_SYNC,              // Process options - synchronous call
            NULL,                      // Window ID for synchronous call
            0,                         // Window message ID for
            &RC);                      // Pointer to a return structure

   if (sRC != SUCCESS)
      {
      sRC = ERR_ENUMATTR;
      }
   else
      {
      AttrTable.sAttrs = (int) RC.usParam;
      AttrTable.pAttrs = (PATTRMAPSTRUCT) malloc(RC.usParam * sizeof(ATTRMAPSTRUCT));
      pAttrs = (PUSHORT) RC.ulParam;
      if (AttrTable.pAttrs == NULL)
         {
         sRC = ERR_INSUFMEM;
         }
      else
         {
         for (i = 0; i < AttrTable.sAttrs; i++)
            {
            sRC = OimGetAttrInfo(
                     pAttrs[i],
                     IPS_OPT_SYNC,     // Perform function synchronously
                     NULL,             // No semaphore to synchronize
                     0,                // No message to synchronize
                     &RC);             // Pointer to return structure

            if (sRC != SUCCESS)
               {
               sRC = ERR_GETATTRINFO;
               break;
               }
            else
               {
               AttrTable.pAttrs[i].usId = pAttrs[i];
               memcpy(
                  &AttrTable.pAttrs[i].Info,
                  (char *) RC.ulParam,
                  sizeof(ATTRINFOSTRUCT));
               }
            }

         if (sRC != SUCCESS)
            {
            DosFreeSeg(SELECTOROF(AttrTable.pAttrs));
            AttrTable.sAttrs = 0;
            AttrTable.pAttrs = NULL;
            }
         }
      DosFreeSeg(SELECTOROF(pAttrs));
      }
   return(sRC);
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:          InitWBTable                                              */
/*                                                                          */
/*  Description:   This function queries the system and builds a memory     */
/*                 table of all workbasketsfound in the system. This        */
/*                 table is used to map a workbasket name to its Id and     */
/*                 the other way around too.                                */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int InitWBTable()
{
   register int sRC, i;
   RCSTRUCT RC;
   PUID pWBs = NULL;

   /* Init table of all user-defined attributes */

   memset(&RC,0,sizeof(RC));
   sRC = OimEnumerateWorkBaskets(
            LOC_OWNER_NAME,            // Identifier for owner of workbaskets
            IPS_OPT_SYNC,              // Process options - synchronous call
            NULL,                      // Window ID for synchronous call
            0,                         // Window message ID for
            &RC);                      // Pointer to a return structure

   if (sRC != SUCCESS)
      {
      sRC = ERR_ENUMWB;
      }
   else
      {
      WBTable.sWBs = (int) RC.usParam;
      WBTable.pWBs = (PWBMAPSTRUCT) malloc(RC.usParam * sizeof(WBMAPSTRUCT));
      pWBs = (PUID) RC.ulParam;
      if (WBTable.pWBs == NULL)
         {
         sRC = ERR_INSUFMEM;
         }
      else
         {
         for (i = 0; i < WBTable.sWBs; i++)
            {
            sRC = OimGetWorkBasketInfo(
                     (PUID) pWBs[i],
                     IPS_OPT_SYNC,     // Perform function synchronously
                     NULL,             // No semaphore to synchronize
                     0,                // No message to synchronize
                     &RC);             // Pointer to return structure

            if (sRC != SUCCESS)
               {
               sRC = ERR_GETWBINFO;
               break;
               }
            else
               {
               memcpy(WBTable.pWBs[i].WBId,pWBs[i],sizeof(UID));
               memcpy(
                  &WBTable.pWBs[i].Info,
                  (char *) RC.ulParam,
                  sizeof(WBINFOSTRUCT));
               }
            }

         if (sRC != SUCCESS)
            {
            DosFreeSeg(SELECTOROF(WBTable.pWBs));
            WBTable.sWBs = 0;
            WBTable.pWBs = NULL;
            }
         }
      DosFreeSeg(SELECTOROF(pWBs));
      }
   return(sRC);
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:          InitCCTable                                              */
/*                                                                          */
/*  Description:   This function queries the system and builds a memory     */
/*                 table of all content classes in the system. This table   */
/*                 is used to map a content class name to its id and back.  */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int InitCCTable()
{
   register int sRC;
   RCSTRUCT RC;

   memset(&RC,0,sizeof(RC));

   /* Init table of all content classes */

   sRC = IpsQueryObjCls(
            IPS_OPT_SYNC,              // Perform function synchronously
            NULL,                      // No semaphore to synchronize
            0,                         // No message to synchronize
            &RC);                      // Pointer to return structure

   if (sRC != SUCCESS)
      {
      sRC = ERR_QRYCONCLS;
      }
   else
      {
      pConClasses = (POBJCLSSTRUCT) RC.ulParam;
      }

   return(sRC);
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:          InitSGTable                                              */
/*                                                                          */
/*  Description:   This function queries the system and builds a memory     */
/*                 table of all storage groups in the system.  This table   */
/*                 is used to map a storage group name to its Id and back.  */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int InitSGTable(void)
{
   register int sRC;
   RCSTRUCT RC;

   memset(&RC,0,sizeof(RCSTRUCT));

   sRC = IpsQueryObjectStgGroupNames(
            IPS_OPT_SYNC,              // Perform function synchronously
            NULL,                      // No semaphore to synchronize
            0,                         // No message to synchronize
            &RC);                      // Pointer to return structure

   if (sRC != SUCCESS)
      {
      sRC = ERR_QRYSTGGROUP;
      }
   else
      {
      SGList.sSGs = RC.usParam;
      SGList.pSGs = (PSTGGROUPNAMESTRUCT) RC.ulParam;
      }
   return(sRC);
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:          ReadDefaults                                             */
/*                                                                          */
/*  Description:   This function opens the defaults file and reads the      */
/*                 default information used in the Setup dialog box.        */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int ReadDefaults()
{
   register int rc = SUCCESS;
   int fh;
   USHORT usId;
   UID uid;

   fh = open(szDefFile,O_BINARY | O_RDONLY);
   if (fh != -1)
      {
      read(fh,&KnownClass,sizeof(KnownClass));
      read(fh,&UnknownClass,sizeof(UnknownClass));
      read(fh,&ExportDefaults,sizeof(ExportDefaults));
      read(fh,szDefWorkBasket,sizeof(szDefWorkBasket));
      read(fh,&ImportFiles,sizeof(ImportFiles));
      read(fh,&szImportPath,sizeof(szImportPath));
      read(fh,&szExportPath,sizeof(szExportPath));
      read(fh,&bAutoNote,sizeof(bAutoNote));
      close(fh);

      if (WBToUID(KnownClass.szWorkBasket,(PUID) uid) != SUCCESS)
         {
         if (WBTable.pWBs != NULL)
            {
            strcpy(KnownClass.szWorkBasket,WBTable.pWBs->Info.szWorkbasketName);
            }
         }

      if (WBToUID(UnknownClass.szWorkBasket,(PUID) uid) != SUCCESS)
         {
         if (WBTable.pWBs != NULL)
            {
            strcpy(UnknownClass.szWorkBasket,WBTable.pWBs->Info.szWorkbasketName);
            }
         }

      if (ClassToId(UnknownClass.szBestFitClass,&usId) != SUCCESS)
         {
         if (ClsTable.pClasses != NULL)
            {
            strcpy(UnknownClass.szBestFitClass,ClsTable.pClasses->Info.szClassName);
            }
         }

      if (WBToUID(ExportDefaults.szWorkBasket,(PUID) uid) != SUCCESS)
         {
         if (WBTable.pWBs != NULL)
            {
            strcpy(ExportDefaults.szWorkBasket,WBTable.pWBs->Info.szWorkbasketName);
            }
         }

      if (WBToUID(szDefWorkBasket,(PUID) uid) != SUCCESS)
         {
         if (WBTable.pWBs != NULL)
            {
            strcpy(szDefWorkBasket,WBTable.pWBs->Info.szWorkbasketName);
            }
         }

      if (ExportDefaults.szFName[0] == '\0')
         {
         strcpy(ExportDefaults.szFName,"IP2EXPRT");
         }
      }
   return(rc);
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:          SaveDefaults                                             */
/*                                                                          */
/*  Description:   This function opens the defaults file and writes the     */
/*                 default information used in the Setup dialog box.        */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int SaveDefaults()
{
   register int rc = SUCCESS;
   int fh;

   fh = open(szDefFile,O_CREAT | O_TRUNC | O_BINARY | O_RDWR,S_IWRITE | S_IREAD);
   if (fh != -1)
      {
      write(fh,&KnownClass,sizeof(KnownClass));
      write(fh,&UnknownClass,sizeof(UnknownClass));
      write(fh,&ExportDefaults,sizeof(ExportDefaults));
      write(fh,szDefWorkBasket,sizeof(szDefWorkBasket));
      write(fh,&ImportFiles,sizeof(ImportFiles));
      write(fh,&szImportPath,sizeof(szImportPath));
      write(fh,&szExportPath,sizeof(szExportPath));
      write(fh,&bAutoNote,sizeof(bAutoNote));
      close(fh);
      }
   return(rc);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int InitializeGlobalData()
{
   register int sRC = SUCCESS;
   register int len;
   char *p;

   InitPointers();
   p = getenv("IP2IMPEX");
   if (p == NULL)
      {
      strcpy(szAppPath,"C:\\");
      sRC = LogError(ERR_NOENVAR,NULL);
      }
   else
      {
      strcpy(szAppPath,p);
      len = strlen(szAppPath);
      if (len == 0)
         {
         strcpy(szAppPath,"C:\\");
         }
      else
         {
         if (szAppPath[len-1] == ';')
            szAppPath[len-1] = '\0';

         len = strlen(szAppPath);
         if (szAppPath[len-1] != '\\')
            {
            szAppPath[len] = '\\';
            szAppPath[len+1] = '\0';
            }
         }
      }
   strcpy(szDefFile,szAppPath);
   strcat(szDefFile,"DEFAULTS.SYS");
   strcpy(szSGMapListFile,szAppPath);
   strcat(szSGMapListFile,"GROUPLST.SYS");
   strcpy(szIPImportLog,szAppPath);
   strcat(szIPImportLog,"IP2IMPEX.LOG");
   strcpy(szImportPath,szAppPath);
   strcpy(szExportPath,szAppPath);
   strcpy(szAppName,"IP2IMPEX");

   return(sRC);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void InitPointers()
{
   ClsTable.sClasses = 0;
   ClsTable.pClasses = NULL;

   AttrTable.sAttrs = 0;
   AttrTable.pAttrs = NULL;

   WBTable.sWBs = 0;
   WBTable.pWBs = NULL;

   pConClasses = NULL;
   pDeleteList = NULL;

   pSGMapList = NULL;
   pStgClassList = NULL;

   memset(&KnownClass,0,sizeof(KnownClass));
   KnownClass.bDelete = FALSE;
   KnownClass.bAppend = TRUE;
   KnownClass.Destination = DEST_FILEROOM;

   memset(&UnknownClass,0,sizeof(UnknownClass));
   UnknownClass.bDelete = FALSE;
   UnknownClass.bAppend = TRUE;
   UnknownClass.Destination = DEST_FILEROOM;

   memset(&ExportDefaults,0,sizeof(ExportDefaults));
   ExportDefaults.bFolder = TRUE;
   ExportDefaults.Destination = DEST_ROUTE;

   memset(&ImportFiles,0,sizeof(ImportFiles));
   ImportFiles.bLST = TRUE;
   ImportFiles.bINX = TRUE;

   memset(szImportPath,0,sizeof(szImportPath));
   memset(szExportPath,0,sizeof(szExportPath));
   memset(szDASDVolName,0,sizeof(szDASDVolName));
   memset(szIPImportLog,0,sizeof(szIPImportLog));
   return;
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:          FreeSystemTables                                         */
/*                                                                          */
/*  Description:   This function frees the memory associated with all       */
/*                 system tables.                                           */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void FreeSystemTables(void)
{
   register int i = 0;

   // InitClassTable
   // InitAttrTable
   // InitWBTable
   // InitCCTable
   // InitSGTable
   // ReadDefaults
   // InitClassGroupMap

   return;
}
