/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

/*BEGINPROLOGUE**************************************************************/
/*                                                                          */
/*   Module Name:              IPGROUPS.C                                   */
/*                                                                          */
/*   Descriptive Name:         This module contains functions that          */
/*                             manipulate the index-class/storage-group     */
/*                             mappings.                                    */
/*                                                                          */
/*   Status:                   Release 1, Level 0                           */
/*                                                                          */
/*   Dependencies:             IBM OS/2 Extended Edition 1.30.1             */
/*                                                                          */
/*ENDPROLOGUE****************************************************************/

#define INCL_DOSMEMMGR
#define INCL_GPIBITMAPS
#define INCL_WIN
#define INCL_PM
#include <os2.h>

#include <stdio.h>                     // Standard C standard input/output
#include <stdlib.h>                    // Standard C library header
#include <string.h>                    // Standard C string header
#include <ctype.h>                     // Contains standard macros and symbols
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>

#define IPS_SDS_INCL                   // To include Spool Device Services
#define IPS_IMG_INCL                   // To include Image Services
#define IPS_PAG_INCL                   // To include Page Services
#define IPS_DSP_INCL                   // To include Display Services
#define IPS_OMS_INCL                   // To include Object Management System
#define IPS_OAS_INCL                   // To include Object Access Services
#include <ips.h>

#include "ip2impex.rch"                // Contains menu symbol definitions
#include "ip2impex.h"                  // Includes prototypes and Masthead
#include "dialog.h"                    // Contains defines used in dialog boxes
#include "globals.h"                   // Contains our global variables
#include "error.h"                     // Contains error definitions

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int InitClassGroupMap()
{
   register int rc = SUCCESS, i, n;
   int fh, done = 0, count;
   SGMAPSTRUCT MapRec;
   PSGMAPSTRUCT pMapStruct;
   USHORT sgid;

   if (pSGMapList != NULL)
      {
      DestroyList(pSGMapList);
      }
   pSGMapList = CreateList(LT_FIXEDLEN,sizeof(SGMAPSTRUCT));
   if (pSGMapList != NULL)
      {
      fh = open(szSGMapListFile,O_BINARY | O_RDONLY);
      if (fh != -1)
         {
         n = (int) (filelength(fh) / sizeof(SGMAPSTRUCT));
         for (i = 0; i < n; i++)
            {
            count = read(fh,&MapRec,sizeof(MapRec));
            // verify that storage groups associated with index classes read
            // in from disk exist in this particular system.
            MapRec.bExclude = TRUE;
            if (StgGroupToId(MapRec.szStgGroupName,&sgid) == -1)
               {
               strcpy(MapRec.szStgGroupName,"DEFAULT");
               }
            rc = AppendListItem(pSGMapList,(char *)&MapRec);
            }
         close(fh);
         }

      // add any new index classes to the file and make DEFAULT their sg.
      // exclude (mark) from the list index classes that are not present in this system.

      for (i = 0; i < ClsTable.sClasses; i++)
         {
         pMapStruct = (PSGMAPSTRUCT) FindClassMapEntry(ClsTable.pClasses[i].Info.szClassName);
         if (pMapStruct == NULL)
            {
            memset(&MapRec,0,sizeof(MapRec));
            strcpy(MapRec.szClassName,ClsTable.pClasses[i].Info.szClassName);
            strcpy(MapRec.szStgGroupName,"DEFAULT");
            MapRec.bExclude = FALSE;
            rc = AppendListItem(pSGMapList,(char *) &MapRec);
            }
         else
            {
            pMapStruct->bExclude = FALSE;
            }
         }
      //rc = SaveClassGroupMap();
      }
   else
      {
      rc = ERR_INSUFMEM;
      }
   return(rc);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int SaveClassGroupMap()
{
   register int rc = SUCCESS, count;
   int fh;
   char *p = NULL;
   PSGMAPSTRUCT pMapStruct;

   SeekList(pSGMapList,LSEEK_TOP);
   if (QueryListCount(pSGMapList) > 0)
      {
      fh = open(szSGMapListFile,O_BINARY | O_CREAT | O_TRUNC | O_RDWR,S_IREAD | S_IWRITE);
      if (fh != -1)
         {
         pMapStruct = (PSGMAPSTRUCT) TopListItem(pSGMapList);
         do
            {
            count = write(fh,pMapStruct,sizeof(SGMAPSTRUCT));
            if (count != sizeof(SGMAPSTRUCT))
               {
               rc = ERR_READING;
               }
            else
               {
               pMapStruct = (PSGMAPSTRUCT) NextListItem(pSGMapList);
               }
            }
         while (pMapStruct != NULL && rc == SUCCESS);
         close(fh);
         }
      else
         {
         rc = ERR_CREATING;
         }
      }
   return(rc);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

PSGMAPSTRUCT FindClassMapEntry(char *szClass)
{
   PSGMAPSTRUCT pMapStruct;

   if ((pMapStruct = (PSGMAPSTRUCT) TopListItem(pSGMapList)) != NULL)
      {
      do
         {
         if (strcmpi(szClass,pMapStruct->szClassName) == 0)
            break;

         pMapStruct = (PSGMAPSTRUCT) NextListItem(pSGMapList);
         }
      while (pMapStruct != NULL);
      }
   return(pMapStruct);
}


PIPLIST pTSGMapList = NULL;

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void PushClassMapTable()
{
   PSGMAPSTRUCT pNode;

   if (pSGMapList != NULL)
      {
      if ((pNode = (PSGMAPSTRUCT) TopListItem(pSGMapList)) != NULL)
         {
         if (pTSGMapList != NULL)
            {
            DestroyList(pTSGMapList);
            }

         pTSGMapList = CreateList(LT_FIXEDLEN,sizeof(SGMAPSTRUCT));
         do
            {
            AppendListItem(pTSGMapList,(char *) pNode);
            pNode = (PSGMAPSTRUCT) NextListItem(pSGMapList);
            }
         while (pNode != NULL);
         }
      }
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void PopClassMapTable()
{
   if (pTSGMapList != NULL)
      {
      DestroyList(pSGMapList);
      pSGMapList = pTSGMapList;
      pTSGMapList = NULL;
      }
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void DestroyClassMapTable()
{
   if (pTSGMapList != NULL)
      {
      DestroyList(pTSGMapList);
      }
   return;
}
