/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

/*BEGINPROLOGUE**************************************************************/
/*                                                                          */
/*   Module Name:              IPERR.C                                      */
/*                                                                          */
/*   Descriptive Name:         Module that contains functions to report     */
/*                             errors to the user as well as logging        */
/*                             them for field service.                      */
/*                                                                          */
/*   Status:                   Release 1, Level 0                           */
/*                                                                          */
/*   Function:                 Same as Descriptive name                     */
/*                                                                          */
/*                                                                          */
/*   Dependencies:             IBM OS/2 Extended Edition 1.30.1             */
/*                                                                          */
/*ENDPROLOGUE****************************************************************/
#define INCL_DOSMEMMGR
#define INCL_GPIBITMAPS
#define INCL_WIN
#define INCL_PM
#include <os2.h>

#include <stdio.h>                     // Standard C standard input/output
#include <stdlib.h>                    // Standard C library header
#include <string.h>                    // Standard C string header
#include <ctype.h>                     // Contains standard macros and symbols
#include <time.h>                      // Contains time-related macros and symbols

#define IPS_SDS_INCL                   // To include Spool Device Services
#define IPS_IMG_INCL                   // To include Image Services
#define IPS_PAG_INCL                   // To include Page Services
#define IPS_DSP_INCL                   // To include Display Services
#define IPS_OMS_INCL                   // To include Object Management System
#define IPS_OAS_INCL                   // To include Object Access Services
#include <ips.h>

#include "ip2impex.rch"                // Contains menu symbol definitions
#include "ip2impex.h"                  // Includes prototypes and Masthead
#include "dialog.h"                    // Contains defines used in dialog boxes
#include "globals.h"                   // Contains our global variables
#include "error.h"                     // Contains error definitions

static USHORT Error = 0xffff;
static char *szStr = "NULL";
static char *szFName = "UNKNOWN";
static int Line = -1;
static char szStrErr[256];             // The resource string is stored here

/*BEGINHEADER****************************************************************/
/*                                                                          */
/*  Name:         _ReportError                                              */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*  This function is called by the ReportError macro. It displays the error */
/*  to the user and logs it to the IP2IMPEX.LOG text file for field service */
/*                                                                          */
/*ENDHEADER******************************************************************/

void _ReportError(USHORT usError,char *szString,char *szFileName,int LineNo)
{
   Error = usError;
   szStr = szString;
   szFName = szFileName;
   Line = LineNo;

   szStrErr[0] = '\0';
   WinLoadString(hAB,0,usError,sizeof(szStrErr),szStrErr);

   WinDlgBox(HWND_DESKTOP,hWndFrame,ErrorDlgProc,0,ID_ERR_DLG,NULL);
   return;
}


/*BEGINHEADER****************************************************************/
/*                                                                          */
/*  Name:         ErrorDlgProc                                              */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*  This is the dialog proc for the ID_ERR_DLG dialog box.                  */
/*                                                                          */
/*ENDHEADER******************************************************************/

MRESULT EXPENTRY ErrorDlgProc(
   HWND hDlg,
   USHORT msg,
   MPARAM mp1,
   MPARAM mp2)
{
   char szErr[12];

   switch (msg)
      {
      case WM_INITDLG:
         if (hWndFrame == NULL)
            CenterWindow(hDlg,HWND_DESKTOP);
         else
            CenterWindow(hDlg,hWndFrame);
         sprintf(szErr,"Error %d",Error);
         WinSetDlgItemText(hDlg,ID_ERRNO,szErr);
         WinSetDlgItemText(hDlg,ID_ERRMSG,szStrErr);
         DosBeep(1000,100);
         break;

      case WM_COMMAND:
         switch (SHORT1FROMMP(mp1))
           {
           case IDD_CANCEL:
              //AppendError();
              WinDismissDlg(hDlg,TRUE);
              break;

           default:
              break;
           }
        break;

     default:
        return(WinDefDlgProc(hDlg,msg,mp1,mp2));
        break;
     }
   return(FALSE);
}


/*BEGINHEADER****************************************************************/
/*                                                                          */
/*  Name:         AppendError                                               */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*  This function appends a text line to IP2IMPEX.LOG based on error info   */
/*  passed to _ReportError and locally global in static variables.          */
/*                                                                          */
/*ENDHEADER******************************************************************/

void AppendError(void)
{
   FILE *fp;
   char szTime[12];
   char szDate[12];
   static int bFirstTime = TRUE;

   fp = fopen(szIPImportLog,"a+t");
   if (fp != NULL)
      {
      _strdate(szDate);
      _strtime(szTime);
      if (bFirstTime)
         {
         fprintf(fp,"\n\n%s - ImagePlus/2 Import/Export Facility\n\n",szDate);
         fprintf(fp,"%-10s%-14s%6s%7s %s\n","Time","Module","Line","Error","Description");
         bFirstTime = FALSE;
         }
      fprintf(fp,"%-10s%-14s%6d%7d %s\n",szTime,szFName,Line,Error,szStrErr);
      fclose(fp);
      }
   return;
}

/*BEGINHEADER****************************************************************/
/*                                                                          */
/*  Name:         _LogError                                                 */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*  This function calls AppendError to append a text line to IP2IMPEX.LOG   */
/*  based on error info passed to _LogError and locally global in static    */
/*  variables.                                                              */
/*                                                                          */
/*ENDHEADER******************************************************************/

int _LogError(USHORT usError,char *szString,char *szFileName,int LineNo)
{
   Error = usError;
   szStr = szString;
   szFName = szFileName;
   Line = LineNo;

   szStrErr[0] = '\0';
   WinLoadString(hAB,hRCMod,usError,sizeof(szStrErr),szStrErr);
   AppendError();
   return(usError);
}
