/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

/*BEGINPROLOGUE**************************************************************/
/*                                                                          */
/*   Module Name:              IPDIALOG.C                                   */
/*                                                                          */
/*   Descriptive Name:         This module contains the dialog procedures   */
/*                             for the various dialog boxes used throughout */
/*                             the application                              */
/*                                                                          */
/*   Status:                   Release 1, Level 0                           */
/*                                                                          */
/*   Dependencies:             IBM OS/2 Extended Edition 1.30.1             */
/*                                                                          */
/*ENDPROLOGUE****************************************************************/

#define INCL_DOSMODULEMGR
#define INCL_DOSMEMMGR
#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#define INCL_DOSMISC
#define INCL_GPIBITMAPS
#define INCL_WIN
#define INCL_PM
#include <os2.h>

#include <stdio.h>                     // Standard C standard input/output
#include <stdlib.h>                    // Standard C library header
#include <string.h>                    // Standard C string header
#include <ctype.h>                     // Contains standard macros and symbols
#include <time.h>                      // Contains time-related macros and symbols

#define IPS_SDS_INCL                   // To include Spool Device Services
#define IPS_IMG_INCL                   // To include Image Services
#define IPS_PAG_INCL                   // To include Page Services
#define IPS_DSP_INCL                   // To include Display Services
#define IPS_OMS_INCL                   // To include Object Management System
#define IPS_OAS_INCL                   // To include Object Access Services
#include <ips.h>

#include "ip2impex.rch"                // Contains menu symbol definitions
#include "ip2impex.h"                  // Includes prototypes and Masthead
#include "dialog.h"                    // Contains defines used in dialog boxes
#include "globals.h"                   // Contains our global variables
#include "error.h"                     // Contains error definitions

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

MRESULT EXPENTRY ImportDlgProc(
   HWND hDlg,
   USHORT msg,
   MPARAM mp1,
   MPARAM mp2)
{
   register int index, rc;
   char buffer[65];
   char a[256];
   USHORT usDrive;
   char szCurDir[65];
   ULONG lDriveMap;
   USHORT usDirLen;
   int count, i;

   switch (msg)
      {
      case WM_INITDLG:
         ReadDefaults();
         CheckMenuItem(IDM_AUTONOTE,bAutoNote);
         if (pImportItems != NULL)
            {
            DestroyList(pImportItems);
            pImportItems = NULL;
            }
         if (szImportPath[0] != '\0')
            {
            if (isalpha(szImportPath[0]) && szImportPath[1] == ':')
               {
               usDrive = (USHORT) (szImportPath[0] - 'A' + 1);
               DosError(1);
               rc = DosSelectDisk(usDrive);
               DosError(0);
               if (rc == SUCCESS)
                  {
                  DosError(1);
                  rc = DosChDir(&szImportPath[2],0L);
                  DosError(0);
                  }
               }
            }

         WinSendDlgItemMsg(hDlg,ID_LSTBOX,
            BM_SETCHECK,MPFROMSHORT(ImportFiles.bLST),MPFROMSHORT(0));
         WinSendDlgItemMsg(hDlg,ID_INXBOX,
            BM_SETCHECK,MPFROMSHORT(ImportFiles.bINX),MPFROMSHORT(0));
         WinSendDlgItemMsg(hDlg,ID_MDIBOX,
            BM_SETCHECK,MPFROMSHORT(ImportFiles.bMDI),MPFROMSHORT(0));
         WinSendDlgItemMsg(hDlg,ID_TIFBOX,
            BM_SETCHECK,MPFROMSHORT(ImportFiles.bTIF),MPFROMSHORT(0));
         WinSendDlgItemMsg(hDlg,ID_CIFBOX,
            BM_SETCHECK,MPFROMSHORT(ImportFiles.bCIF),MPFROMSHORT(0));

         WinSendMsg(hDlg,UM_REDO_DIRLIST,MPFROMSHORT(0),MPFROMSHORT(0));
         break;

      case UM_REDO_DIRLIST:
         rc = DosQCurDisk(&usDrive,&lDriveMap);
         usDirLen = sizeof(szCurDir);
         rc = DosQCurDir(usDrive,szCurDir,&usDirLen);
         buffer[0] = (char) (('A' + usDrive) - 1);
         buffer[1] = ':';
         buffer[2] = '\\';
         buffer[3] = '\0';
         if (rc != SUCCESS)
            {
            szCurDir[0] = '\0';
            }
         strupr(szCurDir);
         strcat(buffer,szCurDir);

         WinSetDlgItemText(hDlg,ID_PATH,buffer);
         CenterWindow(hDlg,hWndFrame);

         WinSendDlgItemMsg(hDlg,ID_PATH_LIST,
            LM_DELETEALL,MPFROMSHORT(0),MPFROMSHORT(0));

         WinSendDlgItemMsg(hDlg,ID_IMPFILES_LIST,
            LM_DELETEALL,MPFROMSHORT(0),MPFROMSHORT(0));

         InitList(WinWindowFromID(hDlg,ID_PATH_LIST),TRUE);
         AddDrivesToList(WinWindowFromID(hDlg,ID_PATH_LIST));
         InitList(WinWindowFromID(hDlg,ID_IMPFILES_LIST),FALSE);
         WinSendDlgItemMsg(hDlg,ID_PATH_LIST,
            LM_SELECTITEM,MPFROMSHORT(0),MPFROMSHORT(TRUE));
         break;

      case WM_CONTROL:
         switch (SHORT1FROMMP(mp1))
            {
            case ID_IMPFILES_LIST:
               if (SHORT2FROMMP(mp1) == LN_ENTER)
                  {
                  WinQueryDlgItemText(hDlg,ID_PATH,
                     sizeof(szImportPath),szImportPath);

                  index = (SHORT) (LONG) WinSendDlgItemMsg(hDlg,ID_IMPFILES_LIST,
                     LM_QUERYSELECTION,MPFROMSHORT(LIT_FIRST),MPFROMSHORT(0));

                  if (index != LIT_NONE)
                     {
                     WinSendDlgItemMsg(hDlg,ID_IMPFILES_LIST,LM_QUERYITEMTEXT,
                        MPFROM2SHORT(index,sizeof(buffer)),MPFROMP(buffer));
                     if (strstr(buffer,".INX") || strstr(buffer,".LST"))
                        {
                        CombinePathAndName(szImportPath,buffer,szCurDir);
                        LoadEditor(szCurDir);
                        }
                     else if(strstr(buffer,".CIF"))
                        {
                        CombinePathAndName(szImportPath,buffer,szCurDir);
                        szCurDir[strlen(szCurDir)-3]=0;
                        sprintf(a,"read_hdr %sCIF %sRPT",szCurDir,szCurDir);
                        system(a);
                        CombinePathAndName(szImportPath,buffer,szCurDir);
                        szCurDir[strlen(szCurDir)-3]='R';
                        szCurDir[strlen(szCurDir)-2]='P';
                        szCurDir[strlen(szCurDir)-1]='T';
                        LoadEditor(szCurDir);
                        }
                     else
                        {
                        DosBeep(1000,150);
                        }
                     }
                  }
               break;

            case ID_LSTBOX:
               ImportFiles.bLST = (SHORT) (ULONG) WinSendDlgItemMsg(hDlg,ID_LSTBOX,
                  BM_QUERYCHECK,MPFROMSHORT(0),MPFROMSHORT(0));

               WinSendDlgItemMsg(hDlg,ID_IMPFILES_LIST,
                  LM_DELETEALL,MPFROMSHORT(0),MPFROMSHORT(0));
               InitList(WinWindowFromID(hDlg,ID_IMPFILES_LIST),FALSE);
               break;

            case ID_INXBOX:
               ImportFiles.bINX = (SHORT) (ULONG) WinSendDlgItemMsg(hDlg,ID_INXBOX,
                  BM_QUERYCHECK,MPFROMSHORT(0),MPFROMSHORT(0));

               WinSendDlgItemMsg(hDlg,ID_IMPFILES_LIST,
                  LM_DELETEALL,MPFROMSHORT(0),MPFROMSHORT(0));
               InitList(WinWindowFromID(hDlg,ID_IMPFILES_LIST),FALSE);
               break;

            case ID_MDIBOX:
               ImportFiles.bMDI = (SHORT) (ULONG) WinSendDlgItemMsg(hDlg,ID_MDIBOX,
                  BM_QUERYCHECK,MPFROMSHORT(0),MPFROMSHORT(0));

               WinSendDlgItemMsg(hDlg,ID_IMPFILES_LIST,
                  LM_DELETEALL,MPFROMSHORT(0),MPFROMSHORT(0));
               InitList(WinWindowFromID(hDlg,ID_IMPFILES_LIST),FALSE);
               break;

            case ID_TIFBOX:
               ImportFiles.bTIF = (SHORT) (ULONG) WinSendDlgItemMsg(hDlg,ID_TIFBOX,
                  BM_QUERYCHECK,MPFROMSHORT(0),MPFROMSHORT(0));

               WinSendDlgItemMsg(hDlg,ID_IMPFILES_LIST,
                  LM_DELETEALL,MPFROMSHORT(0),MPFROMSHORT(0));
               InitList(WinWindowFromID(hDlg,ID_IMPFILES_LIST),FALSE);
               break;

            case ID_CIFBOX:
               ImportFiles.bCIF = (SHORT) (ULONG) WinSendDlgItemMsg(hDlg,ID_CIFBOX,
                  BM_QUERYCHECK,MPFROMSHORT(0),MPFROMSHORT(0));

               WinSendDlgItemMsg(hDlg,ID_IMPFILES_LIST,
                  LM_DELETEALL,MPFROMSHORT(0),MPFROMSHORT(0));
               InitList(WinWindowFromID(hDlg,ID_IMPFILES_LIST),FALSE);
               break;


            case ID_PATH_LIST:
               if (SHORT2FROMMP(mp1) == LN_ENTER)
                  {
                  index = (SHORT) (LONG) WinSendDlgItemMsg(hDlg,ID_PATH_LIST,
                     LM_QUERYSELECTION,
                     MPFROMSHORT(LIT_FIRST),
                     MPFROMSHORT(0));

                  WinSendDlgItemMsg(hDlg,ID_PATH_LIST,
                     LM_QUERYITEMTEXT,
                     MPFROM2SHORT(index,sizeof(buffer)),
                     MPFROMP(buffer));

                  DosError(1);
                  if (buffer[0] != '[')
                     {
                     rc = DosChDir(buffer,0L);
                     }
                  else
                     {
                     rc = DosSelectDisk((buffer[1] - 'A') + 1);
                     }
                  DosError(0);
                  WinSendMsg(hDlg,UM_REDO_DIRLIST,MPFROMSHORT(0),MPFROMSHORT(0));
                  }
               break;
            }
         break;

      case WM_COMMAND:
         switch (SHORT1FROMMP(mp1))
            {
            case IDD_SELECTALL:
               count = (int) (long) WinSendDlgItemMsg(hDlg,ID_IMPFILES_LIST,
                           LM_QUERYITEMCOUNT,MPFROMSHORT(0),MPFROMSHORT(0));
               for (i = 0; i < count; i++)
                  {
                  WinSendDlgItemMsg(hDlg,ID_IMPFILES_LIST,LM_SELECTITEM,
                     MPFROMSHORT(i),MPFROMSHORT(TRUE));
                  }
               break;

            case IDD_CLEAR:
               WinSendDlgItemMsg(hDlg,ID_IMPFILES_LIST,LM_SELECTITEM,
                  MPFROMSHORT(LIT_NONE),MPFROMSHORT(FALSE));
               break;

            case IDD_IMPORT:
               WinQueryDlgItemText(hDlg,ID_PATH,
                  sizeof(szImportPath),szImportPath);

               GetSelectedItems(WinWindowFromID(hDlg,ID_IMPFILES_LIST),
                  &pImportItems);

               SaveDefaults();
               if (QueryListCount(pImportItems) == 0)
                  {
                  ReportError(ERR_NOIMPFILES,NULL);
                  }
               else
                  {
                  WinDismissDlg(hDlg,TRUE);
                  }
               break;

            case IDD_CANCEL:
               WinDismissDlg(hDlg,FALSE);
               break;

            case IDD_SETUP:
               WinDlgBox(HWND_DESKTOP,hDlg,ImportSetupDlgProc,
                  0,ID_IMPSETUP,NULL);
               break;

            default:
               break;
            }
         break;

      default:
         return(WinDefDlgProc(hDlg,msg,mp1,mp2));
         break;
      }
   return(FALSE);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

MRESULT EXPENTRY ImportSetupDlgProc(
   HWND hDlg,
   USHORT msg,
   MPARAM mp1,
   MPARAM mp2)
{
   switch (msg)
      {
      case WM_INITDLG:
         ReadDefaults();
         CheckMenuItem(IDM_AUTONOTE,bAutoNote);
         CenterWindow(hDlg,hWndFrame);
         FillListWithWBs(WinWindowFromID(hDlg,ID_ROUTEWB1),LM_INSERTITEM);
         FillListWithWBs(WinWindowFromID(hDlg,ID_ROUTEWB),LM_INSERTITEM);
         FillListWithClasses(WinWindowFromID(hDlg,ID_BESTFITCLASS),LM_INSERTITEM);

         WinSendDlgItemMsg(hDlg,ID_DELETE1,
            BM_SETCHECK,MPFROMSHORT(KnownClass.bDelete),MPFROMSHORT(0));

         WinSendDlgItemMsg(hDlg,ID_APPEND1,
            BM_SETCHECK,MPFROMSHORT(KnownClass.bAppend),MPFROMSHORT(0));

         if (KnownClass.szWorkBasket[0])
            {
            WinSetDlgItemText(hDlg,ID_ROUTEWB1,KnownClass.szWorkBasket);
            }
         else
            {
            WinSendDlgItemMsg(hDlg,ID_ROUTEWB1,
               LM_SELECTITEM,MPFROMSHORT(0),MPFROMSHORT(TRUE));
            }

         WinEnableWindow(WinWindowFromID(hDlg,ID_ROUTEWB1),FALSE);

         switch (KnownClass.Destination)
            {
            case DEST_FILEROOM:
               WinSendDlgItemMsg(hDlg,ID_SAVEITEMS1,
                  BM_SETCHECK,MPFROMSHORT(1),MPFROMSHORT(0));
               break;

            case DEST_ROUTE:
               WinSendDlgItemMsg(hDlg,ID_ROUTEITEMS1,
                  BM_SETCHECK,MPFROMSHORT(1),MPFROMSHORT(0));

               WinEnableWindow(WinWindowFromID(hDlg,ID_ROUTEWB1),TRUE);
               break;
            }

         if (UnknownClass.szBestFitClass[0])
            {
            WinSetDlgItemText(hDlg,ID_BESTFITCLASS,
               UnknownClass.szBestFitClass);
            }
         else
            {
            WinSendDlgItemMsg(hDlg,ID_BESTFITCLASS,
               LM_SELECTITEM,MPFROMSHORT(0),MPFROMSHORT(TRUE));
            }

         WinSendDlgItemMsg(hDlg,ID_DELETE,
            BM_SETCHECK,MPFROMSHORT(UnknownClass.bDelete),MPFROMSHORT(0));

         WinSendDlgItemMsg(hDlg,ID_APPEND,
            BM_SETCHECK,MPFROMSHORT(UnknownClass.bAppend),MPFROMSHORT(0));

         if (UnknownClass.szWorkBasket[0])
            {
            WinSetDlgItemText(hDlg,ID_ROUTEWB,UnknownClass.szWorkBasket);
            }
         else
            {
            WinSendDlgItemMsg(hDlg,ID_ROUTEWB,
               LM_SELECTITEM,MPFROMSHORT(0),MPFROMSHORT(TRUE));
            }

         WinEnableWindow(WinWindowFromID(hDlg,ID_ROUTEWB),FALSE);

         switch (UnknownClass.Destination)
            {
            case DEST_NOIMPORT:
               WinSendDlgItemMsg(hDlg,ID_DONTIMPORT,
                  BM_SETCHECK,MPFROMSHORT(1),MPFROMSHORT(0));
               break;

            case DEST_FILEROOM:
               WinSendDlgItemMsg(hDlg,ID_SAVEITEMS,
                  BM_SETCHECK,MPFROMSHORT(1),MPFROMSHORT(0));
               break;

            case DEST_ROUTE:
               WinSendDlgItemMsg(hDlg,ID_ROUTEITEMS,
                  BM_SETCHECK,MPFROMSHORT(1),MPFROMSHORT(0));

               WinEnableWindow(WinWindowFromID(hDlg,ID_ROUTEWB),TRUE);
               break;
            }
         break;

      case WM_CONTROL:
         switch (SHORT1FROMMP(mp1))
            {
            case ID_SAVEITEMS1:
               WinEnableWindow(WinWindowFromID(hDlg,ID_ROUTEWB1),FALSE);
               break;

            case ID_ROUTEITEMS1:
               WinEnableWindow(WinWindowFromID(hDlg,ID_ROUTEWB1),TRUE);
               break;

            case ID_DONTIMPORT:
            case ID_SAVEITEMS:
               WinEnableWindow(WinWindowFromID(hDlg,ID_ROUTEWB),FALSE);
               break;
            case ID_ROUTEITEMS:
               WinEnableWindow(WinWindowFromID(hDlg,ID_ROUTEWB),TRUE);
               break;
            }
         break;

      case WM_COMMAND:
         switch (SHORT1FROMMP(mp1))
            {
            case IDD_SETUP:
               KnownClass.bDelete = (SHORT) (ULONG) WinSendDlgItemMsg(
                  hDlg,ID_DELETE1,
                  BM_QUERYCHECK,MPFROMSHORT(0),MPFROMSHORT(0));

               KnownClass.bAppend = (SHORT) (ULONG) WinSendDlgItemMsg(
                  hDlg,ID_APPEND1,
                  BM_QUERYCHECK,MPFROMSHORT(0),MPFROMSHORT(0));

               if (WinSendDlgItemMsg(hDlg,ID_SAVEITEMS1,
                     BM_QUERYCHECK,MPFROMSHORT(0),MPFROMSHORT(0)))
                  {
                  KnownClass.Destination = DEST_FILEROOM;
                  }
               else if (WinSendDlgItemMsg(hDlg,ID_ROUTEITEMS1,
                           BM_QUERYCHECK,MPFROMSHORT(0),MPFROMSHORT(0)))
                  {
                  KnownClass.Destination = DEST_ROUTE;
                  }

               WinQueryDlgItemText(hDlg,ID_ROUTEWB1,
                  sizeof(KnownClass.szWorkBasket),
                  KnownClass.szWorkBasket);

               WinQueryDlgItemText(hDlg,ID_BESTFITCLASS,
                  sizeof(UnknownClass.szBestFitClass),
                  UnknownClass.szBestFitClass);

               UnknownClass.bDelete = (SHORT) (ULONG) WinSendDlgItemMsg(
                  hDlg,ID_DELETE,
                  BM_QUERYCHECK,MPFROMSHORT(0),MPFROMSHORT(0));

               UnknownClass.bAppend = (SHORT) (ULONG) WinSendDlgItemMsg(
                  hDlg,ID_APPEND,
                  BM_QUERYCHECK,MPFROMSHORT(0),MPFROMSHORT(0));

               if (WinSendDlgItemMsg(hDlg,ID_DONTIMPORT,
                     BM_QUERYCHECK,MPFROMSHORT(0),MPFROMSHORT(0)))
                  {
                  UnknownClass.Destination = DEST_NOIMPORT;
                  }
               else if (WinSendDlgItemMsg(hDlg,ID_SAVEITEMS,
                     BM_QUERYCHECK,MPFROMSHORT(0),MPFROMSHORT(0)))
                  {
                  UnknownClass.Destination = DEST_FILEROOM;
                  }
               else if (WinSendDlgItemMsg(hDlg,ID_ROUTEITEMS,
                           BM_QUERYCHECK,MPFROMSHORT(0),MPFROMSHORT(0)))
                  {
                  UnknownClass.Destination = DEST_ROUTE;
                  }

               WinQueryDlgItemText(hDlg,ID_ROUTEWB,
                  sizeof(UnknownClass.szWorkBasket),
                  UnknownClass.szWorkBasket);

               SaveDefaults();

               WinDismissDlg(hDlg,TRUE);
               break;

            case IDD_CANCEL:
               WinDismissDlg(hDlg,FALSE);
               break;

            default:
               break;
            }
         break;

      default:
         return(WinDefDlgProc(hDlg,msg,mp1,mp2));
         break;
      }
   return(FALSE);
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

MRESULT EXPENTRY StgGroupsDlgProc(
   HWND hDlg,
   USHORT msg,
   MPARAM mp1,
   MPARAM mp2)
{
   PSGMAPSTRUCT pMapStruct;
   char buffer[65];
   register int index;

   switch (msg)
      {
      case WM_INITDLG:
         ReadDefaults();
         CheckMenuItem(IDM_AUTONOTE,bAutoNote);
         CenterWindow(hDlg,hWndFrame);
         memset(buffer,0,sizeof(buffer));
         PushClassMapTable();
         FillListWithClasses(WinWindowFromID(hDlg,ID_INDXCLASSES),LM_INSERTITEM);
         FillListWithStgGroups(WinWindowFromID(hDlg,ID_STGGROUPS),LM_INSERTITEM);
         if (UnknownClass.szBestFitClass[0] != '\0')
            {
            index = (SHORT) (LONG) WinSendDlgItemMsg(hDlg,ID_INDXCLASSES,
               LM_SEARCHSTRING,MPFROM2SHORT(LSS_CASESENSITIVE,LIT_FIRST),
               MPFROMP(UnknownClass.szBestFitClass));

            if (index != LIT_NONE && index != LIT_ERROR)
               {
               WinSendDlgItemMsg(hDlg,ID_INDXCLASSES,
                  LM_SELECTITEM,MPFROMSHORT(index),MPFROMSHORT(TRUE));
               }
            else
               {
               WinSendDlgItemMsg(hDlg,ID_INDXCLASSES,
                  LM_SELECTITEM,MPFROMSHORT(0),MPFROMSHORT(TRUE));
               }
            }
         else
            {
            WinSendDlgItemMsg(hDlg,ID_INDXCLASSES,
               LM_SELECTITEM,MPFROMSHORT(0),MPFROMSHORT(TRUE));
            }
         break;

      case WM_CONTROL:
         switch (SHORT1FROMMP(mp1))
            {
            case ID_INDXCLASSES:
               if (SHORT2FROMMP(mp1) == LN_SELECT)
                  {
                  index = (SHORT) (LONG) WinSendDlgItemMsg(hDlg,ID_INDXCLASSES,
                     LM_QUERYSELECTION,
                     MPFROMSHORT(LIT_FIRST),
                     MPFROMSHORT(0));

                  WinSendDlgItemMsg(hDlg,ID_INDXCLASSES,
                     LM_QUERYITEMTEXT,
                     MPFROM2SHORT(index,sizeof(buffer)),
                     MPFROMP(buffer));

                  pMapStruct = FindClassMapEntry(buffer);
                  if (pMapStruct != NULL)
                     {
                     index = (SHORT) (LONG) WinSendDlgItemMsg(hDlg,ID_STGGROUPS,
                        LM_SEARCHSTRING,
                        MPFROM2SHORT(LSS_CASESENSITIVE,LIT_FIRST),
                        MPFROMP(pMapStruct->szStgGroupName));

                     if (index == LIT_NONE)
                        index = 0;

                     WinSendDlgItemMsg(hDlg,ID_STGGROUPS,
                        LM_SELECTITEM,
                        MPFROMSHORT(index),
                        MPFROMSHORT(TRUE));
                     }
                  }
               break;

            case ID_STGGROUPS:
               if (SHORT2FROMMP(mp1) == LN_SELECT)
                  {
                  index = (SHORT) (LONG) WinSendDlgItemMsg(hDlg,ID_INDXCLASSES,
                     LM_QUERYSELECTION,
                     MPFROMSHORT(LIT_FIRST),
                     MPFROMSHORT(0));

                  WinSendDlgItemMsg(hDlg,ID_INDXCLASSES,
                     LM_QUERYITEMTEXT,
                     MPFROM2SHORT(index,sizeof(buffer)),
                     MPFROMP(buffer));

                  pMapStruct = FindClassMapEntry(buffer);
                  if (pMapStruct != NULL)
                     {
                     index = (SHORT) (LONG) WinSendDlgItemMsg(hDlg,ID_STGGROUPS,
                        LM_QUERYSELECTION,
                        MPFROMSHORT(LIT_FIRST),
                        MPFROMSHORT(0));

                     WinSendDlgItemMsg(hDlg,ID_STGGROUPS,
                        LM_QUERYITEMTEXT,
                        MPFROM2SHORT(index,sizeof(buffer)),
                        MPFROMP(buffer));

                     strcpy(pMapStruct->szStgGroupName,buffer);
                     }
                  }
               break;
            }
         break;

      case WM_COMMAND:
         switch (SHORT1FROMMP(mp1))
            {
            case IDD_OK:
               SaveClassGroupMap();
               //DestroyClassMapTable();
               WinDismissDlg(hDlg,TRUE);
               break;

            case IDD_CANCEL:
               //DestroyClassMapTable();
               PopClassMapTable();
               WinDismissDlg(hDlg,FALSE);
               break;

            default:
               break;
            }
         break;

      default:
         return(WinDefDlgProc(hDlg,msg,mp1,mp2));
         break;
      }
   return(FALSE);
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

MRESULT EXPENTRY InProgressDlgProc(
   HWND hDlg,
   USHORT msg,
   MPARAM mp1,
   MPARAM mp2)
{
   char szTime[11];
   static int seconds;
   int hours, minutes, secs;
   char szTitle[65];
   char buffer[128];

   switch (msg)
      {
      case WM_INITDLG:
         ReadDefaults();
         CheckMenuItem(IDM_AUTONOTE,bAutoNote);
         CenterWindow(hDlg,hWndFrame);
         WinSendMsg(hDlg,WM_TIMER,MPFROMSHORT(1),MPFROMSHORT(0));
         WinStartTimer(hAB,hDlg,1,900);
         seconds = 0;
         break;

      case WM_TIMER:
         if (SHORT1FROMMP(mp1) == 1)
            {
            seconds++;
            hours = seconds / 3600;
            minutes = (seconds - (hours * 3600)) / 60;
            secs = seconds - ((minutes * 60) + (hours * 3600));
            sprintf(szTime,"%02d:%02d:%02d ",hours,minutes,secs);

            WinSetDlgItemText(hDlg,ID_CLOCK,szTime);
            WinStartTimer(hAB,hDlg,1,900);
            }
         break;

      case WM_COMMAND:
         switch (SHORT1FROMMP(mp1))
            {
            case IDD_OK:
               WinLoadString(hAB,0,IDS_TITLE,sizeof(szTitle),szTitle);
               WinLoadString(hAB,0,IDS_EXIT,sizeof(buffer),buffer);
               if (WinMessageBox(HWND_DESKTOP,hWndFrame,buffer,szTitle,
                  0,MB_YESNOCANCEL | MB_ICONQUESTION) == MBID_YES)
                  {
                  fAbortTask = TRUE;
                  WinSetDlgItemText(hDlg,ID_TEXT,"Exiting...");
                  WinEnableWindow(WinWindowFromID(hDlg,IDD_OK),FALSE);
                  }
               break;

            default:
               break;
            }
         break;

      default:
         return(WinDefDlgProc(hDlg,msg,mp1,mp2));
         break;
      }
   return(FALSE);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

MRESULT EXPENTRY ExportDlgProc(
   HWND hDlg,
   USHORT msg,
   MPARAM mp1,
   MPARAM mp2)
{
   register int i, count, sRC;
   char buffer[65];

   switch (msg)
      {
      case WM_INITDLG:
         ReadDefaults();
         CheckMenuItem(IDM_AUTONOTE,bAutoNote);
         CenterWindow(hDlg,hWndFrame);
         FillListWithWBs(WinWindowFromID(hDlg,ID_WBCOMBO),LM_INSERTITEM);

         if (szDefWorkBasket[0])
            {
            WinSetDlgItemText(hDlg,ID_WBCOMBO,szDefWorkBasket);
            }
         else
            {
            WinSendDlgItemMsg(hDlg,ID_WBCOMBO,
               LM_SELECTITEM,MPFROMSHORT(0),MPFROMSHORT(TRUE));
            }
         break;

      case WM_CONTROL:
         switch (SHORT1FROMMP(mp1))
            {
            case ID_WBCOMBO:
               if (SHORT2FROMMP(mp1) == CBN_EFCHANGE)
                  {
                  WinQueryDlgItemText(hDlg,ID_WBCOMBO,sizeof(buffer),buffer);
                  count = FillListWithItems(WinWindowFromID(hDlg,ID_ITEMS_LIST),buffer);
                  sprintf(buffer,"~Items in workbasket [%d]",count);
                  WinSetDlgItemText(hDlg,ID_WBITEMS,buffer);
                  }
               break;
            }
         break;

      case WM_COMMAND:
         switch (SHORT1FROMMP(mp1))
            {
            case IDD_SELECTALL:
               count = (int) (long) WinSendDlgItemMsg(hDlg,ID_ITEMS_LIST,
                           LM_QUERYITEMCOUNT,MPFROMSHORT(0),MPFROMSHORT(0));
               for (i = 0; i < count; i++)
                  {
                  WinSendDlgItemMsg(hDlg,ID_ITEMS_LIST,LM_SELECTITEM,
                     MPFROMSHORT(i),MPFROMSHORT(TRUE));
                  }
               break;

            case IDD_CLEAR:
               WinSendDlgItemMsg(hDlg,ID_ITEMS_LIST,LM_SELECTITEM,
                  MPFROMSHORT(LIT_NONE),MPFROMSHORT(FALSE));
               break;

            case IDD_EXPORT:
               WinQueryDlgItemText(hDlg,ID_WBCOMBO,
                  sizeof(szDefWorkBasket),szDefWorkBasket);

               memset(uidExportWb,0,sizeof(UID));
               WBToUID(szDefWorkBasket,(PUID) uidExportWb);

               GetSelectedItems(WinWindowFromID(hDlg,ID_ITEMS_LIST),
                  &pExportItems);

               if (QueryListCount(pExportItems) == 0)
                  {
                  ReportError(ERR_NOEXPPUIDS,NULL);
                  }
               else
                  {
                  SaveDefaults();
                  WinDismissDlg(hDlg,TRUE);
                  }
               break;

            case IDD_CANCEL:
               WinDismissDlg(hDlg,FALSE);
               break;

            case IDD_SETUP:
               sRC = LoadExportDLLPointers();
               if (sRC != SUCCESS)
                  {
                  ReportError(sRC,NULL);
                  }
               else
                  {
                  hDlg = WinLoadDlg(HWND_DESKTOP,hWndFrame,
                           pExportSetupDlgProc,hModule,ID_EXPSETUP_DLG,NULL);
                  if (hDlg != NULL)
                     {
                     WinProcessDlg(hDlg);
                     }
                  UnloadExportDLL();
                  }
               break;

            default:
               break;
            }
         break;

      default:
         return(WinDefDlgProc(hDlg,msg,mp1,mp2));
         break;
      }
   return(FALSE);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int LoadExportDLLPointers()
{
   register int sRC;
   char buffer[65];

   sRC = DosLoadModule(buffer,sizeof(buffer),"IP2EXPRT",&hModule);
   if (sRC != SUCCESS)
      {
      sRC = ERR_LOADMOD;
      }
   else
      {
      sRC = DosGetProcAddr(hModule,"EXPORTSETUPDLGPROC",(PFN FAR *) &pExportSetupDlgProc);
      if (sRC != SUCCESS)
         {
         sRC = ERR_INVDLL;
         }
      else
         {
         sRC = DosGetProcAddr(hModule,"EXPORTITEMSUSEREXIT",(PFN FAR *) &pExportItemsUserExit);
         if (sRC != SUCCESS)
            {
            sRC = ERR_INVDLL;
            }
         }
      }
   return(sRC);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void UnloadExportDLL()
{
   DosFreeModule(hModule);
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void ClearActivityLog()
{
   if (hWndList != NULL)
      {
      WinSendMsg(hWndList,LM_DELETEALL,MPFROMSHORT(0),MPFROMSHORT(0));
      }
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int SaveActivityLog()
{
   register int sRC = SUCCESS;

   if (hWndList != NULL)
      {
      WinDlgBox(HWND_DESKTOP,hWndFrame,SaveLogDlgProc,
         0,ID_SAVELOG_DLG,NULL);
      }
   return(sRC);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

MRESULT EXPENTRY SaveLogDlgProc(
   HWND hDlg,
   USHORT msg,
   MPARAM mp1,
   MPARAM mp2)
{
   char buffer[13];
   char *p, szPath[65];
   register int sRC;

   switch (msg)
      {
      case WM_INITDLG:
         ReadDefaults();
         CheckMenuItem(IDM_AUTONOTE,bAutoNote);
         CenterWindow(hDlg,hWndFrame);
         WinSendDlgItemMsg(hDlg,ID_LOGNAME,
            EM_SETTEXTLIMIT,MPFROMSHORT(8),MPFROMSHORT(0));
         WinSetFocus(HWND_DESKTOP,WinWindowFromID(hDlg,ID_LOGNAME));
         break;

      case WM_COMMAND:
         switch (SHORT1FROMMP(mp1))
            {
            case IDD_SAVE:
               WinQueryDlgItemText(hDlg,ID_LOGNAME,sizeof(buffer),buffer);
               if (strlen(buffer) > 0)
                  {
                  p = strrchr(buffer,'.');
                  if (p != NULL)
                     *p = '\0';
                  strcat(buffer,".LOG");
                  strupr(buffer);
                  if (strcmp(buffer,"IP2IMPEX.LOG") == 0)
                     {
                     ReportError(ERR_INVLOGNM,NULL);
                     WinSetDlgItemText(hDlg,ID_LOGNAME,"");
                     WinSetFocus(HWND_DESKTOP,WinWindowFromID(hDlg,ID_LOGNAME));
                     }
                  else
                     {
                     strcpy(szPath,szAppPath);
                     strcat(szPath,buffer);
                     sRC = SaveListContents(szPath,hWndList);
                     if (sRC != SUCCESS)
                        {
                        ReportError(sRC,NULL);
                        }
                     WinDismissDlg(hDlg,TRUE);
                     }
                  }
               else
                  {
                  WinDismissDlg(hDlg,FALSE);
                  }
               break;

            case IDD_CANCEL:
               WinDismissDlg(hDlg,FALSE);
               break;

            default:
               break;
            }
         break;

      default:
         return(WinDefDlgProc(hDlg,msg,mp1,mp2));
         break;
      }
   return(FALSE);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int SaveListContents(char *szPath,HWND hWndList)
{
   register int count, i;
   register int sRC = SUCCESS;
   char buffer[256];
   FILE *fp;

   count = (SHORT) (ULONG) WinSendMsg(hWndList,LM_QUERYITEMCOUNT,0,0);
   if (count > 0)
      {
      fp = (FILE *) fopen(szPath,"w+t");
      if (fp == NULL)
         {
         sRC = LogError(ERR_OPENING,NULL);
         }
      else
         {
         for (i = 0; i < count; i++)
            {
            WinSendMsg(hWndList,LM_QUERYITEMTEXT,MPFROM2SHORT(i,sizeof(buffer)),
               MPFROMP(buffer));
            strcat(buffer,"\n");
            fputs(buffer,fp);
            }
         fclose(fp);
         }
      }
   return(sRC);
}
