/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

/*BEGINPROLOGUE**************************************************************/
/*                                                                          */
/*   Module Name:              IPDELETE.C                                   */
/*                                                                          */
/*   Descriptive Name:         This module has functions to implement the   */
/*                             deferred deletion of files after import      */
/*                             is completed.                                */
/*                                                                          */
/*   Status:                   Release 1, Level 0                           */
/*                                                                          */
/*   Dependencies:             IBM OS/2 Extended Edition 1.30.1             */
/*                                                                          */
/*ENDPROLOGUE****************************************************************/

#define INCL_DOSMEMMGR
#define INCL_GPIBITMAPS
#define INCL_WIN
#define INCL_PM
#include <os2.h>

#include <stdio.h>                     // Standard C standard input/output
#include <stdlib.h>                    // Standard C library header
#include <string.h>                    // Standard C string header
#include <ctype.h>                     // Contains standard macros and symbols

#define IPS_SDS_INCL                   // To include Spool Device Services
#define IPS_IMG_INCL                   // To include Image Services
#define IPS_PAG_INCL                   // To include Page Services
#define IPS_DSP_INCL                   // To include Display Services
#define IPS_OMS_INCL                   // To include Object Management System
#define IPS_OAS_INCL                   // To include Object Access Services
#include <ips.h>

#include "ip2impex.rch"                // Contains menu symbol definitions
#include "ip2impex.h"                  // Includes prototypes and Masthead
#include "dialog.h"                    // Contains defines used in dialog boxes
#include "globals.h"                   // Contains our global variables
#include "error.h"                     // Contains error definitions

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int InitDeleteList(void)
{
   register int sRC = SUCCESS;

   if (pDeleteList == NULL)
      {
      pDeleteList = CreateList(LT_VARLEN,0);
      }
   return(sRC);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int AddDeferredDelete(char *szFileName)
{
   register int sRC = SUCCESS;

   if (pDeleteList != NULL)
      {
      sRC = AppendListItem(pDeleteList,szFileName);
      }

   return(sRC);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int DeleteFilesInList()
{
   register int sRC = SUCCESS;
   char *pFName;

   if (pDeleteList)
      {
      pFName = (char *) TopListItem(pDeleteList);
      while (pFName != NULL)
         {
         DosDelete(pFName,0L);
         pFName = (char *) NextListItem(pDeleteList);
         }

      DestroyList(pDeleteList);
      pDeleteList = NULL;
      }
   return(sRC);
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int DestroyDeleteList(void)
{
   register int sRC = SUCCESS;

   if (pDeleteList)
      {
      DestroyList(pDeleteList);
      pDeleteList = NULL;
      }
   return(sRC);
}
