/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

/*BEGINPROLOGUE**************************************************************/
/*                                                                          */
/*   Module Name:              IPACCESS.C                                   */
/*                                                                          */
/*   Descriptive Name:         Module that contains functions to manipulate */
/*                             the memory tables required by the rest of    */
/*                             the application.                             */
/*                                                                          */
/*   Status:                   Release 1, Level 0                           */
/*                                                                          */
/*   Function:                 Same as Descriptive name                     */
/*                                                                          */
/*ENDPROLOGUE****************************************************************/
#define INCL_DOSMEMMGR
#define INCL_GPIBITMAPS
#define INCL_WIN
#define INCL_PM
#include <os2.h>

#include <stdio.h>                     // Standard C standard input/output
#include <stdlib.h>                    // Standard C library header
#include <string.h>                    // Standard C string header
#include <ctype.h>                     // Contains standard macros and symbols

#define IPS_SDS_INCL                   // To include Spool Device Services
#define IPS_IMG_INCL                   // To include Image Services
#define IPS_PAG_INCL                   // To include Page Services
#define IPS_DSP_INCL                   // To include Display Services
#define IPS_OMS_INCL                   // To include Object Management System
#define IPS_OAS_INCL                   // To include Object Access Services
#include <ips.h>

#include "ip2impex.rch"                // Contains menu symbol definitions
#include "ip2impex.h"                  // Includes prototypes and Masthead
#include "dialog.h"                    // Contains defines used in dialog boxes
#include "globals.h"                   // Contains our global variables
#include "error.h"                     // Contains error definitions


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int ClassToId(char *szClass,PUSHORT pId)
{
   register int i;
   register int n = ClsTable.sClasses;

   for (i = 0; i < n; i++)
      {
      if (strcmpi(szClass,ClsTable.pClasses[i].Info.szClassName) == 0)
         {
         *pId = ClsTable.pClasses[i].usId;
         return(SUCCESS);
         }
      }
   return(-1);
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int IdToClass(USHORT Id,char *szClass)
{
   register int i;
   register int n = ClsTable.sClasses;

   for (i = 0; i < n; i++)
      {
      if (Id == ClsTable.pClasses[i].usId)
         {
         strcpy(szClass,ClsTable.pClasses[i].Info.szClassName);
         return(SUCCESS);
         }
      }
   return(-1);
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int IdToAttr(USHORT Id,char *szAttr)
{
   register int i;
   register int n = AttrTable.sAttrs;

   for (i = 0; i < n; i++)
      {
      if (Id == AttrTable.pAttrs[i].usId)
         {
         strcpy(szAttr,AttrTable.pAttrs[i].Info.szAttributeName);
         return(SUCCESS);
         }
      }
   return(-1);
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int AttrToId(char *szAttr,PUSHORT pId)
{
   register int i;
   register int n = AttrTable.sAttrs;

   *pId = 0;
   for (i = 0; i < n; i++)
      {
      if (strcmpi(szAttr,AttrTable.pAttrs[i].Info.szAttributeName) == 0)
         {
         *pId = AttrTable.pAttrs[i].usId;
         return(SUCCESS);
         }
      }
   return(-1);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int IsClsAttrIndex(USHORT idClass,USHORT idAttr)
{
   register int i, j;
   register int m, n = ClsTable.sClasses;
   PCLASSATTRSTRUCT pAttrs;

   for (i = 0; i < n; i++)
      {
      if (idClass == ClsTable.pClasses[i].usId)
         {
         pAttrs = ClsTable.pClasses[i].Info.pAttrInfoList;
         m = ClsTable.pClasses[i].Info.usNbrAttrIds;
         for (j = 0; j < m; j++)
            {
            if (pAttrs[j].usAttrId == idAttr)
               {
               return(pAttrs[j].fAttrIndexField);
               }
            }
         }
      }
   return(FALSE);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int IsAttrInClass(USHORT idClass,USHORT idAttr)
{
   register int i, j;
   register int m, n = ClsTable.sClasses;
   PCLASSATTRSTRUCT pAttrs;

   for (i = 0; i < n; i++)
      {
      if (idClass == ClsTable.pClasses[i].usId)
         {
         pAttrs = ClsTable.pClasses[i].Info.pAttrInfoList;
         m = ClsTable.pClasses[i].Info.usNbrAttrIds;
         for (j = 0; j < m; j++)
            {
            if (pAttrs[j].usAttrId == idAttr)
               {
               return(TRUE);
               }
            }
         }
      }
   return(FALSE);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int WBToUID(char *szWB,PUID pUID)
{
   register int i;
   register int n = WBTable.sWBs;

   for (i = 0; i < n; i++)
      {
      if (strcmpi(szWB,WBTable.pWBs[i].Info.szWorkbasketName) == 0)
         {
         memcpy(pUID,WBTable.pWBs[i].WBId,sizeof(UID));
         return(SUCCESS);
         }
      }
   return(-1);
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int UIDToWB(UID uid,char *szWB)
{
   register int i;
   register int n = WBTable.sWBs;

   for (i = 0; i < n; i++)
      {
      if (memcmp(uid,WBTable.pWBs[i].WBId,sizeof(UID)) == 0)
         {
         strcpy(szWB,WBTable.pWBs[i].Info.szWorkbasketName);
         return(SUCCESS);
         }
      }
   return(-1);
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int CCToId(char *szCC,unsigned char _far *pId)
{
   register int i;
   register int n = pConClasses->cClasses;

   for (i = 0; i < n; i++)
      {
      if (strstr(pConClasses->pConCls[i].szObjClsDef,szCC) != 0)
         {
         *pId = pConClasses->pConCls[i].idObjConCls;
         return(SUCCESS);
         }
      }
   return(-1);
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int IdToCC(unsigned char Id,char *szCC)
{
   register int i;
   register int n = pConClasses->cClasses;

   for (i = 0; i < n; i++)
      {
      if (Id == pConClasses->pConCls[i].idObjConCls)
         {
         strcpy(szCC,pConClasses->pConCls[i].szObjClsDef);
         return(SUCCESS);
         }
      }
   return(-1);
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int StgGroupToId(char *szGroup,PUSHORT pId)
{
   register int i;
   register int n = SGList.sSGs;

   for (i = 0; i < n; i++)
      {
      if (strcmpi(szGroup,SGList.pSGs[i].szGroupName) == 0)
         {
         *pId = SGList.pSGs[i].usStgGroup;
         return(SUCCESS);
         }
      }
   return(-1);
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int IdToStgGroup(USHORT Id,char *szGroup)
{
   register int i;
   register int n = SGList.sSGs;

   for (i = 0; i < n; i++)
      {
      if (Id == SGList.pSGs[i].usStgGroup)
         {
         strcpy(szGroup,SGList.pSGs[i].szGroupName);
         return(SUCCESS);
         }
      }
   return(-1);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void FillListWithWBs(HWND hList,int message)
{
   register int i;

   WinSendMsg(hList,LM_DELETEALL,MPFROMSHORT(0),MPFROMSHORT(0));

   for (i = 0; i < WBTable.sWBs; i++)
      {
      WinSendMsg(hList,message,
         MPFROMSHORT(LIT_SORTASCENDING),
         MPFROMP(WBTable.pWBs[i].Info.szWorkbasketName));
      }
   return;
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void FillListWithClasses(HWND hList,int message)
{
   register int i;

   for (i = 0; i < ClsTable.sClasses; i++)
      {
      if ((strcmpi(ClsTable.pClasses[i].Info.szClassName,"No Class") != 0) &&
          (strcmpi(ClsTable.pClasses[i].Info.szClassName,"Search Result") != 0) &&
          (strcmpi(ClsTable.pClasses[i].Info.szClassName,"Delivery Folder") != 0))
         {
         WinSendMsg(hList,message,
            MPFROMSHORT(LIT_SORTASCENDING),
            MPFROMP(ClsTable.pClasses[i].Info.szClassName));
         }
      }
   return;
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void FillListWithStgGroups(HWND hList,int message)
{
   register int i;

   WinSendMsg(hList,LM_DELETEALL,MPFROMSHORT(0),MPFROMSHORT(0));

   for (i = 0; i < SGList.sSGs; i++)
      {
      if (SGList.pSGs[i].usStgGroup != 0)
         {
         WinSendMsg(hList,message,
            MPFROMSHORT(LIT_SORTASCENDING),
            MPFROMP(SGList.pSGs[i].szGroupName));
         }
      }
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int FillListWithItems(HWND hList,char *szWB)
{
   register int i, sRC = SUCCESS;
   UID uid;
   HTOC hTOC;                          // Handle to Table Of Contents
   RCSTRUCT RC;
   USHORT usTOCEntries = 0;
   PTOCENTRYSTRUCT pTOC = NULL;
   char buffer[128];
   char szAttr[128];
   USHORT usItemType;
   USHORT usAttrId;
   PSNAPSHOTSTRUCT pInfo;

   WinSendMsg(hList,LM_DELETEALL,MPFROMSHORT(0),MPFROMSHORT(0));

   sRC = WBToUID(szWB,(PUID) uid);
   if (sRC == SUCCESS)
      {
      memset(&RC,0,sizeof(RC));
      sRC = OimGetTOC(                 // Get folder's tabel of contents
               (PUID) uid,             // UID of this folder
               OIM_ALL,                // Include all documents and folders
               OIM_ALL,                // Include all WIP items
               OIM_ALL,                // Include all items whether suspended
               0,                      // No index classes provided
               NULL,                   // No list of class ids
               &hTOC,                  // Ptr to handle to TOC
               NULL,                   // No abort semaphore provided
               IPS_OPT_SYNC,           // Perform function synchronously
               NULL,                   // No semaphore to synchronize
               0,                      // No message to synchronize
               &RC);                   // Pointer to return structure

      if (sRC == SUCCESS)
         {
         usTOCEntries = (USHORT) RC.usParam;// Number of entries in table of contents
         pTOC = (PTOCENTRYSTRUCT) RC.ulParam;// Ptr to array of entries

         OimCloseTOC(hTOC,IPS_OPT_SYNC,NULL,0,&RC);

         if (usTOCEntries > 0)
            {
            /* Build the contents of the listbox from the returned array*/

            for (i = 0; i < (int) usTOCEntries && sRC == SUCCESS; i++)
               {
               sRC = OimItemSnapshot(  // Get item entry UID
                        (PUID) pTOC[i].uidTOCItem,// Ptr to UID of item to get snapshot of
                        OIM_SYSTEM_ATTR | OIM_USER_ATTR,
                        IPS_OPT_SYNC,  // Perform function synchronously
                        NULL,          // No semaphore to synchronize
                        0,             // No message to synchronize
                        &RC);          // Pointer to return structure

               if (sRC == SUCCESS)
                  {
                  pInfo = (PSNAPSHOTSTRUCT) RC.ulParam;
                  usItemType = pInfo->usItemType;
                  strcpy(buffer,usItemType == OIM_DOCUMENT ? "DOCUMENT":"FOLDER");
                  strcat(buffer," - ");
                  IdToClass(pInfo->usIndexClass,szAttr);
                  strcat(buffer,szAttr);

                  GetDisplayAttribute(pInfo->usIndexClass,&usAttrId);
                  if (usAttrId != 0)
                     {
                     SearchAttrInSnapshot(pInfo,usAttrId,szAttr,sizeof(szAttr));
                     strcat(buffer," - ");
                     strcat(buffer,szAttr);
                     }

                  memcpy(szAttr,pTOC[i].uidTOCItem,sizeof(UID));
                  szAttr[sizeof(UID)] = '\0';
                  strcat(buffer," - ");
                  strcat(buffer,szAttr);

                  DosFreeSeg(SELECTOROF(pInfo));

                  if ((int) (long) WinSendMsg(hList,LM_INSERTITEM,
                      MPFROM2SHORT(LIT_END,0),MPFROMP(buffer)) == LIT_ERROR)
                     {
                     ReportError(ERR_LSTFULL,NULL);
                     break;
                     }
                  }
               }
            }
         else
            {
            strcpy(buffer,"*** No items in workbasket ***");
            WinSendMsg(hList,LM_INSERTITEM,MPFROM2SHORT(LIT_END,0),MPFROMP(buffer));
            }
         DosFreeSeg(SELECTOROF(pTOC));
         }
      }
   return(usTOCEntries);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void GetDisplayAttribute(USHORT usIndexClass,PUSHORT pusAttrId)
{
   register int i, j;
   register int n = ClsTable.sClasses;
   PCLASSATTRSTRUCT pAttr;

   *pusAttrId = 0;
   for (i = 0; i < n; i++)
      {
      if (usIndexClass == ClsTable.pClasses[i].usId)
         {
         pAttr = (PCLASSATTRSTRUCT) ClsTable.pClasses[i].Info.pAttrInfoList;
         for (j = 0; j < (int) ClsTable.pClasses[i].Info.usNbrAttrIds; j++)
            {
            if (pAttr[j].fAttrIndexField)
               {
               *pusAttrId = pAttr[j].usAttrId;
               return;
               }
            }
         if (pAttr)
            {
            *pusAttrId = pAttr[0].usAttrId;
            }
         return;
         }
      }
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void SearchAttrInSnapshot(PSNAPSHOTSTRUCT pInfo,USHORT usAttrId,char *szAttr,int maxlen)
{
   PSNAPATTRS pAttrs = (PSNAPATTRS) pInfo->aAttributes;
   register int i, n = pInfo->usNumAttributes;
   register int len;

   maxlen--;
   strcpy(szAttr,"??????");
   for (i = 0; i < n; i++)
      {
      if (pAttrs[i].usAttrId == usAttrId)
         {
         if (pAttrs[i].pszAttrValue != NULL)
            {
            len = strlen(pAttrs[i].pszAttrValue);
            if (len > maxlen)
               {
               memcpy(szAttr,pAttrs[i].pszAttrValue,maxlen);
               szAttr[maxlen+1] = '\0';
               }
            else
               {
               strcpy(szAttr,pAttrs[i].pszAttrValue);
               }
            }
         }
      }
   return;
}
