/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

/*BEGINPROLOGUE**************************************************************/
/*                                                                          */
/*   Module Name:              IP2IMPEX.H                                   */
/*                                                                          */
/*   Descriptive Name:         This module contains some symbol definitions */
/*                             and also includes ImagePlus/2 header files   */
/*                                                                          */
/*   Status:                   Release 1, Level 0                           */
/*                                                                          */
/*   Function:                 Same as Descriptive name                     */
/*                                                                          */
/*   Dependencies:             IBM OS/2 Extended Edition 1.3.01             */
/*                                                                          */
/*ENDPROLOGUE****************************************************************/

#include "fcaeoim.h"
#include "fcaelobj.h"
#include "fcaeusrx.h"

#include "iplist.h"

#define ReportError(usError,szString) _ReportError(usError,szString,__FILE__,__LINE__);
#define LogError(usError,szString) _LogError(usError,szString,__FILE__,__LINE__);

#define UM_INIT_IP2IMPEX         WM_USER + 1
#define UM_LOGON_DONE            WM_USER + 2
#define UM_REDO_DIRLIST          WM_USER + 3
#define UM_IMPORT                WM_USER + 4
#define UM_IMPORT_DONE           WM_USER + 5


#define OP_DELETE                1

#define TITLE_HEIGHT             40

#define LIST_FILE_LEN            8


typedef struct tagATTRIBUTE
   {
   unsigned int idAttr;                // Attribute id
   char szAttrName[33];                // Attribute name
   char *pData;                        // Ptr to actual attribute data

   } ATTRIBUTE, *PATTRIBUTE;

/* This structure is used by the IMPORT.C module.  It is initially setup by */
/* parsing the input import file. Later on the text information in it is    */
/* translated, for example, the text file contains a tag for specifying a   */
/* storage group; that name must be converted to its corresponding id       */
/* before it can be used internally.  The same applies to WorkBasket, Index */
/* class, attributes, ContentClass, etc.                                    */

typedef struct tagIMPORT_REQUEST
   {
   int sItemType;                      // IT_FOLDER or IT_DOCUMENT
   char szImageFile[13];               // Name of image file to import
   unsigned char ContentClass;         // Content class of the image
   char szIndexClass[33];              // Name of target index class
   unsigned int ClassId;               // Id of target index class

   PIPLIST pAttrs;                     // Ptr to list of attribute structs
   PIPLIST pNote;                      // Ptr to list of note text lines
   PIPLIST pFolderItems;               // Ptr to list of INX file names

   BOOL bAppend;                       // Whether to append the index info
   BOOL bRoute;                        // Whether to route item to workbasket
   BOOL bDelete;                       // Whether to delete original

   char szWorkBasket[33];              // Name of target Workbasket
   UID uidWorkBasket;                  // UID of target workbasket

   char szTargetStgGroup[33];          // Storage group name
   unsigned int TargetStgGroup;        // Storage group id

   char szVolume[33];                  // Name of target Volume
   ULONG ulVolSer;                     // Volume serial number

   //int cAttrs;                         // Count of attributes in array
   //PATTRIBUTE pAttrs;                  // Ptr to array of attribute structs

   } IMPORT_REQUEST, *PIMPORT_REQUEST;


#define DEST_NOIMPORT      1
#define DEST_FILEROOM      2
#define DEST_ROUTE         3

#define DEST_DELETE        4

#define INI_EXE            1
#define INI_DLL            2

typedef struct tagKNOWNCLS_CRITERIA
   {
   BOOL bDelete;                       // TRUE to delete file after import
   BOOL bAppend;                       // TRUE to append note to index
   int Destination;                    // What to do with the item after export
   char szWorkBasket[33];              // Reroute item to this WB after import

   } KNOWNCLS_CRITERIA, *PKNOWNCLS_CRITERIA;

typedef struct tagUNKNOWNCLS_CRITERIA
   {
   char szBestFitClass[33];            // Index class to check in items into
   BOOL bDelete;                       // TRUE to delete file after import
   BOOL bAppend;                       // TRUE to append note to index
   int Destination;                    // What to do with the item after export
   char szWorkBasket[33];              // Reroute item to this WB after import

   } UNKNOWNCLS_CRITERIA, *PUNKNOWNCLS_CRITERIA;

typedef struct tagIMPORT_FILES
   {
   BOOL bLST;
   BOOL bINX;
   BOOL bMDI;
   BOOL bTIF;
   BOOL bCIF;

   } IMPORT_FILES, *PIMPORT_FILES;


typedef struct tagEXPORT_DEFAULTS
   {
   BOOL bFolder;                       // TRUE to export folder contents
   BOOL bCIF;                          // TRUE to build CIF
   int Destination;                    // What to do with the item after export
   char szWorkBasket[33];              // Reroute item to this WB after import
   char szFName[13];                   // Default name for .LST file

   } EXPORT_DEFAULTS, *PEXPORT_DEFAULTS;


typedef struct tagSGMAPSTRUCT
   {
   char szClassName[33];
   char szStgGroupName[33];
   BOOL bExclude;

   } SGMAPSTRUCT, *PSGMAPSTRUCT;

typedef struct tagCLASSMAPSTRUCT
   {
   USHORT usId;
   CLASSINFOSTRUCT Info;

   } CLASSMAPSTRUCT, *PCLASSMAPSTRUCT;

typedef struct tagCLASSTBLSTRUCT
   {
   SHORT sClasses;
   PCLASSMAPSTRUCT pClasses;

   } CLASSTBLSTRUCT, *PCLASSTBLSTRUCT;

typedef struct tagATTRMAPSTRUCT
   {
   USHORT usId;
   ATTRINFOSTRUCT Info;

   } ATTRMAPSTRUCT, *PATTRMAPSTRUCT;

typedef struct tagATTRTBLSTRUCT
   {
   SHORT sAttrs;
   PATTRMAPSTRUCT pAttrs;

   } ATTRTBLSTRUCT, *PATTRTBLSTRUCT;

typedef struct tagWBMAPSTRUCT
   {
   UID WBId;
   WBINFOSTRUCT Info;

   } WBMAPSTRUCT, *PWBMAPSTRUCT;

typedef struct tagWBTBLSTRUCT
   {
   SHORT sWBs;
   PWBMAPSTRUCT pWBs;

   } WBTBLSTRUCT, *PWBTBLSTRUCT;

typedef struct tagSGLISTSTRUCT
   {
   int sSGs;
   PSTGGROUPNAMESTRUCT pSGs;

   } SGLISTSTRUCT, *PSGLISTSTRUCT;

typedef struct tagSGMAPNODE
   {
   SGMAPSTRUCT Info;
   struct tagSGMAPNODE *pNext;

   } SGMAPNODE, *PSGMAPNODE;

typedef struct tagSNAPATTRS
   {
   USHORT usAttrId;
   USHORT usAttrType;
   PSZ pszAttrValue;

   } SNAPATTRS, *PSNAPATTRS;

typedef struct tagFSVOLINFO
   {
   ULONG ulSerial;
   BYTE cch;
   CHAR szVolLabel[12];

   } FSVOLINFO, *PFSVOLINFO;

#include "protos.h"


typedef SHORT (_loadds EXPENTRY *USEREXIT)(HWND,USHORT,USHORT,USHORT,PUID,USEREXITSTRUCT,PUID,PUID);
