/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

/*BEGINPROLOGUE**************************************************************/
/*                                                                          */
/*   Module Name:              IP2IMPEX.C                                   */
/*                                                                          */
/*   Descriptive Name:         Main module for the IP2IMPEX Application     */
/*                                                                          */
/*   Status:                   Release 1, Level 0                           */
/*                                                                          */
/*   Function:                 This is the main module for a PM application */
/*                             that allows an ImagePlus/2 user to import    */
/*                             documents into the system.                   */
/*                                                                          */
/*   Dependencies:             IBM OS/2 Extended Edition 1.30.1             */
/*                                                                          */
/*   Functions:                                                             */
/*                             main                                         */
/*                             WndProc                                      */
/*                             cwRegisterClass                              */
/*                             cwCreateWindow                               */
/*                                                                          */
/*ENDPROLOGUE****************************************************************/

#define ALLOCATE
#define INCL_DOS
#define INCL_DOSMODULEMGR
#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#define INCL_DOSMISC
#define INCL_DOSMEMMGR
#define INCl_DOSSESMGR
#define INCL_GPIBITMAPS
#define INCL_WIN
#define INCL_PM
#include <os2.h>

#include <stdio.h>                     // Standard C standard input/output
#include <stdlib.h>                    // Standard C library header
#include <string.h>                    // Standard C string header
#include <ctype.h>                     // Contains standard macros and symbols

#define IPS_SDS_INCL                   // To include Spool Device Services
#define IPS_IMG_INCL                   // To include Image Services
#define IPS_PAG_INCL                   // To include Page Services
#define IPS_DSP_INCL                   // To include Display Services
#define IPS_OMS_INCL                   // To include Object Management System
#define IPS_OAS_INCL                   // To include Object Access Services
#include <ips.h>

#include "ip2impex.rch"                // Contains menu symbol definitions
#include "ip2impex.h"                  // Includes prototypes and Masthead
#include "dialog.h"                    // Contains defines used in dialog boxes
#include "globals.h"                   // Contains our global variables
#include "error.h"                     // Contains error definitions


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:         main                                                      */
/*                                                                          */
/*  Description:  This is the main entry point of this application          */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

SHORT main(int argc,char **argv)
{
   QMSG qmsg;                          // MSG structure to store messages
   int sRC;                            // Return code variable
   RCSTRUCT RC;                        // Return structure
   RECTL rClient;
   char buffer[65];

   /* The WinInitialize routine initializes the Presentation Manager        */
   /* facilities for use by this application and returns a handle to the    */
   /* anchor block assigned to the application by PM.                       */

   if ((hAB = WinInitialize(0)) == 0)  // Initialize the anchor block
      {
      ReportError(ERR_WININIT,NULL);
      DosExit(1,0);                    // Exit to command line
      }

   /* The WinCreateMsgQueue call creates a message queue for this applicatio*/

   hMQ = WinCreateMsgQueue(hAB, 0);    // Initialize message queue
   if (hMQ == 0)
      {
      ReportError(ERR_CREATEQUEUE,NULL);
      DosExit(1,0);                    // Exit to command line
      }

   sRC = InitializeGlobalData();
   if (sRC != SUCCESS)
      {
      ReportError(sRC,NULL);
      DosExit(1,0);                    // Exit to command line
      }

   /* The following function registers the classes of all application window*/
   if (!cwRegisterClass())             // Register our window class
      {
      ReportError(ERR_REGCLASS,NULL);
      DosExit(1,0);                    // Exit to command line
      }

   /* The CreateWindow function creates a frame window for this application'*/
   /* top window, and set the window's size and location as appropriate.    */

   WinLoadString(hAB,0,IDS_TITLE,sizeof(buffer),buffer);

   hWndFrame = cwCreateWindow(         // Create the frame window
      (HWND)HWND_DESKTOP,              // Desktop is the parent
      FCF_TITLEBAR     |               // Include a title bar
      FCF_SYSMENU      |               // Include a system menu
      FCF_MINBUTTON    |               // Include a minimize button
      FCF_MAXBUTTON    |               // Include a maximize button
      FCF_SIZEBORDER   |               // Sizeable border style
      FCF_MENU         |               // Include a menu bar
      FCF_ACCELTABLE   |               // Include an accelerator table
      FCF_TASKLIST     |               // Include in Task List
      FCF_ICON         |               // Use the application icon
      FCF_SHELLPOSITION,               // Default shell position
      szAppName,                       // Our application name (class)
      buffer,                          // Title of window
      ID_IP2IMPEX,                     // Menu ID
      0, 0,                            // Coordinates
      0, 0,                            // Dimensions
      &hWndClient,                     // Pointer to variable holding handle
      0L,                              // Reserved
      SWP_SHOW);                       // Show this window

   if (hWndFrame == 0)                 // If we couldn't create the frame
      {
      ReportError(ERR_CREATFRAME,NULL);
      WinDestroyMsgQueue(hMQ);         // Destroy message queue
      WinTerminate(hAB);               // Terminate this PM app
      DosExit(1,0);                    // Exit to command line
      }
   else
      {
      WinQueryWindowRect(hWndClient,&rClient);

      hWndList = WinCreateWindow(
                     hWndClient,
                     WC_LISTBOX,
                     "",
                     WS_VISIBLE | LS_NOADJUSTPOS | LS_HORZSCROLL,
                     0,
                     0,
                     (SHORT) rClient.xRight,
                     (SHORT) rClient.yTop - TITLE_HEIGHT,
                     hWndFrame,
                     HWND_TOP,
                     100,
                     NULL,
                     NULL);

      WinLoadString(hAB,0,IDS_PROGRESS,sizeof(buffer),buffer);

      hWndTitle = WinCreateWindow(hWndClient,WC_BUTTON,buffer,
                     BS_PUSHBUTTON | WS_VISIBLE |
                     BS_NOPOINTERFOCUS | BS_NOCURSORSELECT,
                     0,
                     (SHORT) rClient.yTop - TITLE_HEIGHT,
                     (SHORT) rClient.xRight,
                     (SHORT) TITLE_HEIGHT,
                     hWndFrame,HWND_TOP,101,NULL,NULL);
      }

   /* The following call (IpsInit) is mandatory whenever services APIs are  */
   /* required.  If it returns a code other than SUCCESS (0) we             */
   /* carefully study the error code and determine a course of action to    */
   /* correct the situation.  When this function returns an error code      */
   /* Services APIs cannot be used.                                         */

   sRC = IpsInit(&RC);                 // Initialize Services

   if (sRC != SUCCESS)                 // Services initialization failed
      {
      ReportError(ERR_IPSINIT,NULL);
      WinDestroyMsgQueue(hMQ);         // Destroy the message queue
      WinTerminate(hAB);               // Terminate this PM app
      DosExit(1,0);                    // Exit to command line
      }
   else
      {
      /* Logon to OIM database (FCAEDB) on the server. We must call this */
      /* function before we attempt to use any of the Application        */
      /* Facility APIs.  We must also not forget to call OimLogoff when  */
      /* we are done using the APIs.                                     */

      sRC = OimLogon(                  // Logon to OIM database
               LOC_DB_NAME,            // Name of the database
               LOC_APPLICATION_NAME,   // Name of application using the APIs
//             "IMGPLUS",                 User name for activity logging
//             "IMGPLUS",                 User name for item check out
               "IP2IMPEX",              // User name for activity logging
               "IP2IMPEX",              // User name for item check out
               OIM_NORMAL_SESSION,     // Non-configuration session
               IPS_OPT_ASYNC,          // Perform function asynchronously
               hWndClient,             // No semaphore to synchronize
               UM_LOGON_DONE,          // No message to synchronize
               &RC);                   // Pointer to return structure

      if (sRC != SUCCESS)
         {
         ReportError(ERR_OIMLOGON,NULL);
         WinDestroyMsgQueue(hMQ);      // Destroy the message queue
         WinTerminate(hAB);            // Terminate this PM app
         DosExit(1,0);                 // Exit to command line
         }
      else
         {
         hProgressDlg = WinLoadDlg(HWND_DESKTOP,hWndClient,InProgressDlgProc,
                           0,ID_PROGRINI_DLG,NULL);

         if (hProgressDlg != NULL)
            {
            WinShowWindow(hProgressDlg,TRUE);
            }
         }
      }

   /* The following is the message loop for the application.              */

   while (WinGetMsg(hAB,(PQMSG)&qmsg,0,0,0))
      {
      WinDispatchMsg(hAB,(PQMSG)&qmsg);// Dispatch message to windows
      }

   /* Perform clean up before exiting application.                        */
   /* The following routine destroys the application's frame window (which*/
   /* also destroys its child windows), destroys its message queue, and   */
   /* disassociates the application from the Presentation Manager system. */

   WinDestroyWindow(hWndFrame);        // Destroy the frame window
   WinDestroyMsgQueue(hMQ);            // Destroy this app's message queue
   WinTerminate(hAB);                  // Terminate this app's use of the
                                       // Presentation Manager resources
   DosExit(1,0);                       // Exit to command line
   return(0);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:         WndProc                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*  This procedure provides service routines for the general PM events      */
/*  (messages) that PM sends to the window, as well as the user             */
/*  initiated events (messages) that are generated when the user selects    */
/*  the action bar and pulldown menu controls or the corresponding          */
/*  keyboard accelerators.                                                  */
/*                                                                          */
/*  The SWITCH statement shown below distributes the window messages to     */
/*  the respective message service routines, which are set apart by the     */
/*  CASE statements. The window procedures must provide an appropriate      */
/*  service routine for its end user initiated messages, as well as the     */
/*  general PM messages (like the WM_CLOSE message). If a message is        */
/*  sent to this procedure for which there is no programmed CASE clause     */
/*  (i.e., no service routine), the message is defaulted to the             */
/*  WinDefWindowProc function, where it is disposed of by PM.               */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

MRESULT EXPENTRY WndProc(
   HWND hWnd,                          // Handle of window receiving the message
   USHORT message,                     // the message itself
   MPARAM mp1,                         // message parameter 1
   MPARAM mp2)                         // message parameter 2
{
   register int i;
   HPS hPS;                            // Handle for the Presentation Space
   RECTL rClient;                      // Rectangle formed by client area
   int sRC = SUCCESS;                  // common return code value
   static RCSTRUCT RC;                 // Return structure (async operations)
   char *p;
   HWND hDlg;
   PUID pUIDs;
   int count;
   USEREXITSTRUCT UserExit;
   UID uidWb;
   UID uidNewWb;
   BOOL bForceDefaults;
   char buffer[128];
   char szTitle[65];

   switch(message)
      {
      case WM_CREATE:
         /* The WM_CREATE message is sent to a window when an application   */
         /* requests that the window be created.  The window procedure      */
         /* for the new window receives this message after the window is    */
         /* created, but before the window becomes visible.                 */
         fAbortTask = FALSE;
         break;

      case UM_IMPORT:
         hProgressDlg = WinLoadDlg(HWND_DESKTOP,hWndFrame,InProgressDlgProc,
            0,ID_INPROCESS_DLG,NULL);
         if (hProgressDlg != NULL)
            {
            WinShowWindow(hProgressDlg,TRUE);
            }
         DisableAllMenuItems();
         ActivityLogOutput("************************");
         ActivityLogOutput("Import operation started");
         ActivityLogOutput("************************");
         bTaskInProgress = TRUE;
         sRC = SpawnImport(pImportItems);
         bTaskInProgress = FALSE;
         break;

      case UM_IMPORT_DONE:
         bTaskInProgress = FALSE;
         if (SHORT1FROMMP(mp1) == SUCCESS)
            SoundGoodAlarm();
         else
            SoundBadAlarm();
         WinDestroyWindow(hProgressDlg);
         hProgressDlg = NULL;
         EnableAllMenuItems();
         DestroyList(pImportItems);
         pImportItems = NULL;
         break;

      case UM_LOGON_DONE:
         if (RC.sRC != SUCCESS)
            {
            WinDestroyWindow(hProgressDlg);
            hProgressDlg = NULL;
            ReportError(ERR_OIMLOGON,NULL);
            WinPostMsg(hWndFrame,WM_QUIT,0L,0L);
            }
         else
            {
            ActivityLogOutput("Successfully logged on to the database");
            bOimLogon = TRUE;
            EnableMenuItem(IDM_EXIT);
            sRC = InitSystemTables(INI_EXE);
            if (fAbortTask)
               {
               WinLoadString(hAB,0,ERR_EXIT,sizeof(buffer),buffer);
               WinLoadString(hAB,0,IDS_TITLE,sizeof(szTitle),szTitle);
               WinMessageBox(HWND_DESKTOP,hWndFrame,buffer,szTitle,
                  0,MB_OK | MB_INFORMATION);
               WinPostMsg(hWndFrame,WM_QUIT,0L,0L);
               break;
               }
            else if (sRC != SUCCESS)
               {
               LogError(sRC,NULL);
               }
            else
               {
               bForceDefaults = !exists(szDefFile) || !exists(szSGMapListFile);
               if (bForceDefaults)
                  {
                  if (WinDlgBox(HWND_DESKTOP,hWnd,ForceDlgProc,
                     0,ID_FORCE_DLG,NULL) == TRUE)
                     {
                     while (WinDlgBox(HWND_DESKTOP,hWnd,ImportSetupDlgProc,
                        0,ID_IMPSETUP,NULL) != TRUE)
                        ;
                     i = LoadExportDLLPointers();
                     if (i != SUCCESS)
                        {
                        ReportError(i,NULL);
                        }
                     else
                        {
                        i = FALSE;
                        while (i != TRUE)
                           {
                           hDlg = WinLoadDlg(HWND_DESKTOP,hWndFrame,
                                    pExportSetupDlgProc,hModule,ID_EXPSETUP_DLG,NULL);

                           if (hDlg != NULL)
                              {
                              i = WinProcessDlg(hDlg);
                              }
                           else
                              break;
                           }
                        UnloadExportDLL();
                        }

                     while (WinDlgBox(HWND_DESKTOP,hWnd,StgGroupsDlgProc,
                        0,ID_CLSGROUP_DLG,NULL) != TRUE)
                        ;
                     }
                  else
                     {
                     WinLoadString(hAB,0,ERR_EXIT,sizeof(buffer),buffer);
                     WinLoadString(hAB,0,IDS_TITLE,sizeof(szTitle),szTitle);
                     WinMessageBox(HWND_DESKTOP,hWndFrame,buffer,szTitle,
                        0,MB_OK | MB_INFORMATION);
                     WinPostMsg(hWndFrame,WM_QUIT,0L,0L);
                     break;
                     }
                  }
               }

            WinDestroyWindow(hProgressDlg);
            hProgressDlg = NULL;
            if (sRC != SUCCESS)
               {
               ReportError(sRC,NULL);
               WinPostMsg(hWndFrame,WM_QUIT,0L,0L);
               }
            else
               {
               EnableMenuItem(IDM_IMPORT);
               EnableMenuItem(IDM_EXPORT);
               EnableMenuItem(IDM_IMPSETUP);
               EnableMenuItem(IDM_EXPSETUP);
               EnableMenuItem(IDM_STGGROUPS);
               EnableMenuItem(IDM_CLEARLOG);
               EnableMenuItem(IDM_SAVELOG);
               EnableMenuItem(IDM_HELP);
               EnableMenuItem(IDM_AUTONOTE);

               SaveClassGroupMap();
               sRC = ReadDefaults();
               CheckMenuItem(IDM_AUTONOTE,bAutoNote);
               }
            }
         break;

      case WM_SIZE:
         WinQueryWindowRect(hWndClient,&rClient);

         WinSetWindowPos(hWndList,HWND_TOP,
            0,
            0,
            (SHORT) rClient.xRight,
            (SHORT) rClient.yTop - TITLE_HEIGHT,
            SWP_SIZE | SWP_MOVE | SWP_SHOW);

         WinSetWindowPos(hWndTitle,HWND_TOP,
            0,
            (SHORT) rClient.yTop - TITLE_HEIGHT,
            (SHORT) rClient.xRight,
            (SHORT) TITLE_HEIGHT,
            SWP_SIZE | SWP_MOVE | SWP_SHOW);
         break;

      case WM_COMMAND:
         /* The PM messages for action bar and pulldown menu items are      */
         /* processed in this routine.  This switch statement is a good     */
         /* source to find out what to do to perform a specific task.       */

         switch(SHORT1FROMMP(mp1))
            {
            case IDM_AUTONOTE:
               bAutoNote = bAutoNote ? FALSE : TRUE;
               CheckMenuItem(IDM_AUTONOTE,bAutoNote);
               SaveDefaults();
               break;

            case IDM_CLEARLOG:
               ClearActivityLog();
               break;

            case IDM_SAVELOG:
               SaveActivityLog();
               break;

            case IDM_IMPSETUP:
               WinDlgBox(HWND_DESKTOP,hWnd,ImportSetupDlgProc,
                  0,ID_IMPSETUP,NULL);
               break;

            case IDM_EXPSETUP:
               sRC = LoadExportDLLPointers();
               if (sRC != SUCCESS)
                  {
                  ReportError(sRC,NULL);
                  }
               else
                  {
                  hDlg = WinLoadDlg(HWND_DESKTOP,hWndFrame,
                           pExportSetupDlgProc,hModule,ID_EXPSETUP_DLG,NULL);

                  if (hDlg != NULL)
                     {
                     WinProcessDlg(hDlg);
                     }
                  UnloadExportDLL();
                  }
               break;

            case IDM_STGGROUPS:
               WinDlgBox(HWND_DESKTOP,hWnd,StgGroupsDlgProc,
                  0,ID_CLSGROUP_DLG,NULL);
               break;

            case IDM_IMPORT:
               sRC = WinDlgBox(HWND_DESKTOP,hWndFrame,ImportDlgProc,
                        0,ID_IMPORT_DLG,NULL);

               if (sRC == TRUE)
                  {
                  WinPostMsg(hWnd,UM_IMPORT,MPFROMSHORT(0),MPFROMSHORT(0));
                  }
               break;

            case IDM_EXPORT:
               sRC = WinDlgBox(HWND_DESKTOP,hWndFrame,ExportDlgProc,
                        0,ID_EXPORT_DLG,NULL);
               if (sRC == TRUE)
                  {
                  sRC = LoadExportDLLPointers();
                  if (sRC != SUCCESS)
                     {
                     ReportError(sRC,NULL);
                     }
                  else
                     {
                     count = QueryListCount(pExportItems);
                     if (count > 0)
                        {
                        pUIDs = (PUID) malloc(count * sizeof(UID));
                        p = (char *) TopListItem(pExportItems);
                        i = 0;
                        do
                           {
                           if (p[0] != '*')
                              {
                              strrev(p);
                              memcpy(buffer,p,sizeof(UID));
                              buffer[sizeof(UID)] = '\0';
                              strrev(buffer);
                              memcpy(pUIDs[i],buffer,sizeof(UID));
                              i++;
                              }
                           p = (char *) NextListItem(pExportItems);
                           }
                        while (p != NULL);

                        DestroyList(pExportItems);
                        pExportItems = NULL;

                        if (i > 0)
                           {
                           memset(&UserExit,0,sizeof(UserExit));
                           uidWb[0] = '\0';
                           memset(uidNewWb,0,sizeof(UID));
                           DisableAllMenuItems();

                           bTaskInProgress = TRUE;
                           sRC = (*pExportItemsUserExit)(
                                    hWndList,
                                    0,
                                    count,
                                    0xFFFE,
                                    pUIDs,
                                    UserExit,
                                    (PUID) uidWb,
                                    (PUID) uidNewWb);

                           bTaskInProgress = FALSE;
                           UnloadExportDLL();
                           if (sRC == SUCCESS)
                              {
                              SoundGoodAlarm();
                              if (ExportDefaults.Destination = DEST_ROUTE)
                                 {
                                 if (uidNewWb[0] != '\0')
                                    {
                                    for (i = 0; i < count && sRC == SUCCESS; i++)
                                       {
                                       sRC = OimRemoveWorkBasketItem(
                                                (PUID) uidExportWb,
                                                (PUID) pUIDs[i],
                                                IPS_OPT_SYNC,NULL,0,&RC);

                                       if (sRC != SUCCESS)
                                          {
                                          sRC = LogError(ERR_RMVITM,NULL);
                                          }
                                       else
                                          {
                                          sRC = OimAddWorkBasketItem(
                                                   (PUID) uidNewWb,(PUID) pUIDs[i],
                                                   31000,TRUE,IPS_OPT_SYNC,NULL,0,&RC);

                                          if (sRC != SUCCESS)
                                             {
                                             sRC = LogError(ERR_EXPRWB,NULL);
                                             }
                                          }
                                       }
                                    }
                                 }
                              }
                           else
                              {
                              SoundBadAlarm();
                              }
                           }
                        }
                     EnableAllMenuItems();
                     }
                  }
               break;

            case IDM_ABOUT:
               DisplayAboutBox();
               break;

            case IDM_EXIT:
               WinPostMsg(hWndFrame,WM_QUIT,0L,0L);
               break;

            case IDM_HELP:
               DisplayHelpFile();
               break;

            default:
               break; /* End of default case for switch(mp1) */
            }
         break;

      case WM_MOUSEMOVE:
         return(WinDefWindowProc(hWnd,message,mp1,mp2));
         break;

      case WM_PAINT:
         /* Obtain a handle to a cached presentation space                  */
         hPS = WinBeginPaint(hWnd,0,0);

         /* Determine the size of the client area                           */
         //WinQueryWindowRect(hWnd,&rClient);

         /* Fill the background with the default background color           */
         //WinFillRect(hPS,&rClient,CLR_BACKGROUND);

         WinEndPaint(hPS);             // End the processing of WM_PAINT
         break;

      case WM_QUIT:
         return(WinDefWindowProc(hWnd,message,mp1,mp2));
         break;

      case WM_CLOSE:
         if (hWnd != hWndClient || bTaskInProgress)
            {
            break;
            }

         /* Logoff OIM database (FCAEDB) on the server                      */
         if (bOimLogon)
            {
            sRC = OimLogoff(           // End access to the Application Facility
                     IPS_OPT_SYNC,     // Perform function synchronously
                     NULL,             // No semaphore to synchronize
                     0,                // No message to synchronize
                     &RC);             // Pointer to return structure
            }

         return(WinDefWindowProc(hWnd,message,mp1,mp2));
         break;

      default:
         /* For any message for which you don't specifically provide a      */
         /* service routine, you should return the message to PM using      */
         /* the WinDefWindowProc function.                                  */

         return(WinDefWindowProc(hWnd,message,mp1,mp2));
         break;
      }
   return(FALSE);                      // Return code to caller
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:         cwRegisterClass                                           */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*  The following function registers all the classes of all the windows     */
/*  associated with this application. The function returns TRUE if it is    */
/*  successful, otherwise it returns FALSE.                                 */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int cwRegisterClass()
{
   register int sRC;                   // Return code variable

   sRC = WinRegisterClass(             // Register the window class
            hAB,                       // Anchor block handle
            (PCH) szAppName,           // Name of class being registered
            (PFNWP) WndProc,           // Window procedure for class
            CS_SYNCPAINT |             // Redraw immediately
            CS_SIZEREDRAW,             // This window can be resized/repainted
            0);                        // Extra bytes to reserve

   return(sRC);                        // Succesfully return to caller
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:         cwCreateWindow                                            */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*  The following function is used to create a window (the main window,     */
/*  a child window, an icon window, etc.) and set it's initial size and     */
/*  position. It returns the handle to the frame window.                    */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

HWND cwCreateWindow(
   HWND   hWndParent,                  // Handle to the parent of window
   ULONG  ctldata,                     // Frame control flags
   PCH    appname,                     // Class name of the window
   PCH    title,                       // Title of the window
   USHORT ResID,                       // Resource id value
   int    x,                           // Horizontal location
   int    y,                           // Vertical location
   int    cx,                          // Initial width
   int    cy,                          // Initial height
   PHWND  hWndClient,                  // Handle to the client area
   ULONG  lfStyle,                     // Frame window style
   USHORT uSizeStyle)                  // User defined size and location
{
   HWND   hWndFrame;                   // handle to created window frame
   USHORT SizeStyle;                   // local window positioning options
   HPS    hPS;                         // handle to a presentation space
   int    xmod, ymod;                  // modifiers for sizing
   #define DLGXMOD  4                  // Dialog units X modulo
   #define DLGYMOD  8                  // Dialog units Y modulo
   FONTMETRICS fm;                     // structure for determing modifiers

   /* Create the frame window */
   hWndFrame = WinCreateStdWindow(     // create standard window
                  hWndParent,          // parent of window
                  lfStyle,             // frame window style
                  &ctldata,            // frame flags
                  appname,             // class name
                  title,               // window title
                  0L,                  // client window style
                  0,                   // module for resources
                  ResID,               // resource id
                  hWndClient);         // client handle

   /* if hWndFrame is NULL, an error occured when opening the window,       */
   /*     notify the user and exit this function                            */

   if (hWndFrame != 0)
      {
      /* set up size options */

      SizeStyle = SWP_ACTIVATE | SWP_ZORDER | uSizeStyle;

      /* if the height, width, intial x or initial y values are non-zero,   */
      /* then we will need to set up the modifiers for size and location    */

      if ((cx > 0) || (cy > 0) || (x > 0)  || (y > 0))
         {
         hPS = WinGetPS(HWND_DESKTOP);
         GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm);
         xmod = (int)fm.lAveCharWidth;
         ymod = (int)fm.lMaxBaselineExt;
         WinReleasePS(hPS);
         }

      /* if either the width or the height are non-zero, then the size of th*/
      /*     created window will be changed, set SizeStyle accordingly      */

      if ((cx > 0) || (cy > 0))
         {
         SizeStyle |= SWP_SIZE;
         }

      /* set the size and position of the window and activate it            */

      WinSetWindowPos(hWndFrame, HWND_TOP, 0, 0,
                     (USHORT)(cx * xmod)/DLGXMOD,
                     (USHORT)(cy * ymod)/DLGYMOD, SizeStyle);

      /* if the either the intial x or y position of the window is non-zero,*/
      /*    set the window to its new position                              */

      if ((x > 0) || (y > 0))
         {
         WinSetWindowPos(hWndFrame, HWND_TOP,
                        (USHORT)(x * xmod)/DLGXMOD,
                        (USHORT)(y * ymod)/DLGYMOD, 0, 0, SWP_MOVE);
         }
      }
   return(hWndFrame);                  // return handle to the frame window
}


/*BEGINHEADER****************************************************************/
/*                                                                          */
/*  Name:         DisplayAboutBox                                           */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*  This function displays the ABOUTBOX dialog box with information about   */
/*  this application.                                                       */
/*                                                                          */
/*ENDHEADER******************************************************************/

SHORT DisplayAboutBox()
{
   register int sRC;

   sRC = WinDlgBox(                    // Display specified dialog box
            HWND_DESKTOP,
            hWndFrame,
            AboutDlgProc,
            0,
            ABOUTBOX,
            NULL);

   return(sRC);                        // Return code to caller
}


/*BEGINHEADER****************************************************************/
/*                                                                          */
/*  Name:         AboutDlgProc                                              */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*  This is the dialog proc for the ABOUTBOX dialog box.                    */
/*                                                                          */
/*ENDHEADER******************************************************************/

MRESULT EXPENTRY AboutDlgProc(
   HWND hDlg,
   USHORT msg,
   MPARAM mp1,
   MPARAM mp2)
{
   switch (msg)
      {
      case WM_INITDLG:
         CenterWindow(hDlg,hWndFrame);
         break;

      case WM_COMMAND:
         switch (SHORT1FROMMP(mp1))
           {
           case IDD_OK:
           case IDD_CANCEL:
              WinDismissDlg(hDlg,TRUE);
              break;

           default:
              break;
           }
        break;

     default:
        return(WinDefDlgProc(hDlg,msg,mp1,mp2));
        break;
     }
   return(FALSE);
}

/*BEGINHEADER****************************************************************/
/*                                                                          */
/*  Name:         ForceDlgProc                                              */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*  This is the dialog proc for ID_FORCE_DLG dialog box.                    */
/*                                                                          */
/*ENDHEADER******************************************************************/

MRESULT EXPENTRY ForceDlgProc(
   HWND hDlg,
   USHORT msg,
   MPARAM mp1,
   MPARAM mp2)
{
   switch (msg)
      {
      case WM_INITDLG:
         CenterWindow(hDlg,hWndFrame);
         break;

      case WM_COMMAND:
         switch (SHORT1FROMMP(mp1))
            {
            case IDD_OK:
               WinDismissDlg(hDlg,TRUE);
               break;

            case IDD_EXIT:
               WinDismissDlg(hDlg,FALSE);
               break;

            default:
               break;
            }
         break;

      default:
         return(WinDefDlgProc(hDlg,msg,mp1,mp2));
         break;
      }
   return(FALSE);
}

/*BEGINHEADER****************************************************************/
/*                                                                          */
/*  Name:         DisableMenuItem                                           */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*  This function disbales the specified menu item.                         */
/*                                                                          */
/*ENDHEADER******************************************************************/

void DisableMenuItem(USHORT id)
{
   HWND hMenu = NULL;                  // Handle to frame's menu

   hMenu = (HWND) WinWindowFromID(hWndFrame,FID_MENU);

   WinSendMsg(                         // Disable specified menu item
      hMenu,
      MM_SETITEMATTR,
      MPFROM2SHORT(id,TRUE),
      MPFROM2SHORT(MIA_DISABLED,MIA_DISABLED));

   return;                             // Return to caller
}

/*BEGINHEADER****************************************************************/
/*                                                                          */
/*  Name:         EnableMenuItem                                            */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*  This function disbales the specified menu item.                         */
/*                                                                          */
/*ENDHEADER******************************************************************/

void EnableMenuItem(USHORT id)
{
   HWND hMenu = NULL;                  // Handle to frame's menu

   hMenu = (HWND) WinWindowFromID(hWndFrame,FID_MENU);

   WinSendMsg(                         // Enable specified menu item
      hMenu,
      MM_SETITEMATTR,
      MPFROM2SHORT(id,TRUE),
      MPFROM2SHORT(MIA_DISABLED,0));

   return;                             // Return to caller
}

/*BEGINHEADER****************************************************************/
/*                                                                          */
/*  Name:         CheckMenuItem                                             */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*  This function checks/unchecks the specified menu item.                  */
/*                                                                          */
/*ENDHEADER******************************************************************/

void CheckMenuItem(USHORT id,BOOL bCheck)
{
   HWND hMenu = NULL;                  // Handle to frame's menu
   int Mask;

   Mask = bCheck ? MIA_CHECKED : 0;
   hMenu = (HWND) WinWindowFromID(hWndFrame,FID_MENU);

   WinSendMsg(                         // Check/uncheck specified menu item
      hMenu,
      MM_SETITEMATTR,
      MPFROM2SHORT(id,TRUE),
      MPFROM2SHORT(MIA_CHECKED,Mask));

   return;                             // Return to caller
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int SpawnImport(PIPLIST pImportItems)
{
   PBYTE pStack;
   TID ThreadId;
   register int sRC = SUCCESS;

   if (selImpStack == 0)
      {
      sRC = DosAllocSeg(8192,&selImpStack,0);
      if (sRC != SUCCESS)
         {
         sRC = LogError(ERR_INSUFMEM,NULL);
         }
      }

   if (sRC == SUCCESS)
      {
      pStack = (PBYTE) MAKEP(selImpStack,8191);

      sRC = DosCreateThread((PFNTHREAD) TheImportThread,&ThreadId,pStack);
      if (sRC != SUCCESS)
         {
         sRC = LogError(ERR_IMPTHRD,NULL);
         }
      }
   return(sRC);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

VOID APIENTRY TheImportThread()
{
   HMQ hMQ;
   int sRC = SUCCESS;

   hMQ = WinCreateMsgQueue(hAB,0);
   if (hMQ == 0)
      {
      ReportError(ERR_CREATEQUEUE,NULL);
      }
   else
      {
      fAbortTask = FALSE;
      sRC = ImportItems(pImportItems);
      }
   WinSendMsg(hWndClient,UM_IMPORT_DONE,MPFROMSHORT(sRC),MPFROMSHORT(0));
   WinDestroyMsgQueue(hMQ);
   DosExit(EXIT_THREAD,sRC);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void DisableAllMenuItems()
{
   DisableMenuItem(IDM_IMPORT);
   DisableMenuItem(IDM_EXPORT);
   DisableMenuItem(IDM_IMPSETUP);
   DisableMenuItem(IDM_EXPSETUP);
   DisableMenuItem(IDM_STGGROUPS);
   DisableMenuItem(IDM_CLEARLOG);
   DisableMenuItem(IDM_SAVELOG);
   DisableMenuItem(IDM_EXIT);
   DisableMenuItem(IDM_AUTONOTE);
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void EnableAllMenuItems()
{
   EnableMenuItem(IDM_IMPORT);
   EnableMenuItem(IDM_EXPORT);
   EnableMenuItem(IDM_IMPSETUP);
   EnableMenuItem(IDM_EXPSETUP);
   EnableMenuItem(IDM_STGGROUPS);
   EnableMenuItem(IDM_CLEARLOG);
   EnableMenuItem(IDM_SAVELOG);
   EnableMenuItem(IDM_EXIT);
   EnableMenuItem(IDM_AUTONOTE);
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void DisplayHelpFile()
{
   char szPath[128];
   CHAR ObjFail[50];
   RESULTCODES ReturnCodes;
   register int rc;

   memset(szPath,0,sizeof(szPath));
   sprintf(szPath,"view.exe %sip2impex.inf",szAppPath);
   szPath[8] = '\0';

   rc = DosExecPgm(
            ObjFail,            // Object name buffer
            sizeof(ObjFail),    // Length of obj. name buffer
            EXEC_ASYNC,         // Execution flag - asynchronous
            szPath,             // Arguments to pass to VIEW process
            NULL,               // Inherits our environment
            &ReturnCodes,       // Ptr. to resultcodes struct
            "VIEW.EXE");        // Name of program file
   return;
}
