/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

/*BEGINPROLOGUE**************************************************************/
/*                                                                          */
/*   Module Name:              IP2EXPRT.C                                   */
/*                                                                          */
/*   Descriptive Name:         Main module for the IP2EXPRT DLL.            */
/*                                                                          */
/*   Module Owner:             Carlos Portela                               */
/*                             Simple Software Solutions, Inc.              */
/*                                                                          */
/*   Status:                   Release 1, Level 0                           */
/*                                                                          */
/*   Function:                 This is the main module for an OS/2 DLL      */
/*                             that allows an ImagePlus/2 user to export    */
/*                             documents out of the system.                 */
/*                                                                          */
/*   Dependencies:             IBM OS/2 Extended Edition 1.30.1             */
/*                                                                          */
/*ENDPROLOGUE****************************************************************/
#define ALLOCATE
#define INCL_DOSMODULEMGR
#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#define INCL_DOSMISC
#define INCL_DOSMEMMGR
#define INCL_GPIBITMAPS
#define INCL_WIN
#define INCL_PM
#include <os2.h>

#include <stdio.h>                     // Standard C standard input/output
#include <stdlib.h>                    // Standard C library header
#include <string.h>                    // Standard C string header
#include <ctype.h>                     // Contains standard macros and symbols

#define IPS_SDS_INCL                   // To include Spool Device Services
#define IPS_IMG_INCL                   // To include Image Services
#define IPS_PAG_INCL                   // To include Page Services
#define IPS_DSP_INCL                   // To include Display Services
#define IPS_OMS_INCL                   // To include Object Management System
#define IPS_OAS_INCL                   // To include Object Access Services
#include <ips.h>

#include "ip2impex.rch"                // Includes string IDs and menu IDs
#include "ip2impex.h"                  // Includes prototypes and Masthead
#include "dialog.h"                    // Contains defines used in dialog boxes
#include "globals.h"                   // Contains our global variables
#include "error.h"                     // Contains error definitions

static BOOL bCalledFromIP2 = FALSE;

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

SHORT _loadds EXPENTRY ExportItemsUserExit (
   HWND hwnd,                          // Parent window handle
   USHORT usOperation,                 // Operation causing overload
   USHORT usUidCount,                  // Number of items being routed
   USHORT usIndex,                     // Index of item in list causing overload
   PUID puidList,                      // List of UIDs
   USEREXITSTRUCT UserExit,            // Info about currently opened item
   PUID puidWb,                        // UID of the destination workbasket
   PUID puidNewWb)                     // UID of the new workbasket
{
   register int sRC;
   UID uidWb;

   bCalledFromIP2 = FALSE;
   if (usUidCount > 0)
      {
      sRC = DosGetModHandle("IP2EXPRT",&hModule);
      if (sRC != SUCCESS)
         {
         ReportError(ERR_GETMOD,NULL);
         }
      else
         {
         hRCMod = hModule;
         /*
          * When this function is called from the IP/2 Import/Export
          * Facility it is desired to bypass displaying the setup
          * dialog box.  One way to accomplish this is to pass a -1 in
          * the usIndex whenever called from the Import/Export Facility.
          */
         sRC = TRUE;
         if (usIndex != 0xFFFE)
            {
            bCalledFromIP2 = TRUE;
            sRC = WinDlgBox(HWND_DESKTOP,HWND_DESKTOP,ExportSetupDlgProc,
                     hModule,ID_EXPSETUP_DLG,NULL);
            }
         else
            {
            bCalledFromIP2 = FALSE;
            hWndList = hwnd;
            }

         if (sRC == TRUE)
            {
            hProgressDlg = WinLoadDlg(HWND_DESKTOP,HWND_DESKTOP,
               InProgressDlgProc,hModule,ID_PROGRESS_EXP,NULL);

            if (hProgressDlg != NULL)
               {
               WinShowWindow(hProgressDlg,TRUE);
               }

            ActivityLogOutput("************************");
            ActivityLogOutput("Export operation started");
            ActivityLogOutput("************************");

            fAbortTask = FALSE;
            sRC = ExportItems(usUidCount,puidList);
            if (sRC == SUCCESS)
               {
               if (ExportDefaults.Destination == DEST_ROUTE)
                  {
                  sRC = WBToUID(ExportDefaults.szWorkBasket,(PUID) uidWb);
                  if (sRC != SUCCESS)
                     {
                     sRC = LogError(ERR_INVRWB,NULL);
                     }
                  else
                     {
                     if (memcmp(uidWb,puidNewWb,sizeof(UID)) != 0)
                        {
                        WBToUID(ExportDefaults.szWorkBasket,puidNewWb);
                        }
                     }
                  }
               }
            WinDestroyWindow(hProgressDlg);
            }
         }
      }
   return(SUCCESS);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

MRESULT EXPENTRY ExportSetupDlgProc(
   HWND hDlg,
   USHORT msg,
   MPARAM mp1,
   MPARAM mp2)
{
   register int rc;
   char buffer[65], *p;
   USHORT usDrive;
   char szCurDir[65];
   ULONG lDriveMap;
   USHORT usDirLen;
   SHORT index;

   switch (msg)
      {
      case WM_INITDLG:
         ReadDefaults();
         if (szExportPath[0] != '\0')
            {
            if (isalpha(szExportPath[0]) && szExportPath[1] == ':')
               {
               usDrive = (USHORT) (szExportPath[0] - 'A' + 1);
               DosError(1);
               rc = DosSelectDisk(usDrive);
               DosError(0);
               if (rc == SUCCESS)
                  {
                  DosError(1);
                  rc = DosChDir(&szExportPath[2],0L);
                  DosError(0);
                  }
               }
            }

         if (bCalledFromIP2)
            {
            WinSetDlgItemText(hDlg,IDD_SETUP,"~Export");
            }
// Changed 10/12/92 MAB
         WinEnableWindow(WinWindowFromID(hDlg,ID_CIF),TRUE);

         CenterWindow(hDlg,HWND_DESKTOP);
         FillListWithWBs(WinWindowFromID(hDlg,ID_WBCOMBO),LM_INSERTITEM);

         WinSendDlgItemMsg(hDlg,ID_FIRSTLEVEL,
            BM_SETCHECK,MPFROMSHORT(ExportDefaults.bFolder),MPFROMSHORT(0));

         WinSendDlgItemMsg(hDlg,ID_CIF,
            BM_SETCHECK,MPFROMSHORT(ExportDefaults.bCIF),MPFROMSHORT(0));

         WinSendDlgItemMsg(hDlg,ID_LISTFILE,
            EM_SETTEXTLIMIT,MPFROMSHORT(LIST_FILE_LEN),MPFROMSHORT(0));

         WinSetDlgItemText(hDlg,ID_LISTFILE,ExportDefaults.szFName);

         if (ExportDefaults.szWorkBasket[0])
            {
            WinSetDlgItemText(hDlg,ID_WBCOMBO,ExportDefaults.szWorkBasket);
            }
         else
            {
            WinSendDlgItemMsg(hDlg,ID_WBCOMBO,
               LM_SELECTITEM,MPFROMSHORT(0),MPFROMSHORT(TRUE));
            }

         WinSetDlgItemText(hDlg,ID_LISTFILE,ExportDefaults.szFName);

         WinEnableWindow(WinWindowFromID(hDlg,ID_WBCOMBO),FALSE);
         switch (ExportDefaults.Destination)
            {
            case DEST_DELETE:
               WinSendDlgItemMsg(hDlg,ID_DELETE,
                  BM_SETCHECK,MPFROMSHORT(1),MPFROMSHORT(0));
               break;

            case DEST_FILEROOM:
               WinSendDlgItemMsg(hDlg,ID_FILEROOM,
                  BM_SETCHECK,MPFROMSHORT(1),MPFROMSHORT(0));
               break;

            case DEST_ROUTE:
               WinSendDlgItemMsg(hDlg,ID_WB,
                  BM_SETCHECK,MPFROMSHORT(1),MPFROMSHORT(0));

               WinEnableWindow(WinWindowFromID(hDlg,ID_WBCOMBO),TRUE);
               break;
            }

         WinSendMsg(hDlg,UM_REDO_DIRLIST,MPFROMSHORT(0),MPFROMSHORT(0));
         break;

      case UM_REDO_DIRLIST:
         rc = DosQCurDisk(&usDrive,&lDriveMap);
         usDirLen = sizeof(szCurDir);
         rc = DosQCurDir(usDrive,szCurDir,&usDirLen);
         buffer[0] = (char) (('A' + usDrive) - 1);
         buffer[1] = ':';
         buffer[2] = '\\';
         buffer[3] = '\0';
         if (rc != SUCCESS)
            {
            szCurDir[0] = '\0';
            }
         strupr(szCurDir);
         strcat(buffer,szCurDir);

         WinSendDlgItemMsg(hDlg,ID_CURRPATH,
            EM_SETTEXTLIMIT,MPFROMSHORT(65),MPFROMSHORT(0));
         WinSendDlgItemMsg(hDlg,ID_CURRPATH,EM_SETREADONLY,
            MPFROMSHORT(TRUE),MPFROMSHORT(0));
         WinSetDlgItemText(hDlg,ID_CURRPATH,buffer);

         WinSendDlgItemMsg(hDlg,ID_DIRLIST,
            LM_DELETEALL,MPFROMSHORT(0),MPFROMSHORT(0));

         InitList(WinWindowFromID(hDlg,ID_DIRLIST),TRUE);
         AddDrivesToList(WinWindowFromID(hDlg,ID_DIRLIST));
         WinSendDlgItemMsg(hDlg,ID_DIRLIST,
            LM_SELECTITEM,MPFROMSHORT(0),MPFROMSHORT(TRUE));
         break;

      case WM_CONTROL:
         switch (SHORT1FROMMP(mp1))
            {
            case ID_DELETE:
            case ID_FILEROOM:
               WinEnableWindow(WinWindowFromID(hDlg,ID_WBCOMBO),FALSE);
               break;

            case ID_WB:
               WinEnableWindow(WinWindowFromID(hDlg,ID_WBCOMBO),TRUE);
               break;

            case ID_DIRLIST:
               if (SHORT2FROMMP(mp1) == LN_ENTER)
                  {
                  index = (SHORT) (LONG) WinSendDlgItemMsg(hDlg,ID_DIRLIST,
                     LM_QUERYSELECTION,
                     MPFROMSHORT(LIT_FIRST),
                     MPFROMSHORT(0));

                  WinSendDlgItemMsg(hDlg,ID_DIRLIST,
                     LM_QUERYITEMTEXT,
                     MPFROM2SHORT(index,sizeof(buffer)),
                     MPFROMP(buffer));

                  DosError(1);
                  if (buffer[0] != '[')
                     {
                     rc = DosChDir(buffer,0L);
                     }
                  else
                     {
                     rc = DosSelectDisk((buffer[1] - 'A') + 1);
                     }
                  DosError(0);
                  WinSendMsg(hDlg,UM_REDO_DIRLIST,MPFROMSHORT(0),MPFROMSHORT(0));
                  }
               break;
            }
         break;

      case WM_COMMAND:
         switch (SHORT1FROMMP(mp1))
            {
            case IDD_SETUP:
               ExportDefaults.bFolder = (SHORT) (ULONG) WinSendDlgItemMsg(
                  hDlg,ID_FIRSTLEVEL,
                  BM_QUERYCHECK,MPFROMSHORT(0),MPFROMSHORT(0));

               ExportDefaults.bCIF = (SHORT) (ULONG) WinSendDlgItemMsg(
                  hDlg,ID_CIF,
                  BM_QUERYCHECK,MPFROMSHORT(0),MPFROMSHORT(0));

               if (WinSendDlgItemMsg(hDlg,ID_DELETE,
                     BM_QUERYCHECK,MPFROMSHORT(0),MPFROMSHORT(0)))
                  {
                  ExportDefaults.Destination = DEST_DELETE;
                  }
               else if (WinSendDlgItemMsg(hDlg,ID_FILEROOM,
                           BM_QUERYCHECK,MPFROMSHORT(0),MPFROMSHORT(0)))
                  {
                  ExportDefaults.Destination = DEST_FILEROOM;
                  }
               else if (WinSendDlgItemMsg(hDlg,ID_WB,
                           BM_QUERYCHECK,MPFROMSHORT(0),MPFROMSHORT(0)))
                  {
                  ExportDefaults.Destination = DEST_ROUTE;
                  }

               WinQueryDlgItemText(hDlg,ID_CURRPATH,
                  sizeof(szExportPath),
                  szExportPath);

               strupr(szExportPath);

               WinQueryDlgItemText(hDlg,ID_WBCOMBO,
                  sizeof(ExportDefaults.szWorkBasket),
                  ExportDefaults.szWorkBasket);

               WinQueryDlgItemText(hDlg,ID_LISTFILE,
                  sizeof(ExportDefaults.szFName),
                  ExportDefaults.szFName);

               strupr(ExportDefaults.szFName);
               p = strrchr(ExportDefaults.szFName,'.');
               if (p != NULL)
                  *p = '\0';
               if (strlen(ExportDefaults.szFName) == 0)
                  {
                  ReportError(ERR_NOLSTF,NULL);
                  WinSetFocus(HWND_DESKTOP,WinWindowFromID(hDlg,ID_LISTFILE));
                  }
               else
                  {
                  SaveDefaults();
                  WinDismissDlg(hDlg,TRUE);
                  }
               break;

            case IDD_CANCEL:
               WinDismissDlg(hDlg,FALSE);
               break;

            default:
               break;
            }
         break;

      default:
         return(WinDefDlgProc(hDlg,msg,mp1,mp2));
         break;
      }
   return(FALSE);
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

MRESULT EXPENTRY InProgressDlgProc(
   HWND hDlg,
   USHORT msg,
   MPARAM mp1,
   MPARAM mp2)
{
   char szTime[11];
   static int seconds;
   int hours, minutes, secs;
   char szTitle[65];
   char buffer[128];

   switch (msg)
      {
      case WM_INITDLG:
         CenterWindow(hDlg,HWND_DESKTOP);
         WinSendMsg(hDlg,WM_TIMER,MPFROMSHORT(1),MPFROMSHORT(0));
         WinStartTimer(hAB,hDlg,1,900);
         seconds = 0;
         break;

      case WM_TIMER:
         if (SHORT1FROMMP(mp1) == 1)
            {
            seconds++;
            hours = seconds / 3600;
            minutes = (seconds - (hours * 3600)) / 60;
            secs = seconds - ((minutes * 60) + (hours * 3600));
            sprintf(szTime,"%02d:%02d:%02d ",hours,minutes,secs);

            WinSetDlgItemText(hDlg,ID_CLOCK,szTime);
            WinStartTimer(hAB,hDlg,1,900);
            }
         break;

      case WM_COMMAND:
         switch (SHORT1FROMMP(mp1))
            {
            case IDD_OK:
               WinLoadString(hAB,0,IDS_TITLE,sizeof(szTitle),szTitle);
               WinLoadString(hAB,0,IDS_EXIT,sizeof(buffer),buffer);
               if (WinMessageBox(HWND_DESKTOP,hWndFrame,buffer,szTitle,
                  0,MB_YESNOCANCEL | MB_ICONQUESTION) == MBID_YES)
                  {
                  fAbortTask = TRUE;
                  WinSetDlgItemText(hDlg,ID_TEXT,"Exiting...");
                  WinEnableWindow(WinWindowFromID(hDlg,IDD_OK),FALSE);
                  }
               break;

            default:
               break;
            }
         break;

      default:
         return(WinDefDlgProc(hDlg,msg,mp1,mp2));
         break;
      }
   return(FALSE);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

USHORT APIENTRY IPDLLInit(unsigned dhand,unsigned heap,unsigned hand)
{
   register int sRC = SUCCESS;
   HMODULE hModule = 0;

   InitializeGlobalData();

   sRC = InitSystemTables(INI_EXE);
   if (sRC != SUCCESS)
      {
      ReportError(sRC,NULL);
      }
   else
      {
      sRC = ReadDefaults();
      }
   return(!sRC);
}
