/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <process.h>
#include <errno.h>
#include <memory.h>
#include <string.h>
#include <direct.h>
#include <ctype.h>

#define MAXSTR 2048

FILE *in,*out;

void chk_lib(char string[MAXSTR], char *path);
void chk_path(char string[MAXSTR], char *path);
int UpdateCFG(char *path);

int main(int argc,char **argv);

int main(int argc,char **argv)
{
   int rc = 0;
   char szDir[15];
   char szCmd[128];

   printf("\n\n\n\n\n\n\n\n\n\n\n\n\n");
   printf("ImagePlus/2 Import/Export Facility Installation\n");
   printf("Copyright (C) IBM Corporation.\n");
   printf("All rights reserved\n\n");

   if (argc < 2)
      {
      printf("Specify drive letter where system will\n");
      printf("be installed, for example:\n\n");
      printf("\tA:\\>install c:\n\n");
      printf("will install the system on drive C:\n\n");
      printf("NOTE: IP/2 Import/Export Facility diskette must be in the current drive\n\n");
      exit(-1);
      }

   memset(szDir,0,sizeof(szDir));
   szDir[0] = (char) tolower(argv[1][0]);
   szDir[1] = ':';
   strcat(szDir,"\\ip2impex");
   mkdir(szDir);

   printf("Copying files to %s...\n",szDir);
   sprintf(szCmd,"xcopy \\BIN\\*.* %s",szDir);
   rc = system(szCmd);
   if (rc != 0)
      {
      printf("\nNOTE: IP/2 Import/Export Facility diskette must be in the current drive\n\n");
      exit(-1);
      }

   printf("Backup of CONFIG.SYS placed in %s\n",szDir);
   printf("Updating CONFIG.SYS...\n");
   UpdateCFG(szDir);

   printf("\n\nInstallation complete\n\n");
   printf("You CONFIG.SYS has been modified.\n");
   printf("Please re-boot your system\n\n");
   printf("All source files are placed in the \\SOURCE subdirectory.\n");
   printf("Please read the README file in the \\SOURCE subdirectory for\n");
   printf("further information on use of the source code.\n");
   printf("\nAlso please read the README file on the diskette for general information.\n");
   return(rc);
}


int UpdateCFG(char *path)
{
  int rc=0;
  int flag=0;
  char line[2048];

  sprintf(line,"copy c:\\config.sys %s",path);
  system(line);
  sprintf(line,"%s\\config.sys",path);
  if((in=fopen(line,"r"))==NULL)
  {
    printf("Error reading backup CONFIG.SYS\n\a");
    return(-1);
  }

  if((out=fopen("c:\\config.sys","w"))==NULL)
  {
    printf("Error opening C:\\CONFIG.SYS\n\a");
    return(-2);
  }


  while(fgets(line,MAXSTR,in) != NULL)
    {
    if(strncmp("LIBPATH=",line,8)==0) chk_lib(line,path);
    else if(strnicmp("SET PATH=",line,9)==0) chk_path(line,path);
    else if(strnicmp("SET IP2IMPEX=",line,13)==0)
      {
      fprintf(out,"SET IP2IMPEX=%s\n",path);
      flag=1;
      }
    else fputs(line,out);
    }

  if(flag==0) fprintf(out,"\nSET IP2IMPEX=%s\n",path);

  fclose(in);
  fclose(out);

  return(rc);
}

void chk_lib(char string[MAXSTR], char *path)
{
  unsigned int i;
  char *result;
  fputs("LIBPATH=",out);

  if((result = strstr(string,path))==NULL)   fprintf(out,"%s;",path);

  for(i=8;i<strlen(string);i++)               fprintf(out,"%c",string[i]);
}

void chk_path(char string[MAXSTR], char *path)
{
  unsigned int i;
  char *result;
  fputs("SET PATH=",out);
  if((result = strstr(string,path))==NULL)   fprintf(out,"%s;",path);
  for(i=9;i<strlen(string);i++) fprintf(out,"%c",string[i]);
}
