/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

#define INCL_DOS
#define INCL_DOSMEMMGR
#define INCL_GPIBITMAPS
#define INCL_WIN
#define INCL_PM
#include <os2.h>

#include <stdio.h>                     // Standard C standard input/output
#include <stdlib.h>                    // Standard C library header
#include <string.h>                    // Standard C string header
#include <ctype.h>                     // Contains standard macros and symbols
#include <time.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>                        // Contains io macros and symbols

#define IPS_SDS_INCL                   // To include Spool Device Services
#define IPS_IMG_INCL                   // To include Image Services
#define IPS_PAG_INCL                   // To include Page Services
#define IPS_DSP_INCL                   // To include Display Services
#define IPS_OMS_INCL                   // To include Object Management System
#define IPS_OAS_INCL                   // To include Object Access Services
#include <ips.h>

#include "ip2impex.rch"                // Contains menu symbol definitions
#include "ip2impex.h"                  // Includes prototypes and Masthead
#include "dialog.h"                    // Contains defines used in dialog boxes
#include "globals.h"                   // Contains our global variables
#include "error.h"                     // Contains error definitions

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int ImportItems(PIPLIST pList)
{
   register int rc = SUCCESS;
   char *p,*p2;
   char buffer[256];
   char msg[256];
   UID uidItem;
   char *pExt;
   PIPLIST pList2;
   int InCIF=0;


   fAbortTask = FALSE;
   if (QueryListCount(pList) > 0)
      {
      InitDeleteList();
      p = TopListItem(pList);
      while (p != NULL)
         {
         sprintf(buffer,"Importing %s...",p);
         ActivityLogOutput(buffer);
         pExt = strchr(p,'.');
         pExt++;
         InCIF=0;
         if( strcmpi(pExt,"CIF") == 0)
         {
            ConvertCIF(p);
            InCIF=1;
            EnforceExtension(p,".LST");
            pExt = strchr(p,'.');
            pExt++;
         }
         if (strcmpi(pExt,"LST") == 0)
         {
            rc = ParseLST(p,&pList2);
            if (rc == SUCCESS)
            {
            if (UnknownClass.bDelete && KnownClass.bDelete)
              {
              CombinePathAndName(szImportPath,p,buffer);
              AddDeferredDelete(buffer);
              if(InCIF==1)
                {
                EnforceExtension(p,".CIF");
                CombinePathAndName(szImportPath,p,buffer);
                AddDeferredDelete(buffer);
                InCIF=0;
                }
              }
            }
            p2 = TopListItem(pList2);
            while (p2 != NULL)
               {
               sprintf(buffer,"Importing %s...",p2);
               ActivityLogOutput(buffer);
               rc = ImportItem(p2,(PUID) uidItem);
               if (rc == SUCCESS)
                  {
                  sprintf(buffer,"Successfully imported %s",p2);
                  }
               else
                  {
                  strcpy(msg,"No error message available");
                  if (rc == ERR_NOIMP)
                     {
                     WinLoadString(hAB,0,rc,sizeof(msg),msg);
                     sprintf(buffer,"Warning %d importing %s - %s",rc,p2,msg);
                     }
                  else
                     {
                     WinLoadString(hAB,0,rc,sizeof(msg),msg);
                     sprintf(buffer,"Error %d importing %s - %s",rc,p2,msg);
                     ActivityLogOutput("! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! !");
                     }
                  }
               ActivityLogOutput(buffer);
               p2 = NextListItem(pList2);
               }
         }
         else
         {
           rc = ImportItem(p,(PUID) uidItem);
         }
         if (rc == SUCCESS)
            {
            sprintf(buffer,"Successfully imported %s",p);
            }
         else
            {
            strcpy(msg,"No error message available");
            if (rc == ERR_NOIMP)
               {
               WinLoadString(hAB,0,rc,sizeof(msg),msg);
               sprintf(buffer,"Warning %d importing %s - %s",rc,p,msg);
               }
            else
               {
               WinLoadString(hAB,0,rc,sizeof(msg),msg);
               sprintf(buffer,"Error %d importing %s - %s",rc,p,msg);
               ActivityLogOutput("! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! !");
               }
            }
         ActivityLogOutput(buffer);
         p = NextListItem(pList);
         if (fAbortTask == TRUE)
            {
            ActivityLogOutput("Operation successfully stopped...");
            break;
            }
         }
      if (fAbortTask == FALSE)
         {
         DeleteFilesInList();
         DestroyDeleteList();
         }
      }
   return(rc);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int ImportItem(char *szFileName,PUID uidItem)
{
   char *pExt;
   register int rc = SUCCESS;

   pExt = strchr(szFileName,'.');
   if (pExt != NULL)
      {
      pExt++;
      if (strcmpi(pExt,"INX") == 0)
         {
         rc = ImportINX(szFileName,uidItem);
         }
      else if (strcmpi(pExt,"MDI") == 0)
         {
         rc = ImportPlaneImage(szFileName,uidItem);
         }
      else if (strcmpi(pExt,"TIF") == 0)
         {
         rc = ImportPlaneImage(szFileName,uidItem);
         }
      else if (strcmpi(pExt,"CIF") == 0)
         {
         rc = ImportCIF(szFileName);
         }
      else if (strcmpi(pExt,"LST") == 0)
         {
         rc = ImportLST(szFileName);
         }
      else
         {
         rc = ERR_INVIMPFIL;
         }
      }
   else
      {
      rc = ERR_INVIMPFIL;
      }
   return(rc);
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int ImportPlaneImage(char *szFileName,PUID uidItem)
{
   register int sRC = SUCCESS;
   IMPORT_REQUEST ImpReq;
   char *pPeriod;
   PSGMAPSTRUCT pMapStruct;
   BOOL bAM = TRUE;

   memset(&ImpReq,0,sizeof(ImpReq));

   if (UnknownClass.Destination == DEST_NOIMPORT)
      {
      sRC = LogError(ERR_NOIMP,NULL);
      }
   else
      {
      /* Image type is OIM_DOCUMENT */
      ImpReq.sItemType = OIM_DOCUMENT;

      /* Copy file name passed to this function */
      strcpy(ImpReq.szImageFile,szFileName);

      /* Find the content class of the file */
      pPeriod = strrchr(szFileName,'.');
      sRC = ExtensionToCC(pPeriod,&ImpReq.ContentClass);
      if (sRC != SUCCESS)
         {
         LogError(sRC,NULL);
         }
      else
         {
         /* Get the index class of this item */
         strcpy(ImpReq.szIndexClass,UnknownClass.szBestFitClass);
         ClassToId(ImpReq.szIndexClass,&ImpReq.ClassId);

         /* Setup the attributes */

         ImpReq.pAttrs = NULL;

         /* Compose the note for this document */
         AddNoteHeader(&ImpReq.pNote);

         pMapStruct = FindClassMapEntry(UnknownClass.szBestFitClass);
         if (pMapStruct != NULL)
            {
            StgGroupToId(pMapStruct->szStgGroupName,&ImpReq.TargetStgGroup);
            }
         else
            {
            StgGroupToId("DEFAULT",&ImpReq.TargetStgGroup);
            }
         IdToStgGroup(ImpReq.TargetStgGroup,ImpReq.szTargetStgGroup);

         // There is no index info to be appened to the note
         ImpReq.bAppend = FALSE;
         ImpReq.bDelete = UnknownClass.bDelete;

         // Get the name and serial of a DASD volume on
         // the DEFAULT storage group

         strcpy(ImpReq.szVolume,szDASDVolName);
         ImpReq.ulVolSer = ulDASDVolSer;

         if (UnknownClass.Destination == DEST_ROUTE)
            {
            ImpReq.bRoute = TRUE;
            }

         strcpy(ImpReq.szWorkBasket,UnknownClass.szWorkBasket);
         WBToUID(ImpReq.szWorkBasket,(PUID) ImpReq.uidWorkBasket);

         sRC = ImportDocument(&ImpReq,uidItem);
         if (sRC != SUCCESS)
            {
            LogError(sRC,NULL);
            }
         }
      }
   return(sRC);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int ImportCIF(char *szFileName)
{
   register int rc = SUCCESS;
   CHAR parm[128];
   CHAR lstfile[256];
   CHAR buffer[256];

   strcpy(lstfile,szFileName);
   EnforceExtension(lstfile,".LST");
   sprintf(parm,"parsecif %s %s > %sparsecif.log",szFileName,lstfile,szAppPath);
   system(parm);
   rc=ImportLST(lstfile);
   if (rc == SUCCESS)
      {
      if (UnknownClass.bDelete && KnownClass.bDelete)
         {
         CombinePathAndName(szImportPath,szFileName,buffer);
         AddDeferredDelete(buffer);
         }
      }
   return(rc);
}

int ConvertCIF(char *szFileName)
{
   register int rc = SUCCESS;
   CHAR parm[128];
   CHAR lstfile[256];

   strcpy(lstfile,szFileName);
   EnforceExtension(lstfile,".LST");
   sprintf(parm,"parsecif %s %s > %sparsecif.log",szFileName,lstfile,szAppPath);
   system(parm);

   return(rc);
}

int ImportLST(char *szFileName)
{
   register int rc;
   PIPLIST pList;
   char *p;
   UID uidItem;
   char buffer[256];
   char msg[256];
   char szUID[17];

   rc = ParseLST(szFileName,&pList);
   if (rc == SUCCESS)
      {
      if (UnknownClass.bDelete && KnownClass.bDelete)
         {
         CombinePathAndName(szImportPath,szFileName,buffer);
         AddDeferredDelete(buffer);
         }

      if (QueryListCount(pList) > 0)
         {
         p = TopListItem(pList);
         while (p != NULL)
            {
            rc = ImportItem(p,(PUID) uidItem);
            if (rc != SUCCESS)
               {
               memset(szUID,0,sizeof(szUID));
               strcpy(msg,"No error message available");
               WinLoadString(hAB,0,rc,sizeof(msg),msg);
               if (rc == ERR_NOIMP)
                  {
                  sprintf(buffer,"Warning %d importing %s - %s",rc,p,msg);
                  }
               else
                  {
                  sprintf(buffer,"Error %d importing %s - %s",rc,p,msg);
                  ActivityLogOutput("! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! !");
                  }
               ActivityLogOutput(buffer);
               }
            p = NextListItem(pList);
            if (fAbortTask == TRUE)
               {
               ActivityLogOutput("Operation successfully stopped...");
               break;
               }
            }
         }
      DestroyList(pList);
      }
   return(rc);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int ParseLST(char *szFName,PIPLIST *pList)
{
   register int rc = SUCCESS;
   FILE *fp = NULL;
   char buffer[65];
   char szName[128];

   *pList = CreateList(LT_VARLEN,0);
   if (*pList == NULL)
      {
      rc = ERR_INSUFMEM;
      }
   else
      {
      fp = (FILE *) fopen(szFName,"r+t");
      if (fp == NULL)
         {
         rc = ERR_OPENING;
         }
      else
         {
         while (getline(buffer,sizeof(buffer),fp) != NULL)
            {
            if (strlen(buffer) > 0)
               {
               strcpyc(szName,sizeof(szName),buffer,'-');
               rc = AppendListItem(*pList,szName);
               if (rc != SUCCESS)
                  {
                  rc = ERR_INSUFMEM;
                  break;
                  }
               }
            }
         fclose(fp);
         }

      if (rc != SUCCESS)
         {
         DestroyList(*pList);
         }
      }
   return(rc);
}

/*BEGINHEADER****************************************************************/
/*                                                                          */
/*  Name:         ImportINX                                                 */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*  This function imports a document item                                   */
/*                                                                          */
/*ENDHEADER******************************************************************/

int ImportINX(char *szFName,PUID uidItem)
{
   register int sRC;
   IMPORT_REQUEST ImpReq;
   BOOL bKnownClass = TRUE;
   PSGMAPSTRUCT pMapStruct;
   char szPath[128];

   sRC = ParseINX(szFName,&ImpReq);
   if (sRC == SUCCESS)
      {
      // Do all the other things in here before calling Import()

      /* Image type is OIM_DOCUMENT */
      if (ImpReq.sItemType != OIM_DOCUMENT && ImpReq.sItemType != OIM_FOLDER)
         {
         sRC = LogError(ERR_UNKTYPE,NULL);
         }
      else
         {
         if (ImpReq.ContentClass == 0 && ImpReq.sItemType == OIM_DOCUMENT)
            {
            sRC = LogError(ERR_INVCC,NULL);
            }
         else
            {
            bKnownClass = (ClassToId(ImpReq.szIndexClass,&ImpReq.ClassId) == SUCCESS);
            AddNoteHeader(&ImpReq.pNote);

            if (bKnownClass)
               {
               ImpReq.bAppend = KnownClass.bAppend;
               ImpReq.bDelete = KnownClass.bDelete;
               ImpReq.bRoute  = KnownClass.Destination == DEST_ROUTE;

               strcpy(ImpReq.szWorkBasket,KnownClass.szWorkBasket);
               WBToUID(ImpReq.szWorkBasket,(PUID) ImpReq.uidWorkBasket);

               pMapStruct = FindClassMapEntry(ImpReq.szIndexClass);
               if (pMapStruct != NULL)
                  StgGroupToId(pMapStruct->szStgGroupName,&ImpReq.TargetStgGroup);
               else
                  {
                  LogError(ERR_INVMAP,NULL);
                  StgGroupToId("DEFAULT",&ImpReq.TargetStgGroup);
                  }
               if (KnownClass.bAppend)
                  {
                  AddAttrsToNote(&ImpReq);
                  }
               }
            else
               {
               if (UnknownClass.bAppend)
                  {
                  AddAttrsToNote(&ImpReq);
                  }

               strcpy(ImpReq.szIndexClass,UnknownClass.szBestFitClass);
               ClassToId(ImpReq.szIndexClass,&ImpReq.ClassId);

               ImpReq.bAppend = UnknownClass.bAppend;
               ImpReq.bDelete = UnknownClass.bDelete;
               ImpReq.bRoute  = UnknownClass.Destination == DEST_ROUTE;

               pMapStruct = FindClassMapEntry(UnknownClass.szBestFitClass);
               if (pMapStruct != NULL)
                  StgGroupToId(pMapStruct->szStgGroupName,&ImpReq.TargetStgGroup);
               else
                  {
                  LogError(ERR_INBFC,NULL);
                  StgGroupToId("DEFAULT",&ImpReq.TargetStgGroup);
                  }

               strcpy(ImpReq.szWorkBasket,UnknownClass.szWorkBasket);
               WBToUID(ImpReq.szWorkBasket,(PUID) ImpReq.uidWorkBasket);
               }

            if (sRC == SUCCESS)
               {
               IdToStgGroup(ImpReq.TargetStgGroup,ImpReq.szTargetStgGroup);

               // Get the name and serial of a DASD volume on
               // the DEFAULT storage group

               strcpy(ImpReq.szVolume,szDASDVolName);
               ImpReq.ulVolSer = ulDASDVolSer;

               // Normalize the attributes, that is, if the index class
               // is known but one or more of the user-define attributes
               // are unknown then remove those from the list of attributes.

               NormalizeAttributes(&ImpReq);

//               if (ImpReq.bDelete)
//                  {
//                  CombinePathAndName(szImportPath,szFName,szPath);
//                  AddDeferredDelete(szPath);
//                  }

               if (ImpReq.sItemType == OIM_FOLDER)
                  {
                  sRC = ImportFolder(&ImpReq,uidItem);
                  }
               else if (ImpReq.sItemType == OIM_DOCUMENT)
                  {
                  sRC = ImportDocument(&ImpReq,uidItem);
                  }
               else
                  {
                  sRC = ERR_UNKTYPE;
                  }

               if (sRC != SUCCESS)
                  {
                  LogError(sRC,NULL);
                  }
               else
                  {
                      // Moved by MAB
                  if (ImpReq.bDelete)
                     {
                     CombinePathAndName(szImportPath,szFName,szPath);
                     AddDeferredDelete(szPath);
                     }
                  }
               FreeImportRequest(&ImpReq);
               }
            }
         }
      }
   return(sRC);
}

int ParseINX(char *szFName,PIMPORT_REQUEST pImpReq)
{
   register int rc = SUCCESS;
   register int i, AttrCnt = 0;
   FILE *fp;
   char *pPeriod;
   char szAttrName[65];
   char buffer[256];
   BOOL bInNote = FALSE;
   ATTRIBUTE Attr;

   fp = (FILE *) fopen(szFName,"r+t");
   if (fp == NULL)
      {
      rc = ERR_NOINXFILE;
      }
   else
      {
      memset(pImpReq,0,sizeof(IMPORT_REQUEST));
      while (getline(buffer,sizeof(buffer),fp) != NULL)
         {
         if (pPeriod = strchr(buffer,'.'))
            {
            pPeriod++;
            if (match(buffer,":document."))
               {
               pImpReq->sItemType = OIM_DOCUMENT;
               }
            else if (match(buffer,":folder."))
               {
               pImpReq->sItemType = OIM_FOLDER;
               }
            else if (match(buffer,":attri.") || match(buffer,":attr."))
               {
               if (pImpReq->pAttrs == NULL)
                  {
                  pImpReq->pAttrs = CreateList(LT_FIXEDLEN,sizeof(ATTRIBUTE));
                  }

               i = 0;
               while (*pPeriod != '.' && *pPeriod != '\0' &&
                  i < sizeof(szAttrName))
                  {
                  szAttrName[i++] = *pPeriod++;
                  }
               szAttrName[i] = '\0';
               pPeriod++;           // to skip the second period

               memset(&Attr,0,sizeof(Attr));

               strcpy(Attr.szAttrName,szAttrName);
               Attr.pData = malloc(strlen(pPeriod)+1);
               strcpy(Attr.pData,pPeriod);
               AttrToId(szAttrName,&Attr.idAttr);
               AppendListItem(pImpReq->pAttrs,(char *) &Attr);
               }
            else if (match(buffer,":attrcnt."))
               {
               AttrCnt = atoi(pPeriod);
               }
               //else if (match(buffer,":stggroup."))
               //   {
               //   strcpy(pImpReq->szStgGroup,pPeriod);
               //   StgGroupToId(pPeriod,&pImpReq->StgGroup);
               //   }
               //else if (match(buffer,":volume."))
               //   {
               //   strcpy(pImpReq->szVolume,pPeriod);
               //   }
               //else if (match(buffer,":workbasket."))
               //   {
               //   strcpy(pImpReq->szWorkBasket,pPeriod);
               //   WBToUID(pPeriod,(PUID) pImpReq->uidWorkBasket);
               //   }
            else if (match(buffer,":class."))
               {
               strcpy(pImpReq->szIndexClass,pPeriod);
               ClassToId(pPeriod,&pImpReq->ClassId);
               }
            else if (match(buffer,":note."))
               {
               pImpReq->pNote = CreateList(LT_VARLEN,0);
               if (strlen(pPeriod) > 0)
                  AppendListItem(pImpReq->pNote,pPeriod);
               bInNote = TRUE;
               }
            else if (match(buffer,":line."))
               {
               if (bInNote)
                  {
                  AppendListItem(pImpReq->pNote,pPeriod);
                  }
               }
            else if (match(buffer,":enote."))
               {
               bInNote = FALSE;
               }
            else if (match(buffer,":image."))
               {
               strcpy(pImpReq->szImageFile,pPeriod);
               if ((pPeriod = strchr(pImpReq->szImageFile,'.')) != NULL)
                  {
                  ExtensionToCC(pPeriod,&pImpReq->ContentClass);
                  }
               }
            else if (match(buffer,":edoc."))
               {
               break;
               }
            else if (match(buffer,":efolder."))
               {
               break;
               }
            else if (match(buffer,":folderitem."))
               {
               if (pImpReq->pFolderItems == NULL)
                  {
                  pImpReq->pFolderItems = CreateList(LT_VARLEN,0);
                  }
               AppendListItem(pImpReq->pFolderItems,pPeriod);
               }
            }
         }
      fclose(fp);
      }
   return(rc);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int ImportDocument(PIMPORT_REQUEST pImpReq,PUID uidItem)
{
   register int sRC;
   ULONG ulNumPages;
   RCSTRUCT RC;
   HOBJ hNote = NULL;
   HOBJ hObj = NULL;
   PATTRLISTSTRUCT pAttribList;
   char szPath[128];
   USHORT cAttrs;
   POBJINFOSTRUCT pObjInfo;

   memset(&RC,0,sizeof(RC));
   CombinePathAndName(szImportPath,pImpReq->szImageFile,szPath);
   sRC = DosCopy(szPath,szImportTempName,DCPY_EXISTING,0L);
   if (sRC != SUCCESS)
      {
      sRC = LogError(ERR_CPYIMP,NULL);
      }
   else
      {

//      if (pImpReq->bDelete)
//         {
//         AddDeferredDelete(szPath);
//         }

      sRC = IpsCatalogClsObj(
               pImpReq->ContentClass,        // Content class identifier retrieved
               szDASDVolName,                // Volume name
               ulDASDVolSer,                 // Volume serial number
               usDASDStgGroup,               // Storage group identifier
               szImportTempName,             // pszFileName - Name of the file
               NULL,                         // NULL pszFileId
               TRUE,                         // fManage
               OM_NORMAL_PRIORITY,           // Normal cmdPriority
               NULL,                         // NULL hsemAbort
               FALSE,                        // Leave object open
               &ulNumPages,                  // Number of pages in the object
               IPS_OPT_SYNC,                 // Synchronous call with semaphore
               NULL,                         // hSync - semaphore handle
               0,                            // usMsgId
               &RC);                         // Return code structure

      if (sRC != SUCCESS)
         {
         sRC = LogError(ERR_CATOBJ,NULL);
         }
      else
         {

         hObj = (HOBJ) RC.ulParam;
         if (pImpReq->pNote != NULL)
            {
            sRC = CreateNote(pImpReq,&hNote);
            if (sRC != SUCCESS)
               {
               LogError(sRC,NULL);
               }
            }
         }

      if (sRC == SUCCESS)
         {
         AssembleAttributes(hObj,hNote,pImpReq,&cAttrs,&pAttribList);

         sRC = OimCreateItem(             // Create the requested OIM item
                  pImpReq->sItemType,     // Type of item to create
                  pImpReq->ClassId,       // Index class of item
                  cAttrs,                 // Number of attributes
                  pAttribList,            // Attribute list
                  IPS_OPT_SYNC,           // Perform function synchronously
                  NULL,                   // No semaphore to synchronize
                  0,                      // No message to synchronize
                  &RC);                   // Pointer to return structure

         DosFreeSeg(SELECTOROF(pAttribList));

         if (sRC != SUCCESS)
            {
            sRC = LogError(ERR_CRITEM,NULL);
            }
         else
            {
            // Add document to workbasket
            memcpy(uidItem,(PUID) RC.ulParam,sizeof(UID));
            if (pImpReq->bRoute)
               {
               sRC = OimAddWorkBasketItem(
                        (PUID) pImpReq->uidWorkBasket, // Pointer to the UID of // workbasket
                        (PUID) uidItem,         // Pointer to the UID of item to add
                        1,                      // Priority value
                        TRUE,                   // Ignore the overload condition
                        IPS_OPT_SYNC,           // Process options - synchronous
                        NULL,                   // Window ID for synchronous call
                        0,                      // Window message ID for synchronous call
                        &RC);                   // Return structure
               }

            if (sRC != SUCCESS)
               {
               sRC = LogError(ERR_ADDWB,NULL);
               }
            else
               {
               sRC = IpsQueryObject(hObj,IPS_OPT_SYNC,NULL,0,&RC);
               if (sRC != SUCCESS)
                  {
                  sRC = LogError(ERR_QRYOBJ,NULL);
                  }
               else
                  {
                  pObjInfo = (POBJINFOSTRUCT) RC.ulParam;
                  if (pObjInfo->usStgGroup != pImpReq->TargetStgGroup)
                     {
                     IpsChangeObjectStgGroup(hObj,NULL,0,0,
                        pImpReq->TargetStgGroup,IPS_OPT_SYNC,NULL,0,&RC);
                     }
                  DosFreeSeg(SELECTOROF(pObjInfo));
                  }

                  if (sRC != SUCCESS)
                     {
                     if (pImpReq->bRoute)
                        {
                        OimRemoveWorkBasketItem(
                           (PUID) pImpReq->uidWorkBasket,
                           (PUID) uidItem,// Pointer to the UID of item to add
                           IPS_OPT_SYNC,  // Process options - synchronous
                           NULL,          // Window ID for synchronous call
                           0,             // Window message ID for synchronous call
                           &RC);          // Return structure
                        }
                     }
                     else
                     {
                       // Moved by MAB
                       if (pImpReq->bDelete)
                       {
                         AddDeferredDelete(szPath);
                       }
                     }
//                }
               }

            if (sRC != SUCCESS)
               {
               OimDeleteItem(uidItem,NULL,IPS_OPT_SYNC,NULL,0,&RC);
               }
            }
         }

      if (sRC != SUCCESS)
         {
         if (hNote != NULL)
            {
            IpsDeleteObject(hNote,IPS_OPT_SYNC,NULL,0,&RC);
            }
         if (hObj != NULL)
            {
            IpsDeleteObject(hObj,IPS_OPT_SYNC,NULL,0,&RC);
            }
         }
      }
   return(sRC);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int ImportFolder(PIMPORT_REQUEST pImpReq,PUID uidItem)
{
   register int sRC;
   RCSTRUCT RC;
   HOBJ hNote = NULL;
   HOBJ hObj = NULL;
   PATTRLISTSTRUCT pAttribList;
   USHORT cAttrs;
   char *p;
   char buffer[256];
   char msg[256];

   memset(&RC,0,sizeof(RC));
   if (pImpReq->pNote != NULL)
      {
      sRC = CreateNote(pImpReq,&hNote);
      if (sRC != SUCCESS)
         {
         LogError(sRC,NULL);
         }
      }

   if (sRC == SUCCESS)
      {
      AssembleAttributes(hObj,hNote,pImpReq,&cAttrs,&pAttribList);

      sRC = OimCreateItem(             // Create the requested OIM item
               pImpReq->sItemType,     // Type of item to create
               pImpReq->ClassId,       // Index class of item
               cAttrs,                 // Number of attributes
               pAttribList,            // Attribute list
               IPS_OPT_SYNC,           // Perform function synchronously
               NULL,                   // No semaphore to synchronize
               0,                      // No message to synchronize
               &RC);                   // Pointer to return structure

      DosFreeSeg(SELECTOROF(pAttribList));

      if (sRC != SUCCESS)
         {
         sRC = LogError(ERR_CRITEM,NULL);
         }
      else
         {
         // Add document to workbasket
         memcpy(uidItem,(PUID) RC.ulParam,sizeof(UID));
         if (pImpReq->bRoute)
            {
            sRC = OimAddWorkBasketItem(
                     (PUID) pImpReq->uidWorkBasket, // Pointer to the UID of // workbasket
                     (PUID) uidItem,         // Pointer to the UID of item to add
                     1,                      // Priority value
                     TRUE,                   // Ignore the overload condition
                     IPS_OPT_SYNC,           // Process options - synchronous
                     NULL,                   // Window ID for synchronous call
                     0,                      // Window message ID for synchronous call
                     &RC);                   // Return structure

            if (sRC != SUCCESS)
               {
               sRC = LogError(ERR_ADDWB,NULL);
               }
            }

         if (sRC == SUCCESS)
            {
            if (QueryListCount(pImpReq->pFolderItems) > 0)
               {
               UID uidTempItem;

               p = TopListItem(pImpReq->pFolderItems);
               while (p != NULL)
                  {
                  sRC = ImportItem(p,(PUID) uidTempItem);
                  if (sRC != SUCCESS && sRC != ERR_NOIMP)
                     {
                     LogError(sRC,NULL);
                     WinLoadString(hAB,0,sRC,sizeof(msg),msg);
                     sprintf(buffer,"Error %d importing %s - %s",sRC,p,msg);
                     ActivityLogOutput("! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! !");
                     ActivityLogOutput(buffer);
                     sRC = SUCCESS;
                     }
                  else
                     {
                     if (sRC != ERR_NOIMP)
                        {
                        sRC = OimAddFolderItem((PUID) uidItem,
                                 (PUID) uidTempItem,IPS_OPT_SYNC,NULL,0,&RC);
                        if (sRC != SUCCESS)
                           {
                           sRC = LogError(ERR_ADDFLDR,NULL);
                           }
                        }
                     else
                        {
                        WinLoadString(hAB,0,sRC,sizeof(msg),msg);
                        sprintf(buffer,"Warning %d importing %s - %s",sRC,p,msg);
                        ActivityLogOutput(buffer);
                        }
                     }
                  p = NextListItem(pImpReq->pFolderItems);
                  if (fAbortTask == TRUE)
                     {
                     ActivityLogOutput("Operation successfully stopped...");
                     break;
                     }
                  }
               }

            if (sRC != SUCCESS)
               {
               if (pImpReq->bRoute)
                  {
                  OimRemoveWorkBasketItem(
                     (PUID) pImpReq->uidWorkBasket,
                     (PUID) uidItem,   // Pointer to the UID of item to add
                     IPS_OPT_SYNC,     // Process options - synchronous
                     NULL,             // Window ID for synchronous call
                     0,                // Window message ID for synchronous call
                     &RC);             // Return structure
                  }
               }
            }

         if (sRC != SUCCESS)
            {
            OimDeleteItem(uidItem,NULL,IPS_OPT_SYNC,NULL,0,&RC);
            }
         }

      if (sRC != SUCCESS)
         {
         if (hNote != NULL)
            {
            IpsDeleteObject(hNote,IPS_OPT_SYNC,NULL,0,&RC);
            }
         }
      }
   return(sRC);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void AssembleAttributes(
      HOBJ hObj,
      HOBJ hNote,
      PIMPORT_REQUEST pImpReq,
      PUSHORT cAttrs,
      PATTRLISTSTRUCT *pAttribList)
{
   register int i;
   USHORT usSpace = 0;
   char szhNote[12];
   char szhObj[12];
   SEL sel;
   int sRC;
   char *p;
   PATTRLISTSTRUCT pAttrs;
   PATTRIBUTE pAttr;

   *cAttrs = 0;
   *pAttribList = NULL;

   if (hNote != NULL)
      {
      ltoa((ULONG) hNote,szhNote,10);  // Convert to system attribute format
      usSpace += strlen(szhNote) + 1;  // Increase space required for buffer
      (*cAttrs)++;
      }

   if (hObj != NULL)
      {
      ltoa((ULONG) hObj,szhObj,10);    // Convert to system attribute format
      usSpace += strlen(szhObj) + 1;   // Increase space required for buffer
      (*cAttrs)++;
      }

   pAttr = (PATTRIBUTE) TopListItem(pImpReq->pAttrs);
   while (pAttr != NULL)
      {
      usSpace += strlen(pAttr->pData)+1;
      (*cAttrs)++;
      pAttr = (PATTRIBUTE) NextListItem(pImpReq->pAttrs);
      }

   usSpace += (*cAttrs * sizeof(ATTRLISTSTRUCT));

   sRC = DosAllocSeg(                  // Allocate buffer for attributes
            usSpace,                   // Space calculated above
            &sel,                      // Return selector here
            SEG_NONSHARED);            // Do not share this segment

   if (sRC == SUCCESS)
      {
      pAttrs = (PATTRLISTSTRUCT) MAKEP(sel,0);
      *pAttribList = pAttrs;
      p = (char *) &pAttrs[*cAttrs];

      i = 0;
      if (hObj != NULL)
         {
         pAttrs[i].idAttribute = OIM_HIMAGE_ID;
         strcpy(p,szhObj);
         pAttrs[i].pszAttributeValue = p;
         p += strlen(szhObj) + 1;
         i++;
         }
      if (hNote != NULL)
         {
         pAttrs[i].idAttribute = OIM_HNOTE_ID;
         strcpy(p,szhNote);
         pAttrs[i].pszAttributeValue = p;
         p += strlen(szhNote) + 1;
         i++;
         }

      pAttr = (PATTRIBUTE) TopListItem(pImpReq->pAttrs);
      while (pAttr != NULL)
         {
         pAttrs[i].idAttribute = pAttr->idAttr;
         strcpy(p,pAttr->pData);
         pAttrs[i].pszAttributeValue = p;
         p += strlen(pAttr->pData) + 1;
         i++;
         pAttr = (PATTRIBUTE) NextListItem(pImpReq->pAttrs);
         }
      }
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int FreeImportRequest(PIMPORT_REQUEST pImpReq)
{
   register int rc = SUCCESS;
   PATTRIBUTE pAttr;

   if (pImpReq->pAttrs != NULL)
      {
      pAttr = (PATTRIBUTE) TopListItem(pImpReq->pAttrs);
      while (pAttr != NULL)
         {
         if (pAttr->pData != NULL)
            {
            free(pAttr->pData);
            }
         pAttr = (PATTRIBUTE) NextListItem(pImpReq->pAttrs);
         }
      DestroyList(pImpReq->pAttrs);
      pImpReq->pAttrs = NULL;
      }

   if (pImpReq->pNote != NULL)
      {
      DestroyList(pImpReq->pNote);
      pImpReq->pNote = NULL;
      }

   if (pImpReq->pFolderItems != NULL)
      {
      DestroyList(pImpReq->pFolderItems);
      pImpReq->pFolderItems = NULL;
      }
   return(rc);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int CreateNote(PIMPORT_REQUEST pImpReq,HOBJ *hNote)
{
   register int sRC = SUCCESS, len;
   char chDASD, *p;
   HOBJACC hObjAcc;
   char buffer[128];
   ULONG ulBytesWritten;
   RCSTRUCT RC;
   POBJINFOSTRUCT pObjInfo;

   if (pImpReq->pNote == NULL)
      {
      return(sRC);
      }

   sRC = GetDASDId(&chDASD);
   if (sRC != SUCCESS)
      {
      sRC = LogError(sRC,NULL);
      }
   else
      {
      memset(&RC,0,sizeof(RC));
      sRC = IpsCreateObject(           // Create OMS object
               0,                      // No content class for notes
               NULL,                   // No volume used in this release (1.0)
               0L,                     // No volume serial number used
               chDASD,                 // Use default storage class
               usDASDStgGroup,         // Use default storage group
               NULL,                   // No user-defined file identifier (EA)
               OM_NORMAL_PRIORITY,     // We are in no hurry at this point
               NULL,                   // Bypass signaling mechanism
               TRUE,                   // Leave the object open for WRITE access
               IPS_OPT_SYNC,           // Perform function synchronously
               NULL,                   // No semaphore to synchronize
               0,                      // No message to synchronize
               &RC);                   // Pointer to return structure

      if (sRC != SUCCESS)
         {
         sRC = LogError(ERR_CREATNOTE,NULL);
         }
      else
         {
         *hNote = (HOBJ) RC.ulParam;    // Object handle returned in ulParam
         hObjAcc = (HOBJACC) RC.usParam;// Access handle returned in usParam

         p = TopListItem(pImpReq->pNote);
         do
            {
            strcpy(buffer,p);
            strcat(buffer,"\n");
            len = strlen(buffer);

            sRC = IpsWriteObject(      // Write text to object just created
                     hObjAcc,          // Access handle of object to write to
                     buffer,           // Buffer containing data to be written
                     (ULONG) len,      // Number of bytes to write to object
                     &ulBytesWritten,  // Number of bytes actually written
                     IPS_OPT_SYNC,     // Perform function synchronously
                     NULL,             // No semaphore to synchronize
                     0,                // No message to synchronize
                     &RC);             // Pointer to return structure

            if (sRC != SUCCESS)
               {
               sRC = LogError(ERR_WRNOTE,NULL);
               break;
               }
            p = (char *) NextListItem(pImpReq->pNote);
            }
         while (p != NULL);

         sRC = IpsCloseObject(          // Close the note object
                  hObjAcc,             // Access handle of object
                  TRUE,                // Commit changes to this file
                  IPS_OPT_SYNC,        // Perform function synchronously
                  NULL,                // No semaphore to synchronize
                  0,                   // No message to synchronize
                  &RC);                // Pointer to return structure

         if (sRC != SUCCESS)
            {
            sRC = LogError(ERR_CMTNOTE,NULL);
            }
         else
            {
            sRC = IpsQueryObject(*hNote,IPS_OPT_SYNC,NULL,0,&RC);
            if (sRC != SUCCESS)
               {
               sRC = LogError(ERR_QRYOBJ,NULL);
               }
            else
               {
               pObjInfo = (POBJINFOSTRUCT) RC.ulParam;
               if (pObjInfo->usStgGroup != pImpReq->TargetStgGroup)
                  {
                  IpsChangeObjectStgGroup(*hNote,NULL,0,0,
                     pImpReq->TargetStgGroup,IPS_OPT_SYNC,NULL,0,&RC);
                  }
               DosFreeSeg(SELECTOROF(pObjInfo));
               }
            }

         if (sRC != SUCCESS)
            {
            if (*hNote != NULL)
               {
               IpsDeleteObject(*hNote,IPS_OPT_SYNC,NULL,0,&RC);
               }
            }
         }
      }
   return(sRC);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void AddNoteHeader(PIPLIST *pNote)
{
   char buffer[65];

   if (bAutoNote)
      {
      if (*pNote == NULL)
         {
         *pNote = CreateList(LT_VARLEN,0);
         }

      if (*pNote != NULL)
         {
         ComposeDateAndTime(buffer);
         AppendListItem(*pNote,"*****************************");
         AppendListItem(*pNote,buffer);
         AppendListItem(*pNote,"*****************************");
         AppendListItem(*pNote,"Imported into ImagePlus/2...");
         }
      }

   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void AddAttrsToNote(PIMPORT_REQUEST pImpReq)
{
   char buffer[256], *p;
   PATTRIBUTE pAttr;

   if (pImpReq->pNote == NULL)
      {
//      if (bAutoNote)
//         {
         pImpReq->pNote = CreateList(LT_VARLEN,0);
//         }
//      else
//         {
//         return;
//         }
      }

   if (!bAutoNote)
      {
      ComposeDateAndTime(buffer);
      AppendListItem(pImpReq->pNote,"*****************************");
      AppendListItem(pImpReq->pNote,buffer);
      AppendListItem(pImpReq->pNote,"*****************************");
      }
   if (pImpReq->pAttrs == NULL)
      {
      AppendListItem(pImpReq->pNote,"No attributes associated with this item.");
      }
   else
      {
      AppendListItem(pImpReq->pNote,"Index class:");
      sprintf(buffer,"    %s",pImpReq->szIndexClass);
      AppendListItem(pImpReq->pNote,buffer);

      AppendListItem(pImpReq->pNote,"Attributes:");

      pAttr = (PATTRIBUTE) TopListItem(pImpReq->pAttrs);
      while (pAttr != NULL)
         {
         p = pAttr->pData;
         sprintf(buffer,"    %s = %s",pAttr->szAttrName,p == NULL ? "" : p);
         AppendListItem(pImpReq->pNote,buffer);
         pAttr = (PATTRIBUTE) NextListItem(pImpReq->pAttrs);
         }
      AppendListItem(pImpReq->pNote," ");
      }
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void NormalizeAttributes(PIMPORT_REQUEST pImpReq)
{
   USHORT idClass;
   BOOL bFound;
   PATTRIBUTE pAttr;
   register int i;
   register int n = AttrTable.sAttrs;
   register int len;

   if (ClassToId(pImpReq->szIndexClass,&idClass) == SUCCESS)
      {
      pAttr = (PATTRIBUTE) TopListItem(pImpReq->pAttrs);
      while (pAttr != NULL)
         {
         bFound = IsAttrInClass(idClass,pAttr->idAttr);
         if (!bFound)
            {
            DeleteCurrListItem(pImpReq->pAttrs);
            }
         else
            {
            if (pAttr->pData != NULL)
               {
               for (i = 0; i < n; i++)
                  {
                  if (pAttr->idAttr == AttrTable.pAttrs[i].usId)
                     {
                     len = strlen(pAttr->pData);
                     if ((USHORT) len > AttrTable.pAttrs[i].Info.usMaxLength)
                        {
                        pAttr->pData[AttrTable.pAttrs[i].Info.usMaxLength-1] = '\0';
                        }
                     }
                  }
               }
            }
         pAttr = (PATTRIBUTE) NextListItem(pImpReq->pAttrs);
         }
      }
   return;
}
