/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

/*BEGINPROLOGUE**************************************************************/
/*                                                                          */
/*   Module Name:              GLOBALS.H                                    */
/*                                                                          */
/*   Descriptive Name:         This module contains all global symbol       */
/*                             definitions.                                 */
/*                                                                          */
/*   Status:                   Release 1, Level 0                           */
/*                                                                          */
/*   Function:                 Same as Descriptive name                     */
/*                                                                          */
/*   Dependencies:             IBM OS/2 Extended Edition 1.3.01             */
/*                                                                          */
/*ENDPROLOGUE****************************************************************/


#ifdef ALLOCATE
   #define INIT(x) =x
   #define GLOBAL
#else
   #define INIT(x)
   #define GLOBAL extern
#endif

GLOBAL CHAR szAppName[20];             // class name of application

GLOBAL HAB  hAB INIT(NULL);            // Handle to the Anchor Block
GLOBAL HMQ  hMQ INIT(NULL);            // Handle to the Message Queue

GLOBAL HWND hWndFrame INIT(NULL);      // Handle to the Window Frame
GLOBAL HWND hWndClient INIT(NULL);     // Handle to the Client Window
GLOBAL HWND hWndList INIT(NULL);       // Handle to activity log list box
GLOBAL HWND hWndTitle INIT(NULL);      // Handle to progress list box
GLOBAL HWND hProgressDlg INIT(NULL);   // Handle to in-progress window

GLOBAL char szDefFile[128];            // File that stores default settings
GLOBAL char szSGMapListFile[128];      // File that stores class/sg map
GLOBAL char szAppPath[128];            // Path where IP2IMPEX.EXE resides
GLOBAL char szImportTempName[65];      // Path to temp file for import
GLOBAL char szImportPath[65];          // Import path
GLOBAL char szExportPath[65];          // Export path
GLOBAL char szIPImportLog[65];         // IP2IMPEX log file

GLOBAL BOOL bOimLogon INIT(FALSE);     // TRUE if OimLogon worked!
GLOBAL KNOWNCLS_CRITERIA KnownClass;   // Criteria for items with known class
GLOBAL UNKNOWNCLS_CRITERIA UnknownClass;// Criteria for items with unknown class
GLOBAL EXPORT_DEFAULTS ExportDefaults; // Criteria for exporting items
GLOBAL char szDefWorkBasket[33];       // Default workbasket to export from

GLOBAL CLASSTBLSTRUCT ClsTable;        // Global index class structure table
GLOBAL ATTRTBLSTRUCT AttrTable;        // Global attributes structure table
GLOBAL WBTBLSTRUCT WBTable;            // Global workbaskets structure table
GLOBAL POBJCLSSTRUCT pConClasses;      // Pointer to OBJCLSSTRUCT (cont cls)
GLOBAL PIPLIST pDeleteList INIT(NULL); // Pointer to list of deferred deletions
GLOBAL SGLISTSTRUCT SGList;            // Pointer to list of storage groups
GLOBAL PIPLIST pSGMapList INIT(NULL);  // Pointer to class / stg group map list
GLOBAL CHAR szDriveLetters[26];        // Array of possible drive letters
GLOBAL PIPLIST pStgClassList;          // List of storage classes

GLOBAL PIPLIST pImportItems INIT(NULL);// List of filenames to import
GLOBAL PIPLIST pExportItems INIT(NULL);// List of UIDs to export
GLOBAL usItemsCount INIT(0);           // Number of filenames in above list

GLOBAL HMODULE hModule INIT(0);        // Module handle for DosLoadModule
GLOBAL HMODULE hRCMod INIT(0);         // Module handle for resources
GLOBAL PFNWP pExportSetupDlgProc INIT(NULL); // Ptr to export dialog proc
GLOBAL USEREXIT pExportItemsUserExit INIT(NULL);// Ptr to export items user exit

GLOBAL char szDASDVolName[13];         // Name of DASD volume attached to DEFAULT
GLOBAL ULONG ulDASDVolSer INIT(0);     // Serial number of above volume
GLOBAL USHORT usDASDStgGroup;          // The Default storage group

GLOBAL UID uidExportWb;                // The WorkBasket being exported
GLOBAL SEL selImpStack INIT(0);        // Selector of import thread stack
GLOBAL fAbortTask INIT(FALSE);         // Abort flag for import/export tasks
GLOBAL IMPORT_FILES ImportFiles;       // Structure with extension to import

GLOBAL BOOL bTaskInProgress INIT(0);   // Not to allow exit while import/export
GLOBAL BOOL bAutoNote INIT(TRUE);      // 'Auto-noting' enabled by default
