
/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

/*BEGINPROLOGUE**************************************************************/
/*                                                                          */
/*   Module Name:              EXPORT.C                                     */
/*                                                                          */
/*   Descriptive Name:         This module contains all the functions       */
/*                             needed to perform the export of items from   */
/*                             the specified workbasket.                    */
/*                                                                          */
/*   Status:                   Release 1, Level 0                           */
/*                                                                          */
/*   Dependencies:             IBM OS/2 Extended Edition 1.30.1             */
/*                                                                          */
/*ENDPROLOGUE****************************************************************/
#define INCL_DOS
#define INCL_DOSMODULEMGR
#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#define INCL_DOSMISC
#define INCL_DOSMEMMGR
#define INCL_GPIBITMAPS
#define INCL_WIN
#define INCL_PM
#include <os2.h>

#include <stdio.h>                     // Standard C standard input/output
#include <stdlib.h>                    // Standard C library header
#include <string.h>                    // Standard C string header
#include <ctype.h>                     // Contains standard macros and symbols

#define IPS_SDS_INCL                   // To include Spool Device Services
#define IPS_IMG_INCL                   // To include Image Services
#define IPS_PAG_INCL                   // To include Page Services
#define IPS_DSP_INCL                   // To include Display Services
#define IPS_OMS_INCL                   // To include Object Management System
#define IPS_OAS_INCL                   // To include Object Access Services
#include <ips.h>

#include "ip2impex.h"                  // Includes prototypes and Masthead
#include "dialog.h"                    // Contains defines used in dialog boxes
#include "globals.h"                   // Contains our global variables
#include "error.h"                     // Contains error definitions


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

SHORT EXPENTRY ExportItems(USHORT usUidCount,PUID puidList)
{
   FILE *fp;
   char szPath[65], *p;
   char szExpName[33];
   int itemType;
   register int sRC = SUCCESS;
   register int i;
   RCSTRUCT RC;
   PSNAPSHOTSTRUCT pItemSnapshot;
   char buffer[256];
   char parm[256];
   char szCIF[256];
   char msg[256];
   char szUID[sizeof(UID)+1];

   fAbortTask = FALSE;
   memset(&RC,0,sizeof(RC));
   CombinePathAndName(szExportPath,ExportDefaults.szFName,szPath);
   EnforceExtension(szPath,".LST");
   fp = (FILE *) fopen(szPath,"a+t");
   if (fp == NULL)
      {
      sRC = LogError(ERR_OPNLST,NULL);
      }
   else
      {
      for (i = 0; i < (int) usUidCount; i++)
         {
         ActivityLogOutput("Exporting item...");
         sRC = ExportItem((PUID) puidList[i],szExpName,&itemType);
         if (sRC != SUCCESS)
            {
            ActivityLogOutput("! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! !");
            WinLoadString(hAB,hRCMod,sRC,sizeof(msg),msg);
            memcpy(szUID,puidList[i],sizeof(UID));
            szUID[sizeof(UID)] = '\0';
            sprintf(buffer,"Error %d exporting item %s - %s",sRC,szUID,msg);
            ActivityLogOutput(buffer);
            LogError(sRC,NULL);
            DosDelete(szExpName,0L);
            }
         else
            {
            p = strrchr(szExpName,'\\');
            fprintf(fp,"%s-%s\n",(p+1),
               itemType == OIM_DOCUMENT ? "DOCUMENT" : "FOLDER");
            sprintf(buffer,"Successfully exported item to file %s",(p+1));
            ActivityLogOutput(buffer);

            if (ExportDefaults.Destination == DEST_DELETE)
               {
               sRC = OimDeleteItem((PUID) puidList[i],NULL,IPS_OPT_SYNC,NULL,0,&RC);
               if (sRC != SUCCESS)
                  {
                  sRC = LogError(ERR_DELITM,NULL);
                  }
               }
            else if (ExportDefaults.Destination == DEST_FILEROOM)
               {
               sRC = OimItemSnapshot((PUID) puidList[i],OIM_SYSTEM_ATTR | OIM_PRIORITY_ATTR,
                        IPS_OPT_SYNC,NULL,0,&RC);
               if (sRC != SUCCESS)
                  {
                  sRC = LogError(ERR_SNAPSHOT,NULL);
                  }
               else
                  {
                  pItemSnapshot = (PSNAPSHOTSTRUCT) RC.ulParam;

                  if (pItemSnapshot->usWorkFlowID != 0)
                     {
                     sRC = OimRemoveFromWorkFlow(
                              (PUID) puidList[i],
                              IPS_OPT_SYNC,NULL,0,&RC);
                     }

                  if (pItemSnapshot->uidWorkBasket[0] != '\0')
                     {
                     sRC = OimRemoveWorkBasketItem(
                              (PUID) pItemSnapshot->uidWorkBasket,
                              (PUID) puidList[i],
                              IPS_OPT_SYNC,NULL,0,&RC);
                     }
                  }
               }
            }
         if (fAbortTask == TRUE)
            {
            ActivityLogOutput("Operation successfully stopped...");
            break;
            }
         }
      fclose(fp);
      if (sRC != SUCCESS)
         {
         DosDelete(szPath,0L);
         }
      else
         {
            if(ExportDefaults.bCIF!=0)
              {
                 strcpy(szCIF,szPath);
                 EnforceExtension(szCIF,".CIF");
                 sprintf(parm,"buildcif %s %s > %sbuildcif.log",szPath,szCIF,szAppPath);
                 system(parm);
                 sprintf(buffer,"Successfully exported %s to file %s",szPath,szCIF);
                 ActivityLogOutput(buffer);
              }
         }
      }
   return(sRC);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

SHORT EXPENTRY ExportItem(PUID uidItem,char *szExpName,int *itemType)
{
   register int i, sRC;
   PSNAPSHOTSTRUCT pItemSnapshot;
   FILE *fp;
   HOBJ hObj;
   ULONG ulVolSer;
   RCSTRUCT RC;
   char buffer[256], *p;
   char szVolName[15];
   HTOC hTOC;
   USHORT usTOCEntries;
   PTOCENTRYSTRUCT pTOC;
   POBJINFOSTRUCT pObjInfo;
   USHORT usStgGroup;
   char szExt[5];
   char msg[256];
   char szUID[sizeof(UID)+1];


   sRC = OimItemSnapshot((PUID) uidItem,OIM_SYSTEM_ATTR | OIM_USER_ATTR,
            IPS_OPT_SYNC,NULL,0,&RC);
   if (sRC != SUCCESS)
      {
      sRC = LogError(ERR_SNAPSHOT,NULL);
      }
   else
      {
      pItemSnapshot = (PSNAPSHOTSTRUCT) RC.ulParam;
      *itemType = pItemSnapshot->usItemType;

      sRC = GetExportName(szExpName,uidItem);

      fp = (FILE *) fopen(szExpName,"w+t");
      if (fp == NULL)
         {
         sRC = LogError(ERR_CRINX,NULL);
         }
      else
         {
         if (*itemType == OIM_DOCUMENT)
            fprintf(fp,":document.\n");
         else
            fprintf(fp,":folder.\n");

         IdToClass(pItemSnapshot->usIndexClass,buffer);
         fprintf(fp,":class.%s\n",buffer);

         if (pItemSnapshot->usNumAttributes > 0)
            {
            fprintf(fp,":attrcnt.%d\n",pItemSnapshot->usNumAttributes);
            for (i = 0; (USHORT) i < pItemSnapshot->usNumAttributes; i++)
               {
               IdToAttr(pItemSnapshot->aAttributes[i].usAttrId,buffer);
               p = pItemSnapshot->aAttributes[i].pszAttrValue;
               if (IsClsAttrIndex(pItemSnapshot->usIndexClass,
                     pItemSnapshot->aAttributes[i].usAttrId))
                  {
                  fprintf(fp,":attri.%s.%s\n",buffer,p == NULL ? "" : p);
                  }
               else
                  {
                  fprintf(fp,":attr.%s.%s\n",buffer,p == NULL ? "" : p);
                  }
               }
            }

         //if (pItemSnapshot->ulOMNote != 0L)
         //   {
            sRC = OutputNote(fp,pItemSnapshot);
         //   }

         if (*itemType == OIM_FOLDER)
            {
            if (ExportDefaults.bFolder)
               {
               sRC = OimGetTOC(              // Get folder's tabel of contents
                        (PUID) uidItem,      // UID of this folder
                        OIM_ALL,             // Include all documents and folders
                        OIM_ALL,             // Include all WIP items
                        OIM_ALL,             // Include all items whether suspended
                        0,                   // No index classes provided
                        NULL,                // No list of class ids
                        &hTOC,               // Ptr to handle to TOC
                        NULL,                // No abort semaphore provided
                        IPS_OPT_SYNC,        // Perform function synchronously
                        NULL,                // No semaphore to synchronize
                        0,                   // No message to synchronize
                        &RC);                // Pointer to return structure

               if (sRC != SUCCESS)           // Did we get the table of contents?
                  {
                  sRC = LogError(ERR_GETTOC,NULL);
                  }
               else
                  {
                  usTOCEntries = (USHORT) RC.usParam;
                  pTOC = (PTOCENTRYSTRUCT) RC.ulParam;
                  if (usTOCEntries > 0)
                     {
                     char *szExpName;
                     int itemType;

                     szExpName = malloc(65);
                     if (szExpName != NULL)
                        {
                        for (i = 0; (USHORT) i < usTOCEntries; i++)
                           {
                           sRC = ExportItem((PUID) pTOC[i].uidTOCItem,
                                    szExpName,&itemType);
                           if (sRC != SUCCESS)
                              {
                              ActivityLogOutput("! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! !");
                              WinLoadString(hAB,hRCMod,sRC,sizeof(msg),msg);
                              memcpy(szUID,pTOC[i].uidTOCItem,sizeof(UID));
                              szUID[sizeof(UID)] = '\0';
                              sprintf(buffer,"Error %d exporting item %s - %s",sRC,szUID,msg);
                              ActivityLogOutput(buffer);
                              LogError(sRC,NULL);
                              DosDelete(szExpName,0L);
                              }
                           else
                              {
                              p = strrchr(szExpName,'\\');
                              if (p != NULL)
                                 {
                                 fprintf(fp,":folderitem.%s\n",(p+1));
                                 }
                              }
                           if (fAbortTask == TRUE)
                              {
                              ActivityLogOutput("Operation successfully stopped...");
                              break;
                              }
                           }
                        free(szExpName);
                        }
                     }
                  OimCloseTOC(hTOC,IPS_OPT_SYNC,NULL,0,&RC);
                  }
               }
            }
         else if (*itemType == OIM_DOCUMENT)
            {
            sRC = IpsQueryObject((HOBJ)pItemSnapshot->ulOMImage,
                     IPS_OPT_SYNC,NULL,0,&RC);
            if (sRC != SUCCESS)
               {
               sRC = LogError(ERR_QRYOBJ,NULL);
               }
            else
               {
               pObjInfo = (POBJINFOSTRUCT) RC.ulParam;
               StgGroupToId("DEFAULT",&usStgGroup);
               sRC = IpsCreateClsObj(
                        pObjInfo->idObjConCls,
                        NULL,          // No volume name used
                        0L,            // No volume serial number used
                        1,             // Use default storage class
                        usStgGroup,    // Use default storage group
                        NULL,          // No user-defined file identifier (EA)
                        OM_NORMAL_PRIORITY,// We are in no hurry at this point
                        NULL,          // Bypass signaling mechanism
                        FALSE,         // Leave the object open for WRITE access
                        IPS_OPT_SYNC,  // Perform function synchronously
                        NULL,          // Semaphore to synchronize
                        0,             // No message to synchronize
                        &RC);          // Pointer to return structure

               if (sRC != SUCCESS)
                  {
                  sRC = LogError(ERR_CROBJ,NULL);
                  }
               else
                  {
                  hObj = (HOBJ) RC.ulParam;
                  sRC = IpsCopyObject(
                           hObj,       // Destination object
                           (HOBJ) pItemSnapshot->ulOMImage,
                           OM_NORMAL_PRIORITY,// Priority of this request
                           NULL,       // Allows calling routine to abort
                           FALSE,      // Do not delete original
                           IPS_OPT_ASYNC,// Process options
                           NULL,       // Window or semaphore ID
                           0,          // Window message ID
                           &RC);       // Return code structure

                  sRC = WaitAndYield(&RC);
                  if (sRC != SUCCESS)
                     {
                     sRC = LogError(ERR_CPYOBJ,NULL);
                     }
                  else
                     {
                     sRC = IpsUncatClsObj(
                              hObj,       // Object handle of object to be uncataloged
                              szVolName,  // Volume name returned by this function
                              &ulVolSer,  // Volume serial number returned
                              NULL,
                              IPS_OPT_ASYNC,
                              NULL,
                              0,           // usMsgId
                              &RC );       // Return code structure

                     sRC = WaitAndYield(&RC);
                     if (sRC != SUCCESS)
                        {
                        sRC = LogError(ERR_UNCAT,NULL);
                        }
                     else
                        {
                        strcpy(buffer,szExpName);
                        CCToExtension(pObjInfo->idObjConCls,szExt);
                        EnforceExtension(buffer,szExt);

                        sRC = CopyObjToExportDir(
                                 (char *) RC.ulParam,
                                 szVolName,
                                 ulVolSer,
                                 buffer);

                        DosFreeSeg(SELECTOROF(RC.ulParam));

                        if (sRC != SUCCESS)
                           {
                           LogError(sRC,NULL);
                           }
                        else
                           {
                           p = strrchr(buffer,'\\');
                           if (p != NULL)
                              {
                              fprintf(fp,":image.%s\n",p+1);
                              }
                           }
                        }
                     }
                  }
               DosFreeSeg(SELECTOROF(pObjInfo));
               }
            }
         if (sRC == SUCCESS)
            {
            if (*itemType == OIM_DOCUMENT)
               fputs(":edoc.\n",fp);
            else
               fputs(":efolder.\n",fp);
            }
         fclose(fp);          // Close export file
         }
      DosFreeSeg(SELECTOROF(pItemSnapshot));
      }
   return(sRC);                         // Return code to caller
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int OutputNote(FILE *fp,PSNAPSHOTSTRUCT pItem)
{
   register int sRC = SUCCESS, i;
   RCSTRUCT RC;
   HOBJACC hObjAcc;
   POBJINFOSTRUCT pObjInfo;
   char *pNoteData = NULL;
   ULONG ulBytesRead;
   HOBJ hObj;
   char buffer[65];

   hObj = (HOBJ) pItem->ulOMNote;
   memset(&RC,0,sizeof(RC));

   if (hObj == NULL)
      {
         if(bAutoNote)
         {
           fputs(":note.\n",fp);
           ComposeDateAndTime(buffer);
           fputs(":line.*****************************\n",fp);
           fprintf(fp,":line.%s\n",buffer);
           fputs(":line.*****************************\n",fp);
           fputs(":line.Exported from ImagePlus/2...\n",fp);
           fputs(":enote.\n",fp);
         }
      return(sRC);
      }

   fputs(":note.\n",fp);

   if (hObj != NULL)
      {
      sRC = IpsOpenObject(hObj,        // Object handle
               OM_SHARED_READ,         // Object access mode
               OM_RUSH_PRIORITY,       // Calling routine priority
               FALSE,                  // fConflict
               FALSE,                  // fDownload
               NULL,                   // Allows calling routine to abort
               IPS_OPT_SYNC,           // Process options
               NULL,                   // Semaphore or window ID
               0,                      // Window message ID
               &RC);                   // Return code structure

      if (sRC != SUCCESS)
         {
         sRC = LogError(ERR_OPNNOTE,NULL);
         }
      else
         {
         hObjAcc = RC.usParam;
         sRC = IpsQueryObject(hObj,IPS_OPT_SYNC,NULL,0,&RC);
         if (sRC != SUCCESS)
            {
            sRC = LogError(ERR_QRYOBJ,NULL);
            }
         else
            {
            pObjInfo = (POBJINFOSTRUCT) RC.ulParam;
            pNoteData = malloc((USHORT) pObjInfo->cbObjSize);
            if (pNoteData != NULL)
               {
               sRC = IpsReadObject(hObjAcc,pNoteData,pObjInfo->cbObjSize,
                        &ulBytesRead,IPS_OPT_SYNC,NULL,0,&RC);
               if (sRC != SUCCESS)
                  {
                  sRC = LogError(ERR_READOBJ,NULL);
                  }
               else
                  {
                  fputs(":line.",fp);
                  for (i = 0; (USHORT) i < (USHORT) ulBytesRead; i++)
                     {
                     if (pNoteData[i] != '\r')
                        {
                        fputc(pNoteData[i],fp);
                        if (pNoteData[i] == '\n')
                           {
                           fputs(":line.",fp);
                           }
                        }
                     }
                  if (pNoteData[i] != '\n')
                     {
                     fputc('\n',fp);
                     }
                  }
               free(pNoteData);
               }
            DosFreeSeg(SELECTOROF(pObjInfo));
            }
         IpsCloseObject(hObjAcc,FALSE,IPS_OPT_SYNC,NULL,0,&RC);
         }
      }

   if (bAutoNote)
      {
      ComposeDateAndTime(buffer);
      fputs(":line.*****************************\n",fp);
      fprintf(fp,":line.%s\n",buffer);
      fputs(":line.*****************************\n",fp);
      fputs(":line.Exported from ImagePlus/2...\n",fp);
      }
   fputs(":enote.\n",fp);

   return(sRC);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:  This function takes for input a Full src path that may    */
/*                consist of a network path spec or a 'driveless' directory */
/*                path.  It also takes a volume name and a serial number.   */
/*                If the FullSrc is network then simply assemble the output */
/*                filename and copy the files.  If the FullSrc consists of  */
/*                a 'driveless' directory path, then we must find the       */
/*                proper drive letter and proceed to copy the file.         */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int CopyObjToExportDir(
      char *szFullSrc,
      char *szVolName,
      ULONG ulVolSer,
      char *szDestPath)
{
   register int sRC;
   char chDrive, *p;
   char szSrcSpec[65];

   p = strrchr(szFullSrc,'\\');
   if (p == NULL)
      {
      sRC = LogError(ERR_NOFACC,NULL);
      }
   else
      {
      if (szFullSrc[0] == '\\' && szFullSrc[1] == '\\')
         {
         strcpy(szSrcSpec,szFullSrc);
         }
      else
         {
         sRC = FindPathDrive(szFullSrc,&chDrive);
         if (sRC != SUCCESS)
            {
            LogError(sRC,NULL);
            }
         else
            {
            szSrcSpec[0] = chDrive;
            szSrcSpec[1] = ':';
            if (szFullSrc[0] != '\\')
               {
               szSrcSpec[2] = '\\';
               szSrcSpec[3] = '\0';
               }
            else
               {
               szSrcSpec[2] = '\0';
               }
            strcat(szSrcSpec,szFullSrc);
            }
         }
      if (sRC == SUCCESS)
         {
         sRC = DosCopy(szSrcSpec,szDestPath,DCPY_EXISTING,0L);
         if (sRC != SUCCESS)
            {
            sRC = LogError(ERR_COPY,NULL);
            }
         else
            {
            DosDelete(szSrcSpec,0L);
            }
         }
      }
   return(sRC);
}
