/* cif_UTIL.H */
/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

/**************************************************************************/
/*                                                                        */
/*        File: cif_UTIL.H                                                */
/*                                                                        */
/*  Description: IPIA utility functions.                                  */
/*                                                                        */
/**************************************************************************/

/* This function will take an ASCII string and convert it to EBCDIC. */

void ascii2ebcdic (UCHAR * string, const UINT length);

void ascii2ebcdic (UCHAR * string, const UINT length)
/* This procedure takes an ASCII string of a specified length and converts  */
/* an EBCDIC string using the specified table (SV_A, SV_AE, or SV_G).       */
{
   HAB hab=NULL;
   USHORT cpSrc=850, cpDst=500;
   int i;
   PSZ target;

   target=calloc(length+1,1);

   WinCpTranslateString(hab, cpSrc, string, cpDst, length+1, target);

   memcpy(string,target,length+1);

   for(i=0;i<length;i++)
      if(string[i]==0xFF) string[i]='\n';

   free(target);

} // end of ascii2ebcdic()

/* This function takes an EBCDIC string and converts it to ASCII. */

void ebcdic2ascii (UCHAR * string, const UINT length);

void ebcdic2ascii (UCHAR * string, const UINT length)
/* This procedure takes an EBCDIC string of a specified length and converts  */
/* an ASCII string using the specified table (SV_A, SV_AE, or SV_G).       */
{

   HAB hab=NULL;
   USHORT cpSrc=500, cpDst=850;
   PSZ target;
   int i;

   target=calloc(length+1,1);

   WinCpTranslateString(hab, cpSrc, string, cpDst, length+1, target);

   memcpy(string,target,length+1);

   for(i=0;i<length;i++)
      if(string[i]==0xFF) string[i]='\n';

   free(target);
} // end of ebcdic2ascii()
