/* cif_DEFS.H */
/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

/**************************************************************************/
/*                                                                        */
/*        File: cif_DEFS.H                                                */
/*                                                                        */
/*  Description: IPIA defines and structure definitions.                  */
/*                                                                        */
/**************************************************************************/

/* ImagePlus Interchange Architecture(IPIA) Definitions */

/* IPIA Application-Class Tags */

/*    Mnenomic  Value      Description of Content  */

#define DSTREAM 0       /* Entire IPIA data stream */
#define CIU     1       /* Common Interchange Unit */
#define CDPG    2       /* Cope Page */
#define PRIV    3       /* System specific private data */
#define UID     4       /* Unit identifier */
#define FOL     5       /* Folder */
#define TAB     6       /* File Tab */
#define DOC     7       /* Document */
#define EVSET   8       /* Event Set */
#define NOTSET  9       /* Note Set */
#define ATSET   10      /* Attribute Set */
#define IATTRIB 11      /* IPlus Attrib Type */
#define IBMCHAR 12      /* IBM Character String */
#define TIMSTMP 13      /* Time Stamp in Character String */

/* IPIA Context-Specific Class Tags */

/*    Mnenomic  Value      Description of Content  */

#define LEVEL   0       /* Level identifier for encoding in data stream */
#define SOURCE  1       /* Two Char strings: system type */
#define SINK    2       /* Two Char strings: system type */
#define EXPTOK  3       /* Export Reuest token for acknowledgment */
#define RTN     0       /* Round Trip token for above */
#define CREL    1       /* Disposition */
#define CNEW    2       /* none */
#define CRPL    3       /* Doc ID */
#define CINSF   5       /* Folder ID */
#define CINST   6       /* Two Char ssstrings: file tab ID and folder ID */
#define CINSD   7       /* Doc ID */
#define PROC    8       /* Process ID */
#define CIUDES  9       /* Description of CIU contents */
#define CMOD    10      /* Folder ID */
#define CONT    0       /* Architected object specified by format attrib */
#define VER     1       /* Set of versions */
#define ATTRIBS 0       /* Create time, creator ID, optional attributes */
#define CHARTXT 1       /* Text string */
#define CHAROBJ 2       /* Architected object specified by format attrib */
#define INXTYPE 0       /* type of user-defined index */
#define INXVAL  1       /* value of user-defined index */

/* Code Point Definitions for Folder Attributes for Interchange */

#define APPID   9       /* Application ID */
#define AUTODEL 10      /* Auto Delete flag */
#define CODEPGE 13      /* Code Page */
#define TMSTMP  5       /* Time Stamp */
#define FOLCRTD 6       /* Folder Creation Date */
#define FOLDESC 3       /* Folder Description */
#define FOLID   8       /* Folder ID */
#define FOLTOK  30      /* Folder Token */
#define FOLTYPE 11      /* Folder Type */
#define INXCLAS 14      /* Index Class */
#define INXDATA 200     /* Index Data */
#define INXTYPE 0       /* Index Type */
#define INXVAL  1       /* Index Value */
#define ORSID   15      /* ORS Library ID */
#define SECCLAS 7       /* Security Class */
#define USERDTA 12      /* User Data */

/* Code Point Definitions for Document Attributes for Interchange */

#define COLNAME 25      /* Collection Name */
#define DATFILD 17      /* Date Filed */
#define DATRECV 18      /* Date Received */
#define TIMUPD  5       /* Time Stamp of Last Update */
#define DOCDESC 3       /* Document Description */
#define DOCFORM 4       /* Document Format i.e. MODCA */
#define DOCID   8       /* Dcoument ID */
#define DOCNAME 20      /* Document Name */
#define DOCTOKN 30      /* Document Token */
#define DOCTYPE 11      /* Document Type */
#define MGMTCLS 23      /* Management Class */
#define MODPEND 28      /* Modify Pending */
#define NUMPAGE 22      /* Number of pages */
#define ORIGDOC 21      /* Original Document Flag */
#define OMSID   16      /* OMS Library ID */
#define ORSID   15      /* ORS Library ID */
#define OVRLYID 201     /* Overlay ID */
#define RETPERD 26      /* Retention Period */
#define SECCLAS 7       /* Security Class */
#define STRCLAS 24      /* Storage Class */
#define USERDTA 12      /* User defined data */
#define USERDTE 19      /* User defined date */
#define USERSTS 27      /* User defined status */
#define VERSION 29      /* Version number of a document */

/* Defintions for Class bits */

#define UNVRSAL 0       /* Universal */
#define APPLCTN 1       /* Application */
#define CONTEXT 2       /* Context Specific */
#define PRIVATE 3       /* Private */

/* Defintions of P/C Bit */

#define PRMTIVE 0       /* Primitive */
#define CONSTRD 1       /* Constructed */



/****************************************************************************/
/*                         Imposed System limitations                       */
/****************************************************************************/

#define FILECHK 32000           /* Maximum chunk of memory to be allocated  */
                                /* at one time.  This is also the maximum   */
                                /* size of a note and the buffer to be used */
                                /* when appending images.                   */

#define MAXATTR 4096            /* Maximum number of unique attributes per  */
                                /* data stream.                             */

#define MAXCLAS 255             /* Maximum number of classes per data stream*/

#define ATTR 50                 /* Maximum number of attributes to be       */
                                /* associated with each individual class    */

/* Structure Definitions */

typedef struct {                /* Structure used for ID construction */
   UCHAR Number:5;
   UCHAR PC:1;
   UCHAR Class:2;
   } ID;

typedef struct {                /* One byte length value */
  UCHAR Length;
  } SHORTFORM;

typedef struct {                /* Two byte length value */
  UCHAR Bytes:4;
  UCHAR Flag:4;
  } LONGFORM;

typedef struct {                /* Structure for two byte swap */
  UCHAR Byte1;
  UCHAR Byte2;
  } SWAP2;

typedef struct {                /* Structure for four byte swap */
  UCHAR Byte1;
  UCHAR Byte2;
  UCHAR Byte3;
  UCHAR Byte4;
  } SWAP4;

typedef union {                 /* Length data structure */
  SHORTFORM ShortForm;
  LONGFORM LongForm;
  } LENGTH;

                          /* Attribute definition structure */
typedef struct {
  char  *name;                  /* Text description of attribute */
  char  *val;                   /* Text representation of value */
  USHORT num_attr;              /* Attribute number.  This is filled in */
                                /* by an appropriate function in both   */
                                /* the builder and parser.  Each unique */
                                /* variable name gets a unique number.  */
  } ATTRS;

                         /* Element definition structure */
typedef struct {
  char  *class;                 /* Text description of the class */
  USHORT num_class;             /* Class number. This is filled in      */
                                /* by an appropriate function in both   */
                                /* the builder and parser.  Each unique */
                                /* class name gets a unique number.     */
  ATTRS attrs[ATTR];            /* Array of associated attributes */
  UCHAR count;                  /* Number of associated attributes */
  char  *note;                  /* Pointer to the associated note text */
  char  note_present;           /* Flag, on presence of note */
  char  file[43];               /* File name of image */
  char  flag;                   /* Type flag.  The following flags are */
                                /* used: D=Document, F=Folder, E=End   */
                                /* of Folder, *=Begining of data       */
                                /* stream and $=End of data stream.    */
  } DATA;

                         /* Class definition structure */
typedef struct {
  char  *name;                  /* Text description of the class */
  USHORT num_class;             /* Unique Class number */
  USHORT num_attr;              /* Number of associated attributes */
  USHORT nattrs[ATTR];          /* Array of associated attribute NUMBERS */
  } CLASS;

                         /* Class association data structure */

/* This data structure is used in the transform_exit function of parser.  */
/* This exit allows the user to assign text descriptions of attributes    */
/* to attributes that are supplied from a host that does not supply their */
/* descriptions, only a number(ImagePlus FAF and WAF act this way).       */
typedef struct {
  char  *name;                  /* Text description of the class */
  USHORT num_class;             /* Unique Class number */
  USHORT num_attr;              /* Number of associated attributes */
  PUCHAR  attrs[ATTR];          /* Array of pointers to strings containing */
                                /* names for the appropriate classes. */
  } CLASS2;

                         /* Linked list definition structure */
struct linked_list {
  DATA data;                    /* Data element */
  struct linked_list *next;     /* Pointer to next element */
  };

typedef struct linked_list ELEMENT;
typedef ELEMENT            *LINK;
