/* CHNGTEXT.C */
/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#define  INCL_DOS                       /* Include DOS functions */
#define  INCL_DOSFILEMGR
#define  INCL_WINCOUNTRY                /* Include Code Page functions */

#include <os2.h>

#include "ciu_util.h"

/*****************************************************************************/
/*  Main module called as executable.  Two parameters are required for       */
/*  for executable to run to completion.  The first parameter is the file    */
/*  name for the LST file and the second parameter is that of the target     */
/*  CIU file.                                                                */
/*****************************************************************************/

UCHAR EBCDIC='T';

main(argc,argv,envp)
  int argc;
  char *argv[];
  char *envp[];
{
  char temp[80],a[80],b[80],c[80],*t2,*value;
  int i,j,f,foldleft,rc,lp;
  USHORT src;
  FILE *in,*out;
/* Checks for correct and accuracy of parameters */

  if (argc <= 2)
    {
    printf("Usage: chngtext file.lst A|E\a\n");
    printf("       specify A if source is in ASCII\n");
    printf("       specify E if source is in EBCDIC\n");

    exit(1);
    }

  if((argv[2][0]=='e')||(argv[2][0]=='E'))
  {
    EBCDIC='T';  /* Change EBCDIC to ASCII */
  }
  else
  {
    EBCDIC='F';  /* Change ASCII to EBCDIC */
  }

  if(EBCDIC=='T')
  {
     file_2ascii(argv[1]);
  }

  if ((in = fopen(argv[1], "r")) == NULL)
    {
    printf("Error on opening file %s for reading.\a\n", argv[1]);
    exit(3);
    }

/* Parse through the LST file */

  while (fgets(temp, 80, in) != NULL)
    {
    f = 1;
    sscanf(temp, "%[^-]-%s", a, b);

    printf("File: %s \tType: %s\n", a, b);      /* trace info */

    if(EBCDIC=='T')
    {
       file_2ascii(a);
    }
    else
    {
       file_2ebcdic(a);
    }

    }
  fclose(in);                                   /* Close LST file */

  if(EBCDIC=='F')
  {
     file_2ebcdic(argv[1]);
  }

}

int file_2ebcdic(char *name);

int file_2ebcdic(char *name)
{
   FILE *fptrin,*fptrout;
   int i;
   USHORT rc;

   char temp[133], a[133],b[133], *tmpfile;

   tmpfile=tempnam("C:\\","CIF");

   if ((fptrin = fopen(name, "r")) == NULL)
   {
      printf("Error opening: %s\n",name);
      return(1);
   }

   if ((fptrout = fopen(tmpfile, "w")) == NULL)
   {
      printf("Error opening: %s\n",tmpfile);
      return(1);
   }

   while (fgets(temp, 80, fptrin) != NULL)
   {
      if(strnicmp(temp,":folderitem.",12)==0)
      {
        sscanf(temp, "%[^.].%[^\n]", a, b);
        file_2ebcdic(b);
      }
      ascii2ebcdic(temp,strlen(temp));
      fputs(temp,fptrout);
   }

   fclose(fptrin);
   fclose(fptrout);
   rc=DosCopy(tmpfile,name,DCPY_EXISTING,0l);
   DosDelete(tmpfile,0L);
}

int file_2ascii(char *name);

int file_2ascii(char *name)
{
   FILE *fptrin,*fptrout;
   int i;
   USHORT rc;

   char temp[133], a[133],b[133], *tmpfile;

   tmpfile=tempnam("C:\\","CIF");

   if ((fptrin = fopen(name, "r")) == NULL)
   {
      printf("Error opening: %s\n",name);
      return(1);
   }

   if ((fptrout = fopen(tmpfile, "w")) == NULL)
   {
      printf("Error opening: %s\n",tmpfile);
      return(1);
   }

   while (fgets(temp, 80, fptrin) != NULL)
   {
      ebcdic2ascii(temp,strlen(temp));
      fputs(temp,fptrout);
      if(strnicmp(temp,":folderitem.",12)==0)
      {
        sscanf(temp, "%[^.].%[^\n]", a, b);
        file_2ascii(b);
      }
   }

   fclose(fptrin);
   fclose(fptrout);
   rc=DosCopy(tmpfile,name,DCPY_EXISTING,0l);
   DosDelete(tmpfile,0L);
}

int match(char *pStr,char *pTarget);

int match(char *pStr,char *pTarget)
{
  while (*pTarget)
    {
    if (tolower(*pStr) != tolower(*pTarget))
      return (0);
    pTarget++;
    if (*pStr++ == '\0')
      return (0);
    }
  return (1);
}
