/* BUILDcif.H */
/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

/* Include files */
#include <stdio.h>                      /* Standard C libraries */
#include <stdlib.h>

#define  INCL_DOS                       /* Include DOS functions */
#define  INCL_DOSFILEMGR
#define  INCL_WINCOUNTRY                /* Include Code Page functions */
#include <os2.h>

#include "cif_defs.h"                   /* Include cif structures and defines*/
#include "cif_util.h"                   /* Include common cif routines */

FILE *in,*out;                          /* Global file indentifiers */
LINK head = NULL,tail;
DATA item;

char *source = "IP/2 1.1";              /* Data Stream source is IP/2 1.1 */
char *cif_id = NULL;
char EBCDIC = 'F';

UCHAR Unit_Count = 1;                   /* Used for compilation of attribute */
USHORT tot_classes = 0,tot_attrs = 0;   /* and class information.            */
CLASS Class[MAXCLAS];
char *nattrs[MAXATTR];

/* Code Point support functions */

int do_text(char *line,CHAR cdp);       /* Write a text code point(CP) value */
int do_1num(UCHAR num,CHAR cdp);        /* Write a 1 byte CP value */
int do_2num(USHORT num,CHAR cdp);       /* Write a 2 byte CP value */
int do_Xnum(USHORT num,CHAR cdp);       /* Write a 1 or 2 byte CP value */

/* Image and Note functions */

int do_image(UCHAR *file);              /* Append the image file out */
int do_note(char *note);                /* Write the note information out */

/* Various linked list functions */

void flush_item(void);                  /* Append an element to the list */
void print_list(LINK);                  /* Print the list out */
void del_files(LINK);                   /* Delete the files in the list */

/* The two required functions required to be called to build a cif file */

int build_cif(LINK);                    /* Build a cif file */
void do_classes(LINK);                  /* Compile attribute and class info */

/* Functions to build the five highest level parts of a cif file */

int beg_cif(void);                      /* Write beginning data stream info */
int end_cif(void);                      /* Write ending data stream info */
int beg_folder(DATA d);                 /* Write beginning of folder info */
int end_folder(void);                   /* Write end of folder info */
int document(DATA d);                   /* Write document info */

/* Functions to properly nest folders within folders and documents within */
/* folders with the appropriate cif start and end tags.  At the highest   */
/* level a 'cif' can contain either a folder or a document, but each      */
/* item within a folder does not have to have a beginning and ending      */
/* cif tags.                                                              */

void do_newobj(void);                   /* Output beginning cif tag */
void do_endobj(void);                   /* Output end of cif tag */

/* Parses the folder INX file.  This function opens the file and then */
/* prses the folder type tags and fills the global data structure and */
/* then appends the filled data structure to the linked list. This    */
/* function calls the appropriate function to parse the :folderitem.  */
/* tags in the INX file.  This function can and is by itself.         */

int parse_fol(char file[80])
{
  FILE *fp;
  char line[132],a[80],b[80],c[80],*note;
  UCHAR flag;
  USHORT i,n,note_flag = 0;
  int rc = 0;

  if ((fp = fopen(file, "r")) == NULL)
    {
    return (-1);
    }
  strcpy(item.file, file);
  while (fgets(line, 132, fp) != NULL)
    {
    if (strnicmp(line, ":attrcnt.", strlen(":attrcnt.")) == 0)
      {
      sscanf(line, "%[^.].%s", a, b);
      n = atoi(b);
      printf("There are %d attributes.\n", n);
      item.count = n;
      for (i = 0; i < n; i++)
        {
        strset(b, 0);
        strset(c, 0);
        if (fgets(line, 80, fp) == NULL)
          return (2);
        sscanf(line, "%[^.].%[^.].%[^\n]", a, b, c);
        item.attrs[i].name = calloc(strlen(b)+1, sizeof(char));
        strcpy(item.attrs[i].name, b);
        item.attrs[i].val = calloc(strlen(c)+1, sizeof(char));
        strcpy(item.attrs[i].val, c);
        }
      }
    else
      if (match(line, ":note."))
        {
        flag = 0;
        note = calloc(FILECHK, 1);
        while (flag == 0)
          {
          fgets(line, 132, fp);
          sscanf(line, "%[^.].%[^\0]", a, b);
          if (note_flag == 0)
            {
            strcpy(note, b);
            note_flag = strlen(b);
            }
          else
            if ((note_flag+strlen(b)) > FILECHK)
              {
              note_flag = FILECHK;
              printf("Note too large!  Truncated to 32K.\n");
              }
            else
              {
              strcat(note, b);
              note_flag += strlen(b);
              }
          if (line[1] == 'e')
            {
            flag = 1;
            i = 0;
            item.note = calloc(strlen(note)+1, sizeof(char));
            strcpy(item.note, note);
            free(note);
            item.note_present = 1;
            }
          }
        }
      else
        if (strnicmp(line, ":class.", strlen(":class.")) == 0)
          {
          sscanf(line, "%[^.].%[^\n]", a, b);
          item.class = calloc(strlen(b)+1, sizeof(char));
          strcpy(item.class, b);
          }
    }
  fclose(fp);
   //add to list
  item.flag = 'F';
  tail->next = malloc(sizeof(ELEMENT));
  tail = tail->next;
  memcpy(&tail->data, &item, sizeof(ELEMENT));
  flush_item();

  if ((fp = fopen(file, "r")) == NULL)
    {
    return (-1);
    }
  printf("Working on Folder: %s\n", file);
  while (fgets(line, 132, fp) != NULL)
    {
    if (match(line, ":folderitem."))
      {
      sscanf(line, "%[^.].%[^\n]", a, b);
      rc = is_fol(b);
      if (rc == 1)
        {
        parse_fol(b);
        }
      else
        if (rc == 0)
          {
          parse_doc(b);
          }
        else
          {
          return (-2);
          }
      }
    }
  printf("Done with folder: %s\n", file);
  item.flag = 'E';
  tail->next = malloc(sizeof(ELEMENT));
  tail = tail->next;
  memcpy(&tail->data, &item, sizeof(ELEMENT));
  flush_item();
  fclose(fp);
}

/* Parse a document INX file.  This function parses the INX file and fills */
/* a global data structure and then when finished parsing appends it to    */
/* the linked list.                                                        */

int parse_doc(char file[80])
{
  FILE *fp;
  char line[132],a[80],b[80],c[80],*note;
  UCHAR flag;
  USHORT i,n,note_flag = 0;
  int rc = 0;

  printf("Working on document: %s\n", file);

  if ((fp = fopen(file, "r")) == NULL)
    {
    return (-1);
    }
  while (fgets(line, 132, fp) != NULL)
    {
    if (strnicmp(line, ":attrcnt.", strlen(":attrcnt.")) == 0)
      {
      sscanf(line, "%[^.].%s", a, b);
      n = atoi(b);
      printf("There are %d attributes.\n", n);
      item.count = n;
      for (i = 0; i < n; i++)
        {
        strset(b, 0);
        strset(c, 0);
        if (fgets(line, 80, fp) == NULL)
          return (2);
        sscanf(line, "%[^.].%[^.].%[^\n]", a, b, c);
        item.attrs[i].name = calloc(strlen(b)+1, sizeof(char));
        strcpy(item.attrs[i].name, b);
        item.attrs[i].val = calloc(strlen(c)+1, sizeof(char));
        strcpy(item.attrs[i].val, c);
        }
      }
    else
      if (match(line, ":note."))
        {
        flag = 0;
        note = calloc(FILECHK, 1);
        while (flag == 0)
          {
          fgets(line, 132, fp);
          sscanf(line, "%[^.].%[^\0]", a, b);
          if (note_flag == 0)
            {
            strcpy(note, b);
            note_flag = strlen(b);
            }
          else
            if ((note_flag+strlen(b)) > FILECHK)
              {
              note_flag = FILECHK;
              printf("Note too large!  Truncated to 32K.\n");
              }
            else
              {
              strcat(note, b);
              note_flag += strlen(b);
              }
          if (line[1] == 'e')
            {
            flag = 1;
            i = 0;
            item.note = calloc(strlen(note)+1, sizeof(char));
            strcpy(item.note, note);
            free(note);
            item.note_present = 1;
            }
          }
        }
      else
        if (strnicmp(line, ":class.", strlen(":class.")) == 0)
          {
          sscanf(line, "%[^.].%[^\n]", a, b);
          item.class = calloc(strlen(b)+1, sizeof(char));
          strcpy(item.class, b);
          }
        else
          if (strnicmp(line, ":image.", strlen(":image.")) == 0)
            {
            sscanf(line, "%[^.].%[^\n]", a, b);
            strcpy(item.file, b);
            }
    }
  fclose(fp);
   //add to list
  item.flag = 'D';
  tail->next = malloc(sizeof(ELEMENT));
  tail = tail->next;
  memcpy(&tail->data, &item, sizeof(ELEMENT));
  flush_item();
}

/* This function clears the contents of the global data structure item. */

void flush_item(void)
{
  int i;

  item.class = NULL;
  item.num_class = 0;
  item.note_present = 0;
  item.count = 0;
  item.file[0] = 0;
}

/* Opens the file and determines if the file is a document or folder INX file.*/
/* If it is a folder it returns a 1, a -1 if the file doesn't exist or a 0 if */
/* the file is a document.                                                    */

int is_fol(char file[80])
{
  FILE *t;
  char line[80];
  int rc = 0;

  if ((t = fopen(file, "r")) == NULL)
    {
    return (-1);
    }
  fgets(line, 80, t);
  if (match(line, ":folder."))
    rc = 1;
  fclose(t);
  return (rc);

}

/* Traverses the linked list and prints out pertinent information about each */
/* element in the linked list.  This allows the person debugging to see what */
/* was parse prior to the building of the cif file.                          */

void print_list(LINK head)
{
  int i;

  i = 0;
  printf("Entered print_list\n");
  for (i = 0; head != NULL; head = head->next)
    {
    if (head == NULL)
      printf("NULL\n");
    else
      {
      if (head->data.flag == '$')
        printf("END of LST\n");
      else
        if (head->data.flag == '*')
          printf("BEGINNING of LST\n");
        else
          if (head->data.flag == 'E')
            printf("End Of Folder\n");
          else
            if (head->data.flag == 'F')
              {
              printf("Folder is of class: %s and number: %d.\n", head->data.class, head->data.num_class);
              for (i = 0; i < head->data.count; i++)
                {
                printf("  Attribute #%d %s :: %s AN:%d\n", i, head->data.attrs[i].name, head->data.attrs[i].val, head->data.attrs[i].num_attr);
                }                      /* endfor                                                                                                                                                                                                             */
              if (head->data.note_present == 1)
                printf("  The note is %d bytes in length.\n", strlen(head->data.note));
              }
            else
              {
              printf("Document %s is of class: %s and number: %d.\n", head->data.file, head->data.class, head->data.num_class);
              for (i = 0; i < head->data.count; i++)
                {
                printf("  Attribute #%d %s :: %s AN:%d\n", i, head->data.attrs[i].name, head->data.attrs[i].val, head->data.attrs[i].num_attr);
                }                      /* endfor                                                                                                                                                                                                             */
              if (head->data.note_present == 1)
                printf("  The note is %d bytes in length.\n", strlen(head->data.note));
              }
      }
    }
  printf("Exited print_list\n");
}

/* Traverses the linked list and deletes all INX and MDI files referenced in */
/* linked list.                                                              */

void del_files(LINK head)
{
  int i,j;
  USHORT rc;

  i = 0;
  printf("Entered del_files\n");
  for (i = 0; head != NULL; head = head->next)
    {
    if (head == NULL)
      printf("NULL\n");
    else
      {
      if (head->data.flag == '$')
        printf("END of LST\n");
      else
        if (head->data.flag == '*')
          printf("BEGINNING of LST\n");
        else
          if (head->data.flag == 'E')
            printf("End Of Folder\n");
          else
            if (head->data.flag == 'F')
              {
              rc = DosDelete(head->data.file, 0);
              printf("Delete rc=%d on: %s\n", rc, head->data.file);
              }
            else
              if (head->data.flag == 'D')
                {
                rc = DosDelete(head->data.file, 0);
                printf("Delete rc=%d on: %s\n", rc, head->data.file);
                j = strlen(head->data.file);
                head->data.file[j-3] = 'I';
                head->data.file[j-2] = 'N';
                head->data.file[j-1] = 'X';
                rc = DosDelete(head->data.file, 0);
                printf("Delete rc=%d on: %s\n", rc, head->data.file);
                }
      }
    }
  printf("Exited del_files\n");
}

/* Traverses the linked list and compiles information about the attributes */
/* and classes referenced so that it can be placed in the data stream      */
/* header allowing the recieving system to intrepret the referenced data.  */

void do_classes(LINK head)
{
  int i;
  USHORT j,k,l,cur_class,cur_attr;

  i = 0;
  cur_class = 0;
  cur_attr = 0;
  printf("Entered do_classes\n");
  for (i = 0; head != NULL; head = head->next)
    {
    if (head == NULL)
      printf("NULL\n");
    else
      {
      if (head->data.flag == '$')
        printf("END\n");
      else
        if (head->data.flag == '*')
          printf("BEGINNING\n");
        else
          if (head->data.flag == 'E')
            printf("End Of Folder\n");
          else
            {
            for (j = 0; j < head->data.count; j++)
              {
               // Search for Entry in Attribute Array and Add if not found
              k = 0;
              while (k < cur_attr)
                {
                if (strcmp(head->data.attrs[j].name, nattrs[k]) == 0)
                  {
                  head->data.attrs[j].num_attr = k;
                  break;
                  }
                k++;
                }
              if (k == cur_attr)
                {
                printf("Adding an attribute to list.\n");
                nattrs[cur_attr] = calloc(strlen(head->data.attrs[j].name)+1, 1);
                strcpy(nattrs[cur_attr], head->data.attrs[j].name);
                head->data.attrs[j].num_attr = cur_attr;
                cur_attr++;
                }
              }
            // Search for Entry in Class Array and Add if not found
            k = 0;
            while (k < cur_class)
              {
              if (strcmp(head->data.class, Class[k].name) == 0)
                {
                head->data.num_class = k;
                break;
                }
              k++;
              }
            if (k == cur_class)
              {
              Class[cur_class].name = calloc(strlen(head->data.class)+1, 1);
              strcpy(Class[cur_class].name, head->data.class);
              Class[cur_class].num_attr = head->data.count;
              head->data.num_class = cur_class;
              for (l = 0; l < Class[cur_class].num_attr; l++)
                {
                Class[cur_class].nattrs[l] = head->data.attrs[l].num_attr;
                }
              cur_class++;
              }
            }
      }
    }
  printf("There where %d attributes found:\n", cur_attr);
  for (j = 0; j < cur_attr; j++)
    printf(" %d) %s\n", j+1, nattrs[j]);
  printf("There where %d classes found:\n", cur_class);
  for (j = 0; j < cur_class; j++)
    {
    printf(" %d) %s with the following %d attributes:\n", j+1, Class[j].name, Class[j].num_attr);
    for (k = 0; k < Class[j].num_attr; k++)
      printf("    %d)  %3.3d %s\n", k+1, Class[j].nattrs[k]+1, nattrs[Class[j].nattrs[k]]);
    }
  tot_classes = cur_class;
  tot_attrs = cur_attr;
  printf("Exited do_classes\n");
}

/* Utility function to compare two strings */

int match(char *pStr,char *pTarget)
{
  while (*pTarget)
    {
    if (tolower(*pStr) != tolower(*pTarget))
      return (0);
    pTarget++;
    if (*pStr++ == '\0')
      return (0);
    }
  return (1);
}

/* This function traverses the linked list and calls the appropriate   */
/* function for the current element.  This function also regulates the */
/* placement of the beginning and end cif tags.                        */

int build_cif(LINK head)
{
  int i=0;
  int level = 0;                        /* Keeps track of depth of items */

  printf("Entered build_cif\n");        /* trace */
  for (i = 0; head != NULL; head = head->next)     /* loop through list */
    {
    if (head == NULL)
      printf("NULL\n");
    else
      {
      if (head->data.flag == '$')               /* End of data stream proc */
        {
        end_cif();
        printf("Ending cif data stream\n");
        }
      else
        if (head->data.flag == '*')             /* Beg of data stream proc */
          {
          beg_cif();
          printf("Starting cif data stream\n");
          }
        else
          if (head->data.flag == 'E')           /* End of folder processing */
            {
            end_folder();
            level--;
            if (level == 0)
              do_endobj();
            printf("Ending a Folder\n");
            }
          else
            if (head->data.flag == 'D')         /* Document processing */
              {
              if (level == 0)
                do_newobj();
              document(head->data);
              if (level == 0)
                do_endobj();
              printf("Outputing a Document to the cif data stream.\n");
              }
            else
              if (head->data.flag == 'F')       /* Beg of folder processing */
                {
                if (level == 0)
                  do_newobj();
                beg_folder(head->data);
                printf("Outputing Folder information to the cif data stream.\n");
                level++;
                }
      }
    }
  fclose(out);                                  /* Close cif file */
  printf("Exited build_cif\n");
}

/* This function places a beginning of cif tag in the output file. */

void do_newobj(void)
{
  ID id;
  LENGTH len;
  USHORT t = 0,l,j,k;
  UCHAR b1,b2;
//                         cif

  id.Class = APPLCTN;
  id.PC = CONSTRD;
  id.Number = CIU;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&id, 1, 1, out);
  fwrite(&len, 1, 1, out);
//                         Set of CIU
  id.Class = CONTEXT;
  id.PC = CONSTRD;
  id.Number = CIU;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&id, 1, 1, out);
  fwrite(&len, 1, 1, out);
//                         New Object
  id.Class = CONTEXT;
  id.PC = PRMTIVE;
  id.Number = CNEW;
  len.LongForm.Flag = 0;
  len.LongForm.Bytes = 0;
  fwrite(&id, 1, 1, out);
  fwrite(&len, 1, 1, out);
//                         End of Set of CIU
  fwrite(&t, 2, 1, out);
}

/* This function places an end of CIU tag to the output file.  Basically */
/* writes an end of indefinte length tag, two one byte zero's.           */

void do_endobj(void)
{
  USHORT t = 0;

  fwrite(&t, 2, 1, out);
}

/* This function writes the data stream header information.  This info  */
/* includes the following:                                              */
/*                              Code Page information                   */
/*                              Source Machine                          */
/*                              Source ID                               */
/*                              Attribute Information                   */
/*                              Class Information                       */
/* This function leaves the data stream in a state ready to recieve a   */
/* CIU tag.                                                             */

int beg_cif(void)
{
  ID id;
  LENGTH len;
  USHORT t = 0,l,j,k,t2;
  UCHAR b1,b2,temp,b3;
  SWAP2 swap;

  printf("Entered beg_cif.\n");
//                         Data Stream
  id.Class = APPLCTN;
  id.PC = CONSTRD;
  id.Number = DSTREAM;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&id, 1, 1, out);
  fwrite(&len, 1, 1, out);
//                         Level
  do_2num(0x0101, 0x80);
//                         Code Page
  b3=0x42;
  t2=500;
  memcpy(&swap, &t2, 2);
  temp = swap.Byte1;
  swap.Byte1 = swap.Byte2;
  swap.Byte2 = temp;
  fwrite(&b3, 1, 1, out);
  b3=2;
  fwrite(&b3, 1, 1, out);
  fwrite(&swap, 2, 1, out);
//                         Source
  id.Class = CONTEXT;
  id.PC = CONSTRD;
  id.Number = SOURCE;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&id, 1, 1, out);
  fwrite(&len, 1, 1, out);
//                         Type
  if (EBCDIC=='T')
    strcpy(source,"WAF 2.3");
  do_text(source, 0x4C);
//                         ID
  cif_id = getenv("CIF_ID");
  if (cif_id == NULL)
    do_text("IP2IMPEX", 0x4C);
  else
    do_text(cif_id, 0x4C);
//                         End of Source
  fwrite(&t, 2, 1, out);
//                         Attribute Definitions
  b1 = 0xA4;
  b2 = 0x80;
  fwrite(&b1, 1, 1, out);
  fwrite(&b2, 1, 1, out);
  for (l = 0; l < tot_attrs; l++)
    {
//                         Attr Set
    b1 = 0x30;
    b2 = 0x80;
    fwrite(&b1, 1, 1, out);
    fwrite(&b2, 1, 1, out);
//                         Attribute Number
    do_Xnum(l+1, 0x80);
//                         Attribute Type
    do_1num(0x08, 0x81);
//                         Attribute Name
    do_text(nattrs[l], 0x82);
//                         End of Attr
    fwrite(&t, 2, 1, out);
    }
//                         End of Attr Set
  fwrite(&t, 2, 1, out);
//                         Class Definitions
  b1 = 0xA5;
  b2 = 0x80;
  fwrite(&b1, 1, 1, out);
  fwrite(&b2, 1, 1, out);
  for (l = 0; l < tot_classes; l++)
    {
//                         Class Set
    b1 = 0x30;
    b2 = 0x80;
    fwrite(&b1, 1, 1, out);
    fwrite(&b2, 1, 1, out);
//                         Class Number
    do_Xnum(l+1, 0x80);
//                         Class Name
    do_text(Class[l].name, 0x82);
//                         Optional Attributes
    b1 = 0xA5;
    b2 = 0x80;
    fwrite(&b1, 1, 1, out);
    fwrite(&b2, 1, 1, out);
//                         Attributes
    for (k = 0; k < Class[l].num_attr; k++)
      {
      do_Xnum(Class[l].nattrs[k]+1, 0x80);
      }
//                         End of Optional Attributes
    fwrite(&t, 2, 1, out);
//                         End of Class
    fwrite(&t, 2, 1, out);
    }
//                         End of Class Set
  fwrite(&t, 2, 1, out);
//                         Set of CIU's
  id.Class = UNVRSAL;
  id.PC = CONSTRD;
  id.Number = 17;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&id, 1, 1, out);
  fwrite(&len, 1, 1, out);
  printf("Exited beg_ciu.\n");
}

/* This function puts two end of indefinte length fields at the end of the */
/* data stream.  This will properly close out all beginning indefinte      */
/* length identifiers specified in the beg_ciu function.                   */

int end_cif(void)
{
  USHORT t = 0;

  fwrite(&t, 2, 1, out);
  fwrite(&t, 2, 1, out);
   // fprintf(out,"End of CIU info!!");
}

/* This function will write out all information about a folder except for */
/* the documents or folders contained within in and the end of indefinite */
/* length tags.  This function writes attribute, class, and note data.    */
/* This function leaves the data stream in a state ready to receive a     */
/* folder (beg_folder), document (document), end of folder (end_fol)      */
/* or end of cif (end_cif) tag.                                           */

int beg_folder(DATA d)
{
   // fprintf(out,"Document:%s:-->",d.file);
  ID id;
  LENGTH len;
  USHORT t = 0,l,k;
  UCHAR b1 = 0;
  int i = 0;
  char temp[12];

  printf("Entered beg_folder.\n");
//                         Folder
  id.Class = APPLCTN;
  id.PC = CONSTRD;
  id.Number = FOL;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&id, 1, 1, out);
  fwrite(&len, 1, 1, out);
//                         Unit Ident
  do_1num(Unit_Count++, 0x44);
//                         Notes
  if (d.note_present == 1)
    {
    do_note(d.note);
    }
//                         Attrib Set
  id.Class = APPLCTN;
  id.PC = CONSTRD;
  id.Number = ATSET;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&id, 1, 1, out);
  fwrite(&len, 1, 1, out);
//                         Unit ID
  do_1num(Unit_Count++, 0x44);
//                         Set of Attrib
  id.Class = UNVRSAL;
  id.PC = CONSTRD;
  id.Number = 17;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&id, 1, 1, out);
  fwrite(&len, 1, 1, out);
//                         I+ Single Attrib
  b1 = 0xA1;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&b1, 1, 1, out);
  fwrite(&len, 1, 1, out);
//                         Folder Type Name
  do_1num(FOLTYPE, 0x4B);
//                         Folder Class
  do_text(d.class, 0x4C);
//                         End of Single Attrib
  fwrite(&t, 2, 1, out);
//                         I+ Single Attrib
  id.Class = CONTEXT;
  id.PC = CONSTRD;
  id.Number = CIU;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&id, 1, 1, out);
  fwrite(&len, 1, 1, out);
//                         Class Assignment
  do_1num(0x0E, 0x4B);
//                         Class Number
  do_Xnum(d.num_class+1, 0x02);
//                         End of Single Attrib
  fwrite(&t, 2, 1, out);
//                         Attribute Assignment
  b1 = 0xA2;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&b1, 1, 1, out);
  fwrite(&len, 1, 1, out);
//                         Attr Assignment
  do_1num(0xC8, 0x4B);
  b1 = 0x31;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&b1, 1, 1, out);
  fwrite(&len, 1, 1, out);
//                         Attribute Numbers and Values
  for (l = 0; l < d.count; l++)
    {
    b1 = 0x30;
    len.LongForm.Flag = 8;
    len.LongForm.Bytes = 0;
    fwrite(&b1, 1, 1, out);
    fwrite(&len, 1, 1, out);
    do_Xnum(d.attrs[l].num_attr+1, 0x80);
    do_text(d.attrs[l].val, 0x81);
    fwrite(&t, 2, 1, out);
    }
//                         End of Attr Assignment
  fwrite(&t, 2, 1, out);
//                         End of Attribute Assignment
  fwrite(&t, 2, 1, out);
//                         End Set of Attrib
  fwrite(&t, 2, 1, out);
//                         End of Attrib Set
  fwrite(&t, 2, 1, out);
//                         Set of Contents
  t = 0x31;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&t, 1, 1, out);
  fwrite(&len, 1, 1, out);
  printf("Exited beg_folder.\n");
}

/* This function outputs a document and image to the data stream.  This */
/* function writes out attribute, class and note data along with the    */
/* image to the data stream.  This function leaves the data stream in a */
/* state to receive another document, folder, end of folder or end of   */
/* cif tag.                                                             */

int document(DATA d)
{
   // fprintf(out,"Document:%s:-->",d.file);
  ID id;
  LENGTH len;
  USHORT t = 0,l,k;
  UCHAR b1;
  char temp[12];

  printf("Entered document.\n");
//                         Document
  id.Class = APPLCTN;
  id.PC = CONSTRD;
  id.Number = DOC;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&id, 1, 1, out);
  fwrite(&len, 1, 1, out);
//                         Unit Ident
  do_1num(Unit_Count++, 0x44);
//                         Notes
  if (d.note_present == 1)
    {
    do_note(d.note);
    }
//                         Attrib Set
  id.Class = APPLCTN;
  id.PC = CONSTRD;
  id.Number = ATSET;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&id, 1, 1, out);
  fwrite(&len, 1, 1, out);
//                         Unit ID
  do_1num(Unit_Count++, 0x44);
//                         Set of Attrib
  id.Class = UNVRSAL;
  id.PC = CONSTRD;
  id.Number = 17;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&id, 1, 1, out);
  fwrite(&len, 1, 1, out);
//                         I+ Single Attrib
  id.Class = CONTEXT;
  id.PC = CONSTRD;
  id.Number = CIU;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&id, 1, 1, out);
  fwrite(&len, 1, 1, out);
//                         Form Name
  do_1num(DOCTYPE, 0x4B);
//                         ID
  do_text(d.class, 0x4C);
//                         End of Single Attrib
  fwrite(&t, 2, 1, out);
//                         I+ Single Attrib
  id.Class = CONTEXT;
  id.PC = CONSTRD;
  id.Number = CIU;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&id, 1, 1, out);
  fwrite(&len, 1, 1, out);
//                         Class Assignment
  do_1num(0x0E, 0x4B);
//                         Class Number
  do_Xnum(d.num_class+1, 0x02);
//                         End of Single Attrib
  fwrite(&t, 2, 1, out);
//                         Attribute Assignment
  b1 = 0xA2;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&b1, 1, 1, out);
  fwrite(&len, 1, 1, out);
//                         Attr Assignment
  do_1num(0xC8, 0x4B);
  b1 = 0x31;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&b1, 1, 1, out);
  fwrite(&len, 1, 1, out);
//                         Attribute Numbers and Values
  for (l = 0; l < d.count; l++)
    {
    b1 = 0x30;
    len.LongForm.Flag = 8;
    len.LongForm.Bytes = 0;
    fwrite(&b1, 1, 1, out);
    fwrite(&len, 1, 1, out);
    do_Xnum(d.attrs[l].num_attr+1, 0x80);
    do_text(d.attrs[l].val, 0x81);
    fwrite(&t, 2, 1, out);
    }
//                         End of Attr Assignment
  fwrite(&t, 2, 1, out);
//                         End of Attribute Assignment
  fwrite(&t, 2, 1, out);
//                         End Set of Attrib
  fwrite(&t, 2, 1, out);
//                         End Attrib Set
  fwrite(&t, 2, 1, out);
//                         Document Content
  id.Class = CONTEXT;
  id.PC = CONSTRD;
  id.Number = CONT;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&id, 1, 1, out);
  fwrite(&len, 1, 1, out);
//                         Actual Image
  do_image(d.file);
//                         End of Document Content
  fwrite(&t, 2, 1, out);
//                         End of Document
  fwrite(&t, 2, 1, out);
  printf("Exited document.\n");
}

/* This function writes out the two required end of indefinte length    */
/* identifiers to properly close the two beginning of indefinite length */
/* identifiers placed in the data stream by the beg_folder function.    */

int end_folder(void)
{
  USHORT t = 0;
//                         End of Attrib Set

  fwrite(&t, 2, 1, out);
//                         End of Folder
  fwrite(&t, 2, 1, out);
}

/* This function writes a note to the data stream. */

int do_note(char *note)
{
  ID id;
  LENGTH len;
  USHORT t = 0;

  printf("Entered do_note\n");
//                         Note Set
  id.Class = APPLCTN;
  id.PC = CONSTRD;
  id.Number = NOTSET;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&id, 1, 1, out);
  fwrite(&len, 1, 1, out);
//                         Unit ID
  do_1num(Unit_Count++, 0x44);
//                         Seq of Notes
  id.Class = UNVRSAL;
  id.PC = CONSTRD;
  id.Number = 16;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&id, 1, 1, out);
  fwrite(&len, 1, 1, out);
//                         Note
  id.Class = UNVRSAL;
  id.PC = CONSTRD;
  id.Number = 16;
  len.LongForm.Flag = 8;
  len.LongForm.Bytes = 0;
  fwrite(&id, 1, 1, out);
  fwrite(&len, 1, 1, out);
//                         Note Text
  do_text(note, 0x81);
//                         End of Note
  fwrite(&t, 2, 1, out);
//                         End of Seq of Notes
  fwrite(&t, 2, 1, out);
//                         End of Note Set
  fwrite(&t, 2, 1, out);
  printf("Exited do_note\n");
}

/* This function writes a line of text that is to be referenced by a code   */
/* point(CP). This function include the CP, text and length of accompanying */
/* text.                                                                    */

int do_text(char *line,CHAR cdp)
{
  USHORT len2;
  UCHAR temp;
  LONGFORM length;
  SWAP2 swap;

  printf("Entered do_text\n");
  len2 = strlen(line);
  fwrite(&cdp, 1, 1, out);
  if (len2 > 127)
    {
    length.Bytes = 2;
    length.Flag = 8;
    fwrite(&length, 1, 1, out);
    memcpy(&swap, &len2, 2);
    temp = swap.Byte1;
    swap.Byte1 = swap.Byte2;
    swap.Byte2 = temp;
    fwrite(&swap, 2, 1, out);
    }
  else
    {
    temp = len2;
    fwrite(&temp, 1, 1, out);
    }
  ascii2ebcdic(line, len2);
  fprintf(out, "%s", line);
  printf("Exited do_text\n");
}

/* Writes a one byte value along with it's code point and length. */

int do_1num(UCHAR num,CHAR cdp)
{
  UCHAR len = 1;

  fwrite(&cdp, 1, 1, out);
  fwrite(&len, 1, 1, out);
  fwrite(&num, 1, 1, out);
}

/* Writes a two byte value along with it's code point and length. */

int do_2num(USHORT num,CHAR cdp)
{
  UCHAR len = 2;

  fwrite(&cdp, 1, 1, out);
  fwrite(&len, 1, 1, out);
  fwrite(&num, 2, 1, out);
}

/* Writes a one or two byte code point value along with it's code point */
/* and appropriate length. */

int do_Xnum(USHORT num,CHAR cdp)
{
  UCHAR len = 2;
  UCHAR temp2;
  USHORT temp;

  if (num <= 0xFF)
    {
    fwrite(&cdp, 1, 1, out);
    len = 1;
    fwrite(&len, 1, 1, out);
    temp2 = num;
    fwrite(&temp2, 1, 1, out);
    }
  else
    {
    fwrite(&cdp, 1, 1, out);
    fwrite(&len, 1, 1, out);
    swab(&num, &temp, 2);
    fwrite(&temp, 2, 1, out);
    }
}

/* This function appends an image and it's size in bytes to the data */
/* stream.                                                           */

int do_image(UCHAR *file)
{
  HFILE hf;
  UCHAR t;
  USHORT usAction,rc,num,to_read = 0;
  ULONG file_size = 0,current_file_size = 0;
  FILESTATUS fstsFile;
  SWAP2 temp2;
  SWAP4 temp4;
  char *image;
  FILE *img;

  rc = DosOpen(file, &hf, &usAction, 0L, FILE_READONLY, FILE_OPEN, OPEN_ACCESS_READONLY|OPEN_SHARE_DENYNONE|OPEN_FLAGS_SEQUENTIAL, 0L);
  if (rc == 0)
    {
    DosQFileInfo(hf, 1, &fstsFile, sizeof(fstsFile));
    DosClose(hf);
    img = fopen(file, "rb");
    file_size = fstsFile.cbFile;
    printf("File size of %s is %lu bytes.\n", file, file_size);
    if (file_size < FILECHK)
      {
      t = 0x04;
      fwrite(&t, 1, 1, out);
      printf("1");
      t = 0x82;
      fwrite(&t, 1, 1, out);
      printf("2");
      num = file_size;
      memcpy(&temp2, &num, 2);
      printf("3");
      t = temp2.Byte1;
      temp2.Byte1 = temp2.Byte2;
      temp2.Byte2 = t;
      fwrite(&temp2, 2, 1, out);
      printf("4");
      image = calloc(FILECHK, 1);
      printf("5");
      if (image == NULL)
        {
        printf("Memory allocation of %lu bytes failed in do_image.\n", file_size);
        exit(1);
        }
      printf("6");
       //DosRead(hf,image,file_size,&rc);
      rc = fread(image, file_size, 1, img);
      printf("7");
      printf("There was %d chunk read.\n", rc);
      fwrite(image, file_size, 1, out);
      printf("8");
      free(image);
      printf("9");
      fclose(img);
      printf("0");
      }
    else
      {
      t = 0x04;
      fwrite(&t, 1, 1, out);
      t = 0x84;
      fwrite(&t, 1, 1, out);
      memcpy(&temp4, &file_size, 4);
      t = temp4.Byte1;
      temp4.Byte1 = temp4.Byte4;
      temp4.Byte4 = t;
      t = temp4.Byte2;
      temp4.Byte2 = temp4.Byte3;
      temp4.Byte3 = t;
      fwrite(&temp4, 4, 1, out);
      img = fopen(file, "rb");
      image = malloc(FILECHK);
      while (current_file_size < (file_size))
        {
        current_file_size += FILECHK;
        if (current_file_size > file_size)
          to_read = FILECHK-(current_file_size-file_size);
        else
          to_read = FILECHK;
        rc = fread(image, to_read, 1, img);
        printf("There were %u chunk of %u bytes read out of %lu::%lu.\n", rc, to_read, file_size, current_file_size);
        fwrite(image, to_read, 1, out);
        }
      free(image);
      fclose(img);
      }
    }
  DosClose(hf);
  fclose(img);
}
