/* BUILDcif.C */
/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

#include "buildcif.h"

/*****************************************************************************/
/*  Main module called as executable.  Two parameters are required for       */
/*  for executable to run to completion.  The first parameter is the file    */
/*  name for the LST file and the second parameter is that of the target     */
/*  cif file.                                                                */
/*****************************************************************************/

main(argc,argv,envp)
  int argc;
  char *argv[];
  char *envp[];
{
  char temp[80],a[80],b[80],c[80],*t2,*value;
  int i,j,f,foldleft,rc;
  USHORT src;

/* Checks for correct and accuracy of parameters */

  if (argc <= 2)
    {
    printf("Usage: buildcif file.lst file.cif E|A\a\n");
    printf("       specify E for output in EBCDIC\n");
    exit(1);
    }
  if ((out = fopen(argv[2], "wb")) == NULL)
    {
    printf("Error on opening file %s for writing.\a\n", argv[2]);
    exit(3);
    }

  if(argc==4)
  {
    if((argv[3][0]=='E')||(argv[3][0]=='e'))
    {
      EBCDIC='T';
    }
    else
    {
      EBCDIC='F';
    }
  }
  else
  {
    EBCDIC='F';
  }

  if(EBCDIC=='T')
  {
     sprintf(temp,"chngtext %s E",argv[1]);
     system(temp);
  }

  if ((in = fopen(argv[1], "r")) == NULL)
    {
    printf("Error on opening file %s for reading.\a\n", argv[1]);
    exit(2);
    }

/* Create head element in linked list. */

  head = malloc(sizeof(ELEMENT));
  head->data.flag = '*';                        /* This indicates start of */
  strcpy(head->data.file, "BEGINNING");         /* data stream             */
  tail = head;

/* Parse through the LST file and determine type of file DOC or FOLDER */

  while (fgets(temp, 80, in) != NULL)
    {
    f = 1;
    sscanf(temp, "%[^-]-%s", a, b);
    printf("File: %s \tType: %s\n", a, b);      /* trace info */
    rc = is_fol(a);
    if (rc == 1)
      {
      parse_fol(a);                             /* Parse FOLDER INX file */
      }
    else
      if (rc == 0)
        {
        parse_doc(a);                           /* Parse DOCUMENT INX file */
        }
      else
        {
        printf("Error opening %s - isfol().\n", a);       /* Not a folder or doc */
        return (-1);
        }
    }
  fclose(in);                                   /* Close LST file */

  tail->next = malloc(sizeof(ELEMENT));         /* Put end of stream tags in */
  tail = tail->next;                            /* linked list               */
  tail->next = NULL;
  tail->data.flag = '$';
  strcpy(tail->data.file, "END");

 /* This must be called before building the cif file.  This function builds  */
 /* several data structures that provide the attribute and class definitions */
 /* for the data stream.                                                     */

  do_classes(head);

 /* This is primarily called for trace data.  This function prints out a     */
 /* brief description of each item in the linked list.                       */

  print_list(head);

 /* This will actually build the cif file from the linked list and compiled  */
 /* class data.                                                              */

  build_cif(head);

 /* If the environment variable CIF_AUTO_DEL is set to YES then all source   */
 /* files (LST, INX & MDI) will be deleted.                                         */

  value = getenv("CIF_AUTO_DEL");
  if (value != NULL)
    {
    if (strcmpi(value, "YES") == 0)
      {
      del_files(head);                          /* Deletes all INX & MDI */
      src = DosDelete(argv[1], 0);              /* Deletes LST file */
      printf("Delete rc=%d on: %s\n", src, argv[1]);    /* Trace */
      }
    }
}

