/************************************************************************/
/*                                                                      */
/*      AS400IMP.CMD    Batch Import Sample for AS/400 Spool Files      */
/*      ----------------------------------------------------------      */
/*                                                                      */
/*      MODULE NAME  :  AS400IMP                                        */
/*      MODULE GROUP :  ImagePlus/2 EFP                                 */
/*      VERSION      :  01.20                                           */
/*      LANGUAGE     :  SAA-C                                           */
/*      VERSION DATE :  01/06/93                                        */
/*      LAST UPDATE  :  ---                                             */
/*                                                                      */
/************************************************************************/
/*                                                                      */
/*      (C) Copyright IBM Corp. 1993. All rights reserved.              */
/*                                                                      */
/************************************************************************/

'@echo off'                             ;/* no echo                     */
say ""

arg FileName                            ;/* first argument is filename  */

/************************************************************************/
/*      define import parameters                                        */
/************************************************************************/

DocCls = "PHARMACYREQUISITIONS"         ;/* OIM document class          */
VolNam = ""                             ;/* volume name                 */
VolSer = ""                             ;/* volume serial number        */
VolLoc = ""                             ;/* volume location             */
StgGrp = ""                             ;/* storage group               */
WbkNam = ""                             ;/* OIM workbasket name         */

/************************************************************************/
/*      define index field table                                        */
/************************************************************************/

IndTab.0 = 4                            ;/* number of index fields      */

/*      index field ---> CASE NUMBER                                    */
IndTab.1.Nam = "CASENUMBER"             ;/* ImagePlus/2 index field     */
IndTab.1.Row = 7                        ;/* index info starting row     */
IndTab.1.Col = 70                       ;/* index info starting column  */
IndTab.1.Len = 10                       ;/* index info length           */

/*      index field ---> REQUISITION NUMBER                             */
IndTab.2.Nam = "REQUISITIONNUMBER"      ;/* ImagePlus/2 index field     */
IndTab.2.Row = 10                       ;/* index info starting row     */
IndTab.2.Col = 21                       ;/* index info starting column  */
IndTab.2.Len = 10                       ;/* index info length           */

/*      index field ---> PATIENT NAME                                   */
IndTab.3.Nam = "PATIENTNAME"            ;/* ImagePlus/2 index field     */
IndTab.3.Row = 5                        ;/* index info starting row     */
IndTab.3.Col = 21                       ;/* index info starting column  */
IndTab.3.Len = 28                       ;/* index info length           */

/*      index field ---> DATE OF BIRTH                                  */
IndTab.4.Nam = "DATEOFBIRTH"            ;/* ImagePlus/2 index field     */
IndTab.4.Row = 5                        ;/* index info starting row     */
IndTab.4.Col = 70                       ;/* index info starting column  */
IndTab.4.Len = 10                       ;/* index info length           */

/************************************************************************/
/*      check parameters                                                */
/************************************************************************/

if FileName = "" then do
  say "ERROR: NO FILENAME GIVEN"
  exit 1
end

if "" = stream(FileName,"C","QUERY EXISTS") then do
  say "ERROR: INVALID FILENAME OR FILE NOT FOUND"
  exit 1
end

/************************************************************************/
/*      setup import option string                                      */
/************************************************************************/

OptStr = ""

if DocCls <> "" then OptStr = OptStr '"/D' || DocCls || '"'
if VolNam <> "" then OptStr = OptStr '"/V' || VolNam || '"'
if VolSer <> "" then OptStr = OptStr '"/S' || VolSer || '"'
if VolLoc <> "" then OptStr = OptStr '"/P' || VolLoc || '"'
if StgGrp <> "" then OptStr = OptStr '"/G' || StgGrp || '"'
if WbkNam <> "" then OptStr = OptStr '"/W' || WbkNam || '"'

/************************************************************************/
/*      get index information                                           */
/************************************************************************/

l = stream(FileName,"C","OPEN READ")
n = 0
do while 0 <> lines(FileName)
  l = linein(FileName)
  n = n + 1
  do i = 1 to IndTab.0
    if IndTab.i.Row = n then do
      a = strip(substr(l,IndTab.i.Col,IndTab.i.Len))
      a = "/A" || IndTab.i.Nam || "=" || a
      OptStr = OptStr '"' || a || '"'
    end
  end
end
l = stream(FileName,"C","CLOSE")

/************************************************************************/
/*      import file into ImagePlus/2                                    */
/************************************************************************/

"IP2IMPRT" FileName ":ASCII:" OptStr
if rc <> 0 then do
  say ""; say ""
  say "ERROR: IMAGEPLUS/2 IMPORT ERROR"
  exit rc
end

/************************************************************************/
/*      exit                                                            */
/************************************************************************/

say "SPOOLFILE SUCCESSFULLY IMPORTED INTO IMAGEPLUS/2"
exit 0

