**************************************************************************
*                                                                        *
*       IP2EFP.PRO      Profile for IP/2 Enhanced Function Package       *
*       ----------------------------------------------------------       *
*                                                                        *
*       MODULE NAME  :  ---                                              *
*       MODULE GROUP :  IP/2 EFP                                         *
*       VERSION      :  01.20                                            *
*       LANGUAGE     :  ---                                              *
*       AUTHOR       :  AKS                                              *
*       VERSION DATE :  93/06/01                                         *
*       LAST UPDATE  :  ---                                              *
*                                                                        *
**************************************************************************
*                                                                        *
*       (C) Copyright IBM Corp. 1993. All rights reserved.               *
*                                                                        *
**************************************************************************

**************************************************************************
*                                                                        *
*  This profile contains definitions for the ImagePlus/2 Extended        *
*  Function Package.                                                     *
*                                                                        *
*  Lines starting with an asteristik are treated as comments. Blank      *
*  lines are ignored. The maximum line length is 1024 characters.        *
*                                                                        *
*  The following definitions can be used in this profile :               *
*                                                                        *
**************************************************************************

**************************************************************************
*                                                                        *
*  FUNCTION:    Set empty index fields to predefined default value       *
*                                                                        *
*  SYNTAX:      FIELDSET        DocumentClass,FieldName,Value            *
*                                                                        *
*  After saving a document or folder of class <DocumentClass>, the index *
*  field <FieldName> will be set to the text string <Value>, if the user *
*  has left the field empty.                                             *
*                                                                        *
*------------------------------------------------------------------------*
*                                                                        *
*  FUNCTION:    Set empty index fields to predefined default value       *
*                                                                        *
*  SYNTAX:      FIELDCOPY       DocumentClass,FieldFrom,FieldTo          *
*                                                                        *
*  After saving a document or folder of class <DocumentClass>, the con-  *
*  tens of the index field <FieldFrom> will be copied to the index field *
*  <FieldTo>.                                                            *
*                                                                        *
*------------------------------------------------------------------------*
*                                                                        *
*  FUNCTION:    Lock index fields                                        *
*                                                                        *
*  SYNTAX:      FIELDLOCK       DocumentClass,FieldName                  *
*                                                                        *
*  The index field <FieldName> of a document or folder of class <Docu-   *
*  mentClass> is locked and can not be overwritten by the user.          *
*                                                                        *
*------------------------------------------------------------------------*
*                                                                        *
*  FUNCTION:    Automatically set index field to LAN user-ID             *
*                                                                        *
*  SYNTAX:      SETLANID        DocumentClass,FieldName[,DomainName]     *
*                                                                        *
*  After saving a document or folder of class <DocumentClass>, the index *
*  field <FieldName> will be set to the current LAN user-ID.             *
*  If a domain <DomainName> is given, the LAN user for that domain will  *
*  be set. If no domain is given, the local user ID will be used.        *
*                                                                        *
*------------------------------------------------------------------------*
*                                                                        *
*  FUNCTION:    Autostart workflow depending on index field contents     *
*                                                                        *
*  SYNTAX:      WFSTART         Workbasket,DocumentClass,FieldName,Value,*
*                               WorkFlow [,WorkFlow2 [,Workflow3 [,...]]]*
*                                                                        *
*  If a document or folder of class <DocumentClass> that contains the    *
*  text string <Value> in index field <FieldName> is routed to work-     *
*  basket <Workbasket>, the workflow <WorkFlow> will be started for that *
*  document.                                                             *
*  If more than one workflow is given, the documents will be distributed *
*  in a round-robin manner to the workflows given.                       *
*  For example, if the workflow list contains the workflows WF1, WF2 and *
*  WF3, WF1 will be started for the first document, WF2 for the second,  *
*  WF3 for the third, WF1 for the fourth, WF2 for the fifth and so on.   *
*  A workbasket name may be specified instead of the workflow names. In  *
*  this case the document will be routed to that workbasket.             *
*                                                                        *
**************************************************************************

**************************************************************************
*       SET INDEX FIELDS TO DEFAULT VALUES IF EMPTY                      *
**************************************************************************

*FIELDSET        "Customer","CustomerNo","9999"
*FIELDSET        "Customer","Comment","(No Comment)"

**************************************************************************
*       COPY INDEX FIELD CONTENTS                                        *
**************************************************************************

*FIELDCOPY       "Customer","ITEM_CREATE_DATE","Date Scanned"
*FIELDCOPY       "Customer","ITEM_CREATE_TIME","Time Scanned"
*FIELDCOPY       "Customer","CustomerNo","Copy"

**************************************************************************
*       LOCK INDEX FIELDS                                                *
**************************************************************************

*FIELDLOCK       "Customer","CustomerNo"

**************************************************************************
*       STORE LAN ID                                                     *
**************************************************************************

*SETLANID        "Customer","Clerk"
*SETLANID        "Customer","Clerk","DomainName"

**************************************************************************
*       AUTOSTART WORKFLOW DEPENDING ON INDEX FIELD CONTENTS             *
**************************************************************************

*WFSTART         "MailIn","Customer","CustomerNo","4711","WorkFlow4711"
*WFSTART         "MailIn","Customer","CustomerNo","0007","WorkFlow7"
*WFSTART         "MailIn","Customer","CustomerNo","*"   ,"Admin"

**************************************************************************
*       DISTRIBUTE DOCUMENTS TO A LIST OF WORKBASKETS                    *
**************************************************************************

*WFSTART         "WorkBasket1",,,,"Smith","Jones","Miller"
*WFSTART         "WorkBasket1",,,,"Ralf","Edi","Mike","Mike"

**************************************************************************
*       END OF IP2EFP.PRO                                                *
**************************************************************************

