**************************************************************************
*                                                                        *
*       IP2CD.PRO       IP/2 Coded-Data Class Definition Profile         *
*       --------------------------------------------------------         *
*                                                                        *
*       MODULE NAME  :  ---                                              *
*       MODULE GROUP :  IP/2 EFP                                         *
*       VERSION      :  01.20                                            *
*       LANGUAGE     :  ---                                              *
*       AUTHOR       :  AKS                                              *
*       VERSION DATE :  93/06/01                                         *
*       LAST UPDATE  :  ---                                              *
*                                                                        *
**************************************************************************
*                                                                        *
*  This profile contains class definitions for the IP/2 Coded Data       *
*  Content Class. The definition components are seperated by a comma.    *
*  Each component can optionally be included in double quotes.           *
*                                                                        *
*  NOTE:        The maximum profile record length is 2048.               *
*                                                                        *
*                                                                        *
*  Component    Type    Size    Description                              *
*  --------------------------------------------------------------------  *
*  CLASSNAME    STRING   127    class name                               *
*  IMPORTTYPE   STRING   1      import type :                            *
*                                <F>: single file                        *
*                                <N>: multiple files with same name      *
*                                <E>: multiple files with same extension *
*                                <D>: directory                          *
*                                <S>: subtree                            *
*  LISTMASK     STRING   255    list filter (wildcards allowed)          *
*                               list of filenames seperated by ';'       *
*  FILEMASK     STRING   255    import file filter (wildcards allowed)   *
*                               depending on IMPORTTYPE:                 *
*                                <F>: N/A                                *
*                                <N>: list of extensions seperated by ';'*
*                                <E>: list of names seperated by ';'     *
*                                <D>: list of filenames seperated by ';' *
*                                <S>: list of filenames seperated by ';' *
*  PROGRAMNAME  STRING   255    name of program to execute               *
*                               (DEFAULT: start command processor)       *
*  PROGRAMARGS  STRING   255    program argument string with parameters: *
*                                <%1>: objects full-qualified name       *
*                                <%2>: object name                       *
*                                <%3>: object drive and directory        *
*                                <%4>: coded-data class name             *
*  SESSIONTYPE  STRING   1      <D>-Default,<F>-FS,<V>-VIO,<P>-PM        *
*                               (OS/2 2.0: <S>-DOS/FS,<W>-DOS/WINDOWED)  *
*  SESSIONMODE  STRING   1      <D>-Default,<+>-MAX,<->-MIN,<I>-INVISIBLE*
*  WINDOWPARMS  INTEGER  4      window parameters (XPOS YPOS XSIZE YSIZE)*
*  BITMAPFILE   STRING   255    name of associated bitmap/icon file      *
*  DLLNAME      STRING   255    class support dynamic link library       *
*  IMAGEFORMAT  STRING   255    document-to-image conversion format      *
*                                <:ASCII:>      ASCII text files         *
*                                <:PPDS:>       PPDS files               *
*                                <FCABMODC>     MO:DCA files             *
*                                <FCABMOD2>     MO:DCA P/2 files         *
*                                <FCABTIFF>     TIFF files               *
*                                <name of IP/2 content class DLL>        *
*                                                                        *
**************************************************************************
*                                                                        *
*       (C) Copyright IBM Corp. 1993. All rights reserved.               *
*                                                                        *
**************************************************************************

"ASCII",   F,"*.*",        "*.*",    "E.EXE",      "%1",             D,D,"","IP2CD.BMP","",":ASCII:"
"KEDIT",   F,"*.*",        "*.*",    "KEDIT.EXE",  "%1 (width 1024", V,+,"","IP2CD.BMP","",":ASCII:"
"PMWORD",  N,"*.DOC",      "DOC",    "PMWORD.EXE", "%1",             D,D,"","IP2CD.BMP"
"EXCEL",   N,"*.XLS;*.XLM","XLS;XLM","EXCEL.EXE",  "%1",             D,D,"","IP2CD.BMP"
"AUDIO",   N,"*._AU",      "_AU;_AD","PMAUDIO.EXE","%1",             D,D,"","IP2CD.BMP"
"AVC",     D,"*.!AP",      "*.*",    "",           "/C IP2AVC %1 %2",F,D,"","IP2CD.BMP"

"PPDS",    F,"*.*",        "*.*",    "",           "",               D,D,"","IP2CD.BMP","",":PPDS:"
"MO:DCA",  F,"*.*",        "*.*",    "",           "",               D,D,"","IP2CD.BMP","","FCABMOD2"
"TIFF",    F,"*.*",        "*.*",    "",           "",               D,D,"","IP2CD.BMP","","FCABTIFF"

*"OIS",     F,"*.BMP;*.IMG;*.PCX;*.PIC;*.TIF","*.*","OIS.EXE","%1",D,D,"","IP2CD.BMP"
*"WINWORD", N,"*.DOC",      "DOC",    "WINOS2.COM", "WINWORD %1",S,I,"","IP2CD.BMP"
*"AMIPRO",  N,"*.SAM",      "SAM",    "WINOS2.COM", "AMIPRO %1", S,I,"","IP2CD.BMP"

