/************************************************************************/
/*                                                                      */
/*      EFPINST.CMD     ImagePlus/2 EFP Installation Procedure          */
/*      ------------------------------------------------------          */
/*                                                                      */
/*      MODULE NAME  :  EFPINST                                         */
/*      MODULE GROUP :  ImagePlus/2 EFP                                 */
/*      VERSION      :  01.20                                           */
/*      LANGUAGE     :  OS/2 REXX                                       */
/*      VERSION DATE :  01/06/93                                        */
/*      LAST UPDATE  :  ---                                             */
/*                                                                      */
/************************************************************************/
/*                                                                      */
/*      (C) Copyright IBM Corp. 1993. All rights reserved.              */
/*                                                                      */
/************************************************************************/
/*                                                                      */
/*  SYNTAX:  EFPINST import-drive [/NOCOPY]                             */
/*                                                                      */
/*  REQUIRES OS/2 2.0 REXX UTILITY LIBRARY <REXXUTIL.DLL>.              */
/*                                                                      */
/************************************************************************/

arg ImportDrive CopyFlag .
"@echo off"
signal off error

/************************************************************************/
/*      SET CONSTANTS                                                   */
/************************************************************************/

/*      constant definitions
*/
EfpPath                 = "IP2EFP"

IpsApplName             = "ImagePlus"
IpsKeyPath              = "Directory"
IpsIniName              = "FCABIPS.INI"
IpsCfgName              = "IP_CONFIGURATION"
IpsKeyType              = "MACHINE_TYPE"

TocName                 = "SYS\FCABCCLS.TOC"
TocBack                 = "SYS\FCABCCLS.BAK"
CdsDescription          = "CODED:DATA - Coded Data"
CdsDllName              = "IP2CDCC.DLL"

ConfigName              = "CONFIG.SYS"
ClientEnvVar            = "IP2IMP-VOLPATH"
ServerEnvVar            = "IP2IMP-VOLSPATH"
ClientPath              = "\"
ServerPath              = "\OMS_DATA\"

MsgFileName             = "EFPINST.MSG"
MessageUtilNotFound     = "EFP0001: Library <REXXUTIL.DLL> not found.",
                          "EFPINST requires OS/2 2.0 !" || "0d0a"x

/*      define message codes
*/
ErrorUtilNotFound       =       1
ErrorIpsNotInstalled    =       2
ErrorIpsIniNotFound     =       3
ErrorIpsIniCorrupted    =       4
ErrorInvalidDrive       =       5
ErrorFileCopy           =       6
ErrorTocNotFound        =       7
ErrorTocWrite           =       8
WarningCdsInstalled     =       9
WarningConfigNotFound   =       10
WarningDesktopInstall   =       11
InfoConfigUpdated       =       12
InfoInstalled           =       13
InfoRegisterCCls        =       14
MessageProgName         =       15
InfoUsage1              =       16
InfoUsage2              =       17

/************************************************************************/
/*      INITIALIZE                                                      */
/************************************************************************/

/*      get installation drive & path
*/
parse source . . ThisFile
InstPath = filespec("drive",ThisFile) || filespec("path",ThisFile)

/*      load Rexx Utility functions REXXUTIL
*/
call RxFuncAdd "SysLoadFuncs","RexxUtil","SysLoadFuncs"
signal on syntax name CheckFunc; call SysLoadFuncs
CheckFunc:signal off syntax
if (0 \= RxFuncQuery("SysIni"       )) |,
   (0 \= RxFuncQuery("SysDriveMap"  )) |,
   (0 \= RxFuncQuery("SysDropFuncs" )) |,
   (0 \= RxFuncQuery("SysGetMessage")) then do
  exit PrintMessage(ErrorUtilNotFound)
end

/*      get text strings from message file
*/
ProgName = SysGetMessage(MessageProgName,InstPath||MsgFileName)

/************************************************************************/
/*      CHECK FOR USAGE INFORMATION                                     */
/************************************************************************/

if ("" = ImportDrive) | ("?" = ImportDrive) then do
  rc = PrintMessage(InfoUsage1)
  rc = PrintMessage(InfoUsage2)
  exit -1
end

/************************************************************************/
/*      SEARCH FOR IPS DIRECTORY                                        */
/************************************************************************/

/*      get SF/2 install path from OS/2 INI file
*/
IpsPath = SysIni("BOTH",IpsApplName,IpsKeyPath)
if "ERROR:" = IpsPath then do
  exit PrintMessage(ErrorIpsNotInstalled)
end
if '00'x = right(IpsPath,1) then IpsPath = left(IpsPath,length(IpsPath)-1)
if "\"   = right(IpsPath,1) then IpsPath = left(IpsPath,length(IpsPath)-1)

/*      get installation environment from SF/2 INI file
*/
IpsIniName = IpsPath"\"IpsIniName
if "" = stream(IpsIniName,"C","QUERY EXISTS") then do
  exit PrintMessage(ErrorIpsIniNotFound,IpsIniName)
end
Type = SysIni(IpsIniName,IpsCfgName,IpsKeyType)
if "ERROR:" = Type then do
  exit PrintMessage(ErrorIpsIniCorrupted,IpsIniName)
end
if '00'x = right(Type,1) then Type = left(Type,length(Type)-1)
select
  when Type = "SERVER"      then Type = "S"
  when Type = "WORKSTATION" then Type = "W"
  when Type = "STANDALONE"  then Type = "A"
  otherwise exit PrintMessage(ErrorIpsIniCorrupted,IpsIniName)
end

/************************************************************************/
/*      CHECK IMPORT DRIVE                                              */
/************************************************************************/

if 1 = length(ImportDrive) then ImportDrive = ImportDrive || ":"
if 'W' = Type then DriveMap = SysDriveMap(,"REMOTE")
else               DriveMap = SysDriveMap(,"LOCAL")
if 0 = WordPos(ImportDrive,DriveMap) then do
  RetCode = PrintMessage(ErrorInvalidDrive,ImportDrive)
  exit RetCode
end

/************************************************************************/
/*      CHECK COPY FLAG                                                 */
/************************************************************************/

FileCopy = 1
if (translate(CopyFlag) = "/NOCOPY") then FileCopy = 0

/************************************************************************/
/*      COPY EFP FILES INTO IPS DIRECTORY                               */
/************************************************************************/

EfpPath = InstPath || EfpPath
if (translate(CopyFlag) <> "/NOCOPY") then do
  "XCOPY" EfpPath || "\*.*" IpsPath || "\*.* /S 1>NUL 2>NUL"
  if rc \= 0 then do
    exit PrintMessage(ErrorFileCopy,rc,IpsPath)
  end
end

/************************************************************************/
/*      IF SERVER OR STANDALONE UPDATE CONTENT-CLASS TOC FOR EFP CDS    */
/************************************************************************/

if (Type = "S") | (Type = "A") then do
  TocName = IpsPath"\"TocName
  TocBack = IpsPath"\"TocBack
  if "" = stream(TocName,"C","QUERY EXISTS") then do
    exit PrintMessage(ErrorTocNotFound,TocName)
  end
  InstFlag = 0
  LineText = stream(TocName,"C","OPEN READ")
  do while 0 <> lines(TocName)
    LineText = linein(TocName)
    parse var LineText . ";" DllName ";" .
    if translate(DllName) = CdsDllName then do
      InstFlag = 1
      rc = PrintMessage(WarningCdsInstalled,TocName,CdsDllName)
    end
  end
  LineText = stream(TocName,"C","CLOSE")
  if 0 = InstFlag then do
    "COPY" TocName TocBack "1>NUL 2>NUL"
    LineText = stream(TocName,"C","OPEN WRITE")
    LineText = stream(TocName,"C","SEEK <1")
    Count = lineout(TocName,CdsDescription || ";" || CdsDllName || ";;")
    if 0 \= Count then do
      exit PrintMessage(ErrorTocWrite,TocName)
    end
    call charout TocName,'1A'x
    LineText = stream(TocName,"C","CLOSE")
  end
end

/************************************************************************/
/*      UPDATE CONFIG.SYS                                               */
/************************************************************************/

if (Type = "S") | (Type = "A") then do
  ClientPath = ServerPath
  ServerPath = ""
end
ClientSet = "SET" ClientEnvVar || "=" || ImportDrive || ClientPath
ServerSet = "SET" ServerEnvVar || "=" || ServerPath
InstPath || "BOOTDRV"
if rc = 0 then BootDrive = "C"
else           BootDrive = d2c(rc + c2d("A") - 1)
ConfigName = BootDrive":\"ConfigName
if "" = stream(ConfigName,"C","QUERY EXISTS") then do
  rc = PrintMessage(WarningConfigNotFound,ConfigName)
  say "   " ClientSet
  say "   " ServerSet
end
else do
  LineText = stream(ConfigName,"C","OPEN WRITE")
  LineText = stream(ConfigName,"C","SEEK <0")
  Count = lineout(ConfigName," ")
  Count = lineout(ConfigName,"REM *** ImagePlus/2 EFP ***")
  Count = lineout(ConfigName,ClientSet)
  Count = lineout(ConfigName,ServerSet)
  Count = lineout(ConfigName,"REM ***********************")
  call charout ConfigName,'1A'x
  LineText = stream(ConfigName,"C","CLOSE")
  rc = PrintMessage(InfoConfigUpdated,ConfigName)
end

/************************************************************************/
/*      INSTALL EFP PROGRAMS ON DESKTOP                                 */
/************************************************************************/

SetupStr = "PROGTYPE=PM;EXENAME=" || IpsPath || "\BIN\IP2CDINP.EXE"
if 1 \= SysCreateObject("WPProgram",ProgName,"<WP_DESKTOP>",SetupStr) then do
  rc = PrintMessage(WarningDesktopInstall)
end

/************************************************************************/
/*      IF SERVER OR STANDALONE ADVICE USER TO REGISTER CONTENT-CLASS   */
/************************************************************************/

rc = PrintMessage(InfoInstalled)
if (Type = "S") | (Type = "A") then do
  rc = PrintMessage(InfoRegisterCCls)
end

/************************************************************************/
/*      TERMINATE                                                       */
/************************************************************************/

call SysDropFuncs
exit 0

/************************************************************************/
/*      SUBROUTINES                                                     */
/************************************************************************/

/************************************************************************/
/*      PrintMessage            print message                           */
/************************************************************************/

PrintMessage: procedure expose InstPath MsgFileName MessageUtilNotFound
  arg MsgCode,MsgParm1,MsgParm2

if "" = MsgParm1 then MsgParm1 = "%1"
if "" = MsgParm2 then MsgParm2 = "%2"
if 0 = RxFuncQuery("SysGetMessage") then do
  MsgText = SysGetMessage(MsgCode,InstPath||MsgFileName,MsgParm1,MsgParm2)
end
else MsgText = MessageUtilNotFound
if "" = MsgText then MsgText = "EFP" || right(MsgCode,4,"0") || ": ???"
say ""
call charout ,MsgText

return MsgCode

