/***************************************************************************/
/*REXX Exec to RESTORE IP/2 FROM REXX BACKUP COMMAND*/

/**************************************************************************/

/*************************************************************************/
/*CHECK FOR INITIAL PROFILE VALUES */

/*************************************************************************/ 

NEWDIR = DIRECTORY("C:\OS2")

EXIST = STREAM('PROFILE.BUR','C','QUERY EXISTS')

IF EXIST \= 'C:\OS2\PROFILE.BUR' THEN


   CALL SETPROF            /*TELL USER TO CREATE INITIAL PROFILE AND END PROGRAM*/
 
                                   /*GET VALUES FROM PROFILE */

RETURN = STREAM('PROFILE.BUR','C','OPEN')

 IP2DRIVE = LINEIN(PROFILE.BUR) 
 SFDB = LINEIN(PROFILE.BUR) 
 FCAEDB = LINEIN(PROFILE.BUR) 
 STAGING = LINEIN(PROFILE.BUR) 
 TODRIVE = LINEIN(PROFILE.BUR)
 BFAX = LINEIN(PROFILE.BUR) 
 GFAX = LINEIN(PROFILE.BUR) 
 SFDIR = LINEIN(PROFILE.BUR)    
 AFDIR = LINEIN(PROFILE.BUR)
 OMSD  = LINEIN(PROFILE.BUR) 
 

/*********************************************************************/

/* DEFAULTS                                                                             */
/*********************************************************************/


/*IP2DRIVE = C              */
/*SFDIR = IPS           */
/*AFDDIR = IMGPLUS    */
/*STAGING = C:\STAGING */
/*TODRIVE = A                */
/*BFAX = NO                  */
/*GFAX = NO                 */
/*OMSD = C                  */
/*SFDB = C                  */
/*FCAEDB = C               */

RETURN = STREAM('PROFILE.BUR','C','CLOSE')

/**************************************************************************/
/*STEP 1, SHUTDOWN IP/2 */
/**************************************************************************/

NEWDIR = DIRECTORY('C:\'SFDIR)

CALL STOPIT
/**************************************************************************/
/*STEP 2, RESTORE SYSTEM FILES*/
/**************************************************************************/

'RESTORE 'TODRIVE':'  IP2DRIVE':\'SFDIR'\FCABIPS.INI'
'RESTORE 'TODRIVE':'  IP2DRIVE':\'AFDIR'\FCAE.INI'
'RESTORE 'TODRIVE':  C:\CONFIG.SYS'
EXIST = STREAM(TODRIVE':\IBMLAN\IBMLAN.INI','C','QUERY EXISTS')

IF EXIST = TODRIVE':\IBMLAN\IBMLAN.INI' THEN

'RESTORE 'TODRIVE':  C:\IBMLAN\IBMLAN.INI'

     IF GFAX = YES  THEN
     'RESTORE 'TODRIVE':'  IP2DRIVE':\GAMMA\GFAX.$DC'
  
         IF BFAX = YES THEN
     'RESTORE 'TODRIVE':'  IP2DRIVE':\FXM\TBL\FXMPROF.PRF'


/*******************************************************************/
/* STEP 3; RESTORE OF DATABASES                                           */
/*******************************************************************/


   'RESTORE 'TODRIVE':' SFDB':\OMS\DATA'       /* RESTORING DBVISTA DATABASE*/
   'RESTORE ' TODRIVE':'  STAGING            /*RESTORE STAGING */
   'RESTORE 'TODRIVE':'  OMSD':\OMS_DATA'      /*BACKUP OF OBJECTS*/
   IF GFAX = YES THEN
     DO
      'RESTORE 'TODRIVE':'  IP2DRIVE':\FAX\GFAX.$QU'
      'RESTORE 'TODRIVE':'  IP2DRIVE':\FAX\*.TIF'
     END
   IF BFAX = YES THEN  
      'RESTORE 'TODRIVE':'  IP2DRIVE':\FXM'       /*DIRECTORY FOR IBM FAX*/


   SAY 'ENTER FIRST DISKETTE FOR APPLICATION FACILITY DATABASE BACKUP'
   SAY 'PRESS ENTER WHEN READY'
   PULL RESPONSE
   IF RESPONSE = '' THEN
   
    DO
      CALL DBM '-S'
      CALL DBM 'RESTORE DATABASE FCAEDB FROM ' TODRIVE      /*RESTORING FCAEDB */

    END


SAY 'RESTORE HAS ENDED'

 EXIT

/******************************************************************/
/* SUBROUTINE TO CREATE INITIAL PROFILE AND END BACKUPPROGRAM       */
/******************************************************************/

  SETPROF:


   SAY "MUST RE-CREATE INTITIAL BACKUP PROFILE FIRST."
   SAY "PLEASE ENTER 'IP2BACK' ON OS/2 SCREEN PROMPT."

   EXIT

