/***************************************************************************/
/*REXX Exec to Automate Backup for IP/2*/

/**************************************************************************/


   

/*************************************************************************/
/*CREATE INITIAL PROFILE VALUES */

/*************************************************************************/ 

NEWDIR = DIRECTORY("C:\OS2")

EXIST = STREAM('PROFILE.BUR','C','QUERY EXISTS')  /*CHECK FOR EXISTANCE OF BACKUP PROFILE*/

IF EXIST \= 'C:\OS2\PROFILE.BUR' THEN

   CALL SETPROF            /*TELL USER TO CREATE INITIAL PROFILE AND END PROGRAM*/

                                   /*GET VALUES FROM PROFILE */

RETURN = STREAM('PROFILE.BUR','C','OPEN')

 IP2DRIVE = LINEIN(PROFILE.BUR) 
 SFDB = LINEIN(PROFILE.BUR) 
 FCAEDB = LINEIN(PROFILE.BUR) 
 STAGING = LINEIN(PROFILE.BUR) 
 TODRIVE = LINEIN(PROFILE.BUR)
 BFAX = LINEIN(PROFILE.BUR) 
 GFAX = LINEIN(PROFILE.BUR) 
 SFDIR = LINEIN(PROFILE.BUR)    
 AFDIR = LINEIN(PROFILE.BUR)
 OMSD  = LINEIN(PROFILE.BUR) 
 
/*********************************************************************/

/* DEFAULTS                                                                             */
/*********************************************************************/

/*IP2DRIVE = C              */
/*SFDIR = IPS           */
/*AFDDIR = IMGPLUS    */
/*STAGING = C:\STAGING */
/*TODRIVE = A                */
/*BFAX = NO                  */
/*GFAX = NO                 */
/*OMSD = C                  */
/*SFDB = C                  */
/*FCAEDB = C               */

RETURN = STREAM('PROFILE.BUR','C','CLOSE')

/**************************************************************************/
/*Step 1; insure application is in stop or shutdown mode*/
/**************************************************************************/

NEWDIR = DIRECTORY('C:\'SFDIR)

CALL STOPIT

/**************************************************************************/
/*STEP 2, BACKUP SYSTEM FILES*/
/**************************************************************************/

'BACKUP' IP2DRIVE':\'SFDIR'\FCABIPS.INI 'TODRIVE':'
'BACKUP' IP2DRIVE':\'AFDIR'\FCAE.INI 'TODRIVE':  /a'
'BACKUP C:\CONFIG.SYS  'TODRIVE':  /a'
EXIST = STREAM('C:\IBMLAN\IBMLAN.INI','C','QUERY EXISTS')

IF EXIST = 'C:\IBMLAN\IBMLAN.INI' THEN

'BACKUP C:\IBMLAN\IBMLAN.INI 'TODRIVE':  /a'

IF GFAX = YES  THEN
  'BACKUP' IP2DRIVE':\GAMMA\GFAX.$DC      'TODRIVE':  /a'
  

IF BFAX = YES THEN
   'BACKUP' IP2DRIVE':\FXM\TBL\FXMPROF.PRF       'TODRIVE':  /a'
  
/*******************************************************************/
/* STEP 3; FULL BACKUP OF DATABASES                                           */
/*******************************************************************/

'BACKUP 'SFDB':\OMS\DATA   'TODRIVE':  /a'    /* BACKING UP DBVISTA DATABASE*/
'BACKUP 'STAGING  TODRIVE': /a'
'BACKUP 'OMSD':\OMS_DATA   'TODRIVE': /a'   /*BACKUP OF OBJECTS*/
IF GFAX = YES THEN
DO
  'BACKUP  'IP2DRIVE':\FAX\GFAX.$QU     'TODRIVE': /A'
  'BACKUP  'IP2DRIVE':\FAX\*.TIF            'TODRIVE':   /A'
END

IF BFAX = YES THEN  
  'BACKUP 'IP2DRIVE':\FXM    'TODRIVE': /A'    /*DIRECTORY FOR  IBM FAX*/

SAY 'READY TO BEGIN BACKUP OF APPLICATION FACILITY DATABASE'
SAY 'INSERT BLANK DISKETTE AND PRESS ENTER WHEN READY'
PULL RESPONSE
IF RESPONSE = '' THEN
DO
  CALL DBM '-S'
  CALL DBM 'BACKUP DATABASE FCAEDB ALL TO ' TODRIVE      /*BACKUP FCAEDB */
END


SAY 'BACKUP HAS ENDED'

 EXIT

/******************************************************************/
/* IF NO INITIAL PROFILE EXISTS       */
/******************************************************************/

  SETPROF:

   SAY "MUST CREATE INTITIAL BACKUP PROFILE FIRST."
   SAY "PLEASE ENTER 'IP2BACK' ON OS/2 SCREEN PROMPT."

   EXIT

