@echo off
rem *-------------------------------------------------------------------------*
rem *  Module   :  FCABFLST.CMD                                               *
rem *                                                                         *
rem *  Copyright:  5696-125 (5042) - (C) Copyright IBM Corp. 1991             *
rem *              All Rights Reserved                                        *
rem *                                                                         *
rem *  NOTE:  The intended user for this program is the IBM Systems Engineer  *
rem *         (SE) or the customer.                                           *
rem *                                                                         *
rem *  This command file generates a list of all files in the ImagePlus/2     *
rem *  (Services Facility and Application Facility) subdirectory.  By         *
rem *  default, the Services Facility/2 subdirectory is C:\IPS; the           *
rem *  Application Facility/2 subdirectory is C:\IMGPLUS.                     *
rem *                                                                         *
rem *  The file list is placed in a file called FCABFLST.LST, and includes    *
rem *  the file name, date, time, size and checksum.                          *
rem *                                                                         *
rem *  This command file must be given the path to the ImagePlus Services     *
rem *  Facility/2 subdirectory and the path to the ImagePlus Application      *
rem *  Facility/2 subdirectory.  It will inspect all files in these           *
rem *  directories, and in each standard subdirectory of it (that is, those   *
rem *  created by the install program).  The command file will not record     *
rem *  any additional subdirectories you have created.                        *
rem *  The syntax for this command file is explained towards the end of this  *
rem *  file, in the help section.                                             *
rem *-------------------------------------------------------------------------*

cls

rem Display the copyright information
rem The line below is 'echo 0xFF' to force a blank line in the output.
echo 
echo 
echo IBM SAA ImagePlus/2 Software Identification Diagnostic Tool
rem The line below is 'echo 0xFF' to force a blank line in the output.
echo 
echo (C) Copyright IBM Corp. 1991
echo All Rights Reserved
rem The line below is 'echo 0xFF' to force a blank line in the output.
echo 

rem Check to make sure the correct parameters were entered
if %1. == .   goto :help
if %1  == ?   goto :help

rem If an old version of the output file exists, delete it
if exist fcabflst.lst attrib -r fcabflst.lst
if exist fcabflst.lst del fcabflst.lst

rem Identify that I'm doing something
rem echo Generating FCABFLST.LST, please wait...

rem ***** ImagePlus Services Facility/2
echo ...Searching ImagePlus Services Facility/2 (%1)
for %%x in ( %1\*.* ) do fcablvl %%x >> fcabflst.lst

echo    ...identifying files in %1\BIN
for %%x in ( %1\bin\*.* ) do fcablvl %%x >> fcabflst.lst

echo    ...identifying files in %1\DLL
for %%x in ( %1\dll\*.* ) do fcablvl %%x >> fcabflst.lst

echo    ...identifying files in %1\SYS
for %%x in ( %1\sys\*.* ) do fcablvl %%x >> fcabflst.lst

echo    ...identifying files in %1\HELP
for %%x in ( %1\help\*.* ) do fcablvl %%x >> fcabflst.lst

echo    ...identifying files in %1\BOOKS
for %%x in ( %1\books\*.* ) do fcablvl %%x >> fcabflst.lst

echo    ...identifying files in %1\TOOLKIT\INCLUDE
for %%x in ( %1\toolkit\include\*.* ) do fcablvl %%x >> fcabflst.lst

echo    ...identifying files in %1\TOOLKIT\LIB
for %%x in ( %1\toolkit\lib\*.* ) do fcablvl %%x >> fcabflst.lst

rem ***** ImagePlus Application Facility/2
echo ...Searching ImagePlus Application Facility/2 (%2)
for %%x in ( %2\*.* ) do fcablvl %%x >> fcabflst.lst

echo    ...identifying files in %2\BIN
for %%x in ( %2\bin\*.* ) do fcablvl %%x >> fcabflst.lst

echo    ...identifying files in %2\DLL
for %%x in ( %2\dll\*.* ) do fcablvl %%x >> fcabflst.lst

echo    ...identifying files in %2\BIND
for %%x in ( %2\bind\*.* ) do fcablvl %%x >> fcabflst.lst

echo    ...identifying files in %2\HELP
for %%x in ( %2\help\*.* ) do fcablvl %%x >> fcabflst.lst

echo    ...identifying files in %2\BOOKS
for %%x in ( %2\books\*.* ) do fcablvl %%x >> fcabflst.lst

echo    ...identifying files in %2\TOOLKIT\INCLUDE
for %%x in ( %2\toolkit\include\*.* ) do fcablvl %%x >> fcabflst.lst

echo    ...identifying files in %2\TOOLKIT\LIB
for %%x in ( %2\toolkit\lib\*.* ) do fcablvl %%x >> fcabflst.lst

echo File list FCABFLST.LST has been generated, now sorting...

rem Sort the results
sort < fcabflst.lst > fcabflst.srt
del fcabflst.lst
ren fcabflst.srt fcabflst.lst
echo File list FCABFLST.LST has been sorted.
rem The line below is 'echo 0xFF' to force a blank line in the output.
echo 
echo Process completed.

goto :done

:help
echo Usage: FCABFLST ServicesFacility/2Path ApplicationFacility/2Path
rem The line below is 'echo 0xFF' to force a blank line in the output.
echo 
echo where  ServicesFacility/2Path    is the path to ImagePlus Services Facility/2
echo        ApplicationFacility/2Path is the path to ImagePlus Application Facility/2
rem The line below is 'echo 0xFF' to force a blank line in the output.
echo 
echo NOTE:  This command file creates 1 output file--FCABFLST.LST.  Please send
echo        this output file to your IBM ImagePlus/2 Support Personnel when
echo        requested.
:done
