IBM SAA ImagePlus/2 Product Refresh
Corrective Service Diskette (CSD) UR1400
(C) Copyright IBM Corp. 1991, 1993

Program Number: 5696-125


===========================
IBM SAA IMAGEPLUS/2 UPDATES
===========================


This file contains information about installing and using ImagePlus/2
Product Refresh Corrective Service Diskettes (CSD) UR1400. Use this
information to supplement your existing documentation.

CSD UR1400 is a complete refresh of the product and includes all updates
that were delivered on previous CSDs. If you are a new ImagePlus/2
customer, refer to the "IBM SAA ImagePlus/2 Installation Guide" for
installation prerequisites.
:p.If you have an existing ImagePlus/2 system and you haven't already
upgraded your database using CSD UR1260 or CSD UR1300, ensure that
you do so prior to installing CSD UR1400. Please refer to Part I.
Sections C and D of this document entitled "Upgrading your
Services Facility/2 Database" and "Upgrading your Application
Facility/2 Database".



TABLE OF CONTENTS
----------------------------------------------------------

Part I.    Updates and Installation/Configuration Information
           A.  Summary of Enhancements in CSD UR1400
           B.  Before Installing CSD UR1400
           C.  Upgrading your Services Facility/2 Database
           D.  Upgrading your Application Facility/2 Database
           E.  IBM FaxConcentrator Adapter/A Card
           F.  General Installation and Configuration Information

Part II.  Updates to Application Program Interfaces (APIs)
           A.  Services Facility/2 API Updates
           B.  Application Facility/2 API Updates

Part III.  Updates to Data Structures and Enumerated Types
           A.  Services Facility/2 Data Structures and Enumerated Types Updates

Part IV.   Important Reminders
           A.  Storage Planning Guidelines
           B.  Opening Unindexed Documents
           C.  Working with Real Data Values
           D.  Changing Printer Definitions Under OS/2


           Trademarks
-----------------------------------------------------------



PART I.  Updates and Installation/Configuration Information
======================================================================


A.     Summary of Enhancements in CSD UR1400
       =====================================

       o  IBM SAA ImagePlus Store and Retrieve/2

             Store and Retrieve Facility/2 is an image processing
             application that performs functions on image data such as
             receiving data from multiple sources and viewing,
             managing and retrieval of that data. It has an easy-to-use
             interface which is integrated with the OS/2 2.0 desktop.

       o  Install/2 and Preconfiguration

             CSD UR1400 now provides an automated installation of
             ImagePlus/2 through the use of Install/2. This allows
             for an more streamlined installation procedure and also
             provides an optional preconfiguration procedure that lets
             you do the following:
                - define up to 5 users (the program defines a workbasket
                    for each user)
                - define an index class for your application
                - identify an attached scanner or facsimile device,
                    or both

       o  Enhanced Multiple Document Viewing Feature

             CSD UR1400 includes support that allows multiple documents
             and folders to be opened an viewed within a single new
             window called a List window. This capability allows you to
             select multiple documents and folders and begin working on
             the first one as soon as it is opened. This new function
             allows your business to process documents more efficiently,
             since it takes significantly less time to open an item in
             this manner.

       o  One-Item Table of Contents Display Feature

             CSD UR1400 includes support for allowing the customer
             to decide whether or not to display a Table of Contents
             (TOC) as a result of a fileroom search or a list of
             checked out items.

       o  Optional support for suppressing the header page with all print jobs

       o  Global PM Printer Support

       o  Polaroid CI700 Color Printer Support

       o  Polaroid CS500 Color Scanner Support

       o  Services Facility/2 Toolkit Modifications

          -  IPSI2DEF.H

             The size of the szProfile_Desc member of the SCAN_PARM structure
             was changed to szProfile_Desc[MAX_DESC_SIZE+1].  The size of this
             member is correctly shown in the IBM SAA ImagePlus Services
             Facility/2 Programming Reference (SC28-8177).


       o  Updates to data structures and enumerated types

          The documentation on data structures and enumerated types have
          been clarified. See Part III, "Updates to Data Structures and
          Enumerated Types," for more information.

       o  In addition, the following announced products are supported:
               OS/2 Version 2.1
               DB2/2
               Lan Server/Requester Version 3.0
               Support for the following Optical Devices:
                    - 3431
                    - 3995 (023)
                    - 3995 (A23)
               Extended Services Version 1.0
               IBM FaxConcentrator Adapter/A
               GammaLink 4.5


B.     Before Installing CSD UR1400
       ============================

       Before you install CSD UR1400, make sure that:

       o   One of the following versions of OS/2 is installed:

           -  OS/2 Version 2.0 or later, with the latest available level
              of corrective service.

       o   If you have an existing ImagePlus/2 system, you must ensure
           the following:

           - If you have not already upgraded your databases using
           CSD UR1260 or CSD UR1300, you need to do so prior to
           installing CSD UR1400.

           - You have backed up your existing ImagePlus/2 databases.

           For information about backing up your databases, refer to
           the "IBM SAA ImagePlus/2 System Administration Guide".

           - You have ended all ImagePlus/2 programs.

           To properly install and initialize ImagePlus/2, you must
           end all ImagePlus/2 programs before installing CSD UR1400.

           - You have removed any IBM 4216 printer from your system
           configuration.

           Use the Services Administration program to remove the
           4216 printer from the configuration as this printer is
           supported exclusively through OS/2.

           - You have first shut down, then re-started OS/2.


C.     Upgrading Your Services Facility/2 Database
       ===========================================

       If you installed CSD UR1260 and have upgraded your databases
       or you are installing UR1400 as a new install, this section
       does not apply.

       If you have not upgraded you database using CSD UR1260 or
       CSD UR1300, you must do so. During installation of the above
       CSDs, the Services Facility/ 2 database is upgraded and
       reorganized to improve performance. In addition to upgrading
       database, several of the Services Facility/2 database
       executable files are also upgraded.

       The upgrade process will take approximately 7 minutes for
       every 10,000 objects in your database.  The time required
       will vary depending upon the size and complexity of your
       database, as well as the size and speed of your machine.

       After the upgrade program is run on the server, install CSD
       UR1400 on the workstations using the normal network-based
       installation procedure.  If the database upgrade is run on the
       server after CSD UR1400 is installed on the workstations, you
       must reinstall the CSD on the workstations.

       NOTES:

       1.  Prior to upgrading your database, ensure that no users
           are signed on to ImagePlus/2.

       2.  To complete successfully, the FCABUPG program must
           have sufficient DASD available on the same logical disk
           partition where the database resides.  You should sum the file
           sizes for all files under the Services Facility/2 database path
           (\OMS\DATA by default).  For large databases (25,000 objects or
           more), you will need at least 3 times that amount in available
           DASD;  for small databases (under 25,000 objects), you will need
           at least 5 times that amount in available DASD.  This space
           should be made available before CSD UR1400 is installed.  The
           space is released by the program after the upgrade is completed.

       3.  If the FCABUPG program fails, restore your backup
           copy of the Services Facility/2 database and attempt
           to run the upgrade manually by typing the command,
           FCABUPG, from the subdirectory where Services Facility/2
           is installed.  If this also fails, contact your IBM
           service representative.


D.     Upgrading Your Application Facility/2 Database
       ==============================================

       If you installed CSD UR1260 and have upgraded your databases
       or you are installing UR1400 as a new install, this section
       does not apply.

       If you have not upgraded you database using CSD UR1260 or
       CSD UR1300, you must do so. During installation of the above
       CSDs, the Application Facility/ 2 database is upgraded and
       reorganized.
       The upgrade process does not delete any existing data or modify any
       of your previous system settings with the following exceptions:

                 o  The KDMS.LOCK_MGR table is deleted.
                 o  The KDMS.DB_USERS table is deleted.
                 o  The KDMS.HL_ENTRIES table is renamed
                    KDMS.HLOG_ENTRIES.
                 o  Some table indexes are modified.
                 o  The "Time Received" data field is added to the "Not
                    Indexed" index class.  The value of the field will
                    be the time the document was entered in the system.

       If you have previously installed CSD UR1220, the database
       reorganization will take about 3 minutes for every 10,000
       objects in your database.

       If the upgrade program does not complete successfully during
       installation, you can run the program manually after CSD UR1400
       is installed.  To run the program, type the command, FCAEUPG,
       from the subdirectory where Application Facility/2 is installed.

       NOTE:  If you have not previously installed CSD UR1220, the
       upgrade process will change the name of the KDMS.CONFIG table
       to KDMS.PROFILE and will take about 35 minutes for every 10,000
       objects in your database.


E.     IBM FaxConcentrator Adapter/A (FCA/A) Card
       ==========================================

       ImagePlus/2 now supports the IBM FCA/A Card.  This section,
       along with Appendix E in "IBM SAA ImagePlus/2 Installation
       Guide" provides guidelines for installing and using this card.

       1.  Checking the New Subdirectories for the FCA/A Card

           To support the IBM FCA/A Card, the following subdirectories
           were added to the Services Facility/2 installation path:

                   - \FAX
                   - \FAX\SVR
                   - \FAX\SVR\TMPPAGES
                   - \FAX\REQ

           After you install CSD UR1400 on the server, re-apply the
           Services Facility/2 alias to ensure that the subdirectories
           are recognized by the workstation.  See the OS/2 LAN
           Server Network Administrator's Guide for instructions on
           how to apply access profiles.  After you apply the access
           profile, install the CSD on the workstations using the normal
           network-based workstation installation procedure.


F.     General Installation and Configuration Information
       ==================================================

       The following guidelines apply when you are installing
       CSD UR1400:

       1.  Locked Scanner Message (IBM 2456 Scanner)

           The following message may appear during installation of
           CSD UR1400:

                Unable to copy file EXY24.MSG

           This message results when the IBM 2456 scanner is locked by
           the device driver.  Complete the following steps to solve
           this problem:

             a. Edit CONFIG.SYS and change the line DEVICE=EXY24.SYS
                to REM DEVICE=EXY24.SYS.

             b. Shut down, then re-boot your system.

             c. Install CSD UR1400 ImagePlus/2 System.

             d. After installation is completed, edit your CONFIG.SYS
                file and change the REM DEVICE=EXY24.SYS command back to
                DEVICE=EXY24.SYS.

             e. Save the CONFIG.SYS file and re-boot your system.

       2.  Limitation on IBM 2456 Scanner width

           Currently, the IBM 2456 Scanner does not allow a scan width
           of 11.7" with a DPI of 400.  If you select these settings,
           the image will not be scanned.





Part II.  Updates to Application Program Interfaces (APIs)
=====================================================================

This section summarizes the new and updated APIs included in CSD
UR1400. Contact your IBM service representative
for detailed information about the new APIs.  This section also includes
corrections to the API documentation.

A.     Services Facility/2 API Updates
       ===============================
       DevMgrFastQueryVolume SPI:
          This new SPI can be used in place of the DevMgrQueryVolume
          SPI to determine the availability of a specified volume.
          Use the DevMgrFastQueryVolume SPI when you do not need
          complete information about the volume, such as its full path
          name, its size, and the amount of space left on the volume.

       IpsCatalogObject and IpsCatalogClsObject APIs:
          These API functions allocate file space for the object being
          cataloged.

       IpsCreateClsObject API:
          The IpsCreateClsObject API allows a value of null for the
          idStgClass parameter.  The null value specifies that the
          object is created in the first storage class defined in the
          management class for the specified storage group.

       IpsInit API:
          The IpsInit API is applicable only to Presentation Manager
          programs.  The function establishes a Presentation Manager
          message queue, and performs initialization processing
          required for other Services Facility/2 functions.  A call to
          this function from a program other than a Presentation
          Manager program causes a runtime error.

       IpsPanDspPage API:
          The parameter xPixels defines horizontal panning distance
          for a displayed page by specifying the number of pixels that
          the image shifts horizontally.  A positive value shifts the
          image right; a negative value shifts the image left.  The
          parameter yPixels defines the vertical panning distance by
          specifying the number of pels that the image shifts
          vertically.  A positive value shifts the image down; a
          negative value shifts the image up.

       IpsQueryDspPageAttrs API:
          If the IpsQueryDspPageAttrs API function is issued after a
          zoom the returned page attribute values will not correctly
          reflect the attributes of the page until after an
          IpsDisplayPage API has been issued.


       IpsQueryObjCls API:
          In addition to the already documented return values, this
          function can also return the following code in the sRC field
          of an RCSTRUCT data structure:

          Code  Message
          02182 ERROR_SESSION_NOT_CONNECTED

          This can be caused by one of the following reasons:
             (1) The function was unable to connect with the server
                 because the server is not responding.  Ensure that:
                    - The function parameters contain valid values.
                    - The server is operating correctly.
                    - The LAN cable connectors are properly attached at the
                      server or workstations and the host system.
             (2) Other operations are currently processing at the
                 server and the OS/2 function returned a time-out message.
                 A time-out message is corrected by performing one of the
                 following actions:
                    - Delete some of the operations currently processing or
                      wait until several operations are complete before
                      calling the function again.
                    - Increase the LAN time-out value in the LAN configuration
                      file.  Note:  You may need to consult your system
                      administrator to change the LAN configuration file.

       IpsQueryPageAttrs API:
          The new IpsQueryPageAttrs API is modeled after the
          IpcQueryNormPageAttrs content class support function.  Both
          functions return attribute information for a page.  The
          parameters for the new API are as follows:

             hPage - page handle.

             fOptions - function control option flags

             hSync - semaphore/window identifier for synchronization

             usMsgID - window message identifier for synchronization

             pRC - pointer to return data structure

       IpsQuerySplDevs API:
          If IpsQuerySplDevs is called on a server and the spool
          device is local, the API now returns IPS_LOCAL_SERVER
          as the value for usLocation in the DEVINFSTRUCT structure.
          Previously, this API returned the value IPS_LOCAL.


       IpsStartPageScan API:
          In addition to the already documented return values, this
          function can also return the following code in the sRC field
          of an RCSTRUCT data structure:

          Code  Message
          00122 WARNING_FEED_TRAY_IS_EMPTY

          This can be caused by the automatic document feed was empty.
          Load the automatic document feed and call the function again.

For further information on the above APIs, refer to the "IBM SAA
ImagePlus/2 Services Facility/2 Programming Guide" (SC28-8176-02).

B.     Application Facility/2 API Updates
       ==================================
       OimGetWorkBasketInfo API:
          OimGetWorkBasketInfo no longer returns a count for the number
          of items in a workbasket.  The count was previously returned
          to the usParam field in an RCSTRUCT data structure.  The count
          of the number of items in a workbasket can be obtained through
          the new OimTOCCount API.

       OimGetWorkFlowInfo API:
          OimGetWorkFlowInfo no longer returns a count for the number
          of items in a workflow.  The count was previously returned
          to the usNbrItemsinWf element of the WFINFOSTRUCT data
          structure.  The count of the number of items in a workflow
          can be obtained through the OimXrefWorkFlow API.

       OimSearch API:
          OimSearch accepts wildcard characters in any attribute value
          that has a data type of OIM_STRING.  Use the following as
          wildcard characters:

            % (percent) to indicate multiple characters
            _ (underscore) to indicate a single character.

       OimTOCCount API:
          OimTOCCount returns a count of the number of items in the
          table of contents of the specified workbasket or folder.
          The count includes all documents or folders that match the
          specified search criteria.  Use this function when you need
          only a count rather than a complete list of those items.


       OIM Profile APIs:
       With the following APIs, you can store application-specific
       data in the OIM database.  These APIs are intended for
       applications where custom code is developed for user exits
       or that use the ImagePlus/2 APIs to implement a custom
       application.  For example, you could use these APIs to
       supplement the information contained in the OIM profile
       table by storing information describing defined workbaskets.

       These APIs also isolate the application from any
       dependencies on the database implementation.

       These new OIM API functions enable you to write configuration
       values to the OIM database, read those values from the
       database, or retrieve a complete or selected list of values:


         OimProfileWriteString API:
            OimProfileWriteString associates a value string with an
            application name-key name pair and stores the value
            in the OIM profile table as a user value.  You can use this
            function to add a value to the database, or to update or
            remove an existing value.

         OimProfileReadString API:
            OimProfileReadString retrieves the value string currently
            associated with an application name-key name pair and
            copies the value to a user buffer.  You can retrieve
            either a user value or a system value maintained by
            Application Facility/2.

         OimProfileEnumerate API:
            OimProfileEnumerate retrieves a list of application names
            or a list of the key names associated with a particular
            application name.  The function also returns the number of
            strings in the list.  You can retrieve either a list of user
            values or a list of system values maintained by
            Application Facility/2.

For further information on the above APIs, refer to the "IBM SAA
ImagePlus/2 Application Facility/2 Programming Guide" (SC28-8184-02).


Part III. Updates to Data Structures and Enumerated Types
=====================================================================

This section summarizes the updated data structures and enumerated types
included in CSD UR1300 and CSD UR1400.

A.     Services Facility/2 Data Structures and Enumerated Types Updates
       ================================================================

       VOLENTRYSTRUCT structure:
          The value returned in the ulObjCount field indicates whether
          any objects exist in the storage group and volume.  If there
          is at least 1 object, then a 1 is returned regardless of the
          true number of objects; otherwise, a 0 is returned.

          The description of this field is accurate in the
          IpsQueryObjectStgGroup API.  However, it is incorrect in the
          VOLENTRYSTRUCT structure description in Appendix A of the
          IBM SAA ImagePlus Services Facility/2 Programming Reference.

          If you are wanting to get the number of objects that reside on
          a volume, you should use the IpsQueryVolumeObjects API.  This
          API also allows you to restrict the list of objects to those
          belonging to a specified storage group.


Part IV. Important Reminders
====================================================================


A.     Storage Planning Guidelines
       ===========================

       o  Allow for growth when planning your system

          It is important to plan your system to allow for growth and the
          migration of objects to different types of media.  This is
          especially crucial because of the following design
          characteristics of Services Facility/2:

          -  Storage classes within a storage group cannot be removed
             or added.

          -  Management classes once defined cannot be modified.

          -  The assignment of a management class to a storage group
             cannot be changed.

          To minimize problems resulting from these design constraints,
          define management classes that include large, less accessible
          storage media as the final storage location for your objects.
          For example, management classes that include optical storage
          media as the last storage class allow for migration of objects
          no longer needed on a frequent basis.  Do not use the
          system-supplied management class (NO_MANAGE) or the DEFAULT
          storage group for real applications because this class and
          this group permanently store all objects on DASD.

       o  Move your volumes as your business grows

          As your business grows and you add additional storage devices,
          you can move your stored objects by completing the following
          steps.

           1. Define a new management class and storage group with the
              expanded set of required storage classes.  Define the new
              storage group like the old one, with new storage classes
              on the end.  Use the original volumes in the new storage
              group.

           2. Modify your application to begin using the new storage
              group.  With ImagePlus Application Facility/2, this
              entails changing the storage group assigned to the index
              class(es) of the objects.

           3. Move all existing objects from the original storage group
              to the new storage group.  Your IBM support representative
              can assist you in writing a small utility to accomplish
              this using the following Services Facility/2 and
              Application Facility/2 API calls:

                    IpsQueryObjectStgGroup
                    IpsQueryVolumeObjects
                    IpsChangeObjectStgGroup
                    OimSearch
                    OimItemSnapshot
                    OimGetTOC

B.     Opening Unindexed Documents
       ===========================

       If you open an unindexed document after working with indexed
       documents, the index class of the document you previously opened
       appears as the value of the Class field on the index form for
       the current document.  This function allows you to efficiently
       index a series of documents of the same class without having
       to retype the index class.

       If you want to index the current document with a different class,
       type the new class in the Class field on the Index Form window.
       If you are not yet ready to index the document, leave the class
       name of the previous document in the Class field and select
       no on the message window that asks if you want to save the
       changes.  If you made changes to the document, the changes will
       not be saved.


C.     Working with Real data values
       =============================

       Real data values are converted to scientific notation within
       ImagePlus/2.  For large values this may result in a loss of
       precision since digits beyond the 15th decimal place are
       truncated.


D.     Changing Printer Definitions Under OS/2
       =======================================

       Before changing any printer which has been configured under
       the ImagePlus/2 Services Facility Configuration support, the
       printer should first be deleted from the ImagePlus/2 Services
       Facility configuration.  The printer may be reconfigured within
       ImagePlus/2 after the changes to the OS/2 printer definition
       have been made.  The following changes require that the printer
       be deleted from ImagePlus/2 prior to the change being made within
       the OS/2 operating system:

           * Changing the printer's Output Port
           * Changing the printer's OS/2 Queue Name
           * Deleting the printer from OS/2



Trademarks
=======================================================================


       IBM, ImagePlus, SAA, PS/2, and OS/2 are registered
       trademarks of International Business Machines Corporation.

       Kodak is a registered trademark of Eastman Kodak Company.
       Microsoft is a registered trademark of Microsoft Corporation.
       GammaFax is a registered trademark of GammaLink.
       Sony is a registered trademark of Sony.

---------------------------END OF UPDATES---------------------------
