	INCLUDE REGS386.INC
        INCLUDE TRANS.INC

	.386p

DGROUP group _DATA

_DATA segment word public 'DATA' use16
	extrn _cs16real: word
	extrn _ds16real: word
	_ts TRANS  <>		      ; translation struct for r-mode switch
	goProtectMode	dd	?     ; Location of far call routine
_DATA ends

_TEXT segment byte public 'CODE' use16
        assume cs:_TEXT,ds:DGROUP

;
;	void RealModeSwitch(void)
;
public	_RealModeSwitch
_RealModeSwitch proc near
	pop	bx			;Where to return from this procedure

	movzx	ebx, bx
	movzx	esi, si
	movzx	edi, di
	movzx	ebp, bp
	mov	dword ptr _ts.T_EBX, ebx
	mov	dword ptr _ts.T_ESI, esi
	mov	dword ptr _ts.T_EDI, edi
	mov	dword ptr _ts.T_EBP, ebp

	mov	word ptr _ts.T_SP, sp
	mov	word ptr _ts.T_IP, offset _TEXT:@@realModeEntry
	mov	word ptr _ts.T_FLAGS, 0202h
	mov	ax, _cs16real
	mov	word ptr _ts.T_CS, ax
	mov	ax, _ds16real
	mov	word ptr _ts.T_DS, ax
	mov	word ptr _ts.T_ES, ax
	mov	word ptr _ts.T_SS, ax

	xor	ebx, ebx
	xor	ecx, ecx
	push	ds
	pop	es
	mov	di, offset DGROUP:_ts
	movzx	edi, di
	mov	ax,0301h
	int	31h

	mov	esi, dword ptr _ts.T_ESI
	mov	edi, dword ptr _ts.T_EDI
	mov	ebp, dword ptr _ts.T_EBP
	mov	sp, word ptr _ts.T_SP
	jmp	word ptr _ts.T_EBX    ; stored by DPMIprotectedMode() below
@@realModeEntry:
	pop	goProtectMode	; Address to return from real mode callback
	push	bx		; Address stored in realRegs above
	ret			; RealModeSwitch()
_RealModeSwitch   endp

;
;	void ProtectedModeSwitch(void)
;
public	_ProtectedModeSwitch
_ProtectedModeSwitch proc near
	pop	bx			  ;Return point (will be used in
	mov	dword ptr _ts.T_EBX, ebx  ;  RealModeSwitch above)
	mov	dword ptr _ts.T_ESI, esi
	mov	dword ptr _ts.T_EDI, edi
	mov	dword ptr _ts.T_EBP, ebp
	mov	word ptr _ts.T_SP, sp
	jmp	goProtectMode	;Saved retf address from real mode callback
_ProtectedModeSwitch endp

_TEXT	ends

	end
