/* This file is MEMORY.C
**
** demo allocating memory in the DPMI-enviroment
*/

#include <stdio.h>
#include "DPMI.H"
#include "START16.H"
#include "ADOSX16.H"

void protected_program()
{
    printf("hello protected mode\n");
    fflush(stdout);
    RealModeSwitch();
    printf("hello real mode\n");
    fflush(stdout);
    ProtectedModeSwitch();
    printf("hello protected mode\n");
    fflush(stdout);
}

void main()
{
    if (real_to_protected(0))
        exit(1);
    if (hangin_extender()) {
        fprintf(stderr,"ERROR: can't hang in extensions\n");
        protected_to_real(1);
        }
    protected_program();
    protected_to_real(0);
}
