// 
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
// KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR 
// PURPOSE.
// 
// Copyright 1993 Microsoft Corporation, all rights reserved.
// 
// 
#include <windows.h>
#include "TSPI.H"
#include "atspres.h"
	     
#ifdef DEBUG
#include <stdarg.h>
#include <stdio.h> 
void CDECL SPTrace(LPCSTR pszFormat, ...);
#define DebugMsg(x)     SPTrace(x)
#else
#define DebugMsg(x)
#endif


#define ATSP_VERSION 0x00010001
#define ATSP_CALL_ARRAY_SIZE 2

#define INTERNAL_HANGUP "ATH0"
#define INTERNAL_HANGUP_LEN 4

// The size of the ini file, section, and entry strings.

#define INI_FILENAMESIZE 40
#define INI_SECTIONSIZE 80
#define INI_ENTRYSIZE 40

// The maximum length of the items in the ini file.

#define LARGEBUFFER 255
#define MEDIUMBUFFER 80
#define SMALLBUFFER 40

#define INITSTRSIZE 255
#define LINENAMESIZE 80
#define LINEADDRESSSIZE 80
#define PROVIDERINFOSIZE 255
#define MAXADDRSIZE 512
						   
// Serial constants and error codes.

#define SERIAL_RETRY 5
#define SERIAL_TIMEOUT 20
#define SERIAL_BUF_INC 40

#define SERIAL_OK 0
#define SERIAL_ERROR -1
#define SERIAL_FATAL -2
#define SERIAL_NOMEM -3
#define SERIAL_INC -4

#define CALL_STATE_BUSY -5
#define CALL_STATE_TALK -6
#define CALL_STATE_DROP -7
#define CALL_STATE_ERROR -8
#define CALL_STATE_HELP -9
 
// help topic IDs

#define hidConfiguration    1000
#define hidConfigureLine    1001
#define hidTalkDrop         1002

// The number of entries in the devices and speed array.

#define NUMPORTS 4
#define NUMSPEEDS 7


// Line and Call data types

#define MAXDESTADDR 80

typedef struct callInfo
{
	DWORD                                   dwState;                        // The state of this call
	HTAPICALL                       htCall;                 // TAPI opaque call handle
	LINEDIALPARAMS          dpDialParams;
	DWORD                                   dwMediaMode;
	DWORD                                   dwAppSpecific;
	BOOL                                    bInUse;
	char                                    DestAddress[MAXDESTADDR];

} ATSPCallData;

typedef struct lineInfo
{
	// We have only a single address on a single line
	// This structure is constructed in TSPI_Initialize
	// We can have at most one call in a state other than idle or disconnected
  
	BOOL                                    bLineOpen;
	DWORD                                   lineID;                                         // the tapi ID of our line
	int                                     uiCommId;                                       // the associated COM device
	DWORD                                   dwLineMediaModes;
	DWORD                                   dwLineStates;
	DWORD                                   dwAddressStates;
	DWORD                                   dwPermanentProviderID;  // Our permanent provider ID
	HTAPILINE                       htLine;                                         // TAPI opaque line handle
	LINEEVENT                       lpfnEventProc;                          // TAPI event callback function
	ASYNC_COMPLETION        lpfnCompletion;                 // TAPI Completion callback

	BOOL                                    bActiveCall;
	int                                     calls;
	ATSPCallData            call[ATSP_CALL_ARRAY_SIZE];

} ATSPLineData;


