/*---------------------------------------------------------------------------*\
| POLYBEZIER DEMO HEADER FILE
|   This is the poly-bezier header file for poly.c.  This contains the
|   definitions and structures for the polybezier demo window.  It must be
|   include in any module who references the polybezier object.
|
|
| created: 31-Oct-90
| history: 31-Oct-90 <chriswil> created.
|
\*---------------------------------------------------------------------------*/

#ifdef WIN16
#define APIENTRY FAR PASCAL
typedef WORD WPARAM;
//#else
//typedef DWORD WPARAM;
#endif


#define POLYCLASS  "POLYDEMO"
#define POLYTITLE  "PolyBezier Demo"

#define MAX_BEZIER 80
#define VELMAX     10
#define VELMIN      2
#define BEZ_CURVES  1              //Number of Curves in the Bezier
#define BEZ_PTS    3*BEZ_CURVES+1  //Number of Points is the #Curves * 3 + 1 


/*
** This structue defines a basic bezier curve.  It is intended to be used in
** an array of beziers.
*/
typedef struct _BEZBUFFER
{
    POINT pPts[BEZ_PTS];
} BEZBUFFER;
typedef BEZBUFFER      *PBEZBUFFER;
typedef BEZBUFFER NEAR *NPBEZBUFFER;
typedef BEZBUFFER FAR  *LPBEZBUFFER;


/*
** This is the main object for the polybezier window.  This structure defines
** a series of bezier curves and the distance between each curve.
*/
typedef struct _POLYDATA
{
    int      nBezTotal;
    int      nBezCurr;
    int      nColor;
    POINT    pVel[BEZ_PTS];
    HANDLE   hBezBuffer;
} POLYDATA;
typedef POLYDATA      *PPOLYDATA;
typedef POLYDATA NEAR *NPPOLYDATA;
typedef POLYDATA FAR  *LPPOLYDATA;


/*
** POLYBEZIER WINDOW ROUTINES (poly.c)
*/
HWND  FAR      CreatePolyWindow(HWND,int);
LONG  APIENTRY PolyProc(HWND,UINT,WPARAM,LONG);
BOOL           PolyCreateProc(HWND);
VOID           PolyDestroyProc(HWND);
BOOL           PolyCommandProc(HWND,WPARAM,LONG);
VOID           PolyPaintProc(HWND);


VOID           PolyRedraw(HWND);
int            PolyNewVel(int);
VOID           PolyInitPoints(HWND);
VOID           PolyDrawBez(HWND);
