/*************************************************************/
/**                                                         **/
/**                 Microsoft RPC Examples                  **/
/**                 Dictionary Application                  **/
/**             Copyright(c) Microsoft Corp. 1992           **/
/**                                                         **/
/*************************************************************/

/*
 *************************************************************************
 *                                                                       *
 * Remote dictionary example: server side                                *
 *                                                                       *
 * Description:                                                          *
 * This is the driver for the server side remote dictionary              *
 * (splay trees based) demo.  This is a standard server driver,          *
 * and it works as follows:                                              *
 *                                                                       *
 *  o Call RpcCreateServer to initialize all data structures             *
 *                                                                       *
 *  o Initialize an appropriate protocol stack                           *
 *                                                                       *
 *  o Call RpcAddAddress to start listening on a transport address       *
 *    (a named pipe in our case).                                        *
 *                                                                       *
 *  o Call RpcAddInterface to initialize interface specific structures   *
 *    (such as dispatch table, etc.)                                     *
 *                                                                       *
 *  o Optionally advertise by calling RpcExport (not in this version)    *
 *                                                                       *
 *  o Loop forever...                                                    *
 *                                                                       *
 *************************************************************************
*/

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

#include "replay.h"    // header file generated by MIDL compiler
#include "dict0.h"
#include "util0.h"


void Usage()
{
  printf("Usage : server -e <endpoint>\n");
  exit(1);
}

void _CRTAPI1
main(int argc, char *argv[])
{
    RPC_STATUS status;
    unsigned char * pszProtocolSequence = "ncacn_nb_nb";
    unsigned char * pszSecurity         = NULL;
    unsigned char * pszEndpoint         = "15";
    unsigned int    cMinCalls           = 1;
    unsigned int    cMaxCalls           = 20;
    unsigned int    fDontWait           = FALSE;
    int i;

    printf ("Microsoft RPC demo Server - Splay (Binary) Tree DataBase\n");

    /* allow the user to override settings with command line switches */
    for (i = 1; i < argc; i++) {
        if ((*argv[i] == '-') || (*argv[i] == '/')) {
            switch (tolower(*(argv[i]+1))) {
            case 'e':
                pszEndpoint = argv[++i];
                break;
            case 'h':
            case '?':
            default:
                Usage();
            }
        }
        else
            Usage();
    }

    status = RpcServerUseProtseqEp(pszProtocolSequence,
                                   cMaxCalls,   
                                   pszEndpoint,
                                   pszSecurity);  // Security descriptor
    if (status) {
        printf("RpcServerUseProtseqEp returned 0x%x\n", status);
        exit(status);
    }

    status = RpcServerRegisterIf(dict_ServerIfHandle,  // interface to register
                                 NULL,   // MgrTypeUuid
                                 NULL);  // MgrEpv; null means use default
    if (status) {
        printf("RpcServerRegisterIf returned 0x%x\n", status);
        exit(status);
    }

    printf("Calling RpcServerListen\n");
    status = RpcServerListen(cMinCalls,
                             cMaxCalls,
                             fDontWait);
    if (status) {
        printf("RpcServerListen returned: 0x%x\n", status);
        exit(status);
    }

}
