//************************************************************************
//**
//**  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
//**  ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
//**  TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR
//**  A PARTICULAR PURPOSE.
//**
//**  Copyright (C) 1993, 1994 Microsoft Corporation. All Rights Reserved.
//**
//**  mif.h
//**
//**  DESCRIPTION:
//**     This file contains the format of the .MIF files.
//**
//**  HISTORY:
//**     04/29/93       created.
//**     07/04/93       added UNICODE for displayable strings.
//**     09/04/93       added keymaps.
//**     09/05/93       added ID's for channel types.
//**
//************************************************************************

/*
@doc  EXTERNAL SDK

@types   MIFHEADER |
   This is the format of the "hdr " chunk in a Microsoft MIF file.
   This will be the first subchunk of a "MMAP" list chunk.  This will 
   provide information on the MIF itself; what version, who created it,
   and a unique ASCII ID for the instrument.

@field   DWORD | cbStruct |
   This is the inclusive size of the header structure.

@field   DWORD | dwVersion |
   This is the version of the MIF file.
   under.

@field   DWORD | dwCreator |
   This is the creator ID for the MIF.

@field   DWORD | cbInstID |
   This is the size of the unique instrument identifier including the NULL.

@field   BYTE | abInstID[] |
   This is the actual ASCII bytes of the unique instrument id. This _IS_ 
   NULL terminated.  There is no UNICODE version of this since this will
   only be used internally and not displayed to the user.

@othertype  MIFHEADER * | PMIFHEADER |
   A memory model dependant pointer to the structure.

@othertype  MIFHEADER FAR* | LPMIFHEADER |
   A far pointer to the structure.
*/

typedef struct tag_MIFHEADER
{
   DWORD cbStruct;

   DWORD dwVersion;
   DWORD dwCreator;

   DWORD cbInstID;
   BYTE  abInstID[];
} MIFHEADER, *PMIFHEADER, FAR *LPMIFHEADER;


/*
@doc  EXTERNAL SDK

@types   MIFINSTINFO |
   This is the format of the "inst" chunk in a Microsoft MIF file.
   This chunk will contain information on the instrument, e.g. who
   manufactured it, the name of the instrument, it's manufacturer and
   product id's and a revision number.

@field   DWORD | cbStruct |
   This is the inclusive size of the instrument information structure.

@field   DWORD | dwManufactID |
   Manufacturer's ID.

@field   DWORD | dwProductID |
   Product's ID.

@field   DWORD | dwRevision |
   Revision of the product.

@field   DWORD | cbManufactASCII |
   Length of the ASCII version of the manufacturuers name.

@field   DWORD | cbManufactUNICODE |
   Length of the UNICODE version of the manufacturuers name.

@field   DWORD | cbProductASCII |
   Length of the ASCII version of the product name.

@field   DWORD | cbProductUNICODE |
   Length of the UNICODE version of the product name.

@field   BYTE | abData[] |
   Contains the ASCII and UNICODE strings for the manufacturer and product
   names.  NOTE that all strings are separated by a NULL and the NULL IS
   counted in the string lengths.

@othertype  MIFINSTINFO * | PMIFINSTINFO |
   A memory model dependant pointer to the structure.

@othertype  MIFINSTINFO FAR * | LPMIFINSTINFO |
   A far pointer to the structure.

@comm The idea is that the cbManufactXXXXX and cbProductXXXXX will be the
      offsets into the bData array of bytes and it will contain a complete
      string that you can strcpy out.  That is why the NULL is included in
      the byte count and in the actual data.
*/

typedef struct tag_MIFINSTINFO
{
   DWORD cbStruct;

   DWORD dwManufactID;
   DWORD dwProductID;
   DWORD dwRevision;

   DWORD cbManufactASCII;
   DWORD cbManufactUNICODE;
   DWORD cbProductASCII;
   DWORD cbProductUNICODE;

   BYTE  abData[];
} MIFINSTINFO, FAR *LPMIFINSTINFO;

/*
@doc  EXTERNAL SDK

@types   MIFINSTCAPS |
   This is the format of the "caps" chunk in a Microsoft MIF file.
   This chunk will contain information on the MIDI capabilities of
   the device. e.g. basic channel of the instrument, number of channels
   that the instrument has available. the polyphony of the instrument, 
   whether or not it supports General MIDI, etc....

@field   DWORD | cbStruct |
   This is the size of the capabilities structure.

@field   DWORD | fdwFlags |
   Flags specifiying additional capabilities of an instrument.

@flag MIFINSTCAPS_F_GENERAL_MIDI |
   Instrument supports General MIDI.

@flag MIFINSTCAPS_F_SYSTEMEXCLUSIVE |
   Instrument supports system exclusive messages

@field   DWORD | dwBasicChannel |
   The basic channel for the instrument.

@field   DWORD | cNumChannels |
   Number of channels that the instrument supports to.

@field   DWORD | cInstrumentPolyphony |
   The total polyphony for the instrument.

@field   DWORD | cChannelPolyphony |
   The polyphony per channel.

@othertype  MIFINSTCAPS * | PMIFINSTCAPS |
   A memory model dependant pointer to the structure.

@othertype  MIFINSTCAPS FAR * | LPMIFINSTCAPS |
   A far pointer to the structure.
*/

typedef struct tag_MIFINSTCAPS
{
   DWORD cbStruct;
   DWORD fdwFlags;
   DWORD dwBasicChannel;
   DWORD cNumChannels;
   DWORD cInstrumentPolyphony;
   DWORD cChannelPolyphony;
} MIFINSTCAPS, *PMIFINSTCAPS, FAR *LPMIFINSTCAPS;

#define  MIFINSTCAPS_F_GENERAL_MIDI       0x00000001
#define  MIFINSTCAPS_F_SYSTEMEXCLUSIVE    0x00000002

/*
@doc  EXTERNAL SDK

@types   MIFCHANNELHDR |
   This is the format of the "chnl" chunk in a Microsoft MIF file.
   This contains a description on what "type" a channel is, i.e. 
   is it a General MIDI channel, a drum channel, etc... Directly 
   following this header is the actual data on each channel.

@field   DWORD | cbStruct |
   This is the size of the channel header structure.

@field   DWORD | fdwFlags |
   Flags describing the channel type information.

@flag MIFCHANNELHDR_F_GENERAL_MIDI |
   If this flag is set then any channels that are not defined in the 
   MIF are General MIDI channel types.  If this flag is _NOT_ set then
   any channels that are not defined in the MIF are undefined and should 
   NOT be used in mapping.

@field   DWORD | cNumChannels |
   This is the number of channels that follows the header.

@field   DWORD | cbChannelSize |
   This is the size of each channel structure following the header.

@othertype  MIFCHANNELHDR * | PMIFCHANNELHDR |
   A memory model dependant pointer to the structure.

@othertype  MIFCHANNELHDR FAR * | LPMIFCHANNELHDR |
   A far pointer to the structure.
*/

typedef struct tag_MIFCHANNELHDR
{
   DWORD cbStruct;

   DWORD cNumChannels;
   DWORD cbChannelSize;
   DWORD fdwFlags;
} MIFCHANNELHDR, *PMIFCHANNELHDR, FAR *LPMIFCHANNELHDR;

#define  MIFCHANNELHDR_F_GENERAL_MIDI     0x00000001


/*
@doc  EXTERNAL SDK

@types    MIFCHANNELINFO |
   This is the format of the actual channel information for Microsoft
   authored MIF files. This is the Microsoft supported format for
   channel information.

@field   DWORD | dwChannel |
   This is the channel number that the structure defines.

@field   DWORD | dwChannelType |
   Defines the type of channel.

@othertype  MIFCHANNELINFO * | PMIFCHANNELINFO |
   A memory model dependant pointer to the structure.

@othertype  MIFCHANNELINFO FAR * | LPMIFCHANNELINFO |
   A far pointer to the structure.
*/

typedef struct tag_MIFCHANNELINFO
{
   DWORD cbStruct;

   DWORD dwChannel;
   DWORD dwChannelType;
} MIFCHANNELINFO, *PMIFCHANNELINFO, FAR *LPMIFCHANNELINFO;


//
// Currently defined channel types.
//
#define  MIFCHANNELINFO_GENERAL_CHANNEL      0x00000000
#define  MIFCHANNELINFO_DRUM_CHANNEL         0x00000001
#define  MIFCHANNELINFO_LIGHTING_CHANNEL     0x00000002


/*
@doc  EXTERNAL SDK

@types   MIFPATCHMAPHDR |
   This is the format of the "map " chunk in a Microsoft MIF file.
   This chunk contains information on the patch map used for the 
   instrument. Directly following this header is the actual mapping 
   information for each patch.

@field   DWORD | cbStruct |
   This is the size of the patch map header structure.

@field   DWORD | cNumPatches |
   This is the number of patches that are defined below.

@field   DWORD | cbPatchMapSize |
   This is the size of each patch map that is defined below.

@field   DWORD | fdwFlags |
   Flags containing additional mapping information.  

@flag MIFPATCHMAPHDR_F_GENERAL_MIDI |
   If this flag is set the any patches that are not defined in the 
   MIF are General MIDI patches.  If this flag is _NOT_ set the any 
   patches that are not defined in the MIF are undefined and should 
   NOT be mapped to.

@othertype  MIFPATCHMAPHDR * | PMIFPATCHMAPHDR |
   A memory model dependant pointer to the structure.

@othertype  MIFPATCHMAPHDR FAR * | LPMIFPATCHMAPHDR |
   A far pointer to the structure.
*/

typedef struct tag_MIFPATCHMAPHDR
{
   DWORD cbStruct;

   DWORD cNumPatchMaps;
   DWORD cbPatchMapSize;

   DWORD fdwFlags;
} MIFPATCHMAPHDR, *PMIFPATCHMAPHDR, FAR *LPMIFPATCHMAPHDR;

#define  MIFPATCHMAPHDR_F_GENERAL_MIDI    0x00000001

/*
@doc  EXTERNAL SDK

@types   MIFKEYMAPHDR |
   This is the format of the "key " chunk in a Microsoft MIF file.
   This chunk contains information on the all of the key maps used 
   for a given instrument. The information that is in this structure
   pertains to all of the key maps for the instrument.  It contains
   the total number of key maps for the instrument and whether or not
   the key maps are General MIDI.

@field   DWORD | cbStruct |
   This is the size of the key map header structure.

@field   DWORD | cNumKeyMaps |
   This is the number of key maps that follow the header.

@field   DWORD | fdwFlags |
   Flags containing additional mapping information. None are currently
   defined.

@othertype  MIFPATCHMAPHDR * | PMIFPATCHMAPHDR |
   A memory model dependant pointer to the structure.

@othertype  MIFPATCHMAPHDR FAR * | LPMIFPATCHMAPHDR |
   A far pointer to the structure.
*/

typedef struct tag_MIFKEYMAPHDR
{
   DWORD cbStruct;

   DWORD cNumKeyMaps;

   DWORD fdwFlags;
} MIFKEYMAPHDR, *PMIFKEYMAPHDR, FAR *LPMIFKEYMAPHDR;


/*
@doc  EXTERNAL SDK

@types   MIFKEYMAPCHANNELINFO |
   This structure contains information on a given key map for a 
   given channel.  It gives the channel number that the key map
   is for and the number of key maps that are defined for the 
   channel.  It also contains the size of each key map entry, and
   finally if the undefined key maps are General MIDI.
   
@field   DWORD | dwChannel |
   This is the channel number that the key map is for.

@field   DWORD | cNumMaps |
   This is the total number of maps that we have for the channel.

@field   DWORD | cbKeyMapSize |
   This is the size that each key map structure takes.

@field   DWORD | fdwFlags |
   Flags containing additional mapping information.  

@flag MIFKEYMAPCHANNELINFO_F_GENERAL_MIDI |
   If this flag is set the any key maps that are not defined in the 
   MIF are General MIDI key maps.  If this flag is _NOT_ set the any 
   key maps that are not defined in the MIF are undefined and should 
   NOT be mapped to.

@othertype  MIFPATCHMAPHDR * | PMIFPATCHMAPHDR |
   A memory model dependant pointer to the structure.

@othertype  MIFPATCHMAPHDR FAR * | LPMIFPATCHMAPHDR |
   A far pointer to the structure.

@comm Following this structure in the MIF will be the key map data
      for the channel described in the MIFKEYMAPCHANNELINFO struct.  The 
      information for each key map is defined by a MIFMAPENTRY structure.
*/

typedef struct tag_MIFKEYMAPCHANNELINFO
{
   DWORD cbStruct;   

   DWORD dwChannel;
   DWORD cNumKeyMaps;
   DWORD cbKeyMapSize;

   DWORD fdwFlags;
} MIFKEYMAPCHANNELINFO, *PMIFKEYMAPCHANNELINFO, FAR *LPMIFKEYMAPCHANNELINFO;

#define  MIFKEYMAPCHANNELINFO_F_GENERAL_MIDI     0x00000001



/*
@doc  EXTERNAL SDK

@types   MIFMAPENTRY |
   This structure is used to define a source and destination map.  It is
   used for both patch maps and key maps in Microsoft MIF files.

@field   BYTE | bDst |
   This is the destination map or the General MIDI map that we are
   mapping to.

@field   BYTE | bSrc |
   This is the instrument specific map that we are mapping from.

@othertype  MIFMAPENTRY * | PMIFMAPENTRY |
   A memory model dependatn pointer to the structure.

@othertype  MIFMAPENTRY FAR * | LPMIFMAPENTRY |
   A far pointer to the structure.
*/

typedef struct tag_MIFMAPENTRY
{
   DWORD cbStruct;

   BYTE  bDst;
   BYTE  bSrc;
} MIFMAPENTRY, *PMIFMAPENTRY, FAR *LPMIFMAPENTRY;



