//************************************************************************
//**
//**  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
//**  ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
//**  TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR
//**  A PARTICULAR PURPOSE.
//**
//**  Copyright (C) 1993, 1994 Microsoft Corporation. All Rights Reserved.
//**
//**  globals.h
//**
//**  DESCRIPTION:
//**
//**
//**  HISTORY:
//**     04/22/93       created.
//**
//************************************************************************

#ifndef __GLOBALS_H
#define __GLOBALS_H

#define STRICT
#include "preclude.h"
#include <windows.h>
#include <mmsystem.h>
#include "mif.h"

//
// The following macro defines a CODE based pointer to data, which
// is used for constants that do not need to be placed in the read/write
// DATA segment.
//
#ifdef WIN32
#define __based(a)
#endif

#ifdef WIN32
   #define  BCODE
#else
   #define  BCODE                __based(__segname("_CODE"))
#endif

#define  FNLOCAL                    NEAR  PASCAL
#define  FNGLOBAL                   FAR   PASCAL
#define  FNEXPORT                   FAR   PASCAL   __export

#define  CURR_CHANNEL_TYPE(x)       gpInst[gdwCurrInst].aChannelTypes[x]
#define  CURR_PATCH_MAP(x)          gpInst[gdwCurrInst].aPatchMaps[x]
#define  CURR_KEY_MAP(chnl, map)    gpInst[gdwCurrInst].aKeyMaps[chnl][map]

#define  HWND_CURRENT_INSTRUMENT    GetDlgItem(ghwndMain, ID_CURRENT_INSTRUMENT)
#define  HWND_DRUM_CHANNELS         GetDlgItem(ghwndMain, ID_DRUM_CHANNELS)
#define  HWND_EDIT_ENTER            GetDlgItem(ghwndMain, ID_EDIT_ENTER)
#define  HWND_LIST_BOX              GetDlgItem(ghwndMain, ID_LIST_BOX)

#define  HWND_MIF_CURRENT_SECTION   GetDlgItem(ghwndMain, ID_MIF_CURRENT_SECTION)
#define  HWND_CURRENT_INSTRUMENT    GetDlgItem(ghwndMain, ID_CURRENT_INSTRUMENT)
#define  HWND_EDIT_BOX              GetDlgItem(ghwndMain, ID_EDIT_BOX)
#define  HWND_INSTRUMENT_SCROLL     GetDlgItem(ghwndMain, ID_INSTRUMENT_SCROLL)


//
// GENERAL CONSTANT DEFINITIONS
//
#define  MAX_STR_LEN             128
#define  MAX_PATH_LEN            144
#define  MAX_TITLE_LEN           14
#define  NUM_CHANNELS_DEFINED    3
#define  DRUM_CHANNEL            9
#define  MAX_CHANNELS            16
#define  MAX_PATCHES             128
#define  MAX_KEY_MAPS            128
#define  DRUM_KEY_START          35
#define  DRUM_KEY_END            81

//
// VERSION
//
#define  MIF_FMT_VERSION         0x00000100

//
// SECTIONS
//
#define  MIF_HEADER_INFO         0
#define  MIF_INSTRUMENT_INFO     1
#define  MIF_INSTRUMENT_CAPS     2
#define  MIF_CHANNEL_TYPE        3
#define  MIF_PATCH_MAPS          4
#define  MIF_KEY_MAPS            5

#define  TOTAL_SECTION_ENTRIES   6

//
// HEADER LIST BOX POSITIONS
//
#define  MIF_VERSION             0
#define  MIF_CREATOR             1

#define  HEADER_TOTAL            2

//
// INSTRUMENT LIST BOX POSITIONS
//
#define  INST_MANUFACT           0
#define  INST_PRODUCT            1
#define  INST_MID                2
#define  INST_PID                3
#define  INST_REV                4

#define  INST_TOTAL              5


//
// MIDI CAPABILITIES LIST BOX POSITIONS
//
#define  CAPS_BASECHANL          0
#define  CAPS_NUMCHANL           1
#define  CAPS_INSTPOLY           2
#define  CAPS_CHANLPOLY          3
#define  CAPS_GENERAL            4
#define  CAPS_SYSEX              5

#define  CAPS_TOTAL              6


// 
// NEW TYPE DEFINITIONS
//
typedef struct tag_INSTRUMENT
{
   DWORD             dwVersion;
   DWORD             dwCreator;

   char              szInstID[MAX_STR_LEN+1];

   DWORD             dwManufactID;
   DWORD             dwProductID;
   DWORD             dwRevision;

   LPSTR             pszManufactASCII;
   LPSTR             pszManufactUNICODE;
   LPSTR             pszProductASCII;
   LPSTR             pszProductUNICODE;

   DWORD             dwBasicChannel;
   DWORD             cNumChannels;
   DWORD             cInstPoly;
   DWORD             cChannelPoly;
   DWORD             fdwFlags;

   DWORD             aChannelTypes[MAX_CHANNELS];
   BYTE              aPatchMaps[MAX_PATCHES];
   BYTE              aKeyMaps[MAX_CHANNELS][MAX_KEY_MAPS];
} INSTRUMENT, FAR *LPINSTRUMENT;

//
// EXTERNAL FUNCTION PROTOTYPES
//

extern LRESULT  FNEXPORT MainProc(HWND    hwnd, 
                                  UINT    umsg, 
                                  WPARAM  wParam, 
                                  LPARAM  lParam);
extern VOID FNLOCAL InitializeDialog(void);


extern LPVOID   FNLOCAL  AllocPtr(UINT fu, DWORD cb);
extern LPVOID   FNLOCAL  ReAllocPtr(LPVOID pv, UINT fu, DWORD cb);
extern VOID     FNLOCAL  FreePtr(LPVOID FAR *ptr);

extern VOID     FNLOCAL  NotifyUser(UINT u);
extern MMRESULT FNLOCAL  NewConfigFile(VOID);
extern MMRESULT FNLOCAL  OpenConfigFile(VOID);
extern MMRESULT FNLOCAL  SaveConfigFile(VOID);
extern MMRESULT FNLOCAL  SaveConfigFileAs(VOID);
extern MMRESULT FNLOCAL  NewInstrument(VOID);
extern VOID     FNLOCAL  SetupDialog(VOID);

extern VOID     FNLOCAL  CleanUp(VOID);
extern VOID     FNLOCAL  SetWindowTitle(VOID);
extern VOID     FNLOCAL  UpdateListBox(VOID);
extern BOOL     FNLOCAL  AllocateInst(VOID);

extern VOID     FNLOCAL  UpdateInstrument(VOID);



//
// Constant read-only strings (allocated from code segment).
//
extern   char  BCODE    gszClassName[];
extern   char  BCODE    gszSS[];
extern   char  BCODE    gszSU[];
extern   char  BCODE    gszUS[];
extern   char  BCODE    gszUU[];
extern   char  BCODE    gszSX[];
extern   char  BCODE    gszU[];
extern   char  BCODE    gszNULL[];


//
// GLOBAL VARIABLE DECLARATIONS
//
extern   char           gszTitleBar[];
extern   char           gszmifTitle[];
extern   char           gszmifName[];
extern   HINSTANCE      ghinst;
extern   HWND           ghwndMain;
extern   UINT           guCurrSelection;
extern   HMMIO          ghmmio;
extern   LPINSTRUMENT   gpInst;
extern   DWORD          gdwNumInsts;
extern   DWORD          gdwCurrInst;
extern   BOOL           gfChanged;
extern   char           gszbuf[];

extern   char           gszChannelTypes[][20];
extern   BOOL           gfFirstEdit;

#endif // __GLOBALS_H

