//************************************************************************
//**
//**  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
//**  ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
//**  TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR
//**  A PARTICULAR PURPOSE.
//**
//**  Copyright (C) 1993, 1994 Microsoft Corporation. All Rights Reserved.
//**
//**  main.c
//**
//**  DESCRIPTION:
//**     Performs window class registration, creations and message 
//**     polling.
//**
//**  HISTORY:
//**     04/22/93       created.
//**
//************************************************************************


#include "globals.h"
#include "res.h"


//************************************************************************
//**
//**  InitClasses();
//**
//**  DESCRIPTION:
//**     This function will register the main window class.
//**
//**  ARGUMENTS:
//**     VOID
//**
//**  RETURNS:
//**     BOOL  -  TRUE if the main window class was successfully 
//**              registered, FALSE otherwise.
//**
//**  HISTORY:
//**     04/22/93       created.
//**
//************************************************************************

BOOL WINAPI InitClasses(
   VOID)
{
   WNDCLASS wc;

   wc.style          =  CS_HREDRAW | CS_VREDRAW;
   wc.lpfnWndProc    =  MainProc;
   wc.cbClsExtra     =  0;
   wc.cbWndExtra     =  0;
   wc.hInstance      =  ghinst;
   wc.hIcon          =  LoadIcon(ghinst, MAKEINTRESOURCE(SMILE));
   wc.hCursor        =  LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground  =  GetStockObject(WHITE_BRUSH);
   wc.lpszMenuName   =  MAKEINTRESOURCE(M2R_MENU);
   wc.lpszClassName  =  (LPSTR)"mid2rmi";

   if (!RegisterClass(&wc))
      return(FALSE);

   return(TRUE);
} //** InitClasses()



//************************************************************************
//**
//**  InitInstance();
//**
//**  DESCRIPTION:
//**     This function will create the main application window.
//**
//**  ARGUMENTS:
//**     int nCmdShow   -  How the window is to be shown.
//**
//**  RETURNS:
//**     BOOL  -  TRUE if the window was successfully created, 
//**              FALSE if not.
//**
//**  HISTORY:
//**     04/22/93       created.
//**
//************************************************************************

BOOL WINAPI InitInstance(
   int nCmdShow)
{
   // Create the main window.
   //
   ghwndMain = CreateWindowEx(WS_EX_ACCEPTFILES,
                              "mid2rmi",
                              "MID-2-RMI",
                              WS_OVERLAPPEDWINDOW,
                              CW_USEDEFAULT,
                              CW_USEDEFAULT,
                              CW_USEDEFAULT,
                              CW_USEDEFAULT,
                              NULL, NULL, ghinst, NULL);

   // Did we succeed.
   //
   if (!ghwndMain)
      return(FALSE);

   // Show and update..
   //
   ShowWindow(ghwndMain, nCmdShow);
   UpdateWindow(ghwndMain);

   // Return success.
   //
   return(TRUE);
} //** InitInstance()


//************************************************************************
//**
//**  WinMain();
//**
//**  DESCRIPTION:
//**     Setups of window's and classes, processes messages.
//**
//**  ARGUMENTS:
//**     HINSTANCE   hInstance      - Handle to program's instance.
//**     HINSTANCE   hPrevInstance  - Handle to previous instances.
//**     LPSTR       lpszCmdLine    - Command line.
//**     int         nCmdShow       - How do we show the app.
//**
//**  RETURNS:
//**     int 
//**
//**  HISTORY:
//**     04/22/93       created.
//**
//************************************************************************

int PASCAL WinMain(
   HINSTANCE   hInstance,
   HINSTANCE   hPrevInstance,
   LPSTR       lpszCmdLine,
   int         nCmdShow)
{
   MSG   msg;

   // Save the instance handle in a global for
   // easy reference.
   //
   ghinst = hInstance;

   // If there are no previous instances then register classes.
   //
   if (!hPrevInstance)
   {
      if (!InitClasses())
         return(FALSE);
   }

   // Create the window.
   //
   if (!InitInstance(nCmdShow))
      return(FALSE);

   // Poll for messages.
   //
   while (GetMessage(&msg, NULL, NULL, NULL))
   {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }

   // Return to Windows
   //
   return(msg.wParam);
} //** WinMain()
