        page    ,132
	TITLE	$icm32.asm
        .listall

        .386
        OPTION READONLY
	OPTION OLDSTRUCTS

	include icm.inc

        .model FLAT

BLACK	equ	00000000h
WHITE	equ	00FFFFFFh


Row	struc
  E1	dd	0
  E2	dd	0
  E3	dd	0
Row	ends

Mat	struc
  R1	dd 3 dup (0)	; Row <0,0,0>
  R2	dd 3 dup (0)	; Row <0,0,0>
  R3	dd 3 dup (0)	; Row <0,0,0>
Mat	ends

ColorMatrix	struc
  M11	dd	0
  M12	dd	0
  M13	dd	0
  M21	dd	0
  M22	dd	0
  M23	dd	0
  M31	dd	0
  M32	dd	0
  M33	dd	0
ColorMatrix	ends


IcmDllInit	proto NEAR STDCALL, hModule:DWORD, lReason:DWORD, lContext:DWORD

	.data

cxform1 ColorMatrix <4000h,0,0, 0,4000h,0, 0,0,4000h>
cxform2 ColorMatrix <0,4000h,0, 4000h,0,0, 0,0,4000h>
cxform3 ColorMatrix <3C24h,15E4h,0, 0FFFFEA1Ch,3C24h,0, 0,0,4000h>

LCS1	LogColorSpace <0,0,0,0>
LCS2	LogColorSpace <0,0,0,0>
LCS3	LogColorSpace <0,0,0,0>
LCS4	LogColorSpace <0,0,0,0>
LCS5	LogColorSpace <0,0,0,0>

gamma_18	label byte

db	  0, 12, 17, 22, 25, 29, 32, 35, 37, 40, 42, 45, 47, 49, 51, 53
db	 55, 57, 59, 60, 62, 64, 65, 67, 69, 70, 72, 73, 75, 76, 78, 79
db	 81, 82, 83, 85, 86, 87, 89, 90, 91, 93, 94, 95, 96, 97, 99,100
db	101,102,103,104,106,107,108,109,110,111,112,113,114,115,116,117
db	119,120,121,122,123,124,125,126,127,127,128,129,130,131,132,133
db	134,135,136,137,138,139,140,141,141,142,143,144,145,146,147,148
db	148,149,150,151,152,153,154,154,155,156,157,158,158,159,160,161
db	162,163,163,164,165,166,166,167,168,169,170,170,171,172,173,173
db	174,175,176,176,177,178,179,179,180,181,182,182,183,184,185,185
db	186,187,187,188,189,190,190,191,192,192,193,194,194,195,196,196
db	197,198,199,199,200,201,201,202,203,203,204,205,205,206,207,207
db	208,209,209,210,211,211,212,212,213,214,214,215,216,216,217,218
db	218,219,219,220,221,221,222,223,223,224,224,225,226,226,227,227
db	228,229,229,230,231,231,232,232,233,234,234,235,235,236,237,237
db	238,238,239,239,240,241,241,242,242,243,244,244,245,245,246,246
db	247,248,248,249,249,250,250,251,252,252,253,253,254,254,255,255

gamma_22	label byte

db	  0, 21, 28, 34, 39, 43, 46, 50, 53, 56, 59, 61, 64, 66, 68, 70
db	 72, 74, 76, 78, 80, 82, 84, 85, 87, 89, 90, 92, 93, 95, 96, 98
db	 99,101,102,103,105,106,107,109,110,111,112,114,115,116,117,118
db	119,120,122,123,124,125,126,127,128,129,130,131,132,133,134,135
db	136,137,138,139,140,141,142,143,144,144,145,146,147,148,149,150
db	151,151,152,153,154,155,156,156,157,158,159,160,160,161,162,163
db	164,164,165,166,167,167,168,169,170,170,171,172,173,173,174,175
db	175,176,177,178,178,179,180,180,181,182,182,183,184,184,185,186
db	186,187,188,188,189,190,190,191,192,192,193,194,194,195,195,196
db	197,197,198,199,199,200,200,201,202,202,203,203,204,205,205,206
db	206,207,207,208,209,209,210,210,211,212,212,213,213,214,214,215
db	215,216,217,217,218,218,219,219,220,220,221,221,222,223,223,224
db	224,225,225,226,226,227,227,228,228,229,229,230,230,231,231,232
db	232,233,233,234,234,235,235,236,236,237,237,238,238,239,239,240
db	240,241,241,242,242,243,243,244,244,245,245,246,246,247,247,248
db	248,249,249,249,250,250,251,251,252,252,253,253,254,254,255,255



fFirstTime      db      1               ;TRUE

        .code   THUNK32

;-----------------------------------------------------------------------;
; Icm32 DLL init routine
;-----------------------------------------------------------------------;
IcmDllInit proc    near32   hModule:DWORD, lReason:DWORD, lContext:DWORD

        mov     eax, lReason
        cmp     eax, 1
        jne     initok

; Do once-only initialization.
;
        mov     al, 0
        xchg    al, fFirstTime
        or      al, al
        jz      initok

; put fun code here!

initok:
        sub     eax,eax         ;return success
        inc     eax

exit:
        ret

IcmDllInit endp

;-----------------------------------------------------------------------;
; CMGetInfo
;
; CMGetVersion returns the version of Windows supported.
;
;-----------------------------------------------------------------------;

CMGetInfo  proc    near32     dwInfoWanted:dword

	xor	eax,eax
	mov	ebx,dwInfoWanted
	or	ebx,ebx
	.errnz	CMS_GET_VERSION
	jnz	@F
	mov	al,4
	jmp	short cmgi_exit

@@:	dec	ebx
	.errnz	CMS_GET_IDENT - 1
	jnz	cmgi_exit
	mov	eax,'MSCS'

cmgi_exit:
	ret

CMGetInfo  endp

;-----------------------------------------------------------------------;
;-----------------------------------------------------------------------;

CMCreateTransform  proc near32	 lplogcolorspace:DWORD, \
				 lpdevchardest:DWORD,  \
				 lpdevmodedest:DWORD,	   \
				 lpdevchartarget:DWORD,       \
				 lpdevmodetarget:DWORD
	LOCAL	wret	:dword

	xor	eax,eax
	mov	wret,eax	  ; assume failure

; Allocate space for forward transforms, use LogColorSpace for convenience.

	mov	ebx,offset LCS1
	xor	ecx,ecx
	inc	cl
@@:	cmp	[ebx].lcs_version,eax
	jz	cmct_found_space
	add	ebx,SIZE LogColorSpace
	inc	cl
	cmp	cl,6
	jnz	@B
	jmp	cmct_exit

cmct_found_space:
	mov	wret,ecx
	mov	[ebx].lcs_version,ebx	 ; taken!
	mov	[ebx].lcs_size,size LogColorSpace
	mov	[ebx].lcs_ident,COLOR_SPACE_IDENT
	mov	[ebx].lcs_gamma_red,1CCCDh
	mov	[ebx].lcs_gamma_green,1CCCDh
	mov	[ebx].lcs_gamma_blue,1CCCDh
	add	ebx,lcs_endpoints

;	ESI	left matrix
;	EDI	right matrix
;	EBX	resulting matrix

	mov	esi,lpdevchardest
	add	esi,lcs_endpoints
	mov	edi,lpLogColorSpace
	add	edi,lcs_endpoints
	call	matrix_matrix_mul

cmct_exit:
	mov	eax,wret
	ret

CMCreateTransform  endp

;-----------------------------------------------------------------------;
;-----------------------------------------------------------------------;

CMDeleteTransform  proc near32 USES ebx edi esi,
	hcmtransform:DWORD

	xor	eax,eax 		; assume error
	mov	edi,hcmTransform
	cmp	di,5
	ja	cmdt_exit
	dec	edi
	mov	dx, SIZE LOGCOLORSPACE
	imul	di,dx
	add	edi,offset LCS1
	cmp	[edi].lcs_size,size LOGCOLORSPACE	; paranoia
	jnz	cmdt_exit
	xor	ecx,ecx
	mov	cl,(SIZE LOGCOLORSPACE)/4
	rep	stosd				; blow it away!
	inc	eax
cmdt_exit:
	ret

CMDeleteTransform  endp

;-----------------------------------------------------------------------;
;-----------------------------------------------------------------------;

CMTranslateRGB	proc near32 USES ebx edi esi,
	hcmtransform:DWORD,	\
	RGBQuad:DWORD,		\
	lpcolorref:DWORD,	\
	dwFlags:DWORD

	test	dwFlags,NOT 01		; make sure reserved flags are 0
	jnz	CMTR_bad_flags

	mov	eax,RGBQuad
	and	eax,WHITE
	or	eax,eax 		; don't mess with black because of
	.errnz	BLACK			;  gamut checking API stuff
	jz	CMTR_exit

	mov	edi,hcmTransform
	cmp	di,5
	ja	CMTR_nonsense
	dec	edi
	mov	dx, SIZE LOGCOLORSPACE
	imul	di,dx
	add	edi,offset LCS1
	cmp	[edi].lcs_size,size LOGCOLORSPACE
	jnz	CMTR_error_exit

	mov	ecx,[edi].lcs_gamma_red
	cmp	ecx,10000h
	jz	CMTR_matrix_transform
	mov	ebx,offset gamma_18
	cmp	ecx,1CCCDh
	jz	@F
	mov	ebx,offset gamma_22
@@:	xlatb
	ror	eax,8
	xlatb
	ror	eax,8
	xlatb
	ror	eax,16

CMTR_matrix_transform:
	mov	ebx,eax
	lea	esi,[edi].lcs_endpoints
	call	matrix_mul
	jmp	CMTR_exit



CMTR_nonsense:
CMTR_bad_flags:
CMTR_error_exit:
	xor	eax,eax

CMTR_exit:
	and	eax,00FFFFFFh
	mov	edx,eax
	shr	edx,16
	ret

CMTranslateRGB endp

;-----------------------------------------------------------------------;
;-----------------------------------------------------------------------;

CMTranslateRGBs  proc near32  USES edi esi,
	hcmtransform,	\
	lpsrc:DWORD,	\
	srcflags:DWORD, \
	lpdest:DWORD,	\
	destflags:DWORD,\
	ncount:DWORD,	\
	flags:DWORD

	mov	esi,lpsrc
	mov	edi,lpdest
@@:	lodsd
	dec	esi
	invoke	CMTranslateRGB, hcmTransform,eax,0,0
	stosd
	dec	edi
	dec	nCount
	jnz	@B

	ret

CMTranslateRGBs  endp

;-----------------------------------------------------------------------;
;-----------------------------------------------------------------------;

CMCheckColorInGamut  proc near32  hcmtransform:DWORD,	\
				  lprgbquad:DWORD,	\
				  lpbyte:DWORD, 	\
				  uint:DWORD

	ret

CMCheckColorInGamut  endp

;-----------------------------------------------------------------------;
;-----------------------------------------------------------------------;

CMEnumColorProfiles  proc near32  lpdevmode:DWORD,	\
				  farproc:DWORD,	\
				  lpvoid:DWORD
	ret

CMEnumColorProfiles  endp

;-----------------------------------------------------------------------;
; matrix_mul
;
;-----------------------------------------------------------------------;


matrix_mul	proc near32

	movzx	eax,bl
	imul	[esi].M11
	ror	ebx,8
	mov	edi,eax
	movzx	eax,bl
	imul	[esi].M12
	ror	ebx,8
	add	edi,eax
	movzx	eax,bl
	imul	[esi].M13
	ror	ebx,16
	add	eax,edi
	js	trunc_1
	shr	eax,14
r_1:	mov	cl,al

	movzx	eax,bl
	imul	[esi].M21
	ror	ebx,8
	mov	edi,eax
	movzx	eax,bl
	imul	[esi].M22
	ror	ebx,8
	add	edi,eax
	movzx	eax,bl
	imul	[esi].M23
	ror	ebx,16
	add	eax,edi
	js	trunc_2
	shr	eax,14
r_2:	mov	ch,al

	movzx	eax,bl
	imul	[esi].M31
	ror	ebx,8
	mov	edi,eax
	movzx	eax,bl
	imul	[esi].M32
	ror	ebx,8
	add	edi,eax
	movzx	eax,bl
	imul	[esi].M33
	ror	ebx,16
	add	eax,edi
	js	trunc_3
	shr	eax,14
r_3:	shl	eax,16
	mov	ax,cx
	ret


trunc_1:
	mov	al,0
	jmp	r_1

trunc_2:
	mov	al,0
	jmp	r_2

trunc_3:
	mov	al,0
	jmp	r_3

matrix_mul	endp


;-----------------------------------------------------------------------;
; matrix_matrix_mul
;
;
; Entry:
;	ESI   left matrix
;	EDI   right matrix
;	EBX   resulting matrix
;
;-----------------------------------------------------------------------;

matrix_matrix_mul proc near32

	call	mul_row_matrix
	add	esi,size ROW
	add	ebx,size ROW
	call	mul_row_matrix
	add	esi,size ROW
	add	ebx,size ROW
	call	mul_row_matrix
	ret

matrix_matrix_mul endp

;-----------------------------------------------------------------------;
; mul_row_matrix
;
;
; Entry:
;	ESI   row
;	EDI   matrix
;	EBX   resulting matrix
;
;-----------------------------------------------------------------------;


mul_row_matrix	proc near32

	call	mul_row_col
	mov	[ebx].M11,eax
	add	edi,size E1
	call	mul_row_col
	mov	[ebx].M12,eax
	add	edi,size E2
	call	mul_row_col
	mov	[ebx].M13,eax
	sub	edi, 2* (size M11)
	ret

mul_row_matrix	endp

;-----------------------------------------------------------------------;
; mul_row_col
;
;
; Entry:
;	ESI   row
;	EDI   column
;
;-----------------------------------------------------------------------;

mul_row_col	proc near32

	mov	eax,[esi].E1
	imul	[edi].R1
	shrd	eax,edx,14
	mov	ecx,eax
	mov	eax,[esi].E2
	imul	[edi].R2
	shrd	eax,edx,14
	add	ecx,eax
	mov	eax,[esi].E3
	imul	[edi].R3
	shrd	eax,edx,14
	add	eax,ecx
	ret
mul_row_col	endp

end IcmDllInit
