ECHO OFF

REM -------------------------------------------------------------------------
REM  File Name..: INSTALL.BAT
REM  Version....: Professional 2.50
REM  Last Update: 01/14/93
REM ------------------------------------------------------------------------
REM  Notice.....: (c) Copyright 1990, Revisions 90 - 93 by SBT Corporation
REM               All Rights Reserved by SBT Corporation
REM -------------------------------------------------------------------------
REM  App ID.....: SY
REM  App Name...: System Services Module
REM -------------------------------------------------------------------------
REM  Description: Installation boot strap loader batch file
REM -------------------------------------------------------------------------
REM  $Header:   $
REM -------------------------------------------------------------------------
REM Clear screen and display loading message
CLS

REM Setup requirement variable
SET MEMREQ=450

:CHK_FILE

REM Test for starting from default drive
IF NOT EXIST INSTALL.BAT GOTO CHDRV

REM Test for required files
IF NOT EXIST RUNTIME.EXE GOTO MISSING
IF NOT EXIST SBTMEM.EXE  GOTO MISSING
IF NOT EXIST PROINST.EXE GOTO MISSING

:CHK_MEM
REM Check free memory
SBTMEM %MEMREQ% > NUL
IF ERRORLEVEL 2 GOTO NO_MEM

:START
ECHO Starting SBT Professional Installation...

:RUN THE SETUP BOOTSTRAP
PROINST
CLS
IF NOT ERRORLEVEL 1 GOTO CANCEL
SBTINST
GOTO END

REM -------------------------------------------------------------------------
REM Error messages
REM -------------------------------------------------------------------------


:BAD_ZIP
REM Bad zip file expansion error message
ECHO 
ECHO 
ECHO ERROR: Problem encountered during ZIP file expansion.
ECHO 
ECHO Installation can not proceed because an error occurred during
ECHO extraction from the file RUNTIME.EXE.
ECHO 
ECHO Please retry installation with another copy of the SBT
ECHO Installation Disk.
GOTO CANCEL

:CHDRV
REM Wrong Drive error message
ECHO 
ECHO 
ECHO ERROR: You are running the install program from the wrong drive.
ECHO 
ECHO Installation can only proceed when you type "INSTALL" at the prompt
ECHO of the drive in which you have inserted the install disk.
ECHO 
ECHO For example, if you are installing from your A: drive, first switch to
ECHO that drive by typing "A: {Enter}".  Then type "INSTALL".
ECHO 
GOTO CANCEL

:MISSING
REM Missing files error message
ECHO 
ECHO 
ECHO ERROR: Files are missing from installation disk.
ECHO 
ECHO Installation can not proceed because one of the following files
ECHO is missing from the current drive:
ECHO 
IF NOT EXIST RUNTIME.EXE ECHO      RUNTIME.EXE
IF NOT EXIST SBTMEM.EXE  ECHO      SBTMEM.EXE
IF NOT EXIST PROINST.EXE ECHO      PROINST.EXE
ECHO 
ECHO Please rerun INSTALL.BAT from SBT Installation Disk Number 1.
GOTO CANCEL

:NO_MEM
REM Insufficient memory error message
ECHO 
ECHO 
ECHO ERROR: Insufficient free memory.
ECHO 
SBTMEM %MEMREQ%
ECHO 
ECHO Installation can not proceed because your computer has
ECHO insufficient free memory.  You must have at least %MEMREQ% K
ECHO of free memory.  To correct this problem, please unload
ECHO TSRs or other memory resident programs by editing your
ECHO AUTOEXEC.BAT files, then reboot your computer before
ECHO rerunning INSTALL.
GOTO CANCEL


REM -------------------------------------------------------------------------
REM Exit messages
REM -------------------------------------------------------------------------

:CANCEL
REM Installation cancelled message
ECHO SBT Professional Installation cancelled...
ECHO 
ECHO 
ECHO 
GOTO END

:END
SET MEMREQ=
REM -------------------------------------------------------------------------
REM File Name..: INSTALL.BAT
REM Total Lines: 130
