# Sub-makefile for WIN32 run-time library for BC++.
# Included by MAKEFILE when -DCLIBNT is specified.

OBJ1 = \
fsattch.obj \
fsbattch.obj \
fsbclose.obj \
fsbctr1.obj \
fsbctr2.obj \
fsbctr3.obj \
fsbdtr.obj \
fsboflow.obj \
fsbopen.obj \
fsbsbuf.obj \
fsbskoff.obj \
fsbsync.obj \
fsbuflow.obj \
fsclose.obj \
fsctr1.obj \
fsctr2.obj \
fsctr3.obj \
fsctr4.obj \
fsdtr.obj \
fsopen.obj \
fssbuf.obj \
ifsctr1.obj \
ifsctr2.obj \
ifsctr3.obj \
ifsctr4.obj \
ifsdtr.obj \
iofsctr1.obj \
iofsctr2.obj \
iofsctr3.obj \
iofsctr4.obj \
iofsdtr.obj \
iosrctr1.obj \
iosrctr2.obj \
iosrdtr.obj \
iostasn1.obj \
iostasn2.obj \
iostctr1.obj \
iostctr2.obj \
iostctr3.obj \
iostdtr1.obj \
iostdtr2.obj \
ioststd.obj \
isrctr1.obj \
isrctr2.obj \
isrdtr.obj \
istasn1.obj \
istasn2.obj \
istctr1.obj \
istctr2.obj \
istctr3.obj \
istctr4.obj \
istdget.obj \
istdipfx.obj \
istdtr1.obj \
istdtr2.obj \
isteatwh.obj \
istebuf.obj \
istechp.obj \
isteint.obj \
istelng.obj \
istepchr.obj \
isteschr.obj \
istesh.obj \
isteuchr.obj \
isteuint.obj \
isteulng.obj \
isteush.obj \
istgbuf.obj \
istget.obj \
istgline.obj \
istgpchr.obj \
istgschr.obj \
istgstr.obj \
istguchr.obj \
istign.obj \
istmanip.obj \
istpback.obj \
istread.obj \
istskoff.obj \
istskpos.obj \
isttellg.obj \
istws.obj \
istx.obj \
mnrstflg.obj \
mnsbase.obj \
mnsetflg.obj \
mnsetw.obj \
mnsfill.obj \
mnsprec.obj \
ofsctr1.obj \
ofsctr2.obj \
ofsctr3.obj \
ofsctr4.obj \
ofsdtr.obj

OBJ2 = \
osrctr1.obj \
osrctr2.obj \
osrdtr.obj \
ostasn1.obj \
ostasn2.obj \
ostctr1.obj \
ostctr2.obj \
ostctr3.obj \
ostdtr1.obj \
ostdtr2.obj \
ostendl.obj \
ostends.obj \
ostfloat.obj \
ostflush.obj \
ostibuf.obj \
ostint.obj \
ostischr.obj \
ostmanip.obj \
ostmflsh.obj \
ostopfx.obj \
ostosfx.obj \
ostoutst.obj \
ostptr.obj \
ostskoff.obj \
ostskpos.obj \
osttellp.obj \
ostwrite.obj \
ostx.obj \
sdbctr.obj \
sdbdtr.obj \
sdboflow.obj \
sdbpbfl.obj \
sdbskoff.obj \
sdbsync.obj \
sdbuflow.obj \
sdctr.obj \
sddtr.obj \
srbctr1.obj \
srbctr2.obj \
srbctr3.obj \
srbctr4.obj \
srbctr5.obj \
srbctr6.obj \
srbdalc.obj \
srbdtr.obj \
srbfreez.obj \
srbinit.obj \
srboflow.obj \
srbsbuf.obj \
srbskoff.obj \
srbstr.obj \
srbsync.obj \
srbuflow.obj \
srctr1.obj \
srctr2.obj \
srdtr.obj \
stbalc.obj \
stbctr1.obj \
stbctr2.obj \
stbdbp.obj \
stbdnext.obj \
stbdsgtn.obj \
stbdsptn.obj \
stbdtr.obj \
stboflow.obj \
stbpbfl.obj \
stbsbuf.obj \
stbsetb.obj \
stbsetg.obj \
stbsetp.obj \
stbsgetn.obj \
stbskoff.obj \
stbskpos.obj \
stbsputn.obj \
stbstb1.obj \
stbsync.obj \
stbtalc.obj \
stbuflow.obj \
stclear.obj \
stctr1.obj \
stctr2.obj \
stdec.obj \
stdtr.obj \
stflags.obj \
sthex.obj \
stinit.obj \
stiword.obj \
stlock.obj \
stoct.obj \
stpword.obj \
stsetf1.obj \
stsetf2.obj \
stsetst.obj \
stskip.obj \
stsync.obj \
sttie.obj \
stunset.obj \
stusize.obj \
stxalc.obj

# Multi-thread object files.

!ifdef MT
OBJ3 = istedblm.obj isteldbm.obj istefltm.obj fsblkmt.obj
!else
OBJ3 = istedbl.obj isteldbl.obj isteflt.obj fsblkst.obj
!endif

# If building the DLL, append to the linker response file containing
# the objects that will be placed in the DLL.  This file was started in
# CLIB.MAK.

!if $d(DLL)
DLLRSP = dllrsp

dllrsp :
   makersp "$(OBJ)\\\\!s+\n" &&|
   $(OBJ1)
   $(OBJ2)
   $(OBJ3)
|  >> dll.rsp
!endif

# Object files that make up the library

lib1 : $(OBJ1)
lib2 : $(OBJ2)
lib3 : $(OBJ3)
lib  : lib1 lib2 lib3 $(DLLRSP)

# Dependencies that aren't covered by the default.

istefltm.obj : $(SRC)\isteflt.cpp
istedblm.obj : $(SRC)\istedbl.cpp
isteldbm.obj : $(SRC)\isteldbl.cpp
