/*---------------------------------------------------------------------------
 * filename - chmod.c
 *
 * function(s)
 *        chmod - changes access mode of file
 *--------------------------------------------------------------------------*/

/*
 *      C/C++ Run Time Library - Version 6.0
 *
 *      Copyright (c) 1991, 1993 by Borland International
 *      All Rights Reserved.
 *
 */

#include <ntbc.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <_io.h>

/*-------------------------------------------------------------------------*

Name            chmod - changes access mode of file

Usage           #include <sys/types.h>
                #include <sys/stat.h>
                int chmod(const char *filename, int permiss);

Prototype in    io.h

Description     chmod  sets   the  file access  permissions  of   the  file
                according to the mask given by permiss.

                filename points to a string naming the file.

                permiss can contain  one or both of the  symbolic constants
                S_IWRITE and S_IREAD:

                    Value of permiss   Access Permission
                    S_IWRITE            Permission to write
                    S_IREAD             Permission to read
                    S_IREAD | S_IWRITE  Permission to read and write

Return value    Upon  successfully  changing  the  file access  mode, chmod
                returns 0 otherwise, it returns a  value of -1 and errno is
                set to one of the following:
                  ENOENT  Path or file name not found
                  EACCES  Permission denied

*---------------------------------------------------------------------------*/

int _RTLENTRY _EXPFUNC chmod( const char *pathname, int attrib )
{
    DWORD fattr;

    /* Get the current file attributes.
     */
    if ((fattr = GetFileAttributes((char *)pathname)) == -1)
        return (__NTerror());

    /* Set or clear the read-only attribute depending on whether
     * S_IWRITE is set in attrib.  Ignore S_IREAD because a file
     * is always readable on NT.
     */
    if ((attrib & S_IWRITE) == 0)               /* writing not allowed? */
        fattr |= FILE_ATTRIBUTE_READONLY;       /* turn on read-only */
    else                                        /* writing allowed */
        fattr &= ~FILE_ATTRIBUTE_READONLY;      /* turn off read-only */

    /* Set the new file attributes.
     */
    if (SetFileAttributes((char *)pathname, fattr) != TRUE)
        return (__NTerror());
    else
        return (0);
}
