/******************************************************************************
      (C) Copyright 1992 by Autodesk, Inc.

      This program is copyrighted by Autodesk, Inc. and is  licensed
      to you under the following conditions.  You may not distribute
      or  publish the source code of this program in any form.   You
      may  incorporate this code in object form in derivative  works
      provided  such  derivative  works  are  (i.) are  designed and 
      intended  to  work  solely  with  Autodesk, Inc. products, and 
      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright  
      1992 by Autodesk, Inc."

      AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
      AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
      CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
      DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
      UNINTERRUPTED OR ERROR FREE.

*******************************************************************************/

/* For the Metaware High C and High C/C++ compilers, turn off an
   unwanted warning message */
#ifdef __HIGHC__
pragma Offwarn(67); /* kills "switch statement has no cases" warning */
#endif

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include "sxp.h"

#define LIM255(c) (((c)>=255)?255:(c))

/* Variable definitions */
#define SIZE 1
#define WIDTH 2
#define X1 3
#define Y1 4
#define Z1 5
#define X2 13
#define Y2 14
#define Z2 15
#define FRAME1 20
#define FRAME2 21
#define COL1 22
#define COL2 23
/* The above definitions are the LineID numbers for the dialog lines in which
   the variables will be set. The integers assigned to the dialog lines
   containing variables are selected by the IPAS programmer and used by
   3D Studio to identify the variables. */

/************************/

/* Dialog description */
DlgEntry cdialog[]={
	0,"TITLE=\"3D Noise Function (Animated)\"",		/* Text to appear in dialog box */
    SIZE, "LFLOAT=\"Size :\",0.0001,10000.0",          /*  Setup for 'limited float' type
								variable and associated range 
								values */
	0,"TITLE=\"\"",						/* Blank line for spacing */
	COL1,"COLOR=\"Color 1\"",				/* Setup for standard color triple 	
								slider dialog*/
	COL2,"-COLOR=\"Color 2\"",				/* Setup for standard color triple 	
								slider dialog*/
	0,"TITLE=\"\"",						/* Blank line for spacing */
	X1, "LFLOAT=\"Start Offset X:\",-1000.0,1000.0",		/* Limited float variable */
	Y1, "-LFLOAT=\"Y:\",-1000.0,1000.0",			/* Limited float variable */
	Z1, "-LFLOAT=\"Z:\",-1000.0,1000.0",			/* Limited float variable */
	0,"TITLE=\"\"",						/* Blank line for spacing */
	X2, "LFLOAT=\"End Offset X:\",-1000.0,1000.0",		/* Limited float variable */
	Y2, "-LFLOAT=\"Y:\",-1000.0,1000.0",			/* Limited float variable */
	Z2, "-LFLOAT=\"Z:\",-1000.0,1000.0",			/* Limited float variable */
	0,"TITLE=\"\"",						/* Blank line for spacing */
	FRAME1, "LINT=\"Start Frame:\",0,32000,6",		/* Setup for 'limited integer type
								variariable and associated range
								values */
	FRAME2, "-LINT=\"End Frame:\",0,32000,6",		/* Limited integer variable */
	0,"TITLE=\"\"",						/* Blank line for spacing */
	0,NULL
	};

/* State Structure definition */
/* Any variables whose values are set via dialog interface must be declared within the 'State' struct. */	
typedef struct {
	ulong version;
	float size;
	float x1,y1,z1;
	float x2,y2,z2;
	Col24 col1,col2;
	long frame1,frame2;
	} NoiseState;
/* the "state" struct MUST start with a "ulong" which is the version#,
	to prevent using data from old versions of this program.
	This verification is performed automatically. */

/* Version test value */
/* Every external process must have a unique version number  */
#define NOISE_VERS 0xC79A0

#define INIT_NOISE { NOISE_VERS,50.0, 0.0,0.0,0.0, 0.0,0.0,0.0, {0,0,0},{250,250,250},0,30}

static NoiseState init_state = INIT_NOISE; /* default, used for resetting*/	/* Initial state settings */
static NoiseState state = INIT_NOISE; /* current state */			/* Default state settings */

/*----------------------------------------------------------------*/
#define NOISE_DIM 20    
#define FNOISE_DIM 20.0

static float noise_table[NOISE_DIM+1][NOISE_DIM+1][NOISE_DIM+1];

void init_noise() {
	int i,j,k,ii,jj,kk;
	for (i=0; i<=NOISE_DIM; i++)
		for (j=0; j<=NOISE_DIM; j++)
			for (k=0; k<=NOISE_DIM; k++) {
				noise_table[i][j][k] = (float)(rand()&0x7FFF);
				ii = (i==NOISE_DIM)?0:i; 
				jj = (j==NOISE_DIM)?0:j; 
				kk = (k==NOISE_DIM)?0:k; 
				noise_table[i][j][k] = noise_table[ii][jj][kk];
				}
	}

float noise(float x,float y,float z) {
	int ix,iy,iz;
	float fx,fy,fz,mx,my,mz;
	float n,n00,n01,n10,n11,n0,n1;
	mx = fmod(x,FNOISE_DIM); if (mx<0) mx += FNOISE_DIM;
	my = fmod(y,FNOISE_DIM); if (my<0) my += FNOISE_DIM;
	mz = fmod(z,FNOISE_DIM); if (mz<0) mz += FNOISE_DIM;
	ix = (int)mx;
	iy = (int)my;
	iz = (int)mz;
	fx = fmod(mx,1.0);
	fy = fmod(my,1.0);
	fz = fmod(mz,1.0);
	n = noise_table[ix][iy][iz];
	n00 = n + fx*(noise_table[ix+1][iy][iz]-n);
	n = noise_table[ix][iy][iz+1];
	n01 = n + fx*(noise_table[ix+1][iy][iz+1]-n);
	n = noise_table[ix][iy+1][iz];
	n10 = n + fx*(noise_table[ix+1][iy+1][iz]-n);
	n = noise_table[ix][iy+1][iz+1];
	n11 = n + fx*(noise_table[ix+1][iy+1][iz+1]-n);
	n0 = n00 + fy*(n10-n00);
	n1 = n01 + fy*(n11-n01);
	return(((float)(n0+fz*(n1-n0)))/32768.0);
	}

static void lerp_color(Col24 *c, Col24 *a, Col24 *b, float f) {
	int alph = (int)4096*f;
	int ialph = 4096-alph;
	c->r = (ialph*a->r + alph*b->r)>>12;
	c->g = (ialph*a->g + alph*b->g)>>12;
	c->b = (ialph*a->b + alph*b->b)>>12;
	}


float lin_interp(int cur, int start, int end) {
	if  (cur<=start) return(0.0);
	else if (cur>=end) return(1.0);
	else if (end>start) {
		return( ((float)(cur-start))/((float)(end-start)));
		}
	else return(0.0);
	}

/* The following function is a 'Client' procedure that defines a 3-dimensional function to modify the 
diffuse color and/or the shininess. This function is passed the SXPDATA structure contained in the 
EXPbuf, but has no access to packet commands or to other EXPbuf data structures. */

void Client3DText(Sxpdata  *sd) {
	float d,x,y,z,u,iu;
	u = lin_interp(sd->curfield, 2*state.frame1, 2*state.frame2);
	iu = 1.0-u;
	x = iu*state.x1 + u*state.x2 + sd->p[0]/state.size;
	y = iu*state.y1 + u*state.y2 + sd->p[1]/state.size;
	z = iu*state.z1 + u*state.z2 + sd->p[2]/state.size;
	d = noise(x,y,z);
	lerp_color(&sd->col,&state.col1,&state.col2,d);
	}

/* The following function is a 'Client' procedure that defines a 3-dimensional function to compute an 
opacity value. This function is passed the SXPDATA structure contained in the EXPbuf, but has no access 
to packet commands or to other EXPbuf data structures. */

void Client3DOpac(Sxpdata  *sd) { 
	Client3DText(sd); 
	}

/* The following function is a 'Client' procedure that defines a 3-dimensional function to compute a 
normal perturbation value. This function is passed the SXPDATA structure contained in the EXPbuf, but 
has no access to packet commands or to other EXPbuf data structures. */

void Client3DBump(Sxpdata *sd) {
	float x,y,z,del,d,u,iu;
	u = lin_interp(sd->curfield, 2*state.frame1, 2*state.frame2);
	iu = 1.0-u;
	x = iu*state.x1 + u*state.x2 + sd->p[0]/state.size;
	y = iu*state.y1 + u*state.y2 + sd->p[1]/state.size;
	z = iu*state.z1 + u*state.z2 + sd->p[2]/state.size;
	d = noise(x,y,z);
	del = .1;
	sd->norm_pert[0] = (noise(x+del,y,z) - d)/del;
	sd->norm_pert[1] = (noise(x,y+del,z) - d)/del;
	sd->norm_pert[2] = (noise(x,y,z+del) - d)/del;
	}

/* Following function sets the appropriate 'State' variables based
   on the input from the dialog */
void ClientSetStateVar(int id, void *ptr) {
	OVL o;				/* Union of possible values that the dialog can return */
	ulong *ul;

	ul=(void *)ptr;
	o.ul = *ul;
	switch(id) {
		case SIZE:  state.size = o.f; break;			/* State variables set here based on
								values stored in the fields of the 
								Union type .*/
		case X1:  state.x1 = o.f; break;
		case Y1:  state.y1 = o.f; break;
		case Z1:  state.z1 = o.f; break;
		case X2:  state.x2 = o.f; break;
		case Y2:  state.y2 = o.f; break;
		case Z2:  state.z2 = o.f; break;
		case FRAME1: state.frame1 = o.l; break;
		case FRAME2: state.frame2 = o.l; break;
		case COL1:					/* Set each field within the COL 
								variable in RGB format */
			state.col1.r = o.c.r;
			state.col1.g = o.c.g; 
			state.col1.b = o.c.b; 
			break;
		case COL2:					/* Set each field within the COL 
								variable in RGB format */
			state.col2.r = o.c.r;
			state.col2.g = o.c.g; 
			state.col2.b = o.c.b; 
			break;
		}
	}

/* Following function sets the appropriate value of the Union 'OVL' variable
   to return values stored in the 'State' variable */
ulong ClientGetStateVar(int id) {
	OVL o;
	switch(id) {
		case SIZE: o.f = state.size; break;		/* Union variables set to appropriate value
							from 'state' variables */
		case X1: o.f = state.x1; break;
		case Y1: o.f = state.y1; break;
		case Z1: o.f = state.z1; break;
		case X2: o.f = state.x2; break;
		case Y2: o.f = state.y2; break;
		case Z2: o.f = state.z2; break;
		case FRAME1: o.l = state.frame1; break;
		case FRAME2: o.l = state.frame2; break;
		case COL1:
			o.c.r = state.col1.r;
			o.c.g = state.col1.g;
			o.c.b = state.col1.b;
			break;
		case COL2:
			o.c.r = state.col2.r;
			o.c.g = state.col2.g;
			o.c.b = state.col2.b;
			break;
		}
	return(o.ul);					/* the variable requested by 3D Studio is 
							returned to 3D Studio via the 'ulong' field
							of the 'Union' structure 'OVL'. */
	}

/* ---For most applications, the following functions will not change */

/* The following function performs any calculations necessary to the operation of 3DTEXT, 3DBUMP, or 
3DOPAC that cannot be performed within any of these functions. The 'ClientStartUp' procedure does not 
have access to packet-commands. */

void ClientStartup() {
	/* allocate data structures, compute lookup tables, etc */
	init_noise();
	}

void ClientTerminate() { 	
	/* free any data structures, etc. */	
	}

/* Following function allows 3D Studio to determine the size of
   the 'State' structure and returns a pointer to the 'State' struct */

char *ClientGetState(int *size) {
	*size = sizeof(NoiseState);
	return((char *)&state);
	}

/* Following function allows 3D Studio to reset the state of the
   external process */

void ClientResetState() { state = init_state; }
	
/* The following function allows 3D Studio to get the address of a string containing a variable. The IPAS
programmer will not have to call this function or modify the following code, but will have to include it */

DlgEntry *ClientDialog(int n) {	return(&cdialog[n]); }

/* Following function allows 3D Studio to determine the size of
   any variable in the dialog */

int ClientVarSize(int id) {
	switch(id) {
		default:
			return(1);
		}
	}



