/******************************************************************************
      (C) Copyright 1992 by Autodesk, Inc.

      This program is copyrighted by Autodesk, Inc. and is  licensed
      to you under the following conditions.  You may not distribute
      or  publish the source code of this program in any form.   You
      may  incorporate this code in object form in derivative  works
      provided  such  derivative  works  are  (i.) are  designed and 
      intended  to  work  solely  with  Autodesk, Inc. products, and 
      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright  
      1992 by Autodesk, Inc."

      AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
      AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
      CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
      DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
      UNINTERRUPTED OR ERROR FREE.

*******************************************************************************/

/* For the Metaware High C and High C/C++ compilers, turn off an
   unwanted warning message */
#ifdef __HIGHC__
pragma Offwarn(67); /* kills "switch statement has no cases" warning */
#endif

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include "sxp.h"

/* Variable definitions */
#define CHKSIZE 1
#define COL1 2
#define COL2 3
#define XOFF 4
#define YOFF 5
#define ZOFF 6

/* The above definitions are the LineID numbers for the dialog lines in which the variables will be set. 
The integers assigned to the dialog lines containing variables are selected by the IPAS programmer and 
used by 3D Studio to identify the variables. */

/************************/

/* Dialog description */

DlgEntry cdialog[]={
	0,"TITLE=\"3D Checker Pattern\"",			/* Text to appear in dialog box */
	CHKSIZE,"LFLOAT=\"Check size:\",0.0,10000.0,5",	/*  Setup for 'limited float' type 
								variable and associated range 
								values */
	0,"TITLE=\"\"",						/* Blank line for spacing */
	XOFF, "LFLOAT=\"Offset:  X:\",-100000.0,100000.0,5",	/* Limited float variable */
	YOFF, "-LFLOAT=\" Y:\",-100000.0,100000.0,5",		/* Limited float variable */
	ZOFF, "-LFLOAT=\" Z:\",-100000.0,100000.0,5",		/* Limited float variable */
	0,"TITLE=\"\"",						/* Blank line for spacing */
	COL1,"COLOR=\"Color 1\"",				/* Setup for standard color triple 	
								slider dialog*/
	COL2,"-COLOR=\"Color 2\"",				/* Setup for standard color triple 	
								slider dialog*/
	0,"TITLE=\"\"",						/* Blank line for spacing */
	0,NULL
	};

/* Version test value */
/* Every external process must have a unique version number  */
#define CHECK_VERS 0xD101
	
/* State Structure definition */
/* Any variables whose values are set via dialog interface must be declared within the 'State' struct. */	
typedef struct {
	ulong version;
	float cksize;
	float xoff,yoff,zoff;
	Col24 col1;
	Col24 col2;
	} CheckState;

/* the "state" struct MUST start with a "ulong" which is the version#,
	to prevent using data from old versions of this program.
	This verification is performed automatically. */

static CheckState init_state = { CHECK_VERS,60.0,0.0,0.0,0.0,{240,40,0},{0,40,50}};	/* Initial state */
static CheckState state = { CHECK_VERS,60.0,0.0,0.0,0.0,{240,40,0},{0,40,50}};	/* Default state*/

/*----------------------------------------------------------------*/
/* The following function is a 'Client' procedure that defines a 3-dimensional function to modify the 
diffuse color and/or the shininess. This function is passed the SXPDATA structure contained in the 
EXPbuf, but has no access to packet commands or to other EXPbuf data structures. */

void Client3DText(Sxpdata *sd) {
	int ix,iy,iz,k;
	ix = (sd->p[0]+state.xoff+10000)/state.cksize;
	iy = (sd->p[1]+state.yoff+10000)/state.cksize;
	iz = (sd->p[2]+state.zoff+10000)/state.cksize;
	k = (ix&1)^(iy&1)^(iz&1);
	sd->col = k?state.col1:state.col2;
	}

/* The following function is a 'Client' procedure that defines a 3-dimensional function to compute an 
opacity value. This function is passed the SXPDATA structure contained in the EXPbuf, but has no access 
to packet commands or to other EXPbuf data structures. */

void Client3DOpac(Sxpdata *sd) {
	Client3DText(sd);
	}

/* The following function is a 'Client' procedure that defines a 3-dimensional function to compute a 
normal perturbation value. This function is passed the SXPDATA structure contained in the EXPbuf, but 
has no access to packet commands or to other EXPbuf data structures. */

void Client3DBump(Sxpdata *sd) {	}

/* Following function sets the appropriate 'State' variables based
   on the input from the dialog */
void ClientSetStateVar(int id, void *ptr) {
	OVL o;				/* Union of possible values that the dialog can return */
	ulong *ul;

	ul=(void *)ptr;
	o.ul = *ul;
	switch(id) {
		case CHKSIZE:  state.cksize = o.f; break;		/* State variables set here based on
								values stored in the fields of the 
								Union type .*/
		case XOFF:  state.xoff = o.f; break;
		case YOFF:  state.yoff = o.f; break;
		case ZOFF:  state.zoff = o.f; break;
		case COL1: 					/* Set each field within the COL 
								variable in RGB format */
			state.col1.r = o.c.r;			
			state.col1.g = o.c.g;
			state.col1.b = o.c.b;
			break;
		case COL2: 					/* Set each field within the COL 
								variable in RGB format */
			state.col2.r = o.c.r;
			state.col2.g = o.c.g;
			state.col2.b = o.c.b;
			break;
		}
	}

/* Following function sets the appropriate value of the Union 'OVL' variable
   to return values stored in the 'State' variable */
ulong ClientGetStateVar(int id) {
	OVL o;
	switch(id) {
		case CHKSIZE: o.f = state.cksize; break;	/* Union variables set to appropriate value
							from 'state' variables */
		case XOFF: o.f = state.xoff; break;
		case YOFF: o.f = state.yoff; break;
		case ZOFF: o.f = state.zoff; break;
		case COL1:
			o.c.r = state.col1.r;
			o.c.g = state.col1.g;
			o.c.b = state.col1.b;
			break;
		case COL2:
			o.c.r = state.col2.r;
			o.c.g = state.col2.g;
			o.c.b = state.col2.b;
			break;
		}
	return(o.ul);					/* the variable requested by 3D Studio is 
							returned to 3D Studio via the 'ulong' field
							of the 'Union' structure 'OVL'. */
	}
/* ---For most applications, the following functions will not change */

/* Following function allows 3D Studio to determine the size of
   the 'State' structure and returns a pointer to the 'State' struct */

char  *ClientGetState(int *size) {
	*size = sizeof(CheckState);
	return((char *)&state);
	}

/* Following function allows 3D Studio to reset the state of the
   external process */

void ClientResetState() {	
	state = init_state;	
	}

/* The following function performs any calculations necessary to the operation of 3DTEXT, 3DBUMP, or 
3DOPAC that cannot be performed within any of these functions. The 'ClientStartUp' procedure does not 
have access to packet-commands. */

void ClientStartup(void) {
	/* allocate data structures, compute lookup tables, etc */
	}

void ClientTerminate(void) { 
	/* free any data structures, etc. */
	}

/* The following function allows 3D Studio to get the address of a string containing a variable. The IPAS
programmer will not have to call this function or modify the following code, but will have to include it */

DlgEntry *ClientDialog(int n) {	
	return(&cdialog[n]); 
	}

/* Following function allows 3D Studio to determine the size of
   any variable in the dialog */

int ClientVarSize(int id) {
	switch(id) {
		default:
			return(1);
		}
	}

