; ERROR.LSP
; 
; Error handling for BaseLISP
;
; (c) 1993 Cyco Software.
;

(defun *error* (errno)
	(if (and (/= errno 0) (/= errno nil))
		(print
			(strcat
				"ERROR "
				errno
				": "
				(if (= errno E020) "General Error")
				(if (= errno E021) "Out of memory")
				(if (= errno E022) "Stack full")
				(if (= errno E023) "Value too long/Missing quotes")
				(if (= errno E030) "Missing parenthesis")
				(if (= errno E031) "Missing closing parenthesis")
				(if (= errno E032) "Missing opening parenthesis")
				(if (= errno E033) "Not enough parameters")
				(if (= errno E040) "File not found")
				(if (= errno E041) "Can't open file")
				(if (= errno E050) "Unknown system variable")
				(if (= errno E051) "Can't set system variable")
				(if (= errno E052) "Defun")
				(if (= errno E053) "Function parameters")
				(if (= errno E054) "SetQ")
				(if (= errno E055) "Divide by zero")
				(if (= errno E060) "Break in trace")
				(if (= errno E061) "Break")
				".\n"
			)
		)
	)
	0	; return new error value; 0 means 'no error'.
)
