/*  $Id$
 *  
 *  File	options.c
 *  Part of	ChessBase utilities file format (CBUFF)
 *  Author	Anjo Anjewierden, anjo@swi.psy.uva.nl
 *  Purpose	Options for the various utilities
 *  Works with	GNU CC 2.4.5
 *  
 *  Notice	Copyright (c) 1993  Anjo Anjewierden
 *  
 *  History	05/10/93  (Created)
 *  		31/10/93  (Last modified)
 */ 


/*------------------------------------------------------------
 *  Directives
 *------------------------------------------------------------*/

#include "cbuff.h"


unsigned short	UserId = 0;


/*------------------------------------------------------------
 *  Functions
 *------------------------------------------------------------*/

Option
newOption()
{ Option opt;

  opt = (Option) alloc(sizeof(struct option));
  opt->from = 1L;
  opt->to = 999999L;
  opt->database = (CBase) NULL;
  opt->dump = (CBase) NULL;
  opt->output = stdout;
  opt->verbose = FALSE;
  opt->notation = SHORT_ALGEBRAIC;

  return opt;
}


void
freeOption(Option opt)
{ unalloc(opt);
}


/*------------------------------------------------------------
 *  Generic options
 *------------------------------------------------------------*/

int
genericOption(Option opt, char **argv, int argc, int i)
{ if (strhead(argv[i], "-append"))	/* -append */
  { ++i;
    opt->dump = appendBaseArgument(argv[i], "-append", argc, i);
    return i;
  }

  if (strhead(argv[i], "-database"))	/* -database */
  { ++i;
    setCurrentCBase(argv[i], "-database", argc, i);
    opt->database = CurrentBase;
    return i;
  }

  if (strhead(argv[i], "-dump"))	/* -dump */
  { ++i;
    opt->dump = createBaseArgument(argv[i], "-dump", argc, i);
    return i;
  }

  if (strhead(argv[i], "-from"))	/* -from */
  { ++i;
    opt->from = longArgument(argv[i], "-from", argc, i);
    return i;
  }

  if (strhead(argv[i], "-help"))	/* -help */
  { helpUtility(stderr);
    exit(0);
  }

  if (strhead(argv[i], "-language"))	/* -language */
  { ++i;
    setLanguage(stringArgument(argv[i], "-language", argc, i));
    return i;
  }

  if (strhead(argv[i], "-long"))	/* -long */
  { opt->notation = LONG_ALGEBRAIC;
    return i;
  }

  if (strhead(argv[i], "-output"))	/* -output */
  { ++i;
    if (opt->output != stdout)
      fclose(opt->output);
    opt->output = fileArgument(argv[i], "-output", argc, i, "w");
    return i;
  }

  if (strhead(argv[i], "-short"))	/* -short */
  { opt->notation = SHORT_ALGEBRAIC;
    return i;
  }

  if (strhead(argv[i], "-symbols"))	/* -symbols */
  { char *fileName;

    ++i;
    fileName = stringArgument(argv[i], "-symbols", argc, i);
    loadChessSymbols(fileName);
    return i;
  }

  if (strhead(argv[i], "-to"))		/* -to */
  { ++i;
    opt->to = longArgument(argv[i], "-to", argc, i);
    return i;
  }

  if (strhead(argv[i], "-verbose"))	/* -verbose */
  { opt->verbose = TRUE;
    return i;
  }

  if (strhead(argv[i], "-version"))	/* -version */
  { versionCBUFF(stderr);
    exit(0);
  }

  if (strhead(argv[i], "-uid"))		/* -uid */
  { ++i;
    UserId = intArgument(argv[i], "-uid", argc, i);
    return i;
  }

  return FALSE;
}
