/*  $Id$
 *  
 *  File	names.c
 *  Part of	ChessBase utilities file format (CBUFF)
 *  Author	Anjo Anjewierden, anjo@swi.psy.uva.nl
 *  Purpose	Names utility
 *  Works with	GNU CC 2.4.5
 *  
 *  Notice	Copyright (c) 1993  Anjo Anjewierden
 *  
 *  History	14/11/93  (Created)
 *  		30/11/93  (Last modified)
 */ 


/*------------------------------------------------------------
 *  Directives
 *------------------------------------------------------------*/

#include "cbuff.h"


char *		UTILITY_NAME = "Names utility";
char *		UTILITY_VERSION = "1.1.0";

void		helpUtility(FILE *fd);

FILE *		PlayersFile = NULL;
FILE *		NamesFile = NULL;
FILE *		SourceFile = NULL;
FILE *		PlaceFile = NULL;

StringTable	PlayersTable = NULL;
StringTable	NamesTable = NULL;
StringTable	SourceTable = NULL;
StringTable	PlaceTable = NULL;


/*------------------------------------------------------------
 *  Names utility
 *------------------------------------------------------------*/

void
namesUtility(Option opt)
{ Game g = newGame();
  CBase cb = opt->database;
  long from = opt->from;
  long to = (opt->to < getNoGamesCBase(cb) ? opt->to : getNoGamesCBase(cb));
  long n;

  reportCBase(cb, stderr);

  if (PlayersFile) PlayersTable = newStringTable(1000);
  if (NamesFile)  NamesTable = newStringTable(1000);
  if (SourceFile)  SourceTable = newStringTable(1000);
  if (PlaceFile)   PlaceTable = newStringTable(1000);

  n = to-from+1;
  if (n < 0)
    return;
  
  for (n=from; n<=to; n++)
  { environmentError(cb, g, n);
    initialiseGame(g, n, cb);
    if (foundError())
    { reportError(stderr);
      continue;
    }

    if (NamesFile)
    { char *white;
      char *black;
      if (!containsPlayerNamesGameP(g))
	continue;

      white = getWhiteGame(g);
      if (white == NULL)
      { fprintf(stderr, "Players not extracted: %s\n", getPlayersGame(g));
	continue;
      }
      incStringTable(NamesTable, white);
      black = getBlackGame(g);
      incStringTable(NamesTable, black);
    }

    if (PlayersFile)
      incStringTable(PlayersTable, getPlayersGame(g));

    if (SourceFile)
      incStringTable(SourceTable, getSourceGame(g));
    
    if (PlaceFile)
      incStringTable(PlaceTable, getPlaceGame(g));
  }

  if (NamesFile)
  { printStringTable(NamesTable, "%4ld", NamesFile);
    freeStringTable(NamesTable);
    fclose(NamesFile);
    NamesFile = NULL;
  }

  if (PlayersFile)
  { printStringTable(PlayersTable, "%4ld", PlayersFile);
    freeStringTable(PlayersTable);
    fclose(PlayersFile);
    PlayersFile = NULL;
  }

  if (PlaceFile)
  { printStringTable(PlaceTable, "%4ld", PlaceFile);
    freeStringTable(PlaceTable);
    fclose(PlaceFile);
    PlaceFile = NULL;
  }

  if (SourceFile)
  { printStringTable(SourceTable, "%4ld", SourceFile);
    freeStringTable(SourceTable);
    fclose(SourceFile);
    SourceFile = NULL;
  }

  freeGame(g);
}


/*------------------------------------------------------------
 *  Main
 *------------------------------------------------------------*/

int
main(int argc, char *argv[])
{ int i;
  Option options = newOption();

  initChessSymbols(NULL);

  for (i=1; i<argc; i++)
  {
    if (strhead(argv[i], "-names"))	/* -names */
    { ++i;
      NamesFile = fileArgument(argv[i], "-names", argc, i, "w");
      continue;
    }

    if (strhead(argv[i], "-players"))	/* -players */
    { ++i;
      PlayersFile = fileArgument(argv[i], "-players", argc, i, "w");
      continue;
    }

    if (strhead(argv[i], "-place"))	/* -place */
    { ++i;
      PlaceFile = fileArgument(argv[i], "-place", argc, i, "w");
      continue;
    }

    if (strhead(argv[i], "-source"))	/* -source */
    { ++i;
      SourceFile = fileArgument(argv[i], "-source", argc, i, "w");
      continue;
    }

    if (strhead(argv[i], "-"))
    { int n;

      n = genericOption(options, argv, argc, i);
      if (n == 0)
      { fprintf(stderr, "Fatal: Unknown command %s\n", argv[i]);
	fprintf(stderr, "Do ``%s -help'' or see the documentation\n", argv[0]);
	exit(1);
      }
      i = n;
      continue;
    }

    setCurrentCBase(argv[i], "-database", argc, i);
    options->database = CurrentBase;
    namesUtility(options);
    freeCBase(options->database);
    options->database = (CBase) NULL;
  }

  if (options->database)
  { namesUtility(options);
    freeCBase(options->database);
  }

  return 0;
}


/*------------------------------------------------------------
 *  Help
 *------------------------------------------------------------*/

void
helpUtility(FILE *fd)
{ helpCBUFF(fd);
  fprintf(fd, "%s options:\n", UTILITY_NAME);
  fprintf(fd, "-names file   Generates player names in file (Black, White)\n");
  fprintf(fd, "-place file   Generates place (city) in file\n");
  fprintf(fd, "-players file Generates players field in file\n");
  fprintf(fd, "-source file  Generates source field in file\n");
}
