/*  $Id$
 *  
 *  File	merge.c
 *  Part of	ChessBase utilities file format (CBUFF)
 *  Author	Anjo Anjewierden, anjo@swi.psy.uva.nl
 *  Purpose	Merge databases
 *  Works with	GNU CC 2.4.5
 *  
 *  Notice	Copyright (c) 1993  Anjo Anjewierden
 *  
 *  History	17/07/93  (Created)
 *  		17/10/93  (Last modified)
 */ 


/*------------------------------------------------------------
 *  Directives
 *------------------------------------------------------------*/

#include "cbuff.h"

char *		UTILITY_NAME = "Merge utility";
char *		UTILITY_VERSION = "1.2.0";

void		helpUtility(FILE *fd);

void		mergeUtility(Option);


/*------------------------------------------------------------
 *  Merge utility
 *------------------------------------------------------------*/

void
mergeUtility(Option opt)
{ if (opt->dump == NULL)
  { fprintf(stderr, "No output database specified (-dump or -append option)\n");
    exit(1);
  }

  reportCBase(opt->database, stderr);

  exportManyCBase(opt->dump, opt->database, opt->from, opt->to);
}


/*------------------------------------------------------------
 *  Main
 *------------------------------------------------------------*/

int
main(int argc, char *argv[])
{ int i;
  Option options = newOption();

  for (i=1; i<argc; i++)
  {
    if (strhead(argv[i], "-"))
    { int n;

      n = genericOption(options, argv, argc, i);
      if (n == 0)
      { fprintf(stderr, "Fatal: Unknown command %s\n", argv[i]);
	fprintf(stderr, "Do ``%s -help'' or see the documentation\n", argv[0]);
	exit(1);
      }
      i = n;
      continue;
    }

    setCurrentCBase(argv[i], "-database", argc, i);
    options->database = CurrentBase;
    mergeUtility(options);
    freeCBase(options->database);
    options->database = (CBase) NULL;
  }

  if (options->database)
  { mergeUtility(options);
    freeCBase(options->database);
  }

  exit(0);
}


/*------------------------------------------------------------
 *  Help
 *------------------------------------------------------------*/

void
helpUtility(FILE *fd)
{ helpCBUFF(fd);
  fprintf(fd, "%s options:\n", UTILITY_NAME);
}
