/*  $Id$
 *  
 *  File	machine.h
 *  Part of	ChessBase utilities file format (CBUFF)
 *  Author	Anjo Anjewierden, anjo@swi.psy.uva.nl
 *  Purpose	Machine dependencies
 *  Works with	GNU CC 2.4.5
 *  
 *  Notice	Copyright (c) 1993  Anjo Anjewierden
 *  
 *  History	21/10/93  (Created)
 *  		10/11/93  (Last modified)
 */ 


/*------------------------------------------------------------
 *  Description
 *------------------------------------------------------------
 *
 *  This file contains machine dependencies (both hardware and
 *  software).  It may be necessary to edit the values below
 *  depending on the environment.
 */


/*  MAX_LEVEL_NESTING determines the maximum number of
 *  "levels" in the comments.  The current value is a reasonable
 *  limit (event suitable for GM Hubner).
 */
#define MAX_LEVEL_NESTING	50


/*  MAX_FILE_NAME_SIZE determines the maximum length (in bytes)
 *  of a file name.
 */
#define MAX_FILE_NAME_SIZE	256	/* Really depends on OS */


/*  HAS_GETENV determines whether your software environment knows
 *  about the getenv() call.  getenv() is used to determine the
 *  the CBUFF directory which contains several ``standard files''.
 */
#define HAS_GETENV		1


/*  MAX_NAME_SIZE is the maximum size (in characters) of a name.
 *  This constant is mostly used to store names of players and
 *  the source field.
 */
#define MAX_NAME_SIZE		100


/*  MAX_LINE_SIZE is the maximum size of a line when reading an
 *  ASCII file.
 */
#define MAX_LINE_SIZE		1024


/*  If PROTECTED_GAMES is 1 then source code for checking a game
 *  against the ChessBase user id is included.  The default is 0.
 */
#define PROTECTED_GAMES		0
