/*  $Id: language.c,v 1.1 1993/07/13 10:11:32 anjo Exp $
 *  
 *  File	language.c
 *  Part of	ChessBase utilities file format (CBUFF)
 *  Author	Anjo Anjewierden, anjo@swi.psy.uva.nl
 *  Purpose	Definition of chess piece names for natural languages
 *  Works with	GNU CC 2.4.5
 *  
 *  Notice	Copyright (c) 1993  Anjo Anjewierden
 *  
 *  History	12/07/93  (Created)
 *  		30/11/93  (Last modified)
 */ 


/*------------------------------------------------------------
 *  Directives
 *------------------------------------------------------------*/

#include "cbuff.h"


/*------------------------------------------------------------
 *  Definitions
 *------------------------------------------------------------
 *
 *  This file defines the abbreviations of chess pieces for various
 *  languages.  The current set has been taken from the Notation program
 *  developed by Henry Thomas (Henry.Thomas@irisa.fr).  Portuguese provided
 *  by Horacio Neto.
 */

struct language
{ char *	name;
  char *	king;
  char *	queen;
  char *	rook;
  char *	bishop;
  char *	knight;
  char *	pawn;
} Languages[] =
  /* Name      King  Queen Rook Bishop Knight Pawn */
{ { "FIDE",      "K",  "D",  "T", "S",   "N",   "P" },
  { "czech",     "K",  "D",  "V", "S",   "J",   "P" },
  { "dutch",     "K",  "D",  "T", "L",   "P",   "O" },
  { "english",   "K",  "Q",  "R", "B",   "N",   "P" },
  { "french",    "R",  "D",  "T", "F",   "C",   "P" },
  { "german",    "K",  "D",  "T", "L",   "S",   "B" },
  { "hungarian", "K",  "V",  "B", "F",   "H",   "G" },
  { "italian",   "R",  "D",  "T", "A",   "C",   "P" },
  { "polish",    "K",  "H",  "W", "G",   "S",   "P" },
  { "portuguese","R",  "D",  "T", "B",   "C",   "P" },
  { "romanian",  "R",  "D",  "T", "N",   "C",   "P" },
  { "spanish",   "R",  "D",  "T", "A",   "C",   "P" },
  {  NULL,        "",   "",   "",  "",    "",    "" }
};


/*------------------------------------------------------------
 *  Functions
 *------------------------------------------------------------*/

void
setLanguage(char *lang)
{ struct language *p;

  for (p=Languages; p->name!=NULL; p++)
  { if (strcmp(p->name, lang) == 0)
    { AsciiSymbols[KING_SYMBOL] = p->king;
      AsciiSymbols[QUEEN_SYMBOL] = p->queen;
      AsciiSymbols[ROOK_SYMBOL] = p->rook;
      AsciiSymbols[BISHOP_SYMBOL] = p->bishop;
      AsciiSymbols[KNIGHT_SYMBOL] = p->knight;
      AsciiSymbols[PAWN_SYMBOL] = p->pawn;
      return;
    }
  }
  fprintf(stderr, "Fatal: Language %s is not available.\n", lang);
  fprintf(stderr, "       Please mail the piece names to the author.\n\n");
  fprintf(stderr, "Currently the following languages are defined:\n");
  for (p=Languages; p->name != NULL; p++)
    fprintf(stderr, "%-12s  %3s  %3s  %3s  %3s  %3s  %3s\n", p->name,
	    p->king, p->queen, p->rook, p->bishop, p->knight, p->pawn);
  exit(0);
}
