//========================================================================================
//
//     File:			ToolWind.cp
//     Creation Date:	4/14/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRWINDOW_H
#include <BRWindow.h>
#endif

#ifndef PAINT_H
#include "Paint.h"
#endif

#ifndef TOOLWIND_H
#include "ToolWind.h"
#endif

#ifndef TOOLPANE_H
#include "ToolPane.h"
#endif

#ifndef DRWSTATE_H
#include "DrwState.h"
#endif

#ifndef PNTTOOLS_H
#include "PntTools.h"
#endif

DEFINE_CLASS(cToolWindow, BR_CWindow)

//----------------------------------------------------------------------------------------
// cToolWindow::cToolWindow
//----------------------------------------------------------------------------------------

cToolWindow::cToolWindow(BR_CView* enclosure,
						 BR_CBureaucrat* supervisor,
						 cDrawState* State) :
	BR_CWindow(enclosure, supervisor, kFloatingWindow | kHasCaption)
{
	cToolPane * pToolPane;						// Pointer to the tool pane.

	//
	//	Create Tool Pane
	//
	pToolPane = new cToolPane(this, this, State);

	//	Get the Interiorers pane size
	BR_CRectangle PaneSize;
	pToolPane->GetFrame(PaneSize);

	// Set the size of this window based on the size of the tool pane.
	SetFrame(PaneSize, FALSE);
	Place(0, 30, FALSE);
	BR_CCharString32 Title("Tools");
	SetText(Title);

	Show();										// Display the window
}

//----------------------------------------------------------------------------------------
// cToolWindow::~cToolWindow
//----------------------------------------------------------------------------------------

cToolWindow::~cToolWindow()
{
}
